# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Chronicle
      module V1
        # ScopeInfo specifies the scope info of the reference list.
        # @!attribute [rw] reference_list_scope
        #   @return [::Google::Cloud::Chronicle::V1::ReferenceListScope]
        #     Required. The list of scope names of the reference list, if the list is
        #     empty the reference list is treated as unscoped.
        class ScopeInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ReferenceListScope specifies the list of scope names of the reference list.
        # @!attribute [rw] scope_names
        #   @return [::Array<::String>]
        #     Optional. The list of scope names of the reference list. The scope names
        #     should be full resource names and should be of the format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope_name}`.
        class ReferenceListScope
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get details about a reference list.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the reference list to retrieve.
        #     Format:
        #     `projects/{project}/locations/{locations}/instances/{instance}/referenceLists/{reference_list}`
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Chronicle::V1::ReferenceListView]
        #     How much of the ReferenceList to view. Defaults to
        #     REFERENCE_LIST_VIEW_FULL.
        class GetReferenceListRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request for a list of reference lists.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of reference lists.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of reference lists to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 100 reference lists will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListReferenceLists` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListReferenceLists` must
        #     match the call that provided the page token.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Chronicle::V1::ReferenceListView]
        #     How much of each ReferenceList to view. Defaults to
        #     REFERENCE_LIST_VIEW_BASIC.
        class ListReferenceListsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response to a request for a list of reference lists.
        # @!attribute [rw] reference_lists
        #   @return [::Array<::Google::Cloud::Chronicle::V1::ReferenceList>]
        #     The reference lists.
        #     Ordered in ascending alphabetical order by name.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListReferenceListsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to create a reference list.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this reference list will be created.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] reference_list
        #   @return [::Google::Cloud::Chronicle::V1::ReferenceList]
        #     Required. The reference list to create.
        # @!attribute [rw] reference_list_id
        #   @return [::String]
        #     Required. The ID to use for the reference list. This is also the display
        #     name for the reference list. It must satisfy the following requirements:
        #     - Starts with letter.
        #     - Contains only letters, numbers and underscore.
        #     - Has length less than 256.
        #     - Must be unique.
        class CreateReferenceListRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to update a reference list.
        # @!attribute [rw] reference_list
        #   @return [::Google::Cloud::Chronicle::V1::ReferenceList]
        #     Required. The reference list to update.
        #
        #     The reference list's `name` field is used to identify the reference list to
        #     update.
        #     Format:
        #     `projects/{project}/locations/{locations}/instances/{instance}/referenceLists/{reference_list}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update.
        #     When no field mask is supplied, all non-empty fields will be updated.
        #     A field mask of "*" will update all fields, whether empty or not.
        class UpdateReferenceListRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A reference list.
        # Reference lists are user-defined lists of values which users can
        # use in multiple Rules.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the reference list.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}`
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The unique display name of the reference list.
        # @!attribute [r] revision_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the reference list was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Required. A user-provided description of the reference list.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::Chronicle::V1::ReferenceListEntry>]
        #     Required. The entries of the reference list.
        #     When listed, they are returned in the order that was specified at creation
        #     or update. The combined size of the values of the reference list may not
        #     exceed 6MB.
        #     This is returned only when the view is REFERENCE_LIST_VIEW_FULL.
        # @!attribute [r] rules
        #   @return [::Array<::String>]
        #     Output only. The resource names for the associated self-authored Rules that
        #     use this reference list. This is returned only when the view is
        #     REFERENCE_LIST_VIEW_FULL.
        # @!attribute [rw] syntax_type
        #   @return [::Google::Cloud::Chronicle::V1::ReferenceListSyntaxType]
        #     Required. The syntax type indicating how list entries should be validated.
        # @!attribute [r] rule_associations_count
        #   @return [::Integer]
        #     Output only. The count of self-authored rules using the reference list.
        # @!attribute [rw] scope_info
        #   @return [::Google::Cloud::Chronicle::V1::ScopeInfo]
        #     The scope info of the reference list.
        #     During reference list creation, if this field is not set, the reference
        #     list without scopes (an unscoped list) will be created for an unscoped
        #     user. For a scoped user, this field must be set. During reference list
        #     update, if scope_info is requested to be updated, this field must be set.
        class ReferenceList
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An entry in a reference list.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. The value of the entry. Maximum length is 512 characters.
        class ReferenceListEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The syntax type indicating how list entries should be validated.
        module ReferenceListSyntaxType
          # Defaults to REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING.
          REFERENCE_LIST_SYNTAX_TYPE_UNSPECIFIED = 0

          # List contains plain text patterns.
          REFERENCE_LIST_SYNTAX_TYPE_PLAIN_TEXT_STRING = 1

          # List contains only Regular Expression patterns.
          REFERENCE_LIST_SYNTAX_TYPE_REGEX = 2

          # List contains only CIDR patterns.
          REFERENCE_LIST_SYNTAX_TYPE_CIDR = 3
        end

        # ReferenceListView is a mechanism for viewing partial responses of the
        # ReferenceList resource.
        module ReferenceListView
          # The default / unset value.
          # The API will default to the BASIC view for ListReferenceLists.
          # The API will default to the FULL view for methods that return a single
          # ReferenceList resource.
          REFERENCE_LIST_VIEW_UNSPECIFIED = 0

          # Include metadata about the ReferenceList.
          # This is the default view for ListReferenceLists.
          REFERENCE_LIST_VIEW_BASIC = 1

          # Include all details about the ReferenceList: metadata, content lines,
          # associated rule counts. This is the default view for GetReferenceList.
          REFERENCE_LIST_VIEW_FULL = 2
        end
      end
    end
  end
end
