# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Chronicle
      module V1
        # A watchlist is a list of entities that allows for bulk operations over the
        # included entities.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the watchlist.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name of the watchlist.
        #     Note that it must be at least one character and less than 63 characters
        #     (https://google.aip.dev/148).
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the watchlist.
        # @!attribute [rw] multiplying_factor
        #   @return [::Float]
        #     Optional. Weight applied to the risk score for entities
        #     in this watchlist.
        #     The default is 1.0 if it is not specified.
        # @!attribute [rw] entity_population_mechanism
        #   @return [::Google::Cloud::Chronicle::V1::Watchlist::EntityPopulationMechanism]
        #     Required. Mechanism to populate entities in the watchlist.
        # @!attribute [r] entity_count
        #   @return [::Google::Cloud::Chronicle::V1::Watchlist::EntityCount]
        #     Output only. Entity count in the watchlist.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the watchlist was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the watchlist was last updated.
        # @!attribute [rw] watchlist_user_preferences
        #   @return [::Google::Cloud::Chronicle::V1::WatchlistUserPreferences]
        #     Optional. User preferences for watchlist configuration.
        class Watchlist
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Mechanism to populate entities in the watchlist.
          # @!attribute [rw] manual
          #   @return [::Google::Cloud::Chronicle::V1::Watchlist::EntityPopulationMechanism::Manual]
          #     Optional. Entities are added manually.
          class EntityPopulationMechanism
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Entities are added manually.
            class Manual
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Count of different types of entities in the watchlist.
          # @!attribute [r] user
          #   @return [::Integer]
          #     Output only. Count of user type entities in the watchlist.
          # @!attribute [r] asset
          #   @return [::Integer]
          #     Output only. Count of asset type entities in the watchlist.
          class EntityCount
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A collection of user preferences for watchlist UI configuration.
        # @!attribute [rw] pinned
        #   @return [::Boolean]
        #     Optional. Whether the watchlist is pinned on the dashboard.
        class WatchlistUserPreferences
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for getting a watchlist.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The parent, which owns this collection of watchlists.
        #     The name of the watchlist to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}`
        class GetWatchlistRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for listing watchlists.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of watchlists.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of watchlists to return.
        #     The service may return fewer than this value.
        #     If unspecified, at most 200 watchlists will be returned.
        #     The maximum value is 200; values above 200 will be coerced to 200.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListWatchlists` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListWatchlists` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Which watchlist to return in aip.dev/160 form.
        #     Currently, only the following filters are supported:
        #     - `watchlist_user_preferences.pinned=true`
        #     - `has_entity([ENTITY_INDICATOR],[ENTITY_TYPE])`
        #     - `has_entity([ENTITY_INDICATOR],[ENTITY_TYPE],[NAMESPACE])`
        class ListWatchlistsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for listing watchlists.
        # @!attribute [rw] watchlists
        #   @return [::Array<::Google::Cloud::Chronicle::V1::Watchlist>]
        #     Optional. The watchlists from the specified instance.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. A token, which can be sent as `page_token` to retrieve the next
        #     page. If this field is omitted, there are no subsequent pages.
        class ListWatchlistsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for creating watchlist.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this watchlist will be created.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] watchlist_id
        #   @return [::String]
        #     Optional. The ID to use for the watchlist,
        #     which will become the final component of the watchlist's resource name.
        #
        #     This value should be 4-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        # @!attribute [rw] watchlist
        #   @return [::Google::Cloud::Chronicle::V1::Watchlist]
        #     Required. The watchlist to create.
        class CreateWatchlistRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for updating watchlist.
        # @!attribute [rw] watchlist
        #   @return [::Google::Cloud::Chronicle::V1::Watchlist]
        #     Required. The watchlist to update.
        #
        #     The watchlist's `name` field is used to identify the watchlist to update.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. The list of fields to update.
        class UpdateWatchlistRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for deleting watchlist.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the watchlist to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any entities under this watchlist will also be
        #     deleted. (Otherwise, the request will only work if the watchlist has no
        #     entities.)
        class DeleteWatchlistRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
