# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Chronicle
      module V1
        # Request message for CreateDataAccessLabel.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this Data Access Label will be created.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] data_access_label
        #   @return [::Google::Cloud::Chronicle::V1::DataAccessLabel]
        #     Required. Data access label to create.
        # @!attribute [rw] data_access_label_id
        #   @return [::String]
        #     Required. The ID to use for the data access label, which will become the
        #     label's display name and the final component of the label's resource name.
        #     The maximum number of characters should be 63. Regex pattern is as per AIP:
        #     https://google.aip.dev/122#resource-id-segments
        class CreateDataAccessLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to retrieve a data access label.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ID of the data access label to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}`
        class GetDataAccessLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDataAccessLabels.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this data access label will be created.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of data access labels to return. The service may return
        #     fewer than this value. If unspecified, at most 100 data access labels will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDataAccessLabelsRequest` call.
        #     Provide this to retrieve the subsequent page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter which should follow the guidelines of AIP-160.
        #     Supports filtering on all fieds of DataAccessLabel and all operations as
        #     mentioned in https://google.aip.dev/160.
        #     example filter: "create_time greater than \"2023-04-21T11:30:00-04:00\" OR
        #     display_name:\"-21-1\"".
        class ListDataAccessLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDataAccessLabels.
        # @!attribute [rw] data_access_labels
        #   @return [::Array<::Google::Cloud::Chronicle::V1::DataAccessLabel>]
        #     List of data access labels.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDataAccessLabelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDataAccessLabel method.
        # @!attribute [rw] data_access_label
        #   @return [::Google::Cloud::Chronicle::V1::DataAccessLabel]
        #     Required. The data access label to update.
        #
        #     The label's `name` field is used to identify the label to update.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update. If not included, all fields with a non-empty
        #     value will be overwritten. Currently, only the description and definition
        #     fields are supported for update; an update call that attempts to update any
        #     other fields will return INVALID_ARGUMENT.
        class UpdateDataAccessLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete a data access label.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ID of the data access label to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}`
        class DeleteDataAccessLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDataAccessScope.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this Data Access Scope will be created.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] data_access_scope
        #   @return [::Google::Cloud::Chronicle::V1::DataAccessScope]
        #     Required. Data access scope to create.
        # @!attribute [rw] data_access_scope_id
        #   @return [::String]
        #     Required. The user provided scope id which will become the last part of the
        #     name of the scope resource. Needs to be compliant with
        #     https://google.aip.dev/122
        class CreateDataAccessScopeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to retrieve a data access scope.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ID of the data access scope to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}`
        class GetDataAccessScopeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDataAccessScopes.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this data access scope will be created.
        #     Format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of data access scopes to return. The service may return
        #     fewer than this value. If unspecified, at most 100 data access scopes will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDataAccessScopesRequest` call.
        #     Provide this to retrieve the subsequent page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter which should follow the guidelines of AIP-160.
        #     Supports filtering on all fieds of DataAccessScope and all operations as
        #     mentioned in https://google.aip.dev/160.
        #     example filter: "create_time greater than \"2023-04-21T11:30:00-04:00\" OR
        #     display_name:\"-21-1\"".
        class ListDataAccessScopesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDataAccessScopes.
        # @!attribute [rw] data_access_scopes
        #   @return [::Array<::Google::Cloud::Chronicle::V1::DataAccessScope>]
        #     List of data access scopes.
        # @!attribute [rw] global_data_access_scope_granted
        #   @return [::Boolean]
        #     Whether or not global scope is granted to the user.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListDataAccessScopesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDataAccessScope method.
        # @!attribute [rw] data_access_scope
        #   @return [::Google::Cloud::Chronicle::V1::DataAccessScope]
        #     Required. The data access scope to update.
        #
        #     The scope's `name` field is used to identify the scope to update.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}`
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update. If not included, all fields with a non-empty
        #     value will be overwritten. Currently, only the description, the allowed
        #     and denied labels list fields are supported for update;
        #     an update call that attempts to update any
        #     other fields will return INVALID_ARGUMENT.
        class UpdateDataAccessScopeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete a data access scope.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ID of the data access scope to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}`
        class DeleteDataAccessScopeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A DataAccessLabel is a label on events to define user access to data.
        # @!attribute [rw] udm_query
        #   @return [::String]
        #     A UDM query over event data.
        # @!attribute [rw] name
        #   @return [::String]
        #     The unique resource name of the data access label.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The short name displayed for the label as it appears on event
        #     data.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the data access label was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the data access label was last updated.
        # @!attribute [r] author
        #   @return [::String]
        #     Output only. The user who created the data access label.
        # @!attribute [r] last_editor
        #   @return [::String]
        #     Output only. The user who last updated the data access label.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of the data access label for a human reader.
        class DataAccessLabel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A DataAccessScope is a boolean expression of data access labels used
        # to restrict access to data for users.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The unique full name of the data access scope.
        #     The name should comply with https://google.aip.dev/122 standards.
        # @!attribute [rw] allowed_data_access_labels
        #   @return [::Array<::Google::Cloud::Chronicle::V1::DataAccessLabelReference>]
        #     Optional. The allowed labels for the scope.
        #     Either allow_all or allowed_data_access_labels needs to be provided.
        #     When provided, there has to be at least one label allowed for the scope to
        #     be valid.
        #     The logical operator for evaluation of the allowed labels is OR.
        #     E.g.: A customer with scope with allowed labels A and B will be able
        #     to see data with labeled with A or B or (A and B).
        # @!attribute [rw] denied_data_access_labels
        #   @return [::Array<::Google::Cloud::Chronicle::V1::DataAccessLabelReference>]
        #     Optional. The denied labels for the scope.
        #     The logical operator for evaluation of the denied labels is AND.
        #     E.g.: A customer with scope with denied labels A and B won't be able
        #     to see data labeled with A and data labeled with B
        #     and data with labels A and B.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The name to be used for display to customers of the data
        #     access scope.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the data access scope was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the data access scope was last updated.
        # @!attribute [r] author
        #   @return [::String]
        #     Output only. The user who created the data access scope.
        # @!attribute [r] last_editor
        #   @return [::String]
        #     Output only. The user who last updated the data access scope.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of the data access scope for a human reader.
        # @!attribute [rw] allow_all
        #   @return [::Boolean]
        #     Optional. Whether or not the scope allows all labels, allow_all and
        #     allowed_data_access_labels are mutually exclusive and one of them must be
        #     present. denied_data_access_labels can still be used along with allow_all.
        #     When combined with denied_data_access_labels, access will be granted to all
        #     data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
        #     A customer with scope with denied labels A and B and allow_all will be able
        #     to see all data except data labeled with A and data labeled with B and data
        #     with labels A and B.
        class DataAccessScope
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Reference object to a data access label.
        # @!attribute [rw] data_access_label
        #   @return [::String]
        #     The name of the data access label.
        #
        #     Note: The following fields are mutually exclusive: `data_access_label`, `log_type`, `asset_namespace`, `ingestion_label`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] log_type
        #   @return [::String]
        #     The name of the log type.
        #
        #     Note: The following fields are mutually exclusive: `log_type`, `data_access_label`, `asset_namespace`, `ingestion_label`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] asset_namespace
        #   @return [::String]
        #     The asset namespace configured in the forwarder
        #     of the customer's events.
        #
        #     Note: The following fields are mutually exclusive: `asset_namespace`, `data_access_label`, `log_type`, `ingestion_label`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ingestion_label
        #   @return [::Google::Cloud::Chronicle::V1::IngestionLabel]
        #     The ingestion label configured in the forwarder of the customer's events.
        #
        #     Note: The following fields are mutually exclusive: `ingestion_label`, `data_access_label`, `log_type`, `asset_namespace`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of the label.
        #     Data access label and log types's name
        #     will match the display name of the resource.
        #     The asset namespace will match the namespace itself.
        #     The ingestion key value pair will match the key of the tuple.
        class DataAccessLabelReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Representation of an ingestion label type.
        # @!attribute [rw] ingestion_label_key
        #   @return [::String]
        #     Required. The key of the ingestion label. Always required.
        # @!attribute [rw] ingestion_label_value
        #   @return [::String]
        #     Optional. The value of the ingestion label. Optional. An object
        #     with no provided value and some key provided would match
        #     against the given key and ANY value.
        class IngestionLabel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
