# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Chronicle
      module V1
        module RuleService
          # Path helper methods for the RuleService API.
          module Paths
            ##
            # Create a fully-qualified DataAccessScope resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            # @param data_access_scope [String]
            #
            # @return [::String]
            def data_access_scope_path project:, location:, instance:, data_access_scope:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}/dataAccessScopes/#{data_access_scope}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, location:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified ReferenceList resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            # @param reference_list [String]
            #
            # @return [::String]
            def reference_list_path project:, location:, instance:, reference_list:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}/referenceLists/#{reference_list}"
            end

            ##
            # Create a fully-qualified Retrohunt resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            # @param rule [String]
            # @param retrohunt [String]
            #
            # @return [::String]
            def retrohunt_path project:, location:, instance:, rule:, retrohunt:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"
              raise ::ArgumentError, "rule cannot contain /" if rule.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}/rules/#{rule}/retrohunts/#{retrohunt}"
            end

            ##
            # Create a fully-qualified Rule resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            # @param rule [String]
            #
            # @return [::String]
            def rule_path project:, location:, instance:, rule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}/rules/#{rule}"
            end

            ##
            # Create a fully-qualified RuleDeployment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            # @param rule [String]
            #
            # @return [::String]
            def rule_deployment_path project:, location:, instance:, rule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}/rules/#{rule}/deployment"
            end

            extend self
          end
        end
      end
    end
  end
end
