# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/chronicle/v1/rule_pb"

module Google
  module Cloud
    module Chronicle
      module V1
        module RuleService
          ##
          # Client for the RuleService service.
          #
          # RuleService provides interface for user-created rules.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "chronicle.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :rule_service_stub

            ##
            # Configure the RuleService Client class.
            #
            # See {::Google::Cloud::Chronicle::V1::RuleService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all RuleService clients
            #   ::Google::Cloud::Chronicle::V1::RuleService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Chronicle", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_rule.timeout = 60.0

                default_config.rpcs.get_rule.timeout = 60.0
                default_config.rpcs.get_rule.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_rules.timeout = 600.0
                default_config.rpcs.list_rules.retry_policy = {
                  initial_delay: 1.0, max_delay: 600.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_rule.timeout = 600.0

                default_config.rpcs.delete_rule.timeout = 60.0

                default_config.rpcs.list_rule_revisions.timeout = 600.0
                default_config.rpcs.list_rule_revisions.retry_policy = {
                  initial_delay: 1.0, max_delay: 600.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_retrohunt.timeout = 600.0

                default_config.rpcs.get_retrohunt.timeout = 60.0
                default_config.rpcs.get_retrohunt.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_retrohunts.timeout = 60.0
                default_config.rpcs.list_retrohunts.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_rule_deployment.timeout = 600.0
                default_config.rpcs.get_rule_deployment.retry_policy = {
                  initial_delay: 1.0, max_delay: 600.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_rule_deployments.timeout = 600.0
                default_config.rpcs.list_rule_deployments.retry_policy = {
                  initial_delay: 1.0, max_delay: 600.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_rule_deployment.timeout = 600.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the RuleService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Chronicle::V1::RuleService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @rule_service_stub.universe_domain
            end

            ##
            # Create a new RuleService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the RuleService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/chronicle/v1/rule_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @rule_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Chronicle::V1::RuleService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @rule_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Chronicle::V1::RuleService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @rule_service_stub.logger
            end

            # Service calls

            ##
            # Creates a new Rule.
            #
            # @overload create_rule(request, options = nil)
            #   Pass arguments to `create_rule` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::CreateRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::CreateRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_rule(parent: nil, rule: nil)
            #   Pass arguments to `create_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this rule will be created.
            #     Format: `projects/{project}/locations/{location}/instances/{instance}`
            #   @param rule [::Google::Cloud::Chronicle::V1::Rule, ::Hash]
            #     Required. The rule to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::Rule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::Rule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::CreateRuleRequest.new
            #
            #   # Call the create_rule method.
            #   result = client.create_rule request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::Rule.
            #   p result
            #
            def create_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::CreateRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :create_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a Rule.
            #
            # @overload get_rule(request, options = nil)
            #   Pass arguments to `get_rule` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::GetRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::GetRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_rule(name: nil, view: nil)
            #   Pass arguments to `get_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the rule to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
            #   @param view [::Google::Cloud::Chronicle::V1::RuleView]
            #     The view field indicates the scope of fields to populate for the Rule being
            #     returned. If unspecified, defaults to FULL.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::Rule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::Rule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::GetRuleRequest.new
            #
            #   # Call the get_rule method.
            #   result = client.get_rule request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::Rule.
            #   p result
            #
            def get_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::GetRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :get_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Rules.
            #
            # @overload list_rules(request, options = nil)
            #   Pass arguments to `list_rules` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::ListRulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::ListRulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_rules(parent: nil, page_size: nil, page_token: nil, view: nil, filter: nil)
            #   Pass arguments to `list_rules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns this collection of rules.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}`
            #   @param page_size [::Integer]
            #     The maximum number of rules to return. The service may return fewer than
            #     this value. If unspecified, at most 100 rules will be returned. The
            #     maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListRules` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListRules`
            #     must match the call that provided the page token.
            #   @param view [::Google::Cloud::Chronicle::V1::RuleView]
            #     view indicates the scope of fields to populate for the Rule being returned.
            #     If unspecified, defaults to BASIC.
            #   @param filter [::String]
            #     Only the following filters are allowed:
            #     "reference_lists:\\{reference_list_name}"
            #     "data_tables:\\{data_table_name}"
            #     "display_name:\\{display_name}"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::Rule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::Rule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::ListRulesRequest.new
            #
            #   # Call the list_rules method.
            #   result = client.list_rules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Chronicle::V1::Rule.
            #     p item
            #   end
            #
            def list_rules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::ListRulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_rules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_rules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_rules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :list_rules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @rule_service_stub, :list_rules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a Rule.
            #
            # @overload update_rule(request, options = nil)
            #   Pass arguments to `update_rule` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::UpdateRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::UpdateRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_rule(rule: nil, update_mask: nil)
            #   Pass arguments to `update_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param rule [::Google::Cloud::Chronicle::V1::Rule, ::Hash]
            #     Required. The rule to update.
            #
            #     The rule's `name` field is used to identify the rule to update.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to update. If not included, all fields with a non-empty
            #     value will be overwritten.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::Rule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::Rule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::UpdateRuleRequest.new
            #
            #   # Call the update_rule method.
            #   result = client.update_rule request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::Rule.
            #   p result
            #
            def update_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::UpdateRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.rule&.name
                header_params["rule.name"] = request.rule.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :update_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Rule.
            #
            # @overload delete_rule(request, options = nil)
            #   Pass arguments to `delete_rule` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::DeleteRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::DeleteRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_rule(name: nil, force: nil)
            #   Pass arguments to `delete_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the rule to delete. A rule revision timestamp cannot
            #     be specified as part of the name, as deleting specific revisions is not
            #     supported.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
            #   @param force [::Boolean]
            #     Optional. If set to true, any retrohunts and any detections associated with
            #     the rule will also be deleted. If set to false, the call will only succeed
            #     if the rule has no associated retrohunts, including completed retrohunts,
            #     and no associated detections. Regardless of this field's value, the rule
            #     deployment associated with this rule will also be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::DeleteRuleRequest.new
            #
            #   # Call the delete_rule method.
            #   result = client.delete_rule request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::DeleteRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :delete_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all revisions of the rule.
            #
            # @overload list_rule_revisions(request, options = nil)
            #   Pass arguments to `list_rule_revisions` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::ListRuleRevisionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::ListRuleRevisionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_rule_revisions(name: nil, page_size: nil, page_token: nil, view: nil)
            #   Pass arguments to `list_rule_revisions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the rule to list revisions for.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
            #   @param page_size [::Integer]
            #     The maximum number of revisions to return per page. The service may return
            #     fewer than this value. If unspecified, at most 100 revisions will be
            #     returned. The maximum value is 1000; values above 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     The page token, received from a previous `ListRuleRevisions` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListRuleRevisions`
            #     must match the call that provided the page token.
            #   @param view [::Google::Cloud::Chronicle::V1::RuleView]
            #     The view field indicates the scope of fields to populate for the revision
            #     being returned. If unspecified, defaults to BASIC.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::Rule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::Rule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::ListRuleRevisionsRequest.new
            #
            #   # Call the list_rule_revisions method.
            #   result = client.list_rule_revisions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Chronicle::V1::Rule.
            #     p item
            #   end
            #
            def list_rule_revisions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::ListRuleRevisionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_rule_revisions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_rule_revisions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_rule_revisions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :list_rule_revisions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @rule_service_stub, :list_rule_revisions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a Retrohunt.
            #
            # @overload create_retrohunt(request, options = nil)
            #   Pass arguments to `create_retrohunt` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::CreateRetrohuntRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::CreateRetrohuntRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_retrohunt(parent: nil, retrohunt: nil)
            #   Pass arguments to `create_retrohunt` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of retrohunt, which is a rule.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
            #   @param retrohunt [::Google::Cloud::Chronicle::V1::Retrohunt, ::Hash]
            #     Required. The retrohunt to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::CreateRetrohuntRequest.new
            #
            #   # Call the create_retrohunt method.
            #   result = client.create_retrohunt request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_retrohunt request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::CreateRetrohuntRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_retrohunt.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_retrohunt.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_retrohunt.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :create_retrohunt, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a Retrohunt.
            #
            # @overload get_retrohunt(request, options = nil)
            #   Pass arguments to `get_retrohunt` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::GetRetrohuntRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::GetRetrohuntRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_retrohunt(name: nil)
            #   Pass arguments to `get_retrohunt` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the retrohunt to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::Retrohunt]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::Retrohunt]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::GetRetrohuntRequest.new
            #
            #   # Call the get_retrohunt method.
            #   result = client.get_retrohunt request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::Retrohunt.
            #   p result
            #
            def get_retrohunt request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::GetRetrohuntRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_retrohunt.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_retrohunt.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_retrohunt.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :get_retrohunt, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List Retrohunts.
            #
            # @overload list_retrohunts(request, options = nil)
            #   Pass arguments to `list_retrohunts` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::ListRetrohuntsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::ListRetrohuntsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_retrohunts(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_retrohunts` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The rule that the retrohunts belong to.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}`
            #   @param page_size [::Integer]
            #     The maximum number of retrohunt to return. The service may return fewer
            #     than this value. If unspecified, at most 100 retrohunts will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListRetrohunts` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListRetrohunts` must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     A filter that can be used to retrieve specific rule deployments.
            #     The following fields are filterable:
            #     state
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::Retrohunt>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::Retrohunt>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::ListRetrohuntsRequest.new
            #
            #   # Call the list_retrohunts method.
            #   result = client.list_retrohunts request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Chronicle::V1::Retrohunt.
            #     p item
            #   end
            #
            def list_retrohunts request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::ListRetrohuntsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_retrohunts.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_retrohunts.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_retrohunts.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :list_retrohunts, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @rule_service_stub, :list_retrohunts, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a RuleDeployment.
            #
            # @overload get_rule_deployment(request, options = nil)
            #   Pass arguments to `get_rule_deployment` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::GetRuleDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::GetRuleDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_rule_deployment(name: nil)
            #   Pass arguments to `get_rule_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the rule deployment to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::RuleDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::RuleDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::GetRuleDeploymentRequest.new
            #
            #   # Call the get_rule_deployment method.
            #   result = client.get_rule_deployment request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::RuleDeployment.
            #   p result
            #
            def get_rule_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::GetRuleDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_rule_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_rule_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_rule_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :get_rule_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists RuleDeployments across all Rules.
            #
            # @overload list_rule_deployments(request, options = nil)
            #   Pass arguments to `list_rule_deployments` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::ListRuleDeploymentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::ListRuleDeploymentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_rule_deployments(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_rule_deployments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The collection of all parents which own all rule deployments. The
            #     "-" wildcard token must be used as the rule identifier in the resource
            #     path. Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/-`
            #   @param page_size [::Integer]
            #     The maximum number of rule deployments to return. The service may return
            #     fewer than this value. If unspecified, at most 100 rule deployments will be
            #     returned. The maximum value is 1000; values above 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListRuleDeployments` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListRuleDeployments`
            #     must match the call that provided the page token.
            #   @param filter [::String]
            #     A filter that can be used to retrieve specific rule deployments.
            #     The following fields are filterable:
            #     archived, name
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::RuleDeployment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::RuleDeployment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::ListRuleDeploymentsRequest.new
            #
            #   # Call the list_rule_deployments method.
            #   result = client.list_rule_deployments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Chronicle::V1::RuleDeployment.
            #     p item
            #   end
            #
            def list_rule_deployments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::ListRuleDeploymentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_rule_deployments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_rule_deployments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_rule_deployments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :list_rule_deployments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @rule_service_stub, :list_rule_deployments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a RuleDeployment.
            # Failures are not necessarily atomic. If there is a request to update
            # multiple fields, and any update to a single field fails, an error will be
            # returned, but other fields may remain successfully updated.
            #
            # @overload update_rule_deployment(request, options = nil)
            #   Pass arguments to `update_rule_deployment` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::UpdateRuleDeploymentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::UpdateRuleDeploymentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_rule_deployment(rule_deployment: nil, update_mask: nil)
            #   Pass arguments to `update_rule_deployment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param rule_deployment [::Google::Cloud::Chronicle::V1::RuleDeployment, ::Hash]
            #     Required. The rule deployment to update.
            #
            #     The rule deployment's `name` field is used to identify the rule deployment
            #     to update. Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The list of fields to update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::RuleDeployment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::RuleDeployment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::RuleService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::UpdateRuleDeploymentRequest.new
            #
            #   # Call the update_rule_deployment method.
            #   result = client.update_rule_deployment request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::RuleDeployment.
            #   p result
            #
            def update_rule_deployment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::UpdateRuleDeploymentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_rule_deployment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.rule_deployment&.name
                header_params["rule_deployment.name"] = request.rule_deployment.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_rule_deployment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_rule_deployment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @rule_service_stub.call_rpc :update_rule_deployment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the RuleService API.
            #
            # This class represents the configuration for RuleService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Chronicle::V1::RuleService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_rule to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Chronicle::V1::RuleService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_rule.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_rule.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Chronicle::V1::RuleService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "chronicle.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the RuleService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_rule
                ##
                # RPC-specific configuration for `get_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_rule
                ##
                # RPC-specific configuration for `list_rules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_rules
                ##
                # RPC-specific configuration for `update_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_rule
                ##
                # RPC-specific configuration for `delete_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_rule
                ##
                # RPC-specific configuration for `list_rule_revisions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_rule_revisions
                ##
                # RPC-specific configuration for `create_retrohunt`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_retrohunt
                ##
                # RPC-specific configuration for `get_retrohunt`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_retrohunt
                ##
                # RPC-specific configuration for `list_retrohunts`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_retrohunts
                ##
                # RPC-specific configuration for `get_rule_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_rule_deployment
                ##
                # RPC-specific configuration for `list_rule_deployments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_rule_deployments
                ##
                # RPC-specific configuration for `update_rule_deployment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_rule_deployment

                # @private
                def initialize parent_rpcs = nil
                  create_rule_config = parent_rpcs.create_rule if parent_rpcs.respond_to? :create_rule
                  @create_rule = ::Gapic::Config::Method.new create_rule_config
                  get_rule_config = parent_rpcs.get_rule if parent_rpcs.respond_to? :get_rule
                  @get_rule = ::Gapic::Config::Method.new get_rule_config
                  list_rules_config = parent_rpcs.list_rules if parent_rpcs.respond_to? :list_rules
                  @list_rules = ::Gapic::Config::Method.new list_rules_config
                  update_rule_config = parent_rpcs.update_rule if parent_rpcs.respond_to? :update_rule
                  @update_rule = ::Gapic::Config::Method.new update_rule_config
                  delete_rule_config = parent_rpcs.delete_rule if parent_rpcs.respond_to? :delete_rule
                  @delete_rule = ::Gapic::Config::Method.new delete_rule_config
                  list_rule_revisions_config = parent_rpcs.list_rule_revisions if parent_rpcs.respond_to? :list_rule_revisions
                  @list_rule_revisions = ::Gapic::Config::Method.new list_rule_revisions_config
                  create_retrohunt_config = parent_rpcs.create_retrohunt if parent_rpcs.respond_to? :create_retrohunt
                  @create_retrohunt = ::Gapic::Config::Method.new create_retrohunt_config
                  get_retrohunt_config = parent_rpcs.get_retrohunt if parent_rpcs.respond_to? :get_retrohunt
                  @get_retrohunt = ::Gapic::Config::Method.new get_retrohunt_config
                  list_retrohunts_config = parent_rpcs.list_retrohunts if parent_rpcs.respond_to? :list_retrohunts
                  @list_retrohunts = ::Gapic::Config::Method.new list_retrohunts_config
                  get_rule_deployment_config = parent_rpcs.get_rule_deployment if parent_rpcs.respond_to? :get_rule_deployment
                  @get_rule_deployment = ::Gapic::Config::Method.new get_rule_deployment_config
                  list_rule_deployments_config = parent_rpcs.list_rule_deployments if parent_rpcs.respond_to? :list_rule_deployments
                  @list_rule_deployments = ::Gapic::Config::Method.new list_rule_deployments_config
                  update_rule_deployment_config = parent_rpcs.update_rule_deployment if parent_rpcs.respond_to? :update_rule_deployment
                  @update_rule_deployment = ::Gapic::Config::Method.new update_rule_deployment_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
