# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/chronicle/v1/reference_list_pb"
require "google/cloud/chronicle/v1/reference_list_service/rest/service_stub"

module Google
  module Cloud
    module Chronicle
      module V1
        module ReferenceListService
          module Rest
            ##
            # REST client for the ReferenceListService service.
            #
            # ReferenceListService provides an interface for managing reference lists.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "chronicle.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :reference_list_service_stub

              ##
              # Configure the ReferenceListService Client class.
              #
              # See {::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ReferenceListService clients
              #   ::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Chronicle", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.get_reference_list.timeout = 60.0
                  default_config.rpcs.get_reference_list.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_reference_lists.timeout = 60.0
                  default_config.rpcs.list_reference_lists.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_reference_list.timeout = 60.0

                  default_config.rpcs.update_reference_list.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ReferenceListService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @reference_list_service_stub.universe_domain
              end

              ##
              # Create a new ReferenceListService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ReferenceListService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @reference_list_service_stub = ::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @reference_list_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @reference_list_service_stub.logger
              end

              # Service calls

              ##
              # Gets a single reference list.
              #
              # @overload get_reference_list(request, options = nil)
              #   Pass arguments to `get_reference_list` via a request object, either of type
              #   {::Google::Cloud::Chronicle::V1::GetReferenceListRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Chronicle::V1::GetReferenceListRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_reference_list(name: nil, view: nil)
              #   Pass arguments to `get_reference_list` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the reference list to retrieve.
              #     Format:
              #     `projects/{project}/locations/{locations}/instances/{instance}/referenceLists/{reference_list}`
              #   @param view [::Google::Cloud::Chronicle::V1::ReferenceListView]
              #     How much of the ReferenceList to view. Defaults to
              #     REFERENCE_LIST_VIEW_FULL.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Chronicle::V1::ReferenceList]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Chronicle::V1::ReferenceList]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/chronicle/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Chronicle::V1::GetReferenceListRequest.new
              #
              #   # Call the get_reference_list method.
              #   result = client.get_reference_list request
              #
              #   # The returned object is of type Google::Cloud::Chronicle::V1::ReferenceList.
              #   p result
              #
              def get_reference_list request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::GetReferenceListRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_reference_list.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Chronicle::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_reference_list.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_reference_list.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reference_list_service_stub.get_reference_list request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists a collection of reference lists.
              #
              # @overload list_reference_lists(request, options = nil)
              #   Pass arguments to `list_reference_lists` via a request object, either of type
              #   {::Google::Cloud::Chronicle::V1::ListReferenceListsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Chronicle::V1::ListReferenceListsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_reference_lists(parent: nil, page_size: nil, page_token: nil, view: nil)
              #   Pass arguments to `list_reference_lists` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of reference lists.
              #     Format:
              #     `projects/{project}/locations/{location}/instances/{instance}`
              #   @param page_size [::Integer]
              #     The maximum number of reference lists to return.
              #     The service may return fewer than this value.
              #     If unspecified, at most 100 reference lists will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListReferenceLists` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListReferenceLists` must
              #     match the call that provided the page token.
              #   @param view [::Google::Cloud::Chronicle::V1::ReferenceListView]
              #     How much of each ReferenceList to view. Defaults to
              #     REFERENCE_LIST_VIEW_BASIC.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Chronicle::V1::ReferenceList>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Chronicle::V1::ReferenceList>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/chronicle/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Chronicle::V1::ListReferenceListsRequest.new
              #
              #   # Call the list_reference_lists method.
              #   result = client.list_reference_lists request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Chronicle::V1::ReferenceList.
              #     p item
              #   end
              #
              def list_reference_lists request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::ListReferenceListsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_reference_lists.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Chronicle::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_reference_lists.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_reference_lists.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reference_list_service_stub.list_reference_lists request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @reference_list_service_stub, :list_reference_lists, "reference_lists", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new reference list.
              #
              # @overload create_reference_list(request, options = nil)
              #   Pass arguments to `create_reference_list` via a request object, either of type
              #   {::Google::Cloud::Chronicle::V1::CreateReferenceListRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Chronicle::V1::CreateReferenceListRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_reference_list(parent: nil, reference_list: nil, reference_list_id: nil)
              #   Pass arguments to `create_reference_list` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this reference list will be created.
              #     Format: `projects/{project}/locations/{location}/instances/{instance}`
              #   @param reference_list [::Google::Cloud::Chronicle::V1::ReferenceList, ::Hash]
              #     Required. The reference list to create.
              #   @param reference_list_id [::String]
              #     Required. The ID to use for the reference list. This is also the display
              #     name for the reference list. It must satisfy the following requirements:
              #     - Starts with letter.
              #     - Contains only letters, numbers and underscore.
              #     - Has length less than 256.
              #     - Must be unique.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Chronicle::V1::ReferenceList]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Chronicle::V1::ReferenceList]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/chronicle/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Chronicle::V1::CreateReferenceListRequest.new
              #
              #   # Call the create_reference_list method.
              #   result = client.create_reference_list request
              #
              #   # The returned object is of type Google::Cloud::Chronicle::V1::ReferenceList.
              #   p result
              #
              def create_reference_list request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::CreateReferenceListRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_reference_list.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Chronicle::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_reference_list.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_reference_list.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reference_list_service_stub.create_reference_list request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing reference list.
              #
              # @overload update_reference_list(request, options = nil)
              #   Pass arguments to `update_reference_list` via a request object, either of type
              #   {::Google::Cloud::Chronicle::V1::UpdateReferenceListRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Chronicle::V1::UpdateReferenceListRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_reference_list(reference_list: nil, update_mask: nil)
              #   Pass arguments to `update_reference_list` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param reference_list [::Google::Cloud::Chronicle::V1::ReferenceList, ::Hash]
              #     Required. The reference list to update.
              #
              #     The reference list's `name` field is used to identify the reference list to
              #     update.
              #     Format:
              #     `projects/{project}/locations/{locations}/instances/{instance}/referenceLists/{reference_list}`
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update.
              #     When no field mask is supplied, all non-empty fields will be updated.
              #     A field mask of "*" will update all fields, whether empty or not.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Chronicle::V1::ReferenceList]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Chronicle::V1::ReferenceList]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/chronicle/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Chronicle::V1::UpdateReferenceListRequest.new
              #
              #   # Call the update_reference_list method.
              #   result = client.update_reference_list request
              #
              #   # The returned object is of type Google::Cloud::Chronicle::V1::ReferenceList.
              #   p result
              #
              def update_reference_list request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::UpdateReferenceListRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_reference_list.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Chronicle::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_reference_list.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_reference_list.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @reference_list_service_stub.update_reference_list request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ReferenceListService REST API.
              #
              # This class represents the configuration for ReferenceListService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_reference_list to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_reference_list.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Chronicle::V1::ReferenceListService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_reference_list.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "chronicle.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ReferenceListService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_reference_list`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_reference_list
                  ##
                  # RPC-specific configuration for `list_reference_lists`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_reference_lists
                  ##
                  # RPC-specific configuration for `create_reference_list`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_reference_list
                  ##
                  # RPC-specific configuration for `update_reference_list`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_reference_list

                  # @private
                  def initialize parent_rpcs = nil
                    get_reference_list_config = parent_rpcs.get_reference_list if parent_rpcs.respond_to? :get_reference_list
                    @get_reference_list = ::Gapic::Config::Method.new get_reference_list_config
                    list_reference_lists_config = parent_rpcs.list_reference_lists if parent_rpcs.respond_to? :list_reference_lists
                    @list_reference_lists = ::Gapic::Config::Method.new list_reference_lists_config
                    create_reference_list_config = parent_rpcs.create_reference_list if parent_rpcs.respond_to? :create_reference_list
                    @create_reference_list = ::Gapic::Config::Method.new create_reference_list_config
                    update_reference_list_config = parent_rpcs.update_reference_list if parent_rpcs.respond_to? :update_reference_list
                    @update_reference_list = ::Gapic::Config::Method.new update_reference_list_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
