# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/chronicle/v1/data_access_control.proto for package 'Google.Cloud.Chronicle.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/chronicle/v1/data_access_control_pb'

module Google
  module Cloud
    module Chronicle
      module V1
        module DataAccessControlService
          # DataAccessControlService exposes resources and endpoints related to data
          # access control.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.chronicle.v1.DataAccessControlService'

            # Creates a data access label.
            # Data access labels are applied to incoming event data and selected in data
            # access scopes (another resource), and only users with scopes containing the
            # label can see data with that label. Currently, the data access label
            # resource only includes custom labels, which are labels that correspond
            # to UDM queries over event data.
            rpc :CreateDataAccessLabel, ::Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest, ::Google::Cloud::Chronicle::V1::DataAccessLabel
            # Gets a data access label.
            rpc :GetDataAccessLabel, ::Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest, ::Google::Cloud::Chronicle::V1::DataAccessLabel
            # Lists all data access labels for the customer.
            rpc :ListDataAccessLabels, ::Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest, ::Google::Cloud::Chronicle::V1::ListDataAccessLabelsResponse
            # Updates a data access label.
            rpc :UpdateDataAccessLabel, ::Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest, ::Google::Cloud::Chronicle::V1::DataAccessLabel
            # Deletes a data access label. When a label is deleted, new
            # data that enters in the system will not receive the label, but the label
            # will not be removed from old data that still refers to it.
            rpc :DeleteDataAccessLabel, ::Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest, ::Google::Protobuf::Empty
            # Creates a data access scope.
            # Data access scope is a combination of allowed and denied labels attached
            # to a permission group. If a scope has allowed labels A and B and denied
            # labels C and D, then the group of people attached to the scope
            # will have permissions to see all events labeled with A or B (or both) and
            # not labeled with either C or D.
            rpc :CreateDataAccessScope, ::Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest, ::Google::Cloud::Chronicle::V1::DataAccessScope
            # Retrieves an existing data access scope.
            rpc :GetDataAccessScope, ::Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest, ::Google::Cloud::Chronicle::V1::DataAccessScope
            # Lists all existing data access scopes for the customer.
            rpc :ListDataAccessScopes, ::Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest, ::Google::Cloud::Chronicle::V1::ListDataAccessScopesResponse
            # Updates a data access scope.
            rpc :UpdateDataAccessScope, ::Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest, ::Google::Cloud::Chronicle::V1::DataAccessScope
            # Deletes a data access scope.
            rpc :DeleteDataAccessScope, ::Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest, ::Google::Protobuf::Empty
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
