# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/chronicle/v1/data_access_control_pb"

module Google
  module Cloud
    module Chronicle
      module V1
        module DataAccessControlService
          ##
          # Client for the DataAccessControlService service.
          #
          # DataAccessControlService exposes resources and endpoints related to data
          # access control.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "chronicle.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :data_access_control_service_stub

            ##
            # Configure the DataAccessControlService Client class.
            #
            # See {::Google::Cloud::Chronicle::V1::DataAccessControlService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DataAccessControlService clients
            #   ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Chronicle", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_data_access_label.timeout = 60.0

                default_config.rpcs.get_data_access_label.timeout = 60.0
                default_config.rpcs.get_data_access_label.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_data_access_labels.timeout = 60.0
                default_config.rpcs.list_data_access_labels.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_data_access_label.timeout = 60.0

                default_config.rpcs.delete_data_access_label.timeout = 60.0

                default_config.rpcs.create_data_access_scope.timeout = 60.0

                default_config.rpcs.get_data_access_scope.timeout = 60.0
                default_config.rpcs.get_data_access_scope.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_data_access_scopes.timeout = 60.0
                default_config.rpcs.list_data_access_scopes.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_data_access_scope.timeout = 60.0

                default_config.rpcs.delete_data_access_scope.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DataAccessControlService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Chronicle::V1::DataAccessControlService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @data_access_control_service_stub.universe_domain
            end

            ##
            # Create a new DataAccessControlService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DataAccessControlService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/chronicle/v1/data_access_control_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @data_access_control_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Chronicle::V1::DataAccessControlService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @data_access_control_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @data_access_control_service_stub.logger
            end

            # Service calls

            ##
            # Creates a data access label.
            # Data access labels are applied to incoming event data and selected in data
            # access scopes (another resource), and only users with scopes containing the
            # label can see data with that label. Currently, the data access label
            # resource only includes custom labels, which are labels that correspond
            # to UDM queries over event data.
            #
            # @overload create_data_access_label(request, options = nil)
            #   Pass arguments to `create_data_access_label` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_data_access_label(parent: nil, data_access_label: nil, data_access_label_id: nil)
            #   Pass arguments to `create_data_access_label` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this Data Access Label will be created.
            #     Format: `projects/{project}/locations/{location}/instances/{instance}`
            #   @param data_access_label [::Google::Cloud::Chronicle::V1::DataAccessLabel, ::Hash]
            #     Required. Data access label to create.
            #   @param data_access_label_id [::String]
            #     Required. The ID to use for the data access label, which will become the
            #     label's display name and the final component of the label's resource name.
            #     The maximum number of characters should be 63. Regex pattern is as per AIP:
            #     https://google.aip.dev/122#resource-id-segments
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::DataAccessLabel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::DataAccessLabel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest.new
            #
            #   # Call the create_data_access_label method.
            #   result = client.create_data_access_label request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::DataAccessLabel.
            #   p result
            #
            def create_data_access_label request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::CreateDataAccessLabelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_data_access_label.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_data_access_label.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_data_access_label.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :create_data_access_label, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a data access label.
            #
            # @overload get_data_access_label(request, options = nil)
            #   Pass arguments to `get_data_access_label` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_access_label(name: nil)
            #   Pass arguments to `get_data_access_label` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The ID of the data access label to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::DataAccessLabel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::DataAccessLabel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest.new
            #
            #   # Call the get_data_access_label method.
            #   result = client.get_data_access_label request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::DataAccessLabel.
            #   p result
            #
            def get_data_access_label request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::GetDataAccessLabelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_access_label.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_access_label.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_access_label.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :get_data_access_label, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all data access labels for the customer.
            #
            # @overload list_data_access_labels(request, options = nil)
            #   Pass arguments to `list_data_access_labels` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_access_labels(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_data_access_labels` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this data access label will be created.
            #     Format: `projects/{project}/locations/{location}/instances/{instance}`
            #   @param page_size [::Integer]
            #     The maximum number of data access labels to return. The service may return
            #     fewer than this value. If unspecified, at most 100 data access labels will
            #     be returned. The maximum value is 1000; values above 1000 will be coerced
            #     to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListDataAccessLabelsRequest` call.
            #     Provide this to retrieve the subsequent page.
            #   @param filter [::String]
            #     Optional. A filter which should follow the guidelines of AIP-160.
            #     Supports filtering on all fieds of DataAccessLabel and all operations as
            #     mentioned in https://google.aip.dev/160.
            #     example filter: "create_time greater than \"2023-04-21T11:30:00-04:00\" OR
            #     display_name:\"-21-1\"".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::DataAccessLabel>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::DataAccessLabel>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest.new
            #
            #   # Call the list_data_access_labels method.
            #   result = client.list_data_access_labels request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Chronicle::V1::DataAccessLabel.
            #     p item
            #   end
            #
            def list_data_access_labels request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::ListDataAccessLabelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_access_labels.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_access_labels.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_access_labels.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :list_data_access_labels, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_access_control_service_stub, :list_data_access_labels, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a data access label.
            #
            # @overload update_data_access_label(request, options = nil)
            #   Pass arguments to `update_data_access_label` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_data_access_label(data_access_label: nil, update_mask: nil)
            #   Pass arguments to `update_data_access_label` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param data_access_label [::Google::Cloud::Chronicle::V1::DataAccessLabel, ::Hash]
            #     Required. The data access label to update.
            #
            #     The label's `name` field is used to identify the label to update.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to update. If not included, all fields with a non-empty
            #     value will be overwritten. Currently, only the description and definition
            #     fields are supported for update; an update call that attempts to update any
            #     other fields will return INVALID_ARGUMENT.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::DataAccessLabel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::DataAccessLabel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest.new
            #
            #   # Call the update_data_access_label method.
            #   result = client.update_data_access_label request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::DataAccessLabel.
            #   p result
            #
            def update_data_access_label request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::UpdateDataAccessLabelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_data_access_label.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.data_access_label&.name
                header_params["data_access_label.name"] = request.data_access_label.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_data_access_label.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_data_access_label.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :update_data_access_label, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a data access label. When a label is deleted, new
            # data that enters in the system will not receive the label, but the label
            # will not be removed from old data that still refers to it.
            #
            # @overload delete_data_access_label(request, options = nil)
            #   Pass arguments to `delete_data_access_label` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_data_access_label(name: nil)
            #   Pass arguments to `delete_data_access_label` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The ID of the data access label to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest.new
            #
            #   # Call the delete_data_access_label method.
            #   result = client.delete_data_access_label request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_data_access_label request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::DeleteDataAccessLabelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_data_access_label.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_data_access_label.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_data_access_label.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :delete_data_access_label, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a data access scope.
            # Data access scope is a combination of allowed and denied labels attached
            # to a permission group. If a scope has allowed labels A and B and denied
            # labels C and D, then the group of people attached to the scope
            # will have permissions to see all events labeled with A or B (or both) and
            # not labeled with either C or D.
            #
            # @overload create_data_access_scope(request, options = nil)
            #   Pass arguments to `create_data_access_scope` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_data_access_scope(parent: nil, data_access_scope: nil, data_access_scope_id: nil)
            #   Pass arguments to `create_data_access_scope` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this Data Access Scope will be created.
            #     Format: `projects/{project}/locations/{location}/instances/{instance}`
            #   @param data_access_scope [::Google::Cloud::Chronicle::V1::DataAccessScope, ::Hash]
            #     Required. Data access scope to create.
            #   @param data_access_scope_id [::String]
            #     Required. The user provided scope id which will become the last part of the
            #     name of the scope resource. Needs to be compliant with
            #     https://google.aip.dev/122
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::DataAccessScope]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::DataAccessScope]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest.new
            #
            #   # Call the create_data_access_scope method.
            #   result = client.create_data_access_scope request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::DataAccessScope.
            #   p result
            #
            def create_data_access_scope request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::CreateDataAccessScopeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_data_access_scope.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_data_access_scope.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_data_access_scope.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :create_data_access_scope, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves an existing data access scope.
            #
            # @overload get_data_access_scope(request, options = nil)
            #   Pass arguments to `get_data_access_scope` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_access_scope(name: nil)
            #   Pass arguments to `get_data_access_scope` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The ID of the data access scope to retrieve.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::DataAccessScope]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::DataAccessScope]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest.new
            #
            #   # Call the get_data_access_scope method.
            #   result = client.get_data_access_scope request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::DataAccessScope.
            #   p result
            #
            def get_data_access_scope request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::GetDataAccessScopeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_access_scope.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_access_scope.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_access_scope.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :get_data_access_scope, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all existing data access scopes for the customer.
            #
            # @overload list_data_access_scopes(request, options = nil)
            #   Pass arguments to `list_data_access_scopes` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_access_scopes(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_data_access_scopes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this data access scope will be created.
            #     Format: `projects/{project}/locations/{location}/instances/{instance}`
            #   @param page_size [::Integer]
            #     The maximum number of data access scopes to return. The service may return
            #     fewer than this value. If unspecified, at most 100 data access scopes will
            #     be returned. The maximum value is 1000; values above 1000 will be coerced
            #     to 1000.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListDataAccessScopesRequest` call.
            #     Provide this to retrieve the subsequent page.
            #   @param filter [::String]
            #     Optional. A filter which should follow the guidelines of AIP-160.
            #     Supports filtering on all fieds of DataAccessScope and all operations as
            #     mentioned in https://google.aip.dev/160.
            #     example filter: "create_time greater than \"2023-04-21T11:30:00-04:00\" OR
            #     display_name:\"-21-1\"".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::DataAccessScope>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Chronicle::V1::DataAccessScope>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest.new
            #
            #   # Call the list_data_access_scopes method.
            #   result = client.list_data_access_scopes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Chronicle::V1::DataAccessScope.
            #     p item
            #   end
            #
            def list_data_access_scopes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::ListDataAccessScopesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_access_scopes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_access_scopes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_access_scopes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :list_data_access_scopes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_access_control_service_stub, :list_data_access_scopes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a data access scope.
            #
            # @overload update_data_access_scope(request, options = nil)
            #   Pass arguments to `update_data_access_scope` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_data_access_scope(data_access_scope: nil, update_mask: nil)
            #   Pass arguments to `update_data_access_scope` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param data_access_scope [::Google::Cloud::Chronicle::V1::DataAccessScope, ::Hash]
            #     Required. The data access scope to update.
            #
            #     The scope's `name` field is used to identify the scope to update.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}`
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to update. If not included, all fields with a non-empty
            #     value will be overwritten. Currently, only the description, the allowed
            #     and denied labels list fields are supported for update;
            #     an update call that attempts to update any
            #     other fields will return INVALID_ARGUMENT.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Chronicle::V1::DataAccessScope]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Chronicle::V1::DataAccessScope]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest.new
            #
            #   # Call the update_data_access_scope method.
            #   result = client.update_data_access_scope request
            #
            #   # The returned object is of type Google::Cloud::Chronicle::V1::DataAccessScope.
            #   p result
            #
            def update_data_access_scope request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::UpdateDataAccessScopeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_data_access_scope.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.data_access_scope&.name
                header_params["data_access_scope.name"] = request.data_access_scope.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_data_access_scope.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_data_access_scope.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :update_data_access_scope, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a data access scope.
            #
            # @overload delete_data_access_scope(request, options = nil)
            #   Pass arguments to `delete_data_access_scope` via a request object, either of type
            #   {::Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_data_access_scope(name: nil)
            #   Pass arguments to `delete_data_access_scope` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The ID of the data access scope to delete.
            #     Format:
            #     `projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/chronicle/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest.new
            #
            #   # Call the delete_data_access_scope method.
            #   result = client.delete_data_access_scope request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_data_access_scope request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Chronicle::V1::DeleteDataAccessScopeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_data_access_scope.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Chronicle::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_data_access_scope.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_data_access_scope.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_access_control_service_stub.call_rpc :delete_data_access_scope, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DataAccessControlService API.
            #
            # This class represents the configuration for DataAccessControlService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Chronicle::V1::DataAccessControlService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_data_access_label to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_data_access_label.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_data_access_label.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Chronicle::V1::DataAccessControlService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "chronicle.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DataAccessControlService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_data_access_label`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_data_access_label
                ##
                # RPC-specific configuration for `get_data_access_label`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_access_label
                ##
                # RPC-specific configuration for `list_data_access_labels`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_access_labels
                ##
                # RPC-specific configuration for `update_data_access_label`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_data_access_label
                ##
                # RPC-specific configuration for `delete_data_access_label`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_data_access_label
                ##
                # RPC-specific configuration for `create_data_access_scope`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_data_access_scope
                ##
                # RPC-specific configuration for `get_data_access_scope`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_access_scope
                ##
                # RPC-specific configuration for `list_data_access_scopes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_access_scopes
                ##
                # RPC-specific configuration for `update_data_access_scope`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_data_access_scope
                ##
                # RPC-specific configuration for `delete_data_access_scope`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_data_access_scope

                # @private
                def initialize parent_rpcs = nil
                  create_data_access_label_config = parent_rpcs.create_data_access_label if parent_rpcs.respond_to? :create_data_access_label
                  @create_data_access_label = ::Gapic::Config::Method.new create_data_access_label_config
                  get_data_access_label_config = parent_rpcs.get_data_access_label if parent_rpcs.respond_to? :get_data_access_label
                  @get_data_access_label = ::Gapic::Config::Method.new get_data_access_label_config
                  list_data_access_labels_config = parent_rpcs.list_data_access_labels if parent_rpcs.respond_to? :list_data_access_labels
                  @list_data_access_labels = ::Gapic::Config::Method.new list_data_access_labels_config
                  update_data_access_label_config = parent_rpcs.update_data_access_label if parent_rpcs.respond_to? :update_data_access_label
                  @update_data_access_label = ::Gapic::Config::Method.new update_data_access_label_config
                  delete_data_access_label_config = parent_rpcs.delete_data_access_label if parent_rpcs.respond_to? :delete_data_access_label
                  @delete_data_access_label = ::Gapic::Config::Method.new delete_data_access_label_config
                  create_data_access_scope_config = parent_rpcs.create_data_access_scope if parent_rpcs.respond_to? :create_data_access_scope
                  @create_data_access_scope = ::Gapic::Config::Method.new create_data_access_scope_config
                  get_data_access_scope_config = parent_rpcs.get_data_access_scope if parent_rpcs.respond_to? :get_data_access_scope
                  @get_data_access_scope = ::Gapic::Config::Method.new get_data_access_scope_config
                  list_data_access_scopes_config = parent_rpcs.list_data_access_scopes if parent_rpcs.respond_to? :list_data_access_scopes
                  @list_data_access_scopes = ::Gapic::Config::Method.new list_data_access_scopes_config
                  update_data_access_scope_config = parent_rpcs.update_data_access_scope if parent_rpcs.respond_to? :update_data_access_scope
                  @update_data_access_scope = ::Gapic::Config::Method.new update_data_access_scope_config
                  delete_data_access_scope_config = parent_rpcs.delete_data_access_scope if parent_rpcs.respond_to? :delete_data_access_scope
                  @delete_data_access_scope = ::Gapic::Config::Method.new delete_data_access_scope_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
