# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/channel/v1/service_pb"
require "google/cloud/channel/v1/cloud_channel_service"

class ::Google::Cloud::Channel::V1::CloudChannelService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_customers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListCustomersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_customers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_customers, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListCustomersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_customers_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_customers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_customers parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_customers ::Google::Cloud::Channel::V1::ListCustomersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_customers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_customers(::Google::Cloud::Channel::V1::ListCustomersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_customers_client_stub.call_rpc_count
    end
  end

  def test_get_customer
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::Customer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_customer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_customer, name
      assert_kind_of ::Google::Cloud::Channel::V1::GetCustomerRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_customer_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_customer({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_customer name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_customer ::Google::Cloud::Channel::V1::GetCustomerRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_customer({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_customer(::Google::Cloud::Channel::V1::GetCustomerRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_customer_client_stub.call_rpc_count
    end
  end

  def test_check_cloud_identity_accounts_exist
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    domain = "hello world"
    primary_admin_email = "hello world"

    check_cloud_identity_accounts_exist_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :check_cloud_identity_accounts_exist, name
      assert_kind_of ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["domain"]
      assert_equal "hello world", request["primary_admin_email"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, check_cloud_identity_accounts_exist_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.check_cloud_identity_accounts_exist({ parent: parent, domain: domain, primary_admin_email: primary_admin_email }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.check_cloud_identity_accounts_exist parent: parent, domain: domain, primary_admin_email: primary_admin_email do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.check_cloud_identity_accounts_exist ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest.new(parent: parent, domain: domain, primary_admin_email: primary_admin_email) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.check_cloud_identity_accounts_exist({ parent: parent, domain: domain, primary_admin_email: primary_admin_email }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.check_cloud_identity_accounts_exist(::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest.new(parent: parent, domain: domain, primary_admin_email: primary_admin_email), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, check_cloud_identity_accounts_exist_client_stub.call_rpc_count
    end
  end

  def test_create_customer
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::Customer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    customer = {}

    create_customer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_customer, name
      assert_kind_of ::Google::Cloud::Channel::V1::CreateCustomerRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::Customer), request["customer"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_customer_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_customer({ parent: parent, customer: customer }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_customer parent: parent, customer: customer do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_customer ::Google::Cloud::Channel::V1::CreateCustomerRequest.new(parent: parent, customer: customer) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_customer({ parent: parent, customer: customer }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_customer(::Google::Cloud::Channel::V1::CreateCustomerRequest.new(parent: parent, customer: customer), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_customer_client_stub.call_rpc_count
    end
  end

  def test_update_customer
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::Customer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    customer = {}
    update_mask = {}

    update_customer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_customer, name
      assert_kind_of ::Google::Cloud::Channel::V1::UpdateCustomerRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::Customer), request["customer"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_customer_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_customer({ customer: customer, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_customer customer: customer, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_customer ::Google::Cloud::Channel::V1::UpdateCustomerRequest.new(customer: customer, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_customer({ customer: customer, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_customer(::Google::Cloud::Channel::V1::UpdateCustomerRequest.new(customer: customer, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_customer_client_stub.call_rpc_count
    end
  end

  def test_delete_customer
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_customer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_customer, name
      assert_kind_of ::Google::Cloud::Channel::V1::DeleteCustomerRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_customer_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_customer({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_customer name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_customer ::Google::Cloud::Channel::V1::DeleteCustomerRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_customer({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_customer(::Google::Cloud::Channel::V1::DeleteCustomerRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_customer_client_stub.call_rpc_count
    end
  end

  def test_import_customer
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::Customer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    domain = "hello world"
    parent = "hello world"
    auth_token = "hello world"
    overwrite_if_exists = true
    channel_partner_id = "hello world"
    customer = "hello world"

    import_customer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_customer, name
      assert_kind_of ::Google::Cloud::Channel::V1::ImportCustomerRequest, request
      assert_equal "hello world", request["domain"]
      assert_equal :domain, request.customer_identity
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["auth_token"]
      assert_equal true, request["overwrite_if_exists"]
      assert_equal "hello world", request["channel_partner_id"]
      assert_equal "hello world", request["customer"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_customer_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_customer({ domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_customer domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_customer ::Google::Cloud::Channel::V1::ImportCustomerRequest.new(domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_customer({ domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_customer(::Google::Cloud::Channel::V1::ImportCustomerRequest.new(domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_customer_client_stub.call_rpc_count
    end
  end

  def test_provision_cloud_identity
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    customer = "hello world"
    cloud_identity_info = {}
    user = {}
    validate_only = true

    provision_cloud_identity_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :provision_cloud_identity, name
      assert_kind_of ::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest, request
      assert_equal "hello world", request["customer"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::CloudIdentityInfo), request["cloud_identity_info"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::AdminUser), request["user"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, provision_cloud_identity_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.provision_cloud_identity({ customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.provision_cloud_identity customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.provision_cloud_identity ::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest.new(customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.provision_cloud_identity({ customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.provision_cloud_identity(::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest.new(customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, provision_cloud_identity_client_stub.call_rpc_count
    end
  end

  def test_list_entitlements
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListEntitlementsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_entitlements_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entitlements, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListEntitlementsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entitlements_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entitlements parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entitlements ::Google::Cloud::Channel::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entitlements(::Google::Cloud::Channel::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entitlements_client_stub.call_rpc_count
    end
  end

  def test_list_transferable_skus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListTransferableSkusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    cloud_identity_id = "hello world"
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    auth_token = "hello world"
    language_code = "hello world"

    list_transferable_skus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_transferable_skus, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListTransferableSkusRequest, request
      assert_equal "hello world", request["cloud_identity_id"]
      assert_equal :cloud_identity_id, request.transferred_customer_identity
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["auth_token"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_transferable_skus_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_transferable_skus({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_transferable_skus cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_transferable_skus ::Google::Cloud::Channel::V1::ListTransferableSkusRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_transferable_skus({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_transferable_skus(::Google::Cloud::Channel::V1::ListTransferableSkusRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_transferable_skus_client_stub.call_rpc_count
    end
  end

  def test_list_transferable_offers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListTransferableOffersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    cloud_identity_id = "hello world"
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    sku = "hello world"
    language_code = "hello world"
    billing_account = "hello world"

    list_transferable_offers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_transferable_offers, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListTransferableOffersRequest, request
      assert_equal "hello world", request["cloud_identity_id"]
      assert_equal :cloud_identity_id, request.transferred_customer_identity
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["sku"]
      assert_equal "hello world", request["language_code"]
      assert_equal "hello world", request["billing_account"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_transferable_offers_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_transferable_offers({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_transferable_offers cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_transferable_offers ::Google::Cloud::Channel::V1::ListTransferableOffersRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_transferable_offers({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_transferable_offers(::Google::Cloud::Channel::V1::ListTransferableOffersRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_transferable_offers_client_stub.call_rpc_count
    end
  end

  def test_get_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::Entitlement.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entitlement, name
      assert_kind_of ::Google::Cloud::Channel::V1::GetEntitlementRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entitlement({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entitlement name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entitlement ::Google::Cloud::Channel::V1::GetEntitlementRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entitlement({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entitlement(::Google::Cloud::Channel::V1::GetEntitlementRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entitlement_client_stub.call_rpc_count
    end
  end

  def test_create_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entitlement = {}
    request_id = "hello world"

    create_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entitlement, name
      assert_kind_of ::Google::Cloud::Channel::V1::CreateEntitlementRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::Entitlement), request["entitlement"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entitlement({ parent: parent, entitlement: entitlement, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entitlement parent: parent, entitlement: entitlement, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entitlement ::Google::Cloud::Channel::V1::CreateEntitlementRequest.new(parent: parent, entitlement: entitlement, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entitlement({ parent: parent, entitlement: entitlement, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entitlement(::Google::Cloud::Channel::V1::CreateEntitlementRequest.new(parent: parent, entitlement: entitlement, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entitlement_client_stub.call_rpc_count
    end
  end

  def test_change_parameters
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    parameters = [{}]
    request_id = "hello world"
    purchase_order_id = "hello world"

    change_parameters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :change_parameters, name
      assert_kind_of ::Google::Cloud::Channel::V1::ChangeParametersRequest, request
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Cloud::Channel::V1::Parameter, request["parameters"].first
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["purchase_order_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, change_parameters_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.change_parameters({ name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.change_parameters name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.change_parameters ::Google::Cloud::Channel::V1::ChangeParametersRequest.new(name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.change_parameters({ name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.change_parameters(::Google::Cloud::Channel::V1::ChangeParametersRequest.new(name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, change_parameters_client_stub.call_rpc_count
    end
  end

  def test_change_renewal_settings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    renewal_settings = {}
    request_id = "hello world"

    change_renewal_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :change_renewal_settings, name
      assert_kind_of ::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::RenewalSettings), request["renewal_settings"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, change_renewal_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.change_renewal_settings({ name: name, renewal_settings: renewal_settings, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.change_renewal_settings name: name, renewal_settings: renewal_settings, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.change_renewal_settings ::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest.new(name: name, renewal_settings: renewal_settings, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.change_renewal_settings({ name: name, renewal_settings: renewal_settings, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.change_renewal_settings(::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest.new(name: name, renewal_settings: renewal_settings, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, change_renewal_settings_client_stub.call_rpc_count
    end
  end

  def test_change_offer
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    offer = "hello world"
    parameters = [{}]
    purchase_order_id = "hello world"
    request_id = "hello world"
    billing_account = "hello world"

    change_offer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :change_offer, name
      assert_kind_of ::Google::Cloud::Channel::V1::ChangeOfferRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["offer"]
      assert_kind_of ::Google::Cloud::Channel::V1::Parameter, request["parameters"].first
      assert_equal "hello world", request["purchase_order_id"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["billing_account"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, change_offer_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.change_offer({ name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.change_offer name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.change_offer ::Google::Cloud::Channel::V1::ChangeOfferRequest.new(name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.change_offer({ name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.change_offer(::Google::Cloud::Channel::V1::ChangeOfferRequest.new(name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, change_offer_client_stub.call_rpc_count
    end
  end

  def test_start_paid_service
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    start_paid_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :start_paid_service, name
      assert_kind_of ::Google::Cloud::Channel::V1::StartPaidServiceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, start_paid_service_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.start_paid_service({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.start_paid_service name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.start_paid_service ::Google::Cloud::Channel::V1::StartPaidServiceRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.start_paid_service({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.start_paid_service(::Google::Cloud::Channel::V1::StartPaidServiceRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, start_paid_service_client_stub.call_rpc_count
    end
  end

  def test_suspend_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    suspend_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :suspend_entitlement, name
      assert_kind_of ::Google::Cloud::Channel::V1::SuspendEntitlementRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, suspend_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.suspend_entitlement({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.suspend_entitlement name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.suspend_entitlement ::Google::Cloud::Channel::V1::SuspendEntitlementRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.suspend_entitlement({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.suspend_entitlement(::Google::Cloud::Channel::V1::SuspendEntitlementRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, suspend_entitlement_client_stub.call_rpc_count
    end
  end

  def test_cancel_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    cancel_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_entitlement, name
      assert_kind_of ::Google::Cloud::Channel::V1::CancelEntitlementRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_entitlement({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_entitlement name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_entitlement ::Google::Cloud::Channel::V1::CancelEntitlementRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_entitlement({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_entitlement(::Google::Cloud::Channel::V1::CancelEntitlementRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_entitlement_client_stub.call_rpc_count
    end
  end

  def test_activate_entitlement
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    activate_entitlement_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :activate_entitlement, name
      assert_kind_of ::Google::Cloud::Channel::V1::ActivateEntitlementRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, activate_entitlement_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.activate_entitlement({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.activate_entitlement name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.activate_entitlement ::Google::Cloud::Channel::V1::ActivateEntitlementRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.activate_entitlement({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.activate_entitlement(::Google::Cloud::Channel::V1::ActivateEntitlementRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, activate_entitlement_client_stub.call_rpc_count
    end
  end

  def test_transfer_entitlements
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entitlements = [{}]
    auth_token = "hello world"
    request_id = "hello world"

    transfer_entitlements_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :transfer_entitlements, name
      assert_kind_of ::Google::Cloud::Channel::V1::TransferEntitlementsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::Channel::V1::Entitlement, request["entitlements"].first
      assert_equal "hello world", request["auth_token"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, transfer_entitlements_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.transfer_entitlements({ parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.transfer_entitlements parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.transfer_entitlements ::Google::Cloud::Channel::V1::TransferEntitlementsRequest.new(parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.transfer_entitlements({ parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.transfer_entitlements(::Google::Cloud::Channel::V1::TransferEntitlementsRequest.new(parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, transfer_entitlements_client_stub.call_rpc_count
    end
  end

  def test_transfer_entitlements_to_google
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entitlements = [{}]
    request_id = "hello world"

    transfer_entitlements_to_google_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :transfer_entitlements_to_google, name
      assert_kind_of ::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::Channel::V1::Entitlement, request["entitlements"].first
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, transfer_entitlements_to_google_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.transfer_entitlements_to_google({ parent: parent, entitlements: entitlements, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.transfer_entitlements_to_google parent: parent, entitlements: entitlements, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.transfer_entitlements_to_google ::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest.new(parent: parent, entitlements: entitlements, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.transfer_entitlements_to_google({ parent: parent, entitlements: entitlements, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.transfer_entitlements_to_google(::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest.new(parent: parent, entitlements: entitlements, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, transfer_entitlements_to_google_client_stub.call_rpc_count
    end
  end

  def test_list_channel_partner_links
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListChannelPartnerLinksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :UNSPECIFIED

    list_channel_partner_links_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_channel_partner_links, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_channel_partner_links_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_channel_partner_links({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_channel_partner_links parent: parent, page_size: page_size, page_token: page_token, view: view do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_channel_partner_links ::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_channel_partner_links({ parent: parent, page_size: page_size, page_token: page_token, view: view }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_channel_partner_links(::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_channel_partner_links_client_stub.call_rpc_count
    end
  end

  def test_get_channel_partner_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ChannelPartnerLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :UNSPECIFIED

    get_channel_partner_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_channel_partner_link, name
      assert_kind_of ::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :UNSPECIFIED, request["view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_channel_partner_link_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_channel_partner_link({ name: name, view: view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_channel_partner_link name: name, view: view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_channel_partner_link ::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest.new(name: name, view: view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_channel_partner_link({ name: name, view: view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_channel_partner_link(::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest.new(name: name, view: view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_channel_partner_link_client_stub.call_rpc_count
    end
  end

  def test_create_channel_partner_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ChannelPartnerLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_partner_link = {}

    create_channel_partner_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_channel_partner_link, name
      assert_kind_of ::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::ChannelPartnerLink), request["channel_partner_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_channel_partner_link_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_channel_partner_link({ parent: parent, channel_partner_link: channel_partner_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_channel_partner_link parent: parent, channel_partner_link: channel_partner_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_channel_partner_link ::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest.new(parent: parent, channel_partner_link: channel_partner_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_channel_partner_link({ parent: parent, channel_partner_link: channel_partner_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_channel_partner_link(::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest.new(parent: parent, channel_partner_link: channel_partner_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_channel_partner_link_client_stub.call_rpc_count
    end
  end

  def test_update_channel_partner_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ChannelPartnerLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    channel_partner_link = {}
    update_mask = {}

    update_channel_partner_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_channel_partner_link, name
      assert_kind_of ::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::ChannelPartnerLink), request["channel_partner_link"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_channel_partner_link_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_channel_partner_link({ name: name, channel_partner_link: channel_partner_link, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_channel_partner_link name: name, channel_partner_link: channel_partner_link, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_channel_partner_link ::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest.new(name: name, channel_partner_link: channel_partner_link, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_channel_partner_link({ name: name, channel_partner_link: channel_partner_link, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_channel_partner_link(::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest.new(name: name, channel_partner_link: channel_partner_link, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_channel_partner_link_client_stub.call_rpc_count
    end
  end

  def test_get_customer_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::CustomerRepricingConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_customer_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_customer_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_customer_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_customer_repricing_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_customer_repricing_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_customer_repricing_config ::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_customer_repricing_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_customer_repricing_config(::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_customer_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_list_customer_repricing_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_customer_repricing_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_customer_repricing_configs, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_customer_repricing_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_customer_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_customer_repricing_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_customer_repricing_configs ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_customer_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_customer_repricing_configs(::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_customer_repricing_configs_client_stub.call_rpc_count
    end
  end

  def test_create_customer_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::CustomerRepricingConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    customer_repricing_config = {}

    create_customer_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_customer_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::CustomerRepricingConfig), request["customer_repricing_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_customer_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_customer_repricing_config({ parent: parent, customer_repricing_config: customer_repricing_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_customer_repricing_config parent: parent, customer_repricing_config: customer_repricing_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_customer_repricing_config ::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest.new(parent: parent, customer_repricing_config: customer_repricing_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_customer_repricing_config({ parent: parent, customer_repricing_config: customer_repricing_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_customer_repricing_config(::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest.new(parent: parent, customer_repricing_config: customer_repricing_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_customer_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_update_customer_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::CustomerRepricingConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    customer_repricing_config = {}

    update_customer_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_customer_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::CustomerRepricingConfig), request["customer_repricing_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_customer_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_customer_repricing_config({ customer_repricing_config: customer_repricing_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_customer_repricing_config customer_repricing_config: customer_repricing_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_customer_repricing_config ::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest.new(customer_repricing_config: customer_repricing_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_customer_repricing_config({ customer_repricing_config: customer_repricing_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_customer_repricing_config(::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest.new(customer_repricing_config: customer_repricing_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_customer_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_delete_customer_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_customer_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_customer_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_customer_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_customer_repricing_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_customer_repricing_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_customer_repricing_config ::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_customer_repricing_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_customer_repricing_config(::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_customer_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_get_channel_partner_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_partner_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_channel_partner_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_channel_partner_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_channel_partner_repricing_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_channel_partner_repricing_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_channel_partner_repricing_config ::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_channel_partner_repricing_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_channel_partner_repricing_config(::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_channel_partner_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_list_channel_partner_repricing_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_channel_partner_repricing_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_channel_partner_repricing_configs, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_channel_partner_repricing_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_channel_partner_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_channel_partner_repricing_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_channel_partner_repricing_configs ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_channel_partner_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_channel_partner_repricing_configs(::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_channel_partner_repricing_configs_client_stub.call_rpc_count
    end
  end

  def test_create_channel_partner_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_partner_repricing_config = {}

    create_channel_partner_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_channel_partner_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig), request["channel_partner_repricing_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_channel_partner_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_channel_partner_repricing_config({ parent: parent, channel_partner_repricing_config: channel_partner_repricing_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_channel_partner_repricing_config parent: parent, channel_partner_repricing_config: channel_partner_repricing_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_channel_partner_repricing_config ::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest.new(parent: parent, channel_partner_repricing_config: channel_partner_repricing_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_channel_partner_repricing_config({ parent: parent, channel_partner_repricing_config: channel_partner_repricing_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_channel_partner_repricing_config(::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest.new(parent: parent, channel_partner_repricing_config: channel_partner_repricing_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_channel_partner_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_update_channel_partner_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    channel_partner_repricing_config = {}

    update_channel_partner_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_channel_partner_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig), request["channel_partner_repricing_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_channel_partner_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_channel_partner_repricing_config({ channel_partner_repricing_config: channel_partner_repricing_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_channel_partner_repricing_config channel_partner_repricing_config: channel_partner_repricing_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_channel_partner_repricing_config ::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest.new(channel_partner_repricing_config: channel_partner_repricing_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_channel_partner_repricing_config({ channel_partner_repricing_config: channel_partner_repricing_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_channel_partner_repricing_config(::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest.new(channel_partner_repricing_config: channel_partner_repricing_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_channel_partner_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_delete_channel_partner_repricing_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_channel_partner_repricing_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_channel_partner_repricing_config, name
      assert_kind_of ::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_channel_partner_repricing_config_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_channel_partner_repricing_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_channel_partner_repricing_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_channel_partner_repricing_config ::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_channel_partner_repricing_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_channel_partner_repricing_config(::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_channel_partner_repricing_config_client_stub.call_rpc_count
    end
  end

  def test_list_sku_groups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListSkuGroupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_sku_groups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sku_groups, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListSkuGroupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sku_groups_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sku_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sku_groups parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sku_groups ::Google::Cloud::Channel::V1::ListSkuGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sku_groups({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sku_groups(::Google::Cloud::Channel::V1::ListSkuGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sku_groups_client_stub.call_rpc_count
    end
  end

  def test_list_sku_group_billable_skus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_sku_group_billable_skus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_sku_group_billable_skus, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_sku_group_billable_skus_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_sku_group_billable_skus({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_sku_group_billable_skus parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_sku_group_billable_skus ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_sku_group_billable_skus({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_sku_group_billable_skus(::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_sku_group_billable_skus_client_stub.call_rpc_count
    end
  end

  def test_lookup_offer
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::Offer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entitlement = "hello world"

    lookup_offer_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :lookup_offer, name
      assert_kind_of ::Google::Cloud::Channel::V1::LookupOfferRequest, request
      assert_equal "hello world", request["entitlement"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, lookup_offer_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.lookup_offer({ entitlement: entitlement }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.lookup_offer entitlement: entitlement do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.lookup_offer ::Google::Cloud::Channel::V1::LookupOfferRequest.new(entitlement: entitlement) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.lookup_offer({ entitlement: entitlement }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.lookup_offer(::Google::Cloud::Channel::V1::LookupOfferRequest.new(entitlement: entitlement), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, lookup_offer_client_stub.call_rpc_count
    end
  end

  def test_list_products
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListProductsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_products_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_products, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListProductsRequest, request
      assert_equal "hello world", request["account"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_products_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_products({ account: account, page_size: page_size, page_token: page_token, language_code: language_code }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_products account: account, page_size: page_size, page_token: page_token, language_code: language_code do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_products ::Google::Cloud::Channel::V1::ListProductsRequest.new(account: account, page_size: page_size, page_token: page_token, language_code: language_code) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_products({ account: account, page_size: page_size, page_token: page_token, language_code: language_code }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_products(::Google::Cloud::Channel::V1::ListProductsRequest.new(account: account, page_size: page_size, page_token: page_token, language_code: language_code), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_products_client_stub.call_rpc_count
    end
  end

  def test_list_skus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListSkusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    account = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_skus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_skus, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListSkusRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["account"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_skus_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_skus({ parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_skus parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_skus ::Google::Cloud::Channel::V1::ListSkusRequest.new(parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_skus({ parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_skus(::Google::Cloud::Channel::V1::ListSkusRequest.new(parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_skus_client_stub.call_rpc_count
    end
  end

  def test_list_offers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListOffersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    language_code = "hello world"
    show_future_offers = true

    list_offers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_offers, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListOffersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["language_code"]
      assert_equal true, request["show_future_offers"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_offers_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_offers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_offers parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_offers ::Google::Cloud::Channel::V1::ListOffersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_offers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_offers(::Google::Cloud::Channel::V1::ListOffersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_offers_client_stub.call_rpc_count
    end
  end

  def test_list_purchasable_skus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListPurchasableSkusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    create_entitlement_purchase = {}
    customer = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_purchasable_skus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_purchasable_skus, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListPurchasableSkusRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::ListPurchasableSkusRequest::CreateEntitlementPurchase), request["create_entitlement_purchase"]
      assert_equal :create_entitlement_purchase, request.purchase_option
      assert_equal "hello world", request["customer"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_purchasable_skus_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_purchasable_skus({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_purchasable_skus create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_purchasable_skus ::Google::Cloud::Channel::V1::ListPurchasableSkusRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_purchasable_skus({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_purchasable_skus(::Google::Cloud::Channel::V1::ListPurchasableSkusRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_purchasable_skus_client_stub.call_rpc_count
    end
  end

  def test_list_purchasable_offers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListPurchasableOffersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    create_entitlement_purchase = {}
    customer = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_purchasable_offers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_purchasable_offers, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListPurchasableOffersRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Channel::V1::ListPurchasableOffersRequest::CreateEntitlementPurchase), request["create_entitlement_purchase"]
      assert_equal :create_entitlement_purchase, request.purchase_option
      assert_equal "hello world", request["customer"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["language_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_purchasable_offers_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_purchasable_offers({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_purchasable_offers create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_purchasable_offers ::Google::Cloud::Channel::V1::ListPurchasableOffersRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_purchasable_offers({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_purchasable_offers(::Google::Cloud::Channel::V1::ListPurchasableOffersRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_purchasable_offers_client_stub.call_rpc_count
    end
  end

  def test_query_eligible_billing_accounts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    customer = "hello world"
    skus = ["hello world"]

    query_eligible_billing_accounts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_eligible_billing_accounts, name
      assert_kind_of ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest, request
      assert_equal "hello world", request["customer"]
      assert_equal ["hello world"], request["skus"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_eligible_billing_accounts_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_eligible_billing_accounts({ customer: customer, skus: skus }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_eligible_billing_accounts customer: customer, skus: skus do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_eligible_billing_accounts ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest.new(customer: customer, skus: skus) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_eligible_billing_accounts({ customer: customer, skus: skus }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_eligible_billing_accounts(::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest.new(customer: customer, skus: skus), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_eligible_billing_accounts_client_stub.call_rpc_count
    end
  end

  def test_register_subscriber
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::RegisterSubscriberResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    service_account = "hello world"

    register_subscriber_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :register_subscriber, name
      assert_kind_of ::Google::Cloud::Channel::V1::RegisterSubscriberRequest, request
      assert_equal "hello world", request["account"]
      assert_equal "hello world", request["service_account"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, register_subscriber_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.register_subscriber({ account: account, service_account: service_account }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.register_subscriber account: account, service_account: service_account do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.register_subscriber ::Google::Cloud::Channel::V1::RegisterSubscriberRequest.new(account: account, service_account: service_account) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.register_subscriber({ account: account, service_account: service_account }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.register_subscriber(::Google::Cloud::Channel::V1::RegisterSubscriberRequest.new(account: account, service_account: service_account), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, register_subscriber_client_stub.call_rpc_count
    end
  end

  def test_unregister_subscriber
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::UnregisterSubscriberResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    service_account = "hello world"

    unregister_subscriber_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :unregister_subscriber, name
      assert_kind_of ::Google::Cloud::Channel::V1::UnregisterSubscriberRequest, request
      assert_equal "hello world", request["account"]
      assert_equal "hello world", request["service_account"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, unregister_subscriber_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.unregister_subscriber({ account: account, service_account: service_account }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.unregister_subscriber account: account, service_account: service_account do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.unregister_subscriber ::Google::Cloud::Channel::V1::UnregisterSubscriberRequest.new(account: account, service_account: service_account) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.unregister_subscriber({ account: account, service_account: service_account }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.unregister_subscriber(::Google::Cloud::Channel::V1::UnregisterSubscriberRequest.new(account: account, service_account: service_account), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, unregister_subscriber_client_stub.call_rpc_count
    end
  end

  def test_list_subscribers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListSubscribersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subscribers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subscribers, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListSubscribersRequest, request
      assert_equal "hello world", request["account"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subscribers_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subscribers({ account: account, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subscribers account: account, page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subscribers ::Google::Cloud::Channel::V1::ListSubscribersRequest.new(account: account, page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subscribers({ account: account, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subscribers(::Google::Cloud::Channel::V1::ListSubscribersRequest.new(account: account, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subscribers_client_stub.call_rpc_count
    end
  end

  def test_list_entitlement_changes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Channel::V1::ListEntitlementChangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_entitlement_changes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entitlement_changes, name
      assert_kind_of ::Google::Cloud::Channel::V1::ListEntitlementChangesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entitlement_changes_client_stub do
      # Create client
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entitlement_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entitlement_changes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entitlement_changes ::Google::Cloud::Channel::V1::ListEntitlementChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entitlement_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entitlement_changes(::Google::Cloud::Channel::V1::ListEntitlementChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entitlement_changes_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Channel::V1::CloudChannelService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Channel::V1::CloudChannelService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Channel::V1::CloudChannelService::Operations, client.operations_client
  end
end
