# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/channel/v1/service_pb"
require "google/cloud/channel/v1/cloud_channel_service/rest"


class ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_customers
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListCustomersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_customers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_customers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_customers_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_customers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_customers parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_customers ::Google::Cloud::Channel::V1::ListCustomersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_customers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_customers(::Google::Cloud::Channel::V1::ListCustomersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_customers_client_stub.call_count
      end
    end
  end

  def test_get_customer
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::Customer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_get_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_customer_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_customer({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_customer name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_customer ::Google::Cloud::Channel::V1::GetCustomerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_customer({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_customer(::Google::Cloud::Channel::V1::GetCustomerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_customer_client_stub.call_count
      end
    end
  end

  def test_check_cloud_identity_accounts_exist
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    domain = "hello world"
    primary_admin_email = "hello world"

    check_cloud_identity_accounts_exist_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_check_cloud_identity_accounts_exist_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, check_cloud_identity_accounts_exist_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.check_cloud_identity_accounts_exist({ parent: parent, domain: domain, primary_admin_email: primary_admin_email }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.check_cloud_identity_accounts_exist parent: parent, domain: domain, primary_admin_email: primary_admin_email do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.check_cloud_identity_accounts_exist ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest.new(parent: parent, domain: domain, primary_admin_email: primary_admin_email) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.check_cloud_identity_accounts_exist({ parent: parent, domain: domain, primary_admin_email: primary_admin_email }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.check_cloud_identity_accounts_exist(::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest.new(parent: parent, domain: domain, primary_admin_email: primary_admin_email), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, check_cloud_identity_accounts_exist_client_stub.call_count
      end
    end
  end

  def test_create_customer
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::Customer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    customer = {}

    create_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_create_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_customer_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_customer({ parent: parent, customer: customer }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_customer parent: parent, customer: customer do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_customer ::Google::Cloud::Channel::V1::CreateCustomerRequest.new(parent: parent, customer: customer) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_customer({ parent: parent, customer: customer }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_customer(::Google::Cloud::Channel::V1::CreateCustomerRequest.new(parent: parent, customer: customer), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_customer_client_stub.call_count
      end
    end
  end

  def test_update_customer
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::Customer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    customer = {}
    update_mask = {}

    update_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_update_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_customer_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_customer({ customer: customer, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_customer customer: customer, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_customer ::Google::Cloud::Channel::V1::UpdateCustomerRequest.new(customer: customer, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_customer({ customer: customer, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_customer(::Google::Cloud::Channel::V1::UpdateCustomerRequest.new(customer: customer, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_customer_client_stub.call_count
      end
    end
  end

  def test_delete_customer
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_delete_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_customer_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_customer({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_customer name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_customer ::Google::Cloud::Channel::V1::DeleteCustomerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_customer({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_customer(::Google::Cloud::Channel::V1::DeleteCustomerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_customer_client_stub.call_count
      end
    end
  end

  def test_import_customer
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::Customer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    domain = "hello world"
    parent = "hello world"
    auth_token = "hello world"
    overwrite_if_exists = true
    channel_partner_id = "hello world"
    customer = "hello world"

    import_customer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_import_customer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_customer_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_customer({ domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_customer domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_customer ::Google::Cloud::Channel::V1::ImportCustomerRequest.new(domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_customer({ domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_customer(::Google::Cloud::Channel::V1::ImportCustomerRequest.new(domain: domain, parent: parent, auth_token: auth_token, overwrite_if_exists: overwrite_if_exists, channel_partner_id: channel_partner_id, customer: customer), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_customer_client_stub.call_count
      end
    end
  end

  def test_provision_cloud_identity
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    customer = "hello world"
    cloud_identity_info = {}
    user = {}
    validate_only = true

    provision_cloud_identity_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_provision_cloud_identity_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, provision_cloud_identity_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.provision_cloud_identity({ customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.provision_cloud_identity customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.provision_cloud_identity ::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest.new(customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.provision_cloud_identity({ customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.provision_cloud_identity(::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest.new(customer: customer, cloud_identity_info: cloud_identity_info, user: user, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, provision_cloud_identity_client_stub.call_count
      end
    end
  end

  def test_list_entitlements
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListEntitlementsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_entitlements_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_entitlements_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entitlements_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entitlements parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entitlements ::Google::Cloud::Channel::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entitlements({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entitlements(::Google::Cloud::Channel::V1::ListEntitlementsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entitlements_client_stub.call_count
      end
    end
  end

  def test_list_transferable_skus
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListTransferableSkusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    cloud_identity_id = "hello world"
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    auth_token = "hello world"
    language_code = "hello world"

    list_transferable_skus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_transferable_skus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_transferable_skus_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_transferable_skus({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_transferable_skus cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_transferable_skus ::Google::Cloud::Channel::V1::ListTransferableSkusRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_transferable_skus({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_transferable_skus(::Google::Cloud::Channel::V1::ListTransferableSkusRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, auth_token: auth_token, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_transferable_skus_client_stub.call_count
      end
    end
  end

  def test_list_transferable_offers
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListTransferableOffersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    cloud_identity_id = "hello world"
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    sku = "hello world"
    language_code = "hello world"
    billing_account = "hello world"

    list_transferable_offers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_transferable_offers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_transferable_offers_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_transferable_offers({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_transferable_offers cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_transferable_offers ::Google::Cloud::Channel::V1::ListTransferableOffersRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_transferable_offers({ cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_transferable_offers(::Google::Cloud::Channel::V1::ListTransferableOffersRequest.new(cloud_identity_id: cloud_identity_id, parent: parent, page_size: page_size, page_token: page_token, sku: sku, language_code: language_code, billing_account: billing_account), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_transferable_offers_client_stub.call_count
      end
    end
  end

  def test_get_entitlement
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::Entitlement.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entitlement_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_get_entitlement_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entitlement_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entitlement({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entitlement name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entitlement ::Google::Cloud::Channel::V1::GetEntitlementRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entitlement({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entitlement(::Google::Cloud::Channel::V1::GetEntitlementRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entitlement_client_stub.call_count
      end
    end
  end

  def test_create_entitlement
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entitlement = {}
    request_id = "hello world"

    create_entitlement_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_create_entitlement_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entitlement_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entitlement({ parent: parent, entitlement: entitlement, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entitlement parent: parent, entitlement: entitlement, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entitlement ::Google::Cloud::Channel::V1::CreateEntitlementRequest.new(parent: parent, entitlement: entitlement, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entitlement({ parent: parent, entitlement: entitlement, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entitlement(::Google::Cloud::Channel::V1::CreateEntitlementRequest.new(parent: parent, entitlement: entitlement, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entitlement_client_stub.call_count
      end
    end
  end

  def test_change_parameters
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    parameters = [{}]
    request_id = "hello world"
    purchase_order_id = "hello world"

    change_parameters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_change_parameters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, change_parameters_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.change_parameters({ name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.change_parameters name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.change_parameters ::Google::Cloud::Channel::V1::ChangeParametersRequest.new(name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.change_parameters({ name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.change_parameters(::Google::Cloud::Channel::V1::ChangeParametersRequest.new(name: name, parameters: parameters, request_id: request_id, purchase_order_id: purchase_order_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, change_parameters_client_stub.call_count
      end
    end
  end

  def test_change_renewal_settings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    renewal_settings = {}
    request_id = "hello world"

    change_renewal_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_change_renewal_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, change_renewal_settings_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.change_renewal_settings({ name: name, renewal_settings: renewal_settings, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.change_renewal_settings name: name, renewal_settings: renewal_settings, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.change_renewal_settings ::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest.new(name: name, renewal_settings: renewal_settings, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.change_renewal_settings({ name: name, renewal_settings: renewal_settings, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.change_renewal_settings(::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest.new(name: name, renewal_settings: renewal_settings, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, change_renewal_settings_client_stub.call_count
      end
    end
  end

  def test_change_offer
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    offer = "hello world"
    parameters = [{}]
    purchase_order_id = "hello world"
    request_id = "hello world"
    billing_account = "hello world"

    change_offer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_change_offer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, change_offer_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.change_offer({ name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.change_offer name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.change_offer ::Google::Cloud::Channel::V1::ChangeOfferRequest.new(name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.change_offer({ name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.change_offer(::Google::Cloud::Channel::V1::ChangeOfferRequest.new(name: name, offer: offer, parameters: parameters, purchase_order_id: purchase_order_id, request_id: request_id, billing_account: billing_account), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, change_offer_client_stub.call_count
      end
    end
  end

  def test_start_paid_service
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    start_paid_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_start_paid_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_paid_service_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_paid_service({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_paid_service name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_paid_service ::Google::Cloud::Channel::V1::StartPaidServiceRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_paid_service({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_paid_service(::Google::Cloud::Channel::V1::StartPaidServiceRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_paid_service_client_stub.call_count
      end
    end
  end

  def test_suspend_entitlement
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    suspend_entitlement_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_suspend_entitlement_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, suspend_entitlement_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.suspend_entitlement({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.suspend_entitlement name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.suspend_entitlement ::Google::Cloud::Channel::V1::SuspendEntitlementRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.suspend_entitlement({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.suspend_entitlement(::Google::Cloud::Channel::V1::SuspendEntitlementRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, suspend_entitlement_client_stub.call_count
      end
    end
  end

  def test_cancel_entitlement
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    cancel_entitlement_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_cancel_entitlement_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_entitlement_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_entitlement({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_entitlement name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_entitlement ::Google::Cloud::Channel::V1::CancelEntitlementRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_entitlement({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_entitlement(::Google::Cloud::Channel::V1::CancelEntitlementRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_entitlement_client_stub.call_count
      end
    end
  end

  def test_activate_entitlement
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    activate_entitlement_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_activate_entitlement_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, activate_entitlement_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.activate_entitlement({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.activate_entitlement name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.activate_entitlement ::Google::Cloud::Channel::V1::ActivateEntitlementRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.activate_entitlement({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.activate_entitlement(::Google::Cloud::Channel::V1::ActivateEntitlementRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, activate_entitlement_client_stub.call_count
      end
    end
  end

  def test_transfer_entitlements
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entitlements = [{}]
    auth_token = "hello world"
    request_id = "hello world"

    transfer_entitlements_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_transfer_entitlements_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, transfer_entitlements_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.transfer_entitlements({ parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.transfer_entitlements parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.transfer_entitlements ::Google::Cloud::Channel::V1::TransferEntitlementsRequest.new(parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.transfer_entitlements({ parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.transfer_entitlements(::Google::Cloud::Channel::V1::TransferEntitlementsRequest.new(parent: parent, entitlements: entitlements, auth_token: auth_token, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, transfer_entitlements_client_stub.call_count
      end
    end
  end

  def test_transfer_entitlements_to_google
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entitlements = [{}]
    request_id = "hello world"

    transfer_entitlements_to_google_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_transfer_entitlements_to_google_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, transfer_entitlements_to_google_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.transfer_entitlements_to_google({ parent: parent, entitlements: entitlements, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.transfer_entitlements_to_google parent: parent, entitlements: entitlements, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.transfer_entitlements_to_google ::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest.new(parent: parent, entitlements: entitlements, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.transfer_entitlements_to_google({ parent: parent, entitlements: entitlements, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.transfer_entitlements_to_google(::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest.new(parent: parent, entitlements: entitlements, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, transfer_entitlements_to_google_client_stub.call_count
      end
    end
  end

  def test_list_channel_partner_links
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListChannelPartnerLinksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    view = :UNSPECIFIED

    list_channel_partner_links_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_channel_partner_links_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_channel_partner_links_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_channel_partner_links({ parent: parent, page_size: page_size, page_token: page_token, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_channel_partner_links parent: parent, page_size: page_size, page_token: page_token, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_channel_partner_links ::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_channel_partner_links({ parent: parent, page_size: page_size, page_token: page_token, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_channel_partner_links(::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest.new(parent: parent, page_size: page_size, page_token: page_token, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_channel_partner_links_client_stub.call_count
      end
    end
  end

  def test_get_channel_partner_link
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ChannelPartnerLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :UNSPECIFIED

    get_channel_partner_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_get_channel_partner_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_channel_partner_link_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_channel_partner_link({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_channel_partner_link name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_channel_partner_link ::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_channel_partner_link({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_channel_partner_link(::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_channel_partner_link_client_stub.call_count
      end
    end
  end

  def test_create_channel_partner_link
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ChannelPartnerLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_partner_link = {}

    create_channel_partner_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_create_channel_partner_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_channel_partner_link_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_channel_partner_link({ parent: parent, channel_partner_link: channel_partner_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_channel_partner_link parent: parent, channel_partner_link: channel_partner_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_channel_partner_link ::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest.new(parent: parent, channel_partner_link: channel_partner_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_channel_partner_link({ parent: parent, channel_partner_link: channel_partner_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_channel_partner_link(::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest.new(parent: parent, channel_partner_link: channel_partner_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_channel_partner_link_client_stub.call_count
      end
    end
  end

  def test_update_channel_partner_link
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ChannelPartnerLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    channel_partner_link = {}
    update_mask = {}

    update_channel_partner_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_update_channel_partner_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_channel_partner_link_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_channel_partner_link({ name: name, channel_partner_link: channel_partner_link, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_channel_partner_link name: name, channel_partner_link: channel_partner_link, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_channel_partner_link ::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest.new(name: name, channel_partner_link: channel_partner_link, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_channel_partner_link({ name: name, channel_partner_link: channel_partner_link, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_channel_partner_link(::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest.new(name: name, channel_partner_link: channel_partner_link, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_channel_partner_link_client_stub.call_count
      end
    end
  end

  def test_get_customer_repricing_config
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::CustomerRepricingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_customer_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_get_customer_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_customer_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_customer_repricing_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_customer_repricing_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_customer_repricing_config ::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_customer_repricing_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_customer_repricing_config(::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_customer_repricing_config_client_stub.call_count
      end
    end
  end

  def test_list_customer_repricing_configs
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_customer_repricing_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_customer_repricing_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_customer_repricing_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_customer_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_customer_repricing_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_customer_repricing_configs ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_customer_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_customer_repricing_configs(::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_customer_repricing_configs_client_stub.call_count
      end
    end
  end

  def test_create_customer_repricing_config
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::CustomerRepricingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    customer_repricing_config = {}

    create_customer_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_create_customer_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_customer_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_customer_repricing_config({ parent: parent, customer_repricing_config: customer_repricing_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_customer_repricing_config parent: parent, customer_repricing_config: customer_repricing_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_customer_repricing_config ::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest.new(parent: parent, customer_repricing_config: customer_repricing_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_customer_repricing_config({ parent: parent, customer_repricing_config: customer_repricing_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_customer_repricing_config(::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest.new(parent: parent, customer_repricing_config: customer_repricing_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_customer_repricing_config_client_stub.call_count
      end
    end
  end

  def test_update_customer_repricing_config
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::CustomerRepricingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    customer_repricing_config = {}

    update_customer_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_update_customer_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_customer_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_customer_repricing_config({ customer_repricing_config: customer_repricing_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_customer_repricing_config customer_repricing_config: customer_repricing_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_customer_repricing_config ::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest.new(customer_repricing_config: customer_repricing_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_customer_repricing_config({ customer_repricing_config: customer_repricing_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_customer_repricing_config(::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest.new(customer_repricing_config: customer_repricing_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_customer_repricing_config_client_stub.call_count
      end
    end
  end

  def test_delete_customer_repricing_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_customer_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_delete_customer_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_customer_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_customer_repricing_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_customer_repricing_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_customer_repricing_config ::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_customer_repricing_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_customer_repricing_config(::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_customer_repricing_config_client_stub.call_count
      end
    end
  end

  def test_get_channel_partner_repricing_config
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_partner_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_get_channel_partner_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_channel_partner_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_channel_partner_repricing_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_channel_partner_repricing_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_channel_partner_repricing_config ::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_channel_partner_repricing_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_channel_partner_repricing_config(::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_channel_partner_repricing_config_client_stub.call_count
      end
    end
  end

  def test_list_channel_partner_repricing_configs
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_channel_partner_repricing_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_channel_partner_repricing_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_channel_partner_repricing_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_channel_partner_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_channel_partner_repricing_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_channel_partner_repricing_configs ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_channel_partner_repricing_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_channel_partner_repricing_configs(::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_channel_partner_repricing_configs_client_stub.call_count
      end
    end
  end

  def test_create_channel_partner_repricing_config
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_partner_repricing_config = {}

    create_channel_partner_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_create_channel_partner_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_channel_partner_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_channel_partner_repricing_config({ parent: parent, channel_partner_repricing_config: channel_partner_repricing_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_channel_partner_repricing_config parent: parent, channel_partner_repricing_config: channel_partner_repricing_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_channel_partner_repricing_config ::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest.new(parent: parent, channel_partner_repricing_config: channel_partner_repricing_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_channel_partner_repricing_config({ parent: parent, channel_partner_repricing_config: channel_partner_repricing_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_channel_partner_repricing_config(::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest.new(parent: parent, channel_partner_repricing_config: channel_partner_repricing_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_channel_partner_repricing_config_client_stub.call_count
      end
    end
  end

  def test_update_channel_partner_repricing_config
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    channel_partner_repricing_config = {}

    update_channel_partner_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_update_channel_partner_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_channel_partner_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_channel_partner_repricing_config({ channel_partner_repricing_config: channel_partner_repricing_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_channel_partner_repricing_config channel_partner_repricing_config: channel_partner_repricing_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_channel_partner_repricing_config ::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest.new(channel_partner_repricing_config: channel_partner_repricing_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_channel_partner_repricing_config({ channel_partner_repricing_config: channel_partner_repricing_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_channel_partner_repricing_config(::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest.new(channel_partner_repricing_config: channel_partner_repricing_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_channel_partner_repricing_config_client_stub.call_count
      end
    end
  end

  def test_delete_channel_partner_repricing_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_channel_partner_repricing_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_delete_channel_partner_repricing_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_channel_partner_repricing_config_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_channel_partner_repricing_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_channel_partner_repricing_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_channel_partner_repricing_config ::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_channel_partner_repricing_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_channel_partner_repricing_config(::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_channel_partner_repricing_config_client_stub.call_count
      end
    end
  end

  def test_list_sku_groups
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListSkuGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_sku_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_sku_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sku_groups_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sku_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sku_groups parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sku_groups ::Google::Cloud::Channel::V1::ListSkuGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sku_groups({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sku_groups(::Google::Cloud::Channel::V1::ListSkuGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sku_groups_client_stub.call_count
      end
    end
  end

  def test_list_sku_group_billable_skus
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_sku_group_billable_skus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_sku_group_billable_skus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sku_group_billable_skus_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sku_group_billable_skus({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sku_group_billable_skus parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sku_group_billable_skus ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sku_group_billable_skus({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sku_group_billable_skus(::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sku_group_billable_skus_client_stub.call_count
      end
    end
  end

  def test_lookup_offer
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::Offer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entitlement = "hello world"

    lookup_offer_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_lookup_offer_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_offer_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_offer({ entitlement: entitlement }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_offer entitlement: entitlement do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_offer ::Google::Cloud::Channel::V1::LookupOfferRequest.new(entitlement: entitlement) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_offer({ entitlement: entitlement }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_offer(::Google::Cloud::Channel::V1::LookupOfferRequest.new(entitlement: entitlement), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_offer_client_stub.call_count
      end
    end
  end

  def test_list_products
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListProductsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_products_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_products({ account: account, page_size: page_size, page_token: page_token, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_products account: account, page_size: page_size, page_token: page_token, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_products ::Google::Cloud::Channel::V1::ListProductsRequest.new(account: account, page_size: page_size, page_token: page_token, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_products({ account: account, page_size: page_size, page_token: page_token, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_products(::Google::Cloud::Channel::V1::ListProductsRequest.new(account: account, page_size: page_size, page_token: page_token, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_products_client_stub.call_count
      end
    end
  end

  def test_list_skus
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListSkusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    account = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_skus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_skus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_skus_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_skus({ parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_skus parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_skus ::Google::Cloud::Channel::V1::ListSkusRequest.new(parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_skus({ parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_skus(::Google::Cloud::Channel::V1::ListSkusRequest.new(parent: parent, account: account, page_size: page_size, page_token: page_token, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_skus_client_stub.call_count
      end
    end
  end

  def test_list_offers
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListOffersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    language_code = "hello world"
    show_future_offers = true

    list_offers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_offers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_offers_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_offers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_offers parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_offers ::Google::Cloud::Channel::V1::ListOffersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_offers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_offers(::Google::Cloud::Channel::V1::ListOffersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, language_code: language_code, show_future_offers: show_future_offers), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_offers_client_stub.call_count
      end
    end
  end

  def test_list_purchasable_skus
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListPurchasableSkusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    create_entitlement_purchase = {}
    customer = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_purchasable_skus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_purchasable_skus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_purchasable_skus_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_purchasable_skus({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_purchasable_skus create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_purchasable_skus ::Google::Cloud::Channel::V1::ListPurchasableSkusRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_purchasable_skus({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_purchasable_skus(::Google::Cloud::Channel::V1::ListPurchasableSkusRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_purchasable_skus_client_stub.call_count
      end
    end
  end

  def test_list_purchasable_offers
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListPurchasableOffersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    create_entitlement_purchase = {}
    customer = "hello world"
    page_size = 42
    page_token = "hello world"
    language_code = "hello world"

    list_purchasable_offers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_purchasable_offers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_purchasable_offers_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_purchasable_offers({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_purchasable_offers create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_purchasable_offers ::Google::Cloud::Channel::V1::ListPurchasableOffersRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_purchasable_offers({ create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_purchasable_offers(::Google::Cloud::Channel::V1::ListPurchasableOffersRequest.new(create_entitlement_purchase: create_entitlement_purchase, customer: customer, page_size: page_size, page_token: page_token, language_code: language_code), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_purchasable_offers_client_stub.call_count
      end
    end
  end

  def test_query_eligible_billing_accounts
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    customer = "hello world"
    skus = ["hello world"]

    query_eligible_billing_accounts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_query_eligible_billing_accounts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_eligible_billing_accounts_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_eligible_billing_accounts({ customer: customer, skus: skus }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_eligible_billing_accounts customer: customer, skus: skus do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_eligible_billing_accounts ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest.new(customer: customer, skus: skus) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_eligible_billing_accounts({ customer: customer, skus: skus }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_eligible_billing_accounts(::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest.new(customer: customer, skus: skus), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_eligible_billing_accounts_client_stub.call_count
      end
    end
  end

  def test_register_subscriber
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::RegisterSubscriberResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    service_account = "hello world"

    register_subscriber_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_register_subscriber_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, register_subscriber_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.register_subscriber({ account: account, service_account: service_account }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.register_subscriber account: account, service_account: service_account do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.register_subscriber ::Google::Cloud::Channel::V1::RegisterSubscriberRequest.new(account: account, service_account: service_account) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.register_subscriber({ account: account, service_account: service_account }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.register_subscriber(::Google::Cloud::Channel::V1::RegisterSubscriberRequest.new(account: account, service_account: service_account), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, register_subscriber_client_stub.call_count
      end
    end
  end

  def test_unregister_subscriber
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::UnregisterSubscriberResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    service_account = "hello world"

    unregister_subscriber_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_unregister_subscriber_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, unregister_subscriber_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.unregister_subscriber({ account: account, service_account: service_account }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.unregister_subscriber account: account, service_account: service_account do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.unregister_subscriber ::Google::Cloud::Channel::V1::UnregisterSubscriberRequest.new(account: account, service_account: service_account) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.unregister_subscriber({ account: account, service_account: service_account }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.unregister_subscriber(::Google::Cloud::Channel::V1::UnregisterSubscriberRequest.new(account: account, service_account: service_account), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, unregister_subscriber_client_stub.call_count
      end
    end
  end

  def test_list_subscribers
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListSubscribersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subscribers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_subscribers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subscribers_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subscribers({ account: account, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subscribers account: account, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subscribers ::Google::Cloud::Channel::V1::ListSubscribersRequest.new(account: account, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subscribers({ account: account, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subscribers(::Google::Cloud::Channel::V1::ListSubscribersRequest.new(account: account, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subscribers_client_stub.call_count
      end
    end
  end

  def test_list_entitlement_changes
    # Create test objects.
    client_result = ::Google::Cloud::Channel::V1::ListEntitlementChangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_entitlement_changes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.stub :transcode_list_entitlement_changes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entitlement_changes_client_stub do
        # Create client
        client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entitlement_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entitlement_changes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entitlement_changes ::Google::Cloud::Channel::V1::ListEntitlementChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entitlement_changes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entitlement_changes(::Google::Cloud::Channel::V1::ListEntitlementChangesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entitlement_changes_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client::Configuration, config
  end
end
