# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Channel
      module V1
        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#check_cloud_identity_accounts_exist CloudChannelService.CheckCloudIdentityAccountsExist}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The reseller account's resource name.
        #     Parent uses the format: accounts/\\{account_id}
        # @!attribute [rw] domain
        #   @return [::String]
        #     Required. Domain to fetch for Cloud Identity account customers, including
        #     domain and team customers. For team customers, please use the domain for
        #     their emails.
        # @!attribute [rw] primary_admin_email
        #   @return [::String]
        #     Optional. Primary admin email to fetch for Cloud Identity account team
        #     customer.
        class CheckCloudIdentityAccountsExistRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Entity representing a Cloud Identity account that may be
        # associated with a Channel Services API partner.
        # @!attribute [rw] existing
        #   @return [::Boolean]
        #     Returns true if a Cloud Identity account exists for a specific domain.
        # @!attribute [rw] owned
        #   @return [::Boolean]
        #     Returns true if the Cloud Identity account is associated with a customer
        #     of the Channel Services partner.
        # @!attribute [rw] customer_name
        #   @return [::String]
        #     If owned = true, the name of the customer that owns the Cloud Identity
        #     account.
        #     Customer_name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}
        # @!attribute [rw] customer_cloud_identity_id
        #   @return [::String]
        #     If existing = true, the Cloud Identity ID of the customer.
        # @!attribute [rw] customer_type
        #   @return [::Google::Cloud::Channel::V1::CloudIdentityInfo::CustomerType]
        #     If existing = true, the type of the customer.
        # @!attribute [rw] channel_partner_cloud_identity_id
        #   @return [::String]
        #     If existing = true, and is 2-tier customer, the channel partner of the
        #     customer.
        class CloudIdentityCustomerAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#check_cloud_identity_accounts_exist CloudChannelService.CheckCloudIdentityAccountsExist}.
        # @!attribute [rw] cloud_identity_accounts
        #   @return [::Array<::Google::Cloud::Channel::V1::CloudIdentityCustomerAccount>]
        #     The Cloud Identity accounts associated with the domain.
        class CheckCloudIdentityAccountsExistResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_customers CloudChannelService.ListCustomers}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller account to list customers from.
        #     Parent uses the format: accounts/\\{account_id}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of customers to return. The service may return
        #     fewer than this value. If unspecified, returns at most 10 customers. The
        #     maximum value is 50.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results other than the first page.
        #     Obtained through
        #     {::Google::Cloud::Channel::V1::ListCustomersResponse#next_page_token ListCustomersResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_customers CloudChannelService.ListCustomers}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filters applied to the [CloudChannelService.ListCustomers]
        #     results. See
        #     https://cloud.google.com/channel/docs/concepts/google-cloud/filter-customers
        #     for more information.
        class ListCustomersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_customers CloudChannelService.ListCustomers}.
        # @!attribute [rw] customers
        #   @return [::Array<::Google::Cloud::Channel::V1::Customer>]
        #     The customers belonging to a reseller or distributor.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::Channel::V1::ListCustomersRequest#page_token ListCustomersRequest.page_token}
        #     to obtain that page.
        class ListCustomersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#get_customer CloudChannelService.GetCustomer}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the customer to retrieve.
        #     Name uses the format: accounts/\\{account_id}/customers/\\{customer_id}
        class GetCustomerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#create_customer CloudChannelService.CreateCustomer}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of reseller account in which to create the
        #     customer. Parent uses the format: accounts/\\{account_id}
        # @!attribute [rw] customer
        #   @return [::Google::Cloud::Channel::V1::Customer]
        #     Required. The customer to create.
        class CreateCustomerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#update_customer CloudChannelService.UpdateCustomer}.
        # @!attribute [rw] customer
        #   @return [::Google::Cloud::Channel::V1::Customer]
        #     Required. New contents of the customer.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The update mask that applies to the resource.
        #     Optional.
        class UpdateCustomerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#delete_customer CloudChannelService.DeleteCustomer}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the customer to delete.
        class DeleteCustomerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#import_customer CloudChannelService.ImportCustomer}
        # @!attribute [rw] domain
        #   @return [::String]
        #     Required. Customer domain.
        #
        #     Note: The following fields are mutually exclusive: `domain`, `cloud_identity_id`, `primary_admin_email`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_identity_id
        #   @return [::String]
        #     Required. Customer's Cloud Identity ID
        #
        #     Note: The following fields are mutually exclusive: `cloud_identity_id`, `domain`, `primary_admin_email`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] primary_admin_email
        #   @return [::String]
        #     Required. Customer's primary admin email.
        #
        #     Note: The following fields are mutually exclusive: `primary_admin_email`, `domain`, `cloud_identity_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller's account.
        #     Parent takes the format: accounts/\\{account_id} or
        #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}
        # @!attribute [rw] auth_token
        #   @return [::String]
        #     Optional. The super admin of the resold customer generates this token to
        #     authorize a reseller to access their Cloud Identity and purchase
        #     entitlements on their behalf. You can omit this token after authorization.
        #     See https://support.google.com/a/answer/7643790 for more details.
        # @!attribute [rw] overwrite_if_exists
        #   @return [::Boolean]
        #     Required. Choose to overwrite an existing customer if found.
        #     This must be set to true if there is an existing customer with a
        #     conflicting region code or domain.
        # @!attribute [rw] channel_partner_id
        #   @return [::String]
        #     Optional. Cloud Identity ID of a channel partner who will be the direct
        #     reseller for the customer's order. This field is required for 2-tier
        #     transfer scenarios and can be provided via the request Parent binding as
        #     well.
        # @!attribute [rw] customer
        #   @return [::String]
        #     Optional. Specifies the customer that will receive imported Cloud Identity
        #     information.
        #     Format: accounts/\\{account_id}/customers/\\{customer_id}
        class ImportCustomerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#provision_cloud_identity CloudChannelService.ProvisionCloudIdentity}
        # @!attribute [rw] customer
        #   @return [::String]
        #     Required. Resource name of the customer.
        #     Format: accounts/\\{account_id}/customers/\\{customer_id}
        # @!attribute [rw] cloud_identity_info
        #   @return [::Google::Cloud::Channel::V1::CloudIdentityInfo]
        #     CloudIdentity-specific customer information.
        # @!attribute [rw] user
        #   @return [::Google::Cloud::Channel::V1::AdminUser]
        #     Admin user information.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Validate the request and preview the review, but do not post it.
        class ProvisionCloudIdentityRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_entitlements CloudChannelService.ListEntitlements}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller's customer account to list
        #     entitlements for.
        #     Parent uses the format: accounts/\\{account_id}/customers/\\{customer_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer results than
        #     requested. If unspecified, return at most 50 entitlements. The maximum
        #     value is 100; the server will coerce values above 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token for a page of results other than the first page.
        #     Obtained using
        #     {::Google::Cloud::Channel::V1::ListEntitlementsResponse#next_page_token ListEntitlementsResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_entitlements CloudChannelService.ListEntitlements}
        #     call.
        class ListEntitlementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_entitlements CloudChannelService.ListEntitlements}.
        # @!attribute [rw] entitlements
        #   @return [::Array<::Google::Cloud::Channel::V1::Entitlement>]
        #     The reseller customer's entitlements.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to list the next page of results.
        #     Pass to
        #     {::Google::Cloud::Channel::V1::ListEntitlementsRequest#page_token ListEntitlementsRequest.page_token}
        #     to obtain that page.
        class ListEntitlementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_transferable_skus CloudChannelService.ListTransferableSkus}
        # @!attribute [rw] cloud_identity_id
        #   @return [::String]
        #     Customer's Cloud Identity ID
        #
        #     Note: The following fields are mutually exclusive: `cloud_identity_id`, `customer_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] customer_name
        #   @return [::String]
        #     A reseller is required to create a customer and use the resource name of
        #     the created customer here.
        #     Customer_name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}
        #
        #     Note: The following fields are mutually exclusive: `customer_name`, `cloud_identity_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The reseller account's resource name.
        #     Parent uses the format: accounts/\\{account_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The requested page size. Server might return fewer results than requested.
        #     If unspecified, returns at most 100 SKUs.
        #     The maximum value is 1000; the server will coerce values above 1000.
        #     Optional.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token for a page of results other than the first page.
        #     Obtained using
        #     {::Google::Cloud::Channel::V1::ListTransferableSkusResponse#next_page_token ListTransferableSkusResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_transferable_skus CloudChannelService.ListTransferableSkus}
        #     call. Optional.
        # @!attribute [rw] auth_token
        #   @return [::String]
        #     Optional. The super admin of the resold customer generates this token to
        #     authorize a reseller to access their Cloud Identity and purchase
        #     entitlements on their behalf. You can omit this token after authorization.
        #     See https://support.google.com/a/answer/7643790 for more details.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     The BCP-47 language code. For example, "en-US". The
        #     response will localize in the corresponding language code, if specified.
        #     The default value is "en-US".
        #     Optional.
        class ListTransferableSkusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_transferable_skus CloudChannelService.ListTransferableSkus}.
        # @!attribute [rw] transferable_skus
        #   @return [::Array<::Google::Cloud::Channel::V1::TransferableSku>]
        #     Information about existing SKUs for a customer that needs a transfer.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::Channel::V1::ListTransferableSkusRequest#page_token ListTransferableSkusRequest.page_token}
        #     to obtain that page.
        class ListTransferableSkusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_transferable_offers CloudChannelService.ListTransferableOffers}
        # @!attribute [rw] cloud_identity_id
        #   @return [::String]
        #     Customer's Cloud Identity ID
        #
        #     Note: The following fields are mutually exclusive: `cloud_identity_id`, `customer_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] customer_name
        #   @return [::String]
        #     A reseller should create a customer and use the resource name of
        #     that customer here.
        #
        #     Note: The following fields are mutually exclusive: `customer_name`, `cloud_identity_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller's account.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server might return fewer results than requested.
        #     If unspecified, returns at most 100 offers.
        #     The maximum value is 1000; the server will coerce values above 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token for a page of results other than the first page.
        #     Obtained using
        #     {::Google::Cloud::Channel::V1::ListTransferableOffersResponse#next_page_token ListTransferableOffersResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_transferable_offers CloudChannelService.ListTransferableOffers}
        #     call.
        # @!attribute [rw] sku
        #   @return [::String]
        #     Required. The SKU to look up Offers for.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The BCP-47 language code. For example, "en-US". The
        #     response will localize in the corresponding language code, if specified.
        #     The default value is "en-US".
        # @!attribute [rw] billing_account
        #   @return [::String]
        #     Optional. The Billing Account to look up Offers for. Format:
        #     accounts/\\{account_id}/billingAccounts/\\{billing_account_id}.
        #
        #     This field is only relevant for multi-currency accounts. It should be left
        #     empty for single currency accounts.
        class ListTransferableOffersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_transferable_offers CloudChannelService.ListTransferableOffers}.
        # @!attribute [rw] transferable_offers
        #   @return [::Array<::Google::Cloud::Channel::V1::TransferableOffer>]
        #     Information about Offers for a customer that can be used for
        #     transfer.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::Channel::V1::ListTransferableOffersRequest#page_token ListTransferableOffersRequest.page_token}
        #     to obtain that page.
        class ListTransferableOffersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TransferableOffer represents an Offer that can be used in Transfer.
        # Read-only.
        # @!attribute [rw] offer
        #   @return [::Google::Cloud::Channel::V1::Offer]
        #     Offer with parameter constraints updated to allow the Transfer.
        class TransferableOffer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#get_entitlement CloudChannelService.GetEntitlement}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the entitlement to retrieve.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        class GetEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_channel_partner_links CloudChannelService.ListChannelPartnerLinks}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller account for listing channel
        #     partner links. Parent uses the format: accounts/\\{account_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer results than
        #     requested. If unspecified, server will pick a default size (25). The
        #     maximum value is 200; the server will coerce values above 200.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token for a page of results other than the first page.
        #     Obtained using
        #     {::Google::Cloud::Channel::V1::ListChannelPartnerLinksResponse#next_page_token ListChannelPartnerLinksResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_channel_partner_links CloudChannelService.ListChannelPartnerLinks}
        #     call.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Channel::V1::ChannelPartnerLinkView]
        #     Optional. The level of granularity the ChannelPartnerLink will display.
        class ListChannelPartnerLinksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_channel_partner_links CloudChannelService.ListChannelPartnerLinks}.
        # @!attribute [rw] channel_partner_links
        #   @return [::Array<::Google::Cloud::Channel::V1::ChannelPartnerLink>]
        #     The Channel partner links for a reseller.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest#page_token ListChannelPartnerLinksRequest.page_token}
        #     to obtain that page.
        class ListChannelPartnerLinksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#get_channel_partner_link CloudChannelService.GetChannelPartnerLink}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the channel partner link to retrieve.
        #     Name uses the format: accounts/\\{account_id}/channelPartnerLinks/\\{id}
        #     where \\{id} is the Cloud Identity ID of the partner.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Channel::V1::ChannelPartnerLinkView]
        #     Optional. The level of granularity the ChannelPartnerLink will display.
        class GetChannelPartnerLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#create_channel_partner_link CloudChannelService.CreateChannelPartnerLink}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Create a channel partner link for the provided reseller account's
        #     resource name.
        #     Parent uses the format: accounts/\\{account_id}
        # @!attribute [rw] channel_partner_link
        #   @return [::Google::Cloud::Channel::V1::ChannelPartnerLink]
        #     Required. The channel partner link to create.
        #     Either channel_partner_link.reseller_cloud_identity_id or domain can be
        #     used to create a link.
        class CreateChannelPartnerLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#update_channel_partner_link CloudChannelService.UpdateChannelPartnerLink}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the channel partner link to cancel.
        #     Name uses the format: accounts/\\{account_id}/channelPartnerLinks/\\{id}
        #     where \\{id} is the Cloud Identity ID of the partner.
        # @!attribute [rw] channel_partner_link
        #   @return [::Google::Cloud::Channel::V1::ChannelPartnerLink]
        #     Required. The channel partner link to update. Only
        #     channel_partner_link.link_state is allowed for updates.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask that applies to the resource.
        #     The only allowable value for an update mask is
        #     channel_partner_link.link_state.
        class UpdateChannelPartnerLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#get_customer_repricing_config CloudChannelService.GetCustomerRepricingConfig}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the CustomerRepricingConfig.
        #     Format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/customerRepricingConfigs/\\{id}.
        class GetCustomerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_customer_repricing_configs CloudChannelService.ListCustomerRepricingConfigs}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the customer.
        #     Parent uses the format: accounts/\\{account_id}/customers/\\{customer_id}.
        #     Supports accounts/\\{account_id}/customers/- to retrieve configs for all
        #     customers.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of repricing configs to return. The service
        #     may return fewer than this value. If unspecified, returns a maximum of 50
        #     rules. The maximum value is 100; values above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results beyond the first page.
        #     Obtained through
        #     {::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsResponse#next_page_token ListCustomerRepricingConfigsResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_customer_repricing_configs CloudChannelService.ListCustomerRepricingConfigs}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter for [CloudChannelService.ListCustomerRepricingConfigs]
        #     results (customer only). You can use this filter when you support
        #     a BatchGet-like query.
        #     To use the filter, you must set `parent=accounts/{account_id}/customers/-`.
        #
        #     Example: customer = accounts/account_id/customers/c1 OR
        #     customer = accounts/account_id/customers/c2.
        class ListCustomerRepricingConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_customer_repricing_configs CloudChannelService.ListCustomerRepricingConfigs}.
        # @!attribute [rw] customer_repricing_configs
        #   @return [::Array<::Google::Cloud::Channel::V1::CustomerRepricingConfig>]
        #     The repricing configs for this channel partner.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest#page_token ListCustomerRepricingConfigsRequest.page_token}
        #     to obtain that page.
        class ListCustomerRepricingConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#create_customer_repricing_config CloudChannelService.CreateCustomerRepricingConfig}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the customer that will receive this
        #     repricing config. Parent uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}
        # @!attribute [rw] customer_repricing_config
        #   @return [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
        #     Required. The CustomerRepricingConfig object to update.
        class CreateCustomerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#update_customer_repricing_config CloudChannelService.UpdateCustomerRepricingConfig}.
        # @!attribute [rw] customer_repricing_config
        #   @return [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
        #     Required. The CustomerRepricingConfig object to update.
        class UpdateCustomerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#delete_customer_repricing_config CloudChannelService.DeleteCustomerRepricingConfig}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the customer repricing config rule to
        #     delete. Format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/customerRepricingConfigs/\\{id}.
        class DeleteCustomerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#get_channel_partner_repricing_config CloudChannelService.GetChannelPartnerRepricingConfig}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the ChannelPartnerRepricingConfig
        #     Format:
        #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}/channelPartnerRepricingConfigs/\\{id}.
        class GetChannelPartnerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_channel_partner_repricing_configs CloudChannelService.ListChannelPartnerRepricingConfigs}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the account's
        #     {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink}. Parent
        #     uses the format:
        #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}.
        #     Supports accounts/\\{account_id}/channelPartnerLinks/- to retrieve configs
        #     for all channel partners.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of repricing configs to return. The service
        #     may return fewer than this value. If unspecified, returns a maximum of 50
        #     rules. The maximum value is 100; values above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results beyond the first page.
        #     Obtained through
        #     {::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsResponse#next_page_token ListChannelPartnerRepricingConfigsResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_channel_partner_repricing_configs CloudChannelService.ListChannelPartnerRepricingConfigs}
        #     call.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter for
        #     [CloudChannelService.ListChannelPartnerRepricingConfigs] results
        #     (channel_partner_link only). You can use this filter when you support a
        #     BatchGet-like query. To use the filter, you must set
        #     `parent=accounts/{account_id}/channelPartnerLinks/-`.
        #
        #     Example: `channel_partner_link =
        #     accounts/account_id/channelPartnerLinks/c1` OR `channel_partner_link =
        #     accounts/account_id/channelPartnerLinks/c2`.
        class ListChannelPartnerRepricingConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_channel_partner_repricing_configs CloudChannelService.ListChannelPartnerRepricingConfigs}.
        # @!attribute [rw] channel_partner_repricing_configs
        #   @return [::Array<::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig>]
        #     The repricing configs for this channel partner.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest#page_token ListChannelPartnerRepricingConfigsRequest.page_token}
        #     to obtain that page.
        class ListChannelPartnerRepricingConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#create_channel_partner_repricing_config CloudChannelService.CreateChannelPartnerRepricingConfig}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the ChannelPartner that will receive the
        #     repricing config. Parent uses the format:
        #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}
        # @!attribute [rw] channel_partner_repricing_config
        #   @return [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
        #     Required. The ChannelPartnerRepricingConfig object to update.
        class CreateChannelPartnerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#update_channel_partner_repricing_config CloudChannelService.UpdateChannelPartnerRepricingConfig}.
        # @!attribute [rw] channel_partner_repricing_config
        #   @return [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
        #     Required. The ChannelPartnerRepricingConfig object to update.
        class UpdateChannelPartnerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteChannelPartnerRepricingConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the channel partner repricing config rule to
        #     delete.
        class DeleteChannelPartnerRepricingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSkuGroups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the account from which to list SKU groups.
        #     Parent uses the format: accounts/\\{account}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of SKU groups to return. The service may
        #     return fewer than this value. If unspecified, returns a maximum of 1000 SKU
        #     groups. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results beyond the first page.
        #     Obtained through
        #     [ListSkuGroups.next_page_token][] of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_sku_groups CloudChannelService.ListSkuGroups}
        #     call.
        class ListSkuGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSkuGroupBillableSkus.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the SKU group.
        #     Format: accounts/\\{account}/skuGroups/\\{sku_group}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of SKUs to return. The service may return
        #     fewer than this value. If unspecified, returns a maximum of 100000 SKUs.
        #     The maximum value is 100000; values above 100000 will be coerced to 100000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results beyond the first page.
        #     Obtained through
        #     [ListSkuGroupBillableSkus.next_page_token][] of the previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_sku_group_billable_skus CloudChannelService.ListSkuGroupBillableSkus}
        #     call.
        class ListSkuGroupBillableSkusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSkuGroups.
        # @!attribute [rw] sku_groups
        #   @return [::Array<::Google::Cloud::Channel::V1::SkuGroup>]
        #     The list of SKU groups requested.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to [ListSkuGroups.page_token][] to obtain that
        #     page.
        class ListSkuGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSkuGroupBillableSkus.
        # @!attribute [rw] billable_skus
        #   @return [::Array<::Google::Cloud::Channel::V1::BillableSku>]
        #     The list of billable SKUs in the requested SKU group.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to [ListSkuGroupBillableSkus.page_token][] to obtain that
        #     page.
        class ListSkuGroupBillableSkusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the SKU group information.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of SKU group. Format:
        #     accounts/\\{account}/skuGroups/\\{sku_group}.
        #     Example:
        #     "accounts/C01234/skuGroups/3d50fd57-3157-4577-a5a9-a219b8490041".
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Unique human readable identifier for the SKU group.
        class SkuGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the Billable SKU information.
        # @!attribute [rw] sku
        #   @return [::String]
        #     Resource name of Billable SKU. Format:
        #     billableSkus/\\{sku}.
        #     Example:
        #     billableSkus/6E1B-6634-470F".
        # @!attribute [rw] sku_display_name
        #   @return [::String]
        #     Unique human readable name for the SKU.
        # @!attribute [rw] service
        #   @return [::String]
        #     Resource name of Service which contains Repricing SKU. Format:
        #     services/\\{service}.
        #     Example:
        #     "services/B7D9-FDCB-15D8".
        # @!attribute [rw] service_display_name
        #   @return [::String]
        #     Unique human readable name for the Service.
        class BillableSku
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#create_entitlement CloudChannelService.CreateEntitlement}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller's customer account in which to
        #     create the entitlement. Parent uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}
        # @!attribute [rw] entitlement
        #   @return [::Google::Cloud::Channel::V1::Entitlement]
        #     Required. The entitlement to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class CreateEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#transfer_entitlements CloudChannelService.TransferEntitlements}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller's customer account that will
        #     receive transferred entitlements. Parent uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}
        # @!attribute [rw] entitlements
        #   @return [::Array<::Google::Cloud::Channel::V1::Entitlement>]
        #     Required. The new entitlements to create or transfer.
        # @!attribute [rw] auth_token
        #   @return [::String]
        #     The super admin of the resold customer generates this token to
        #     authorize a reseller to access their Cloud Identity and purchase
        #     entitlements on their behalf. You can omit this token after authorization.
        #     See https://support.google.com/a/answer/7643790 for more details.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class TransferEntitlementsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#transfer_entitlements CloudChannelService.TransferEntitlements}.
        # This is put in the response field of google.longrunning.Operation.
        # @!attribute [rw] entitlements
        #   @return [::Array<::Google::Cloud::Channel::V1::Entitlement>]
        #     The transferred entitlements.
        class TransferEntitlementsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#transfer_entitlements_to_google CloudChannelService.TransferEntitlementsToGoogle}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller's customer account where the
        #     entitlements transfer from. Parent uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}
        # @!attribute [rw] entitlements
        #   @return [::Array<::Google::Cloud::Channel::V1::Entitlement>]
        #     Required. The entitlements to transfer to Google.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class TransferEntitlementsToGoogleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [CloudChannelService.ChangeParametersRequest][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entitlement to update.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] parameters
        #   @return [::Array<::Google::Cloud::Channel::V1::Parameter>]
        #     Required. Entitlement parameters to update. You can only change editable
        #     parameters.
        #
        #     To view the available Parameters for a request, refer to the
        #     {::Google::Cloud::Channel::V1::Offer#parameter_definitions Offer.parameter_definitions}
        #     from the desired offer.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        # @!attribute [rw] purchase_order_id
        #   @return [::String]
        #     Optional. Purchase order ID provided by the reseller.
        class ChangeParametersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#change_renewal_settings CloudChannelService.ChangeRenewalSettings}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entitlement to update.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] renewal_settings
        #   @return [::Google::Cloud::Channel::V1::RenewalSettings]
        #     Required. New renewal settings.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class ChangeRenewalSettingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#change_offer CloudChannelService.ChangeOffer}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the entitlement to update.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] offer
        #   @return [::String]
        #     Required. New Offer.
        #     Format: accounts/\\{account_id}/offers/\\{offer_id}.
        # @!attribute [rw] parameters
        #   @return [::Array<::Google::Cloud::Channel::V1::Parameter>]
        #     Optional. Parameters needed to purchase the Offer. To view the available
        #     Parameters refer to the
        #     {::Google::Cloud::Channel::V1::Offer#parameter_definitions Offer.parameter_definitions}
        #     from the desired offer.
        # @!attribute [rw] purchase_order_id
        #   @return [::String]
        #     Optional. Purchase order id provided by the reseller.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        # @!attribute [rw] billing_account
        #   @return [::String]
        #     Optional. The billing account resource name that is used to pay for this
        #     entitlement when setting up billing on a trial subscription.
        #
        #     This field is only relevant for multi-currency accounts. It should be
        #     left empty for single currency accounts.
        class ChangeOfferRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#start_paid_service CloudChannelService.StartPaidService}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entitlement to start a paid service for.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class StartPaidServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#cancel_entitlement CloudChannelService.CancelEntitlement}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the entitlement to cancel.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class CancelEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#suspend_entitlement CloudChannelService.SuspendEntitlement}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the entitlement to suspend.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class SuspendEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#activate_entitlement CloudChannelService.ActivateEntitlement}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the entitlement to activate.
        #     Name uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. You can specify an optional unique request ID, and if you need to
        #     retry your request, the server will know to ignore the request if it's
        #     complete.
        #
        #     For example, you make an initial request and the request times out. If you
        #     make the request again with the same request ID, the server can check if
        #     it received the original operation with the same request ID. If it did, it
        #     will ignore the second request.
        #
        #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
        #     with the exception that zero UUID is not supported
        #     (`00000000-0000-0000-0000-000000000000`).
        class ActivateEntitlementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for LookupOffer.
        # @!attribute [rw] entitlement
        #   @return [::String]
        #     Required. The resource name of the entitlement to retrieve the Offer.
        #     Entitlement uses the format:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        class LookupOfferRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListProducts.
        # @!attribute [rw] account
        #   @return [::String]
        #     Required. The resource name of the reseller account.
        #     Format: accounts/\\{account_id}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer results than
        #     requested. If unspecified, returns at most 100 Products. The maximum value
        #     is 1000; the server will coerce values above 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token for a page of results other than the first page.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The BCP-47 language code. For example, "en-US". The
        #     response will localize in the corresponding language code, if specified.
        #     The default value is "en-US".
        class ListProductsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListProducts.
        # @!attribute [rw] products
        #   @return [::Array<::Google::Cloud::Channel::V1::Product>]
        #     List of Products requested.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        class ListProductsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListSkus.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Product to list SKUs for.
        #     Parent uses the format: products/\\{product_id}.
        #     Supports products/- to retrieve SKUs for all products.
        # @!attribute [rw] account
        #   @return [::String]
        #     Required. Resource name of the reseller.
        #     Format: accounts/\\{account_id}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer results than
        #     requested. If unspecified, returns at most 100 SKUs. The maximum value is
        #     1000; the server will coerce values above 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token for a page of results other than the first page.
        #     Optional.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The BCP-47 language code. For example, "en-US". The
        #     response will localize in the corresponding language code, if specified.
        #     The default value is "en-US".
        class ListSkusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListSkus.
        # @!attribute [rw] skus
        #   @return [::Array<::Google::Cloud::Channel::V1::Sku>]
        #     The list of SKUs requested.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        class ListSkusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListOffers.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the reseller account from which to list
        #     Offers. Parent uses the format: accounts/\\{account_id}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer results than
        #     requested. If unspecified, returns at most 500 Offers. The maximum value is
        #     1000; the server will coerce values above 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token for a page of results other than the first page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The expression to filter results by name (name of
        #     the Offer), sku.name (name of the SKU), or sku.product.name (name of the
        #     Product).
        #     Example 1: sku.product.name=products/p1 AND sku.name!=products/p1/skus/s1
        #     Example 2: name=accounts/a1/offers/o1
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The BCP-47 language code. For example, "en-US". The
        #     response will localize in the corresponding language code, if specified.
        #     The default value is "en-US".
        # @!attribute [rw] show_future_offers
        #   @return [::Boolean]
        #     Optional. A boolean flag that determines if a response returns future
        #     offers 30 days from now. If the show_future_offers is true, the response
        #     will only contain offers that are scheduled to be available 30 days from
        #     now.
        class ListOffersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListOffers.
        # @!attribute [rw] offers
        #   @return [::Array<::Google::Cloud::Channel::V1::Offer>]
        #     The list of Offers requested.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        class ListOffersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListPurchasableSkus.
        # @!attribute [rw] create_entitlement_purchase
        #   @return [::Google::Cloud::Channel::V1::ListPurchasableSkusRequest::CreateEntitlementPurchase]
        #     List SKUs for CreateEntitlement purchase.
        #
        #     Note: The following fields are mutually exclusive: `create_entitlement_purchase`, `change_offer_purchase`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] change_offer_purchase
        #   @return [::Google::Cloud::Channel::V1::ListPurchasableSkusRequest::ChangeOfferPurchase]
        #     List SKUs for ChangeOffer purchase with a new SKU.
        #
        #     Note: The following fields are mutually exclusive: `change_offer_purchase`, `create_entitlement_purchase`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] customer
        #   @return [::String]
        #     Required. The resource name of the customer to list SKUs for.
        #     Format: accounts/\\{account_id}/customers/\\{customer_id}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer results than
        #     requested. If unspecified, returns at most 100 SKUs. The maximum value is
        #     1000; the server will coerce values above 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token for a page of results other than the first page.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The BCP-47 language code. For example, "en-US". The
        #     response will localize in the corresponding language code, if specified.
        #     The default value is "en-US".
        class ListPurchasableSkusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # List SKUs for a new entitlement. Make the purchase using
          # {::Google::Cloud::Channel::V1::CloudChannelService::Client#create_entitlement CloudChannelService.CreateEntitlement}.
          # @!attribute [rw] product
          #   @return [::String]
          #     Required. List SKUs belonging to this Product.
          #     Format: products/\\{product_id}.
          #     Supports products/- to retrieve SKUs for all products.
          class CreateEntitlementPurchase
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # List SKUs for upgrading or downgrading an entitlement. Make the purchase
          # using
          # {::Google::Cloud::Channel::V1::CloudChannelService::Client#change_offer CloudChannelService.ChangeOffer}.
          # @!attribute [rw] entitlement
          #   @return [::String]
          #     Required. Resource name of the entitlement.
          #     Format:
          #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
          # @!attribute [rw] change_type
          #   @return [::Google::Cloud::Channel::V1::ListPurchasableSkusRequest::ChangeOfferPurchase::ChangeType]
          #     Required. Change Type for the entitlement.
          class ChangeOfferPurchase
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Change Type enum.
            module ChangeType
              # Not used.
              CHANGE_TYPE_UNSPECIFIED = 0

              # SKU is an upgrade on the current entitlement.
              UPGRADE = 1

              # SKU is a downgrade on the current entitlement.
              DOWNGRADE = 2
            end
          end
        end

        # Response message for ListPurchasableSkus.
        # @!attribute [rw] purchasable_skus
        #   @return [::Array<::Google::Cloud::Channel::V1::PurchasableSku>]
        #     The list of SKUs requested.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        class ListPurchasableSkusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SKU that you can purchase. This is used in ListPurchasableSku API
        # response.
        # @!attribute [rw] sku
        #   @return [::Google::Cloud::Channel::V1::Sku]
        #     SKU
        class PurchasableSku
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListPurchasableOffers.
        # @!attribute [rw] create_entitlement_purchase
        #   @return [::Google::Cloud::Channel::V1::ListPurchasableOffersRequest::CreateEntitlementPurchase]
        #     List Offers for CreateEntitlement purchase.
        #
        #     Note: The following fields are mutually exclusive: `create_entitlement_purchase`, `change_offer_purchase`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] change_offer_purchase
        #   @return [::Google::Cloud::Channel::V1::ListPurchasableOffersRequest::ChangeOfferPurchase]
        #     List Offers for ChangeOffer purchase.
        #
        #     Note: The following fields are mutually exclusive: `change_offer_purchase`, `create_entitlement_purchase`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] customer
        #   @return [::String]
        #     Required. The resource name of the customer to list Offers for.
        #     Format: accounts/\\{account_id}/customers/\\{customer_id}.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server might return fewer results than
        #     requested. If unspecified, returns at most 100 Offers. The maximum value is
        #     1000; the server will coerce values above 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token for a page of results other than the first page.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     Optional. The BCP-47 language code. For example, "en-US". The
        #     response will localize in the corresponding language code, if specified.
        #     The default value is "en-US".
        class ListPurchasableOffersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # List Offers for CreateEntitlement purchase.
          # @!attribute [rw] sku
          #   @return [::String]
          #     Required. SKU that the result should be restricted to.
          #     Format: products/\\{product_id}/skus/\\{sku_id}.
          # @!attribute [rw] billing_account
          #   @return [::String]
          #     Optional. Billing account that the result should be restricted to.
          #     Format: accounts/\\{account_id}/billingAccounts/\\{billing_account_id}.
          class CreateEntitlementPurchase
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # List Offers for ChangeOffer purchase.
          # @!attribute [rw] entitlement
          #   @return [::String]
          #     Required. Resource name of the entitlement.
          #     Format:
          #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
          # @!attribute [rw] new_sku
          #   @return [::String]
          #     Optional. Resource name of the new target SKU. Provide this SKU when
          #     upgrading or downgrading an entitlement. Format:
          #     products/\\{product_id}/skus/\\{sku_id}
          # @!attribute [rw] billing_account
          #   @return [::String]
          #     Optional. Resource name of the new target Billing Account. Provide this
          #     Billing Account when setting up billing for a trial subscription. Format:
          #     accounts/\\{account_id}/billingAccounts/\\{billing_account_id}.
          #
          #     This field is only relevant for multi-currency accounts. It should be
          #     left empty for single currency accounts.
          class ChangeOfferPurchase
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for ListPurchasableOffers.
        # @!attribute [rw] purchasable_offers
        #   @return [::Array<::Google::Cloud::Channel::V1::PurchasableOffer>]
        #     The list of Offers requested.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        class ListPurchasableOffersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Offer that you can purchase for a customer. This is used in the
        # ListPurchasableOffer API response.
        # @!attribute [rw] offer
        #   @return [::Google::Cloud::Channel::V1::Offer]
        #     Offer.
        class PurchasableOffer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for QueryEligibleBillingAccounts.
        # @!attribute [rw] customer
        #   @return [::String]
        #     Required. The resource name of the customer to list eligible billing
        #     accounts for. Format: accounts/\\{account_id}/customers/\\{customer_id}.
        # @!attribute [rw] skus
        #   @return [::Array<::String>]
        #     Required. List of SKUs to list eligible billing accounts for. At least one
        #     SKU is required. Format: products/\\{product_id}/skus/\\{sku_id}.
        class QueryEligibleBillingAccountsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for QueryEligibleBillingAccounts.
        # @!attribute [rw] sku_purchase_groups
        #   @return [::Array<::Google::Cloud::Channel::V1::SkuPurchaseGroup>]
        #     List of SKU purchase groups where each group represents a set of SKUs that
        #     must be purchased using the same billing account. Each SKU from
        #     [QueryEligibleBillingAccountsRequest.skus] will appear in exactly one SKU
        #     group.
        class QueryEligibleBillingAccountsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a set of SKUs that must be purchased using the same billing
        # account.
        # @!attribute [rw] skus
        #   @return [::Array<::String>]
        #     Resource names of the SKUs included in this group.
        #     Format: products/\\{product_id}/skus/\\{sku_id}.
        # @!attribute [rw] billing_account_purchase_infos
        #   @return [::Array<::Google::Cloud::Channel::V1::BillingAccountPurchaseInfo>]
        #     List of billing accounts that are eligible to purhcase these SKUs.
        class SkuPurchaseGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a billing account that can be used to make a purchase.
        # @!attribute [rw] billing_account
        #   @return [::Google::Cloud::Channel::V1::BillingAccount]
        #     The billing account resource.
        class BillingAccountPurchaseInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request Message for RegisterSubscriber.
        # @!attribute [rw] account
        #   @return [::String]
        #     Required. Resource name of the account.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Required. Service account that provides subscriber access to the registered
        #     topic.
        class RegisterSubscriberRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response Message for RegisterSubscriber.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Name of the topic the subscriber will listen to.
        class RegisterSubscriberResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request Message for UnregisterSubscriber.
        # @!attribute [rw] account
        #   @return [::String]
        #     Required. Resource name of the account.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Required. Service account to unregister from subscriber access to the
        #     topic.
        class UnregisterSubscriberRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response Message for UnregisterSubscriber.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Name of the topic the service account subscriber access was removed from.
        class UnregisterSubscriberResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request Message for ListSubscribers.
        # @!attribute [rw] account
        #   @return [::String]
        #     Required. Resource name of the account.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of service accounts to return. The service may
        #     return fewer than this value. If unspecified, returns at most 100 service
        #     accounts. The maximum value is 1000; the server will coerce values above
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListSubscribers` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListSubscribers` must
        #     match the call that provided the page token.
        class ListSubscribersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response Message for ListSubscribers.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Name of the topic registered with the reseller.
        # @!attribute [rw] service_accounts
        #   @return [::Array<::String>]
        #     List of service accounts which have subscriber access to the topic.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListSubscribersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_entitlement_changes CloudChannelService.ListEntitlementChanges}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the entitlement for which to list
        #     entitlement changes. The `-` wildcard may be used to match entitlements
        #     across a customer. Formats:
        #
        #       * accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        #       * accounts/\\{account_id}/customers/\\{customer_id}/entitlements/-
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of entitlement changes to return. The service
        #     may return fewer than this value. If unspecified, returns at most 10
        #     entitlement changes. The maximum value is 50; the server will coerce values
        #     above 50.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_entitlement_changes CloudChannelService.ListEntitlementChanges}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_entitlement_changes CloudChannelService.ListEntitlementChanges}
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filters applied to the list results.
        class ListEntitlementChangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::Channel::V1::CloudChannelService::Client#list_entitlement_changes CloudChannelService.ListEntitlementChanges}
        # @!attribute [rw] entitlement_changes
        #   @return [::Array<::Google::Cloud::Channel::V1::EntitlementChange>]
        #     The list of entitlement changes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to list the next page of results.
        class ListEntitlementChangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
