# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Channel
      module V1
        # A Product is the entity a customer uses when placing an order. For example,
        # Google Workspace, Google Voice, etc.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource Name of the Product.
        #     Format: products/\\{product_id}
        # @!attribute [rw] marketing_info
        #   @return [::Google::Cloud::Channel::V1::MarketingInfo]
        #     Marketing information for the product.
        class Product
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a product's purchasable Stock Keeping Unit (SKU).
        # SKUs represent the different variations of the product. For example, Google
        # Workspace Business Standard and Google Workspace Business Plus are Google
        # Workspace product SKUs.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource Name of the SKU.
        #     Format: products/\\{product_id}/skus/\\{sku_id}
        # @!attribute [rw] marketing_info
        #   @return [::Google::Cloud::Channel::V1::MarketingInfo]
        #     Marketing information for the SKU.
        # @!attribute [rw] product
        #   @return [::Google::Cloud::Channel::V1::Product]
        #     Product the SKU is associated with.
        class Sku
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the marketing information for a Product, SKU or Offer.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Human readable name.
        # @!attribute [rw] description
        #   @return [::String]
        #     Human readable description. Description can contain HTML.
        # @!attribute [rw] default_logo
        #   @return [::Google::Cloud::Channel::V1::Media]
        #     Default logo.
        class MarketingInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents media information.
        # @!attribute [rw] title
        #   @return [::String]
        #     Title of the media.
        # @!attribute [rw] content
        #   @return [::String]
        #     URL of the media.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Channel::V1::MediaType]
        #     Type of the media.
        class Media
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Type of media used.
        module MediaType
          # Not used.
          MEDIA_TYPE_UNSPECIFIED = 0

          # Type of image.
          MEDIA_TYPE_IMAGE = 1
        end
      end
    end
  end
end
