# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Channel
      module V1
        # Change event entry for Entitlement order history
        # @!attribute [rw] suspension_reason
        #   @return [::Google::Cloud::Channel::V1::Entitlement::SuspensionReason]
        #     Suspension reason for the Entitlement.
        #
        #     Note: The following fields are mutually exclusive: `suspension_reason`, `cancellation_reason`, `activation_reason`, `other_change_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cancellation_reason
        #   @return [::Google::Cloud::Channel::V1::EntitlementChange::CancellationReason]
        #     Cancellation reason for the Entitlement.
        #
        #     Note: The following fields are mutually exclusive: `cancellation_reason`, `suspension_reason`, `activation_reason`, `other_change_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] activation_reason
        #   @return [::Google::Cloud::Channel::V1::EntitlementChange::ActivationReason]
        #     The Entitlement's activation reason
        #
        #     Note: The following fields are mutually exclusive: `activation_reason`, `suspension_reason`, `cancellation_reason`, `other_change_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] other_change_reason
        #   @return [::String]
        #     e.g. purchase_number change reason, entered by CRS.
        #
        #     Note: The following fields are mutually exclusive: `other_change_reason`, `suspension_reason`, `cancellation_reason`, `activation_reason`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] entitlement
        #   @return [::String]
        #     Required. Resource name of an entitlement in the form:
        #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
        # @!attribute [rw] offer
        #   @return [::String]
        #     Required. Resource name of the Offer at the time of change.
        #     Takes the form: accounts/\\{account_id}/offers/\\{offer_id}.
        # @!attribute [rw] provisioned_service
        #   @return [::Google::Cloud::Channel::V1::ProvisionedService]
        #     Service provisioned for an Entitlement.
        # @!attribute [rw] change_type
        #   @return [::Google::Cloud::Channel::V1::EntitlementChange::ChangeType]
        #     The change action type.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The submitted time of the change.
        # @!attribute [rw] operator_type
        #   @return [::Google::Cloud::Channel::V1::EntitlementChange::OperatorType]
        #     Operator type responsible for the change.
        # @!attribute [rw] parameters
        #   @return [::Array<::Google::Cloud::Channel::V1::Parameter>]
        #     Extended parameters, such as:
        #     purchase_order_number, gcp_details;
        #     internal_correlation_id, long_running_operation_id, order_id;
        #     etc.
        # @!attribute [rw] operator
        #   @return [::String]
        #     Human-readable identifier that shows what operator made a change.
        #     When the operator_type is RESELLER, this is the user's email address.
        #     For all other operator types, this is empty.
        class EntitlementChange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the type of change action
          module ChangeType
            # Not used.
            CHANGE_TYPE_UNSPECIFIED = 0

            # New Entitlement was created.
            CREATED = 1

            # Price plan associated with an Entitlement was changed.
            PRICE_PLAN_SWITCHED = 3

            # Number of seats committed for a commitment Entitlement was changed.
            COMMITMENT_CHANGED = 4

            # An annual Entitlement was renewed.
            RENEWED = 5

            # Entitlement was suspended.
            SUSPENDED = 6

            # Entitlement was activated.
            ACTIVATED = 7

            # Entitlement was cancelled.
            CANCELLED = 8

            # Entitlement was upgraded or downgraded for ex. from Google Workspace
            # Business Standard to Google Workspace Business Plus.
            SKU_CHANGED = 9

            # The settings for renewal of an Entitlement have changed.
            RENEWAL_SETTING_CHANGED = 10

            # Use for Google Workspace subscription.
            # Either a trial was converted to a paid subscription or a new subscription
            # with no trial is created.
            PAID_SUBSCRIPTION_STARTED = 11

            # License cap was changed for the entitlement.
            LICENSE_CAP_CHANGED = 12

            # The suspension details have changed (but it is still suspended).
            SUSPENSION_DETAILS_CHANGED = 13

            # The trial end date was extended.
            TRIAL_END_DATE_EXTENDED = 14

            # Entitlement started trial.
            TRIAL_STARTED = 15
          end

          # Specifies the type of operator responsible for the change
          module OperatorType
            # Not used.
            OPERATOR_TYPE_UNSPECIFIED = 0

            # Customer service representative.
            CUSTOMER_SERVICE_REPRESENTATIVE = 1

            # System auto job.
            SYSTEM = 2

            # Customer user.
            CUSTOMER = 3

            # Reseller user.
            RESELLER = 4
          end

          # Cancellation reason for the entitlement
          module CancellationReason
            # Not used.
            CANCELLATION_REASON_UNSPECIFIED = 0

            # Reseller triggered a cancellation of the service.
            SERVICE_TERMINATED = 1

            # Relationship between the reseller and customer has ended due to a
            # transfer.
            RELATIONSHIP_ENDED = 2

            # Entitlement transferred away from reseller while still keeping other
            # entitlement(s) with the reseller.
            PARTIAL_TRANSFER = 3
          end

          # The Entitlement's activation reason
          module ActivationReason
            # Not used.
            ACTIVATION_REASON_UNSPECIFIED = 0

            # Reseller reactivated a suspended Entitlement.
            RESELLER_REVOKED_SUSPENSION = 1

            # Customer accepted pending terms of service.
            CUSTOMER_ACCEPTED_PENDING_TOS = 2

            # Reseller updated the renewal settings on an entitlement that was
            # suspended due to cancellation, and this update reactivated the
            # entitlement.
            RENEWAL_SETTINGS_CHANGED = 3

            # Other reasons (Activated temporarily for cancellation, added a payment
            # plan to a trial entitlement, etc.)
            OTHER_ACTIVATION_REASON = 100
          end
        end
      end
    end
  end
end
