# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/channel/v1/service.proto for package 'google.cloud.channel.v1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/channel/v1/service_pb'

module Google
  module Cloud
    module Channel
      module V1
        module CloudChannelService
          # CloudChannelService lets Google cloud resellers and distributors manage
          # their customers, channel partners, entitlements, and reports.
          #
          # Using this service:
          # 1. Resellers and distributors can manage a customer entity.
          # 2. Distributors can register an authorized reseller in their channel and
          #    provide them with delegated admin access.
          # 3. Resellers and distributors can manage customer entitlements.
          #
          # CloudChannelService exposes the following resources:
          # - [Customer][google.cloud.channel.v1.Customer]s: An entity-usually an
          # enterprise-managed by a reseller or distributor.
          #
          # - [Entitlement][google.cloud.channel.v1.Entitlement]s: An entity that
          # provides a customer with the means to use a service. Entitlements are created
          # or updated as a result of a successful fulfillment.
          #
          # - [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s: An
          # entity that identifies links between distributors and their indirect
          # resellers in a channel.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.channel.v1.CloudChannelService'

            # List [Customer][google.cloud.channel.v1.Customer]s.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            #
            # Return value:
            # List of [Customer][google.cloud.channel.v1.Customer]s, or an empty list if
            # there are no customers.
            rpc :ListCustomers, ::Google::Cloud::Channel::V1::ListCustomersRequest, ::Google::Cloud::Channel::V1::ListCustomersResponse
            # Returns the requested [Customer][google.cloud.channel.v1.Customer]
            # resource.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
            # invalid name parameter.
            #
            # Return value:
            # The [Customer][google.cloud.channel.v1.Customer] resource.
            rpc :GetCustomer, ::Google::Cloud::Channel::V1::GetCustomerRequest, ::Google::Cloud::Channel::V1::Customer
            # Confirms the existence of Cloud Identity accounts based on the domain and
            # if the Cloud Identity accounts are owned by the reseller.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * INVALID_VALUE: Invalid domain value in the request.
            #
            # Return value:
            # A list of
            # [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
            # resources for the domain (may be empty)
            #
            # Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
            # no
            # [CloudIdentityCustomerAccount][google.cloud.channel.v1.CloudIdentityCustomerAccount]
            # resources match the domain.
            rpc :CheckCloudIdentityAccountsExist, ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest, ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistResponse
            # Creates a new [Customer][google.cloud.channel.v1.Customer] resource under
            # the reseller or distributor account.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED:
            #     * The reseller account making the request is different from the
            #     reseller account in the API request.
            #     * You are not authorized to create a customer. See
            #     https://support.google.com/channelservices/answer/9759265
            # * INVALID_ARGUMENT:
            #     * Required request parameters are missing or invalid.
            #     * Domain field value doesn't match the primary email domain.
            #
            # Return value:
            # The newly created [Customer][google.cloud.channel.v1.Customer] resource.
            rpc :CreateCustomer, ::Google::Cloud::Channel::V1::CreateCustomerRequest, ::Google::Cloud::Channel::V1::Customer
            # Updates an existing [Customer][google.cloud.channel.v1.Customer] resource
            # for the reseller or distributor.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
            # for the name in the request.
            #
            # Return value:
            # The updated [Customer][google.cloud.channel.v1.Customer] resource.
            rpc :UpdateCustomer, ::Google::Cloud::Channel::V1::UpdateCustomerRequest, ::Google::Cloud::Channel::V1::Customer
            # Deletes the given [Customer][google.cloud.channel.v1.Customer] permanently.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The account making the request does not own
            # this customer.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * FAILED_PRECONDITION: The customer has existing entitlements.
            # * NOT_FOUND: No [Customer][google.cloud.channel.v1.Customer] resource found
            # for the name in the request.
            rpc :DeleteCustomer, ::Google::Cloud::Channel::V1::DeleteCustomerRequest, ::Google::Protobuf::Empty
            # Imports a [Customer][google.cloud.channel.v1.Customer] from the Cloud
            # Identity associated with the provided Cloud Identity ID or domain before a
            # TransferEntitlements call. If a linked Customer already exists and
            # overwrite_if_exists is true, it will update that Customer's data.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED:
            #     * The reseller account making the request is different from the
            #     reseller account in the API request.
            #     * You are not authorized to import the customer. See
            #     https://support.google.com/channelservices/answer/9759265
            # * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
            # * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
            # expired or invalid.
            # * ALREADY_EXISTS: A customer already exists and has conflicting critical
            # fields. Requires an overwrite.
            #
            # Return value:
            # The [Customer][google.cloud.channel.v1.Customer].
            rpc :ImportCustomer, ::Google::Cloud::Channel::V1::ImportCustomerRequest, ::Google::Cloud::Channel::V1::Customer
            # Creates a Cloud Identity for the given customer using the customer's
            # information, or the information provided here.
            #
            # Possible error codes:
            #
            # *  PERMISSION_DENIED:
            #      * The customer doesn't belong to the reseller.
            #      * You are not authorized to provision cloud identity id. See
            #      https://support.google.com/channelservices/answer/9759265
            # *  INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # *  NOT_FOUND: The customer was not found.
            # *  ALREADY_EXISTS: The customer's primary email already exists. Retry
            #    after changing the customer's primary contact email.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata contains an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :ProvisionCloudIdentity, ::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest, ::Google::Longrunning::Operation
            # Lists [Entitlement][google.cloud.channel.v1.Entitlement]s belonging to a
            # customer.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            #
            # Return value:
            # A list of the customer's
            # [Entitlement][google.cloud.channel.v1.Entitlement]s.
            rpc :ListEntitlements, ::Google::Cloud::Channel::V1::ListEntitlementsRequest, ::Google::Cloud::Channel::V1::ListEntitlementsResponse
            # List [TransferableSku][google.cloud.channel.v1.TransferableSku]s of a
            # customer based on the Cloud Identity ID or Customer Name in the request.
            #
            # Use this method to list the entitlements information of an
            # unowned customer. You should provide the customer's
            # Cloud Identity ID or Customer Name.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED:
            #     * The customer doesn't belong to the reseller and has no auth token.
            #     * The supplied auth token is invalid.
            #     * The reseller account making the request is different
            #     from the reseller account in the query.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            #
            # Return value:
            # A list of the customer's
            # [TransferableSku][google.cloud.channel.v1.TransferableSku].
            rpc :ListTransferableSkus, ::Google::Cloud::Channel::V1::ListTransferableSkusRequest, ::Google::Cloud::Channel::V1::ListTransferableSkusResponse
            # List [TransferableOffer][google.cloud.channel.v1.TransferableOffer]s of a
            # customer based on Cloud Identity ID or Customer Name in the request.
            #
            # Use this method when a reseller gets the entitlement information of an
            # unowned customer. The reseller should provide the customer's
            # Cloud Identity ID or Customer Name.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED:
            #     * The customer doesn't belong to the reseller and has no auth token.
            #     * The customer provided incorrect reseller information when generating
            #     auth token.
            #     * The reseller account making the request is different
            #     from the reseller account in the query.
            #     * The reseller is not authorized to transact on this Product. See
            #     https://support.google.com/channelservices/answer/9759265
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            #
            # Return value:
            # List of [TransferableOffer][google.cloud.channel.v1.TransferableOffer] for
            # the given customer and SKU.
            rpc :ListTransferableOffers, ::Google::Cloud::Channel::V1::ListTransferableOffersRequest, ::Google::Cloud::Channel::V1::ListTransferableOffersResponse
            # Returns the requested [Entitlement][google.cloud.channel.v1.Entitlement]
            # resource.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: The customer entitlement was not found.
            #
            # Return value:
            # The requested [Entitlement][google.cloud.channel.v1.Entitlement] resource.
            rpc :GetEntitlement, ::Google::Cloud::Channel::V1::GetEntitlementRequest, ::Google::Cloud::Channel::V1::Entitlement
            # Creates an entitlement for a customer.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED:
            #     * The customer doesn't belong to the reseller.
            #     * The reseller is not authorized to transact on this Product. See
            #     https://support.google.com/channelservices/answer/9759265
            # * INVALID_ARGUMENT:
            #     * Required request parameters are missing or invalid.
            #     * There is already a customer entitlement for a SKU from the same
            #     product family.
            # * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
            # Google Channel support for further troubleshooting.
            # * NOT_FOUND: The customer or offer resource was not found.
            # * ALREADY_EXISTS:
            #     * The SKU was already purchased for the customer.
            #     * The customer's primary email already exists. Retry
            #     after changing the customer's primary contact email.
            # * CONDITION_NOT_MET or FAILED_PRECONDITION:
            #     * The domain required for purchasing a SKU has not been verified.
            #     * A pre-requisite SKU required to purchase an Add-On SKU is missing.
            #     For example, Google Workspace Business Starter is required to purchase
            #     Vault or Drive.
            #     * (Developer accounts only) Reseller and resold domain must meet the
            #     following naming requirements:
            #         * Domain names must start with goog-test.
            #         * Domain names must include the reseller domain.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :CreateEntitlement, ::Google::Cloud::Channel::V1::CreateEntitlementRequest, ::Google::Longrunning::Operation
            # Change parameters of the entitlement.
            #
            # An entitlement update is a long-running operation and it updates the
            # entitlement as a result of fulfillment.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # For example, the number of seats being changed is greater than the allowed
            # number of max seats, or decreasing seats for a commitment based plan.
            # * NOT_FOUND: Entitlement resource not found.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :ChangeParameters, ::Google::Cloud::Channel::V1::ChangeParametersRequest, ::Google::Longrunning::Operation
            # Updates the renewal settings for an existing customer entitlement.
            #
            # An entitlement update is a long-running operation and it updates the
            # entitlement as a result of fulfillment.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: Entitlement resource not found.
            # * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
            # commitment plan. Can't enable or disable renewals for non-commitment plans.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            #   Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :ChangeRenewalSettings, ::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest, ::Google::Longrunning::Operation
            # Updates the Offer for an existing customer entitlement.
            #
            # An entitlement update is a long-running operation and it updates the
            # entitlement as a result of fulfillment.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: Offer or Entitlement resource not found.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :ChangeOffer, ::Google::Cloud::Channel::V1::ChangeOfferRequest, ::Google::Longrunning::Operation
            # Starts paid service for a trial entitlement.
            #
            # Starts paid service for a trial entitlement immediately. This method is
            # only applicable if a plan is set up for a trial entitlement but has some
            # trial days remaining.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: Entitlement resource not found.
            # * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
            # entitlement on trial plans.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :StartPaidService, ::Google::Cloud::Channel::V1::StartPaidServiceRequest, ::Google::Longrunning::Operation
            # Suspends a previously fulfilled entitlement.
            #
            # An entitlement suspension is a long-running operation.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: Entitlement resource not found.
            # * NOT_ACTIVE: Entitlement is not active.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :SuspendEntitlement, ::Google::Cloud::Channel::V1::SuspendEntitlementRequest, ::Google::Longrunning::Operation
            # Cancels a previously fulfilled entitlement.
            #
            # An entitlement cancellation is a long-running operation.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * FAILED_PRECONDITION: There are Google Cloud projects linked to the
            # Google Cloud entitlement's Cloud Billing subaccount.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: Entitlement resource not found.
            # * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
            # add-ons, or entitlements for Google Cloud's development platform.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The response will contain
            # google.protobuf.Empty on success. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :CancelEntitlement, ::Google::Cloud::Channel::V1::CancelEntitlementRequest, ::Google::Longrunning::Operation
            # Activates a previously suspended entitlement. Entitlements suspended for
            # pending ToS acceptance can't be activated using this method.
            #
            # An entitlement activation is a long-running operation and it updates
            # the state of the customer entitlement.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: Entitlement resource not found.
            # * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
            # suspensions and entitlements that have accepted the TOS.
            # * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
            # state.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :ActivateEntitlement, ::Google::Cloud::Channel::V1::ActivateEntitlementRequest, ::Google::Longrunning::Operation
            # Transfers customer entitlements to new reseller.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED:
            #     * The customer doesn't belong to the reseller.
            #     * The reseller is not authorized to transact on this Product. See
            #     https://support.google.com/channelservices/answer/9759265
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: The customer or offer resource was not found.
            # * ALREADY_EXISTS: The SKU was already transferred for the customer.
            # * CONDITION_NOT_MET or FAILED_PRECONDITION:
            #     * The SKU requires domain verification to transfer, but the domain is
            #     not verified.
            #     * An Add-On SKU (example, Vault or Drive) is missing the
            #     pre-requisite SKU (example, G Suite Basic).
            #     * (Developer accounts only) Reseller and resold domain must meet the
            #     following naming requirements:
            #         * Domain names must start with goog-test.
            #         * Domain names must include the reseller domain.
            #     * Specify all transferring entitlements.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :TransferEntitlements, ::Google::Cloud::Channel::V1::TransferEntitlementsRequest, ::Google::Longrunning::Operation
            # Transfers customer entitlements from their current reseller to Google.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: The customer or offer resource was not found.
            # * ALREADY_EXISTS: The SKU was already transferred for the customer.
            # * CONDITION_NOT_MET or FAILED_PRECONDITION:
            #     * The SKU requires domain verification to transfer, but the domain is
            #     not verified.
            #     * An Add-On SKU (example, Vault or Drive) is missing the
            #     pre-requisite SKU (example, G Suite Basic).
            #     * (Developer accounts only) Reseller and resold domain must meet the
            #     following naming requirements:
            #         * Domain names must start with goog-test.
            #         * Domain names must include the reseller domain.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The ID of a long-running operation.
            #
            # To get the results of the operation, call the GetOperation method of
            # CloudChannelOperationsService. The response will contain
            # google.protobuf.Empty on success. The Operation metadata will contain an
            # instance of [OperationMetadata][google.cloud.channel.v1.OperationMetadata].
            rpc :TransferEntitlementsToGoogle, ::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest, ::Google::Longrunning::Operation
            # List [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]s
            # belonging to a distributor. You must be a distributor to call this method.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            #
            # Return value:
            # The list of the distributor account's
            # [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resources.
            rpc :ListChannelPartnerLinks, ::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest, ::Google::Cloud::Channel::V1::ListChannelPartnerLinksResponse
            # Returns the requested
            # [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
            # You must be a distributor to call this method.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: ChannelPartnerLink resource not found because of an
            # invalid channel partner link name.
            #
            # Return value:
            # The [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
            # resource.
            rpc :GetChannelPartnerLink, ::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest, ::Google::Cloud::Channel::V1::ChannelPartnerLink
            # Initiates a channel partner link between a distributor and a reseller, or
            # between resellers in an n-tier reseller channel.
            # Invited partners need to follow the invite_link_uri provided in the
            # response to accept. After accepting the invitation, a link is set up
            # between the two parties.
            # You must be a distributor to call this method.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
            # exists.
            # * NOT_FOUND: No Cloud Identity customer exists for provided domain.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The new [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink]
            # resource.
            rpc :CreateChannelPartnerLink, ::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest, ::Google::Cloud::Channel::V1::ChannelPartnerLink
            # Updates a channel partner link. Distributors call this method to change a
            # link's status. For example, to suspend a partner link.
            # You must be a distributor to call this method.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request is different
            # from the reseller account in the API request.
            # * INVALID_ARGUMENT:
            #     * Required request parameters are missing or invalid.
            #     * Link state cannot change from invited to active or suspended.
            #     * Cannot send reseller_cloud_identity_id, invite_url, or name in update
            #     mask.
            # * NOT_FOUND: ChannelPartnerLink resource not found.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The updated
            # [ChannelPartnerLink][google.cloud.channel.v1.ChannelPartnerLink] resource.
            rpc :UpdateChannelPartnerLink, ::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest, ::Google::Cloud::Channel::V1::ChannelPartnerLink
            # Gets information about how a Reseller modifies their bill before sending
            # it to a Customer.
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * NOT_FOUND: The
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # was not found.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # resource, otherwise returns an error.
            rpc :GetCustomerRepricingConfig, ::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest, ::Google::Cloud::Channel::V1::CustomerRepricingConfig
            # Lists information about how a Reseller modifies their bill before sending
            # it to a Customer.
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * NOT_FOUND: The
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # specified does not exist or is not associated with the given account.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # resources. The data for each resource is displayed in the ascending order
            # of:
            #
            # * Customer ID
            # * [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement]
            # * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # * [CustomerRepricingConfig.update_time][google.cloud.channel.v1.CustomerRepricingConfig.update_time]
            #
            # If unsuccessful, returns an error.
            rpc :ListCustomerRepricingConfigs, ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest, ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsResponse
            # Creates a CustomerRepricingConfig. Call this method to set modifications
            # for a specific customer's bill. You can only create configs if the
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # is a future month. If needed, you can create a config for the current
            # month, with some restrictions.
            #
            # When creating a config for a future month, make sure there are no existing
            # configs for that
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
            #
            # The following restrictions are for creating configs in the current month.
            #
            # * This functionality is reserved for recovering from an erroneous config,
            # and should not be used for regular business cases.
            # * The new config will not modify exports used with other configs.
            # Changes to the config may be immediate, but may take up to 24 hours.
            # * There is a limit of ten configs for any
            # [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
            # for any
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
            # * The contained
            # [CustomerRepricingConfig.repricing_config][google.cloud.channel.v1.CustomerRepricingConfig.repricing_config]
            # value must be different from the value used in the current config for a
            # [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * INVALID_ARGUMENT: Missing or invalid required parameters in the
            # request. Also displays if the updated config is for the current month or
            # past months.
            # * NOT_FOUND: The
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # specified does not exist or is not associated with the given account.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the updated
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # resource, otherwise returns an error.
            rpc :CreateCustomerRepricingConfig, ::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest, ::Google::Cloud::Channel::V1::CustomerRepricingConfig
            # Updates a CustomerRepricingConfig. Call this method to set modifications
            # for a specific customer's bill. This method overwrites the existing
            # CustomerRepricingConfig.
            #
            # You can only update configs if the
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # is a future month. To make changes to configs for the current month, use
            # [CreateCustomerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateCustomerRepricingConfig],
            # taking note of its restrictions. You cannot update the
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
            #
            # When updating a config in the future:
            #
            # * This config must already exist.
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * INVALID_ARGUMENT: Missing or invalid required parameters in the
            # request. Also displays if the updated config is for the current month or
            # past months.
            # * NOT_FOUND: The
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # specified does not exist or is not associated with the given account.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the updated
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # resource, otherwise returns an error.
            rpc :UpdateCustomerRepricingConfig, ::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest, ::Google::Cloud::Channel::V1::CustomerRepricingConfig
            # Deletes the given
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # permanently. You can only delete configs if their
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # is set to a date after the current month.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The account making the request does not own
            # this customer.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * FAILED_PRECONDITION: The
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # is active or in the past.
            # * NOT_FOUND: No
            # [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
            # found for the name in the request.
            rpc :DeleteCustomerRepricingConfig, ::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest, ::Google::Protobuf::Empty
            # Gets information about how a Distributor modifies their bill before sending
            # it to a ChannelPartner.
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * NOT_FOUND: The
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # was not found.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # resource, otherwise returns an error.
            rpc :GetChannelPartnerRepricingConfig, ::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest, ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig
            # Lists information about how a Reseller modifies their bill before sending
            # it to a ChannelPartner.
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * NOT_FOUND: The
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # specified does not exist or is not associated with the given account.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # resources. The data for each resource is displayed in the ascending order
            # of:
            #
            # * Channel Partner ID
            # * [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # * [ChannelPartnerRepricingConfig.update_time][google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time]
            #
            # If unsuccessful, returns an error.
            rpc :ListChannelPartnerRepricingConfigs, ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest, ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsResponse
            # Creates a ChannelPartnerRepricingConfig. Call this method to set
            # modifications for a specific ChannelPartner's bill. You can only create
            # configs if the
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # is a future month. If needed, you can create a config for the current
            # month, with some restrictions.
            #
            # When creating a config for a future month, make sure there are no existing
            # configs for that
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
            #
            # The following restrictions are for creating configs in the current month.
            #
            # * This functionality is reserved for recovering from an erroneous config,
            # and should not be used for regular business cases.
            # * The new config will not modify exports used with other configs.
            # Changes to the config may be immediate, but may take up to 24 hours.
            # * There is a limit of ten configs for any ChannelPartner or
            # [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement],
            # for any
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
            # * The contained
            # [ChannelPartnerRepricingConfig.repricing_config][google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config]
            # value must be different from the value used in the current config for a
            # ChannelPartner.
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * INVALID_ARGUMENT: Missing or invalid required parameters in the
            # request. Also displays if the updated config is for the current month or
            # past months.
            # * NOT_FOUND: The
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # specified does not exist or is not associated with the given account.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the updated
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # resource, otherwise returns an error.
            rpc :CreateChannelPartnerRepricingConfig, ::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest, ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig
            # Updates a ChannelPartnerRepricingConfig. Call this method to set
            # modifications for a specific ChannelPartner's bill. This method overwrites
            # the existing CustomerRepricingConfig.
            #
            # You can only update configs if the
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # is a future month. To make changes to configs for the current month, use
            # [CreateChannelPartnerRepricingConfig][google.cloud.channel.v1.CloudChannelService.CreateChannelPartnerRepricingConfig],
            # taking note of its restrictions. You cannot update the
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month].
            #
            # When updating a config in the future:
            #
            # * This config must already exist.
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different.
            # * INVALID_ARGUMENT: Missing or invalid required parameters in the
            # request. Also displays if the updated config is for the current month or
            # past months.
            # * NOT_FOUND: The
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # specified does not exist or is not associated with the given account.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the updated
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # resource, otherwise returns an error.
            rpc :UpdateChannelPartnerRepricingConfig, ::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest, ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig
            # Deletes the given
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # permanently. You can only delete configs if their
            # [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
            # is set to a date after the current month.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The account making the request does not own
            # this customer.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * FAILED_PRECONDITION: The
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # is active or in the past.
            # * NOT_FOUND: No
            # [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
            # found for the name in the request.
            rpc :DeleteChannelPartnerRepricingConfig, ::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest, ::Google::Protobuf::Empty
            # Lists the Rebilling supported SKU groups the account is authorized to
            # sell.
            # Reference: https://cloud.google.com/skus/sku-groups
            #
            # Possible Error Codes:
            #
            # * PERMISSION_DENIED: If the account making the request and the account
            # being queried are different, or the account doesn't exist.
            # * INTERNAL: Any non-user error related to technical issues in the
            # backend. In this case, contact Cloud Channel support.
            #
            # Return Value:
            # If successful, the [SkuGroup][google.cloud.channel.v1.SkuGroup] resources.
            # The data for each resource is displayed in the alphabetical order of SKU
            # group display name.
            # The data for each resource is displayed in the ascending order of
            # [SkuGroup.display_name][google.cloud.channel.v1.SkuGroup.display_name]
            #
            # If unsuccessful, returns an error.
            rpc :ListSkuGroups, ::Google::Cloud::Channel::V1::ListSkuGroupsRequest, ::Google::Cloud::Channel::V1::ListSkuGroupsResponse
            # Lists the Billable SKUs in a given SKU group.
            #
            # Possible error codes:
            # PERMISSION_DENIED: If the account making the request and the account
            # being queried for are different, or the account doesn't exist.
            # INVALID_ARGUMENT: Missing or invalid required parameters in the
            # request.
            # INTERNAL: Any non-user error related to technical issue in the
            # backend. In this case, contact cloud channel support.
            #
            # Return Value:
            # If successful, the [BillableSku][google.cloud.channel.v1.BillableSku]
            # resources. The data for each resource is displayed in the ascending order
            # of:
            #
            # * [BillableSku.service_display_name][google.cloud.channel.v1.BillableSku.service_display_name]
            # * [BillableSku.sku_display_name][google.cloud.channel.v1.BillableSku.sku_display_name]
            #
            # If unsuccessful, returns an error.
            rpc :ListSkuGroupBillableSkus, ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest, ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusResponse
            # Returns the requested [Offer][google.cloud.channel.v1.Offer] resource.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: Entitlement or offer was not found.
            #
            # Return value:
            # The [Offer][google.cloud.channel.v1.Offer] resource.
            rpc :LookupOffer, ::Google::Cloud::Channel::V1::LookupOfferRequest, ::Google::Cloud::Channel::V1::Offer
            # Lists the Products the reseller is authorized to sell.
            #
            # Possible error codes:
            #
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            rpc :ListProducts, ::Google::Cloud::Channel::V1::ListProductsRequest, ::Google::Cloud::Channel::V1::ListProductsResponse
            # Lists the SKUs for a product the reseller is authorized to sell.
            #
            # Possible error codes:
            #
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            rpc :ListSkus, ::Google::Cloud::Channel::V1::ListSkusRequest, ::Google::Cloud::Channel::V1::ListSkusResponse
            # Lists the Offers the reseller can sell.
            #
            # Possible error codes:
            #
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            rpc :ListOffers, ::Google::Cloud::Channel::V1::ListOffersRequest, ::Google::Cloud::Channel::V1::ListOffersResponse
            # Lists the following:
            #
            # * SKUs that you can purchase for a customer
            # * SKUs that you can upgrade or downgrade for an entitlement.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            rpc :ListPurchasableSkus, ::Google::Cloud::Channel::V1::ListPurchasableSkusRequest, ::Google::Cloud::Channel::V1::ListPurchasableSkusResponse
            # Lists the following:
            #
            # * Offers that you can purchase for a customer.
            # * Offers that you can change for an entitlement.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED:
            #     * The customer doesn't belong to the reseller
            #     * The reseller is not authorized to transact on this Product. See
            #     https://support.google.com/channelservices/answer/9759265
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            rpc :ListPurchasableOffers, ::Google::Cloud::Channel::V1::ListPurchasableOffersRequest, ::Google::Cloud::Channel::V1::ListPurchasableOffersResponse
            # Lists the billing accounts that are eligible to purchase particular SKUs
            # for a given customer.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            #
            # Return value:
            # Based on the provided list of SKUs, returns a list of SKU groups that must
            # be purchased using the same billing account and the billing accounts
            # eligible to purchase each SKU group.
            rpc :QueryEligibleBillingAccounts, ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest, ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsResponse
            # Registers a service account with subscriber privileges on the Cloud Pub/Sub
            # topic for this Channel Services account. After you create a
            # subscriber, you get the events through
            # [SubscriberEvent][google.cloud.channel.v1.SubscriberEvent]
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request and the
            # provided reseller account are different, or the impersonated user
            # is not a super admin.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The topic name with the registered service email address.
            rpc :RegisterSubscriber, ::Google::Cloud::Channel::V1::RegisterSubscriberRequest, ::Google::Cloud::Channel::V1::RegisterSubscriberResponse
            # Unregisters a service account with subscriber privileges on the Cloud
            # Pub/Sub topic created for this Channel Services account. If there are no
            # service accounts left with subscriber privileges, this deletes the topic.
            # You can call ListSubscribers to check for these accounts.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request and the
            # provided reseller account are different, or the impersonated user
            # is not a super admin.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: The topic resource doesn't exist.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # The topic name that unregistered the service email address.
            # Returns a success response if the service email address wasn't registered
            # with the topic.
            rpc :UnregisterSubscriber, ::Google::Cloud::Channel::V1::UnregisterSubscriberRequest, ::Google::Cloud::Channel::V1::UnregisterSubscriberResponse
            # Lists service accounts with subscriber privileges on the Cloud Pub/Sub
            # topic created for this Channel Services account.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request and the
            # provided reseller account are different, or the impersonated user
            # is not a super admin.
            # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
            # * NOT_FOUND: The topic resource doesn't exist.
            # * INTERNAL: Any non-user error related to a technical issue in the
            # backend. Contact Cloud Channel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # Contact Cloud Channel support.
            #
            # Return value:
            # A list of service email addresses.
            rpc :ListSubscribers, ::Google::Cloud::Channel::V1::ListSubscribersRequest, ::Google::Cloud::Channel::V1::ListSubscribersResponse
            # List entitlement history.
            #
            # Possible error codes:
            #
            # * PERMISSION_DENIED: The reseller account making the request and the
            # provided reseller account are different.
            # * INVALID_ARGUMENT: Missing or invalid required fields in the request.
            # * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
            # invalid name parameter.
            # * INTERNAL: Any non-user error related to a technical issue in the backend.
            # In this case, contact CloudChannel support.
            # * UNKNOWN: Any non-user error related to a technical issue in the backend.
            # In this case, contact Cloud Channel support.
            #
            # Return value:
            # List of [EntitlementChange][google.cloud.channel.v1.EntitlementChange]s.
            rpc :ListEntitlementChanges, ::Google::Cloud::Channel::V1::ListEntitlementChangesRequest, ::Google::Cloud::Channel::V1::ListEntitlementChangesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
