# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/channel/v1/service_pb"
require "google/cloud/channel/v1/cloud_channel_service/rest/service_stub"

module Google
  module Cloud
    module Channel
      module V1
        module CloudChannelService
          module Rest
            ##
            # REST client for the CloudChannelService service.
            #
            # CloudChannelService lets Google cloud resellers and distributors manage
            # their customers, channel partners, entitlements, and reports.
            #
            # Using this service:
            # 1. Resellers and distributors can manage a customer entity.
            # 2. Distributors can register an authorized reseller in their channel and
            #    provide them with delegated admin access.
            # 3. Resellers and distributors can manage customer entitlements.
            #
            # CloudChannelService exposes the following resources:
            # - {::Google::Cloud::Channel::V1::Customer Customer}s: An entity-usually an
            # enterprise-managed by a reseller or distributor.
            #
            # - {::Google::Cloud::Channel::V1::Entitlement Entitlement}s: An entity that
            # provides a customer with the means to use a service. Entitlements are created
            # or updated as a result of a successful fulfillment.
            #
            # - {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink}s: An
            # entity that identifies links between distributors and their indirect
            # resellers in a channel.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudchannel.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_channel_service_stub

              ##
              # Configure the CloudChannelService Client class.
              #
              # See {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudChannelService clients
              #   ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Channel", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.provision_cloud_identity.timeout = 60.0

                  default_config.rpcs.create_entitlement.timeout = 60.0

                  default_config.rpcs.change_parameters.timeout = 60.0

                  default_config.rpcs.change_renewal_settings.timeout = 60.0

                  default_config.rpcs.change_offer.timeout = 60.0

                  default_config.rpcs.start_paid_service.timeout = 60.0

                  default_config.rpcs.suspend_entitlement.timeout = 60.0

                  default_config.rpcs.cancel_entitlement.timeout = 60.0

                  default_config.rpcs.activate_entitlement.timeout = 60.0

                  default_config.rpcs.transfer_entitlements.timeout = 60.0

                  default_config.rpcs.transfer_entitlements_to_google.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudChannelService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_channel_service_stub.universe_domain
              end

              ##
              # Create a new CloudChannelService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudChannelService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @cloud_channel_service_stub = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_channel_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Channel::V1::CloudChannelService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_channel_service_stub.logger
              end

              # Service calls

              ##
              # List {::Google::Cloud::Channel::V1::Customer Customer}s.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # Return value:
              # List of {::Google::Cloud::Channel::V1::Customer Customer}s, or an empty list if
              # there are no customers.
              #
              # @overload list_customers(request, options = nil)
              #   Pass arguments to `list_customers` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListCustomersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListCustomersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_customers(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_customers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the reseller account to list customers from.
              #     Parent uses the format: accounts/\\{account_id}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of customers to return. The service may return
              #     fewer than this value. If unspecified, returns at most 10 customers. The
              #     maximum value is 50.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results other than the first page.
              #     Obtained through
              #     {::Google::Cloud::Channel::V1::ListCustomersResponse#next_page_token ListCustomersResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_customers CloudChannelService.ListCustomers}
              #     call.
              #   @param filter [::String]
              #     Optional. Filters applied to the [CloudChannelService.ListCustomers]
              #     results. See
              #     https://cloud.google.com/channel/docs/concepts/google-cloud/filter-customers
              #     for more information.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Customer>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Customer>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListCustomersRequest.new
              #
              #   # Call the list_customers method.
              #   result = client.list_customers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::Customer.
              #     p item
              #   end
              #
              def list_customers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListCustomersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_customers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_customers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_customers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_customers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_customers, "customers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the requested {::Google::Cloud::Channel::V1::Customer Customer}
              # resource.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: The customer resource doesn't exist. Usually the result of an
              # invalid name parameter.
              #
              # Return value:
              # The {::Google::Cloud::Channel::V1::Customer Customer} resource.
              #
              # @overload get_customer(request, options = nil)
              #   Pass arguments to `get_customer` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::GetCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::GetCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_customer(name: nil)
              #   Pass arguments to `get_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the customer to retrieve.
              #     Name uses the format: accounts/\\{account_id}/customers/\\{customer_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::Customer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::Customer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::GetCustomerRequest.new
              #
              #   # Call the get_customer method.
              #   result = client.get_customer request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::Customer.
              #   p result
              #
              def get_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::GetCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.get_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Confirms the existence of Cloud Identity accounts based on the domain and
              # if the Cloud Identity accounts are owned by the reseller.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * INVALID_VALUE: Invalid domain value in the request.
              #
              # Return value:
              # A list of
              # {::Google::Cloud::Channel::V1::CloudIdentityCustomerAccount CloudIdentityCustomerAccount}
              # resources for the domain (may be empty)
              #
              # Note: in the v1alpha1 version of the API, a NOT_FOUND error returns if
              # no
              # {::Google::Cloud::Channel::V1::CloudIdentityCustomerAccount CloudIdentityCustomerAccount}
              # resources match the domain.
              #
              # @overload check_cloud_identity_accounts_exist(request, options = nil)
              #   Pass arguments to `check_cloud_identity_accounts_exist` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload check_cloud_identity_accounts_exist(parent: nil, domain: nil, primary_admin_email: nil)
              #   Pass arguments to `check_cloud_identity_accounts_exist` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The reseller account's resource name.
              #     Parent uses the format: accounts/\\{account_id}
              #   @param domain [::String]
              #     Required. Domain to fetch for Cloud Identity account customers, including
              #     domain and team customers. For team customers, please use the domain for
              #     their emails.
              #   @param primary_admin_email [::String]
              #     Optional. Primary admin email to fetch for Cloud Identity account team
              #     customer.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest.new
              #
              #   # Call the check_cloud_identity_accounts_exist method.
              #   result = client.check_cloud_identity_accounts_exist request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistResponse.
              #   p result
              #
              def check_cloud_identity_accounts_exist request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::CheckCloudIdentityAccountsExistRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.check_cloud_identity_accounts_exist.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.check_cloud_identity_accounts_exist.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.check_cloud_identity_accounts_exist.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.check_cloud_identity_accounts_exist request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new {::Google::Cloud::Channel::V1::Customer Customer} resource under
              # the reseller or distributor account.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED:
              #     * The reseller account making the request is different from the
              #     reseller account in the API request.
              #     * You are not authorized to create a customer. See
              #     https://support.google.com/channelservices/answer/9759265
              # * INVALID_ARGUMENT:
              #     * Required request parameters are missing or invalid.
              #     * Domain field value doesn't match the primary email domain.
              #
              # Return value:
              # The newly created {::Google::Cloud::Channel::V1::Customer Customer} resource.
              #
              # @overload create_customer(request, options = nil)
              #   Pass arguments to `create_customer` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::CreateCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::CreateCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_customer(parent: nil, customer: nil)
              #   Pass arguments to `create_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of reseller account in which to create the
              #     customer. Parent uses the format: accounts/\\{account_id}
              #   @param customer [::Google::Cloud::Channel::V1::Customer, ::Hash]
              #     Required. The customer to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::Customer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::Customer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::CreateCustomerRequest.new
              #
              #   # Call the create_customer method.
              #   result = client.create_customer request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::Customer.
              #   p result
              #
              def create_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::CreateCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.create_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an existing {::Google::Cloud::Channel::V1::Customer Customer} resource
              # for the reseller or distributor.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: No {::Google::Cloud::Channel::V1::Customer Customer} resource found
              # for the name in the request.
              #
              # Return value:
              # The updated {::Google::Cloud::Channel::V1::Customer Customer} resource.
              #
              # @overload update_customer(request, options = nil)
              #   Pass arguments to `update_customer` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::UpdateCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::UpdateCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_customer(customer: nil, update_mask: nil)
              #   Pass arguments to `update_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param customer [::Google::Cloud::Channel::V1::Customer, ::Hash]
              #     Required. New contents of the customer.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The update mask that applies to the resource.
              #     Optional.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::Customer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::Customer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::UpdateCustomerRequest.new
              #
              #   # Call the update_customer method.
              #   result = client.update_customer request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::Customer.
              #   p result
              #
              def update_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::UpdateCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.update_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the given {::Google::Cloud::Channel::V1::Customer Customer} permanently.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The account making the request does not own
              # this customer.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * FAILED_PRECONDITION: The customer has existing entitlements.
              # * NOT_FOUND: No {::Google::Cloud::Channel::V1::Customer Customer} resource found
              # for the name in the request.
              #
              # @overload delete_customer(request, options = nil)
              #   Pass arguments to `delete_customer` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::DeleteCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::DeleteCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_customer(name: nil)
              #   Pass arguments to `delete_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the customer to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::DeleteCustomerRequest.new
              #
              #   # Call the delete_customer method.
              #   result = client.delete_customer request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::DeleteCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.delete_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Imports a {::Google::Cloud::Channel::V1::Customer Customer} from the Cloud
              # Identity associated with the provided Cloud Identity ID or domain before a
              # TransferEntitlements call. If a linked Customer already exists and
              # overwrite_if_exists is true, it will update that Customer's data.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED:
              #     * The reseller account making the request is different from the
              #     reseller account in the API request.
              #     * You are not authorized to import the customer. See
              #     https://support.google.com/channelservices/answer/9759265
              # * NOT_FOUND: Cloud Identity doesn't exist or was deleted.
              # * INVALID_ARGUMENT: Required parameters are missing, or the auth_token is
              # expired or invalid.
              # * ALREADY_EXISTS: A customer already exists and has conflicting critical
              # fields. Requires an overwrite.
              #
              # Return value:
              # The {::Google::Cloud::Channel::V1::Customer Customer}.
              #
              # @overload import_customer(request, options = nil)
              #   Pass arguments to `import_customer` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ImportCustomerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ImportCustomerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_customer(domain: nil, cloud_identity_id: nil, primary_admin_email: nil, parent: nil, auth_token: nil, overwrite_if_exists: nil, channel_partner_id: nil, customer: nil)
              #   Pass arguments to `import_customer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param domain [::String]
              #     Required. Customer domain.
              #
              #     Note: The following parameters are mutually exclusive: `domain`, `cloud_identity_id`, `primary_admin_email`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param cloud_identity_id [::String]
              #     Required. Customer's Cloud Identity ID
              #
              #     Note: The following parameters are mutually exclusive: `cloud_identity_id`, `domain`, `primary_admin_email`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param primary_admin_email [::String]
              #     Required. Customer's primary admin email.
              #
              #     Note: The following parameters are mutually exclusive: `primary_admin_email`, `domain`, `cloud_identity_id`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The resource name of the reseller's account.
              #     Parent takes the format: accounts/\\{account_id} or
              #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}
              #   @param auth_token [::String]
              #     Optional. The super admin of the resold customer generates this token to
              #     authorize a reseller to access their Cloud Identity and purchase
              #     entitlements on their behalf. You can omit this token after authorization.
              #     See https://support.google.com/a/answer/7643790 for more details.
              #   @param overwrite_if_exists [::Boolean]
              #     Required. Choose to overwrite an existing customer if found.
              #     This must be set to true if there is an existing customer with a
              #     conflicting region code or domain.
              #   @param channel_partner_id [::String]
              #     Optional. Cloud Identity ID of a channel partner who will be the direct
              #     reseller for the customer's order. This field is required for 2-tier
              #     transfer scenarios and can be provided via the request Parent binding as
              #     well.
              #   @param customer [::String]
              #     Optional. Specifies the customer that will receive imported Cloud Identity
              #     information.
              #     Format: accounts/\\{account_id}/customers/\\{customer_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::Customer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::Customer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ImportCustomerRequest.new
              #
              #   # Call the import_customer method.
              #   result = client.import_customer request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::Customer.
              #   p result
              #
              def import_customer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ImportCustomerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_customer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_customer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_customer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.import_customer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Cloud Identity for the given customer using the customer's
              # information, or the information provided here.
              #
              # Possible error codes:
              #
              # *  PERMISSION_DENIED:
              #      * The customer doesn't belong to the reseller.
              #      * You are not authorized to provision cloud identity id. See
              #      https://support.google.com/channelservices/answer/9759265
              # *  INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # *  NOT_FOUND: The customer was not found.
              # *  ALREADY_EXISTS: The customer's primary email already exists. Retry
              #    after changing the customer's primary contact email.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata contains an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload provision_cloud_identity(request, options = nil)
              #   Pass arguments to `provision_cloud_identity` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload provision_cloud_identity(customer: nil, cloud_identity_info: nil, user: nil, validate_only: nil)
              #   Pass arguments to `provision_cloud_identity` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param customer [::String]
              #     Required. Resource name of the customer.
              #     Format: accounts/\\{account_id}/customers/\\{customer_id}
              #   @param cloud_identity_info [::Google::Cloud::Channel::V1::CloudIdentityInfo, ::Hash]
              #     CloudIdentity-specific customer information.
              #   @param user [::Google::Cloud::Channel::V1::AdminUser, ::Hash]
              #     Admin user information.
              #   @param validate_only [::Boolean]
              #     Validate the request and preview the review, but do not post it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest.new
              #
              #   # Call the provision_cloud_identity method.
              #   result = client.provision_cloud_identity request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def provision_cloud_identity request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ProvisionCloudIdentityRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.provision_cloud_identity.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.provision_cloud_identity.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.provision_cloud_identity.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.provision_cloud_identity request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists {::Google::Cloud::Channel::V1::Entitlement Entitlement}s belonging to a
              # customer.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # Return value:
              # A list of the customer's
              # {::Google::Cloud::Channel::V1::Entitlement Entitlement}s.
              #
              # @overload list_entitlements(request, options = nil)
              #   Pass arguments to `list_entitlements` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListEntitlementsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListEntitlementsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_entitlements(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_entitlements` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the reseller's customer account to list
              #     entitlements for.
              #     Parent uses the format: accounts/\\{account_id}/customers/\\{customer_id}
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server might return fewer results than
              #     requested. If unspecified, return at most 50 entitlements. The maximum
              #     value is 100; the server will coerce values above 100.
              #   @param page_token [::String]
              #     Optional. A token for a page of results other than the first page.
              #     Obtained using
              #     {::Google::Cloud::Channel::V1::ListEntitlementsResponse#next_page_token ListEntitlementsResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_entitlements CloudChannelService.ListEntitlements}
              #     call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Entitlement>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Entitlement>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListEntitlementsRequest.new
              #
              #   # Call the list_entitlements method.
              #   result = client.list_entitlements request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::Entitlement.
              #     p item
              #   end
              #
              def list_entitlements request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListEntitlementsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_entitlements.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_entitlements.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_entitlements.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_entitlements request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_entitlements, "entitlements", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List {::Google::Cloud::Channel::V1::TransferableSku TransferableSku}s of a
              # customer based on the Cloud Identity ID or Customer Name in the request.
              #
              # Use this method to list the entitlements information of an
              # unowned customer. You should provide the customer's
              # Cloud Identity ID or Customer Name.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED:
              #     * The customer doesn't belong to the reseller and has no auth token.
              #     * The supplied auth token is invalid.
              #     * The reseller account making the request is different
              #     from the reseller account in the query.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # Return value:
              # A list of the customer's
              # {::Google::Cloud::Channel::V1::TransferableSku TransferableSku}.
              #
              # @overload list_transferable_skus(request, options = nil)
              #   Pass arguments to `list_transferable_skus` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListTransferableSkusRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListTransferableSkusRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_transferable_skus(cloud_identity_id: nil, customer_name: nil, parent: nil, page_size: nil, page_token: nil, auth_token: nil, language_code: nil)
              #   Pass arguments to `list_transferable_skus` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param cloud_identity_id [::String]
              #     Customer's Cloud Identity ID
              #
              #     Note: The following parameters are mutually exclusive: `cloud_identity_id`, `customer_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param customer_name [::String]
              #     A reseller is required to create a customer and use the resource name of
              #     the created customer here.
              #     Customer_name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}
              #
              #     Note: The following parameters are mutually exclusive: `customer_name`, `cloud_identity_id`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The reseller account's resource name.
              #     Parent uses the format: accounts/\\{account_id}
              #   @param page_size [::Integer]
              #     The requested page size. Server might return fewer results than requested.
              #     If unspecified, returns at most 100 SKUs.
              #     The maximum value is 1000; the server will coerce values above 1000.
              #     Optional.
              #   @param page_token [::String]
              #     A token for a page of results other than the first page.
              #     Obtained using
              #     {::Google::Cloud::Channel::V1::ListTransferableSkusResponse#next_page_token ListTransferableSkusResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_transferable_skus CloudChannelService.ListTransferableSkus}
              #     call. Optional.
              #   @param auth_token [::String]
              #     Optional. The super admin of the resold customer generates this token to
              #     authorize a reseller to access their Cloud Identity and purchase
              #     entitlements on their behalf. You can omit this token after authorization.
              #     See https://support.google.com/a/answer/7643790 for more details.
              #   @param language_code [::String]
              #     The BCP-47 language code. For example, "en-US". The
              #     response will localize in the corresponding language code, if specified.
              #     The default value is "en-US".
              #     Optional.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::TransferableSku>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::TransferableSku>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListTransferableSkusRequest.new
              #
              #   # Call the list_transferable_skus method.
              #   result = client.list_transferable_skus request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::TransferableSku.
              #     p item
              #   end
              #
              def list_transferable_skus request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListTransferableSkusRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_transferable_skus.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_transferable_skus.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_transferable_skus.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_transferable_skus request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_transferable_skus, "transferable_skus", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List {::Google::Cloud::Channel::V1::TransferableOffer TransferableOffer}s of a
              # customer based on Cloud Identity ID or Customer Name in the request.
              #
              # Use this method when a reseller gets the entitlement information of an
              # unowned customer. The reseller should provide the customer's
              # Cloud Identity ID or Customer Name.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED:
              #     * The customer doesn't belong to the reseller and has no auth token.
              #     * The customer provided incorrect reseller information when generating
              #     auth token.
              #     * The reseller account making the request is different
              #     from the reseller account in the query.
              #     * The reseller is not authorized to transact on this Product. See
              #     https://support.google.com/channelservices/answer/9759265
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # Return value:
              # List of {::Google::Cloud::Channel::V1::TransferableOffer TransferableOffer} for
              # the given customer and SKU.
              #
              # @overload list_transferable_offers(request, options = nil)
              #   Pass arguments to `list_transferable_offers` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListTransferableOffersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListTransferableOffersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_transferable_offers(cloud_identity_id: nil, customer_name: nil, parent: nil, page_size: nil, page_token: nil, sku: nil, language_code: nil, billing_account: nil)
              #   Pass arguments to `list_transferable_offers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param cloud_identity_id [::String]
              #     Customer's Cloud Identity ID
              #
              #     Note: The following parameters are mutually exclusive: `cloud_identity_id`, `customer_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param customer_name [::String]
              #     A reseller should create a customer and use the resource name of
              #     that customer here.
              #
              #     Note: The following parameters are mutually exclusive: `customer_name`, `cloud_identity_id`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The resource name of the reseller's account.
              #   @param page_size [::Integer]
              #     Requested page size. Server might return fewer results than requested.
              #     If unspecified, returns at most 100 offers.
              #     The maximum value is 1000; the server will coerce values above 1000.
              #   @param page_token [::String]
              #     A token for a page of results other than the first page.
              #     Obtained using
              #     {::Google::Cloud::Channel::V1::ListTransferableOffersResponse#next_page_token ListTransferableOffersResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_transferable_offers CloudChannelService.ListTransferableOffers}
              #     call.
              #   @param sku [::String]
              #     Required. The SKU to look up Offers for.
              #   @param language_code [::String]
              #     Optional. The BCP-47 language code. For example, "en-US". The
              #     response will localize in the corresponding language code, if specified.
              #     The default value is "en-US".
              #   @param billing_account [::String]
              #     Optional. The Billing Account to look up Offers for. Format:
              #     accounts/\\{account_id}/billingAccounts/\\{billing_account_id}.
              #
              #     This field is only relevant for multi-currency accounts. It should be left
              #     empty for single currency accounts.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::TransferableOffer>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::TransferableOffer>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListTransferableOffersRequest.new
              #
              #   # Call the list_transferable_offers method.
              #   result = client.list_transferable_offers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::TransferableOffer.
              #     p item
              #   end
              #
              def list_transferable_offers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListTransferableOffersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_transferable_offers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_transferable_offers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_transferable_offers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_transferable_offers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_transferable_offers, "transferable_offers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the requested {::Google::Cloud::Channel::V1::Entitlement Entitlement}
              # resource.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: The customer entitlement was not found.
              #
              # Return value:
              # The requested {::Google::Cloud::Channel::V1::Entitlement Entitlement} resource.
              #
              # @overload get_entitlement(request, options = nil)
              #   Pass arguments to `get_entitlement` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::GetEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::GetEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_entitlement(name: nil)
              #   Pass arguments to `get_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the entitlement to retrieve.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::Entitlement]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::Entitlement]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::GetEntitlementRequest.new
              #
              #   # Call the get_entitlement method.
              #   result = client.get_entitlement request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::Entitlement.
              #   p result
              #
              def get_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::GetEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.get_entitlement request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an entitlement for a customer.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED:
              #     * The customer doesn't belong to the reseller.
              #     * The reseller is not authorized to transact on this Product. See
              #     https://support.google.com/channelservices/answer/9759265
              # * INVALID_ARGUMENT:
              #     * Required request parameters are missing or invalid.
              #     * There is already a customer entitlement for a SKU from the same
              #     product family.
              # * INVALID_VALUE: Make sure the OfferId is valid. If it is, contact
              # Google Channel support for further troubleshooting.
              # * NOT_FOUND: The customer or offer resource was not found.
              # * ALREADY_EXISTS:
              #     * The SKU was already purchased for the customer.
              #     * The customer's primary email already exists. Retry
              #     after changing the customer's primary contact email.
              # * CONDITION_NOT_MET or FAILED_PRECONDITION:
              #     * The domain required for purchasing a SKU has not been verified.
              #     * A pre-requisite SKU required to purchase an Add-On SKU is missing.
              #     For example, Google Workspace Business Starter is required to purchase
              #     Vault or Drive.
              #     * (Developer accounts only) Reseller and resold domain must meet the
              #     following naming requirements:
              #         * Domain names must start with goog-test.
              #         * Domain names must include the reseller domain.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload create_entitlement(request, options = nil)
              #   Pass arguments to `create_entitlement` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::CreateEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::CreateEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_entitlement(parent: nil, entitlement: nil, request_id: nil)
              #   Pass arguments to `create_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the reseller's customer account in which to
              #     create the entitlement. Parent uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}
              #   @param entitlement [::Google::Cloud::Channel::V1::Entitlement, ::Hash]
              #     Required. The entitlement to create.
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::CreateEntitlementRequest.new
              #
              #   # Call the create_entitlement method.
              #   result = client.create_entitlement request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::CreateEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.create_entitlement request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Change parameters of the entitlement.
              #
              # An entitlement update is a long-running operation and it updates the
              # entitlement as a result of fulfillment.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # For example, the number of seats being changed is greater than the allowed
              # number of max seats, or decreasing seats for a commitment based plan.
              # * NOT_FOUND: Entitlement resource not found.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload change_parameters(request, options = nil)
              #   Pass arguments to `change_parameters` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ChangeParametersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ChangeParametersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload change_parameters(name: nil, parameters: nil, request_id: nil, purchase_order_id: nil)
              #   Pass arguments to `change_parameters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entitlement to update.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #   @param parameters [::Array<::Google::Cloud::Channel::V1::Parameter, ::Hash>]
              #     Required. Entitlement parameters to update. You can only change editable
              #     parameters.
              #
              #     To view the available Parameters for a request, refer to the
              #     {::Google::Cloud::Channel::V1::Offer#parameter_definitions Offer.parameter_definitions}
              #     from the desired offer.
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              #   @param purchase_order_id [::String]
              #     Optional. Purchase order ID provided by the reseller.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ChangeParametersRequest.new
              #
              #   # Call the change_parameters method.
              #   result = client.change_parameters request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def change_parameters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ChangeParametersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.change_parameters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.change_parameters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.change_parameters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.change_parameters request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the renewal settings for an existing customer entitlement.
              #
              # An entitlement update is a long-running operation and it updates the
              # entitlement as a result of fulfillment.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: Entitlement resource not found.
              # * NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
              # commitment plan. Can't enable or disable renewals for non-commitment plans.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              #   Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload change_renewal_settings(request, options = nil)
              #   Pass arguments to `change_renewal_settings` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload change_renewal_settings(name: nil, renewal_settings: nil, request_id: nil)
              #   Pass arguments to `change_renewal_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entitlement to update.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #   @param renewal_settings [::Google::Cloud::Channel::V1::RenewalSettings, ::Hash]
              #     Required. New renewal settings.
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest.new
              #
              #   # Call the change_renewal_settings method.
              #   result = client.change_renewal_settings request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def change_renewal_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ChangeRenewalSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.change_renewal_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.change_renewal_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.change_renewal_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.change_renewal_settings request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Offer for an existing customer entitlement.
              #
              # An entitlement update is a long-running operation and it updates the
              # entitlement as a result of fulfillment.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: Offer or Entitlement resource not found.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload change_offer(request, options = nil)
              #   Pass arguments to `change_offer` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ChangeOfferRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ChangeOfferRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload change_offer(name: nil, offer: nil, parameters: nil, purchase_order_id: nil, request_id: nil, billing_account: nil)
              #   Pass arguments to `change_offer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the entitlement to update.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #   @param offer [::String]
              #     Required. New Offer.
              #     Format: accounts/\\{account_id}/offers/\\{offer_id}.
              #   @param parameters [::Array<::Google::Cloud::Channel::V1::Parameter, ::Hash>]
              #     Optional. Parameters needed to purchase the Offer. To view the available
              #     Parameters refer to the
              #     {::Google::Cloud::Channel::V1::Offer#parameter_definitions Offer.parameter_definitions}
              #     from the desired offer.
              #   @param purchase_order_id [::String]
              #     Optional. Purchase order id provided by the reseller.
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              #   @param billing_account [::String]
              #     Optional. The billing account resource name that is used to pay for this
              #     entitlement when setting up billing on a trial subscription.
              #
              #     This field is only relevant for multi-currency accounts. It should be
              #     left empty for single currency accounts.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ChangeOfferRequest.new
              #
              #   # Call the change_offer method.
              #   result = client.change_offer request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def change_offer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ChangeOfferRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.change_offer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.change_offer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.change_offer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.change_offer request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts paid service for a trial entitlement.
              #
              # Starts paid service for a trial entitlement immediately. This method is
              # only applicable if a plan is set up for a trial entitlement but has some
              # trial days remaining.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: Entitlement resource not found.
              # * FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
              # entitlement on trial plans.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload start_paid_service(request, options = nil)
              #   Pass arguments to `start_paid_service` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::StartPaidServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::StartPaidServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_paid_service(name: nil, request_id: nil)
              #   Pass arguments to `start_paid_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the entitlement to start a paid service for.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::StartPaidServiceRequest.new
              #
              #   # Call the start_paid_service method.
              #   result = client.start_paid_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_paid_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::StartPaidServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_paid_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_paid_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_paid_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.start_paid_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Suspends a previously fulfilled entitlement.
              #
              # An entitlement suspension is a long-running operation.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: Entitlement resource not found.
              # * NOT_ACTIVE: Entitlement is not active.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload suspend_entitlement(request, options = nil)
              #   Pass arguments to `suspend_entitlement` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::SuspendEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::SuspendEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload suspend_entitlement(name: nil, request_id: nil)
              #   Pass arguments to `suspend_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the entitlement to suspend.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::SuspendEntitlementRequest.new
              #
              #   # Call the suspend_entitlement method.
              #   result = client.suspend_entitlement request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def suspend_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::SuspendEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.suspend_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.suspend_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.suspend_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.suspend_entitlement request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancels a previously fulfilled entitlement.
              #
              # An entitlement cancellation is a long-running operation.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * FAILED_PRECONDITION: There are Google Cloud projects linked to the
              # Google Cloud entitlement's Cloud Billing subaccount.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: Entitlement resource not found.
              # * DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
              # add-ons, or entitlements for Google Cloud's development platform.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The response will contain
              # google.protobuf.Empty on success. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload cancel_entitlement(request, options = nil)
              #   Pass arguments to `cancel_entitlement` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::CancelEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::CancelEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_entitlement(name: nil, request_id: nil)
              #   Pass arguments to `cancel_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the entitlement to cancel.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::CancelEntitlementRequest.new
              #
              #   # Call the cancel_entitlement method.
              #   result = client.cancel_entitlement request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def cancel_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::CancelEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.cancel_entitlement request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Activates a previously suspended entitlement. Entitlements suspended for
              # pending ToS acceptance can't be activated using this method.
              #
              # An entitlement activation is a long-running operation and it updates
              # the state of the customer entitlement.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: Entitlement resource not found.
              # * SUSPENSION_NOT_RESELLER_INITIATED: Can only activate reseller-initiated
              # suspensions and entitlements that have accepted the TOS.
              # * NOT_SUSPENDED: Can only activate suspended entitlements not in an ACTIVE
              # state.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload activate_entitlement(request, options = nil)
              #   Pass arguments to `activate_entitlement` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ActivateEntitlementRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ActivateEntitlementRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload activate_entitlement(name: nil, request_id: nil)
              #   Pass arguments to `activate_entitlement` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the entitlement to activate.
              #     Name uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ActivateEntitlementRequest.new
              #
              #   # Call the activate_entitlement method.
              #   result = client.activate_entitlement request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def activate_entitlement request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ActivateEntitlementRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.activate_entitlement.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.activate_entitlement.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.activate_entitlement.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.activate_entitlement request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Transfers customer entitlements to new reseller.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED:
              #     * The customer doesn't belong to the reseller.
              #     * The reseller is not authorized to transact on this Product. See
              #     https://support.google.com/channelservices/answer/9759265
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: The customer or offer resource was not found.
              # * ALREADY_EXISTS: The SKU was already transferred for the customer.
              # * CONDITION_NOT_MET or FAILED_PRECONDITION:
              #     * The SKU requires domain verification to transfer, but the domain is
              #     not verified.
              #     * An Add-On SKU (example, Vault or Drive) is missing the
              #     pre-requisite SKU (example, G Suite Basic).
              #     * (Developer accounts only) Reseller and resold domain must meet the
              #     following naming requirements:
              #         * Domain names must start with goog-test.
              #         * Domain names must include the reseller domain.
              #     * Specify all transferring entitlements.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload transfer_entitlements(request, options = nil)
              #   Pass arguments to `transfer_entitlements` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::TransferEntitlementsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::TransferEntitlementsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload transfer_entitlements(parent: nil, entitlements: nil, auth_token: nil, request_id: nil)
              #   Pass arguments to `transfer_entitlements` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the reseller's customer account that will
              #     receive transferred entitlements. Parent uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}
              #   @param entitlements [::Array<::Google::Cloud::Channel::V1::Entitlement, ::Hash>]
              #     Required. The new entitlements to create or transfer.
              #   @param auth_token [::String]
              #     The super admin of the resold customer generates this token to
              #     authorize a reseller to access their Cloud Identity and purchase
              #     entitlements on their behalf. You can omit this token after authorization.
              #     See https://support.google.com/a/answer/7643790 for more details.
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::TransferEntitlementsRequest.new
              #
              #   # Call the transfer_entitlements method.
              #   result = client.transfer_entitlements request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def transfer_entitlements request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::TransferEntitlementsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.transfer_entitlements.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.transfer_entitlements.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.transfer_entitlements.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.transfer_entitlements request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Transfers customer entitlements from their current reseller to Google.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: The customer or offer resource was not found.
              # * ALREADY_EXISTS: The SKU was already transferred for the customer.
              # * CONDITION_NOT_MET or FAILED_PRECONDITION:
              #     * The SKU requires domain verification to transfer, but the domain is
              #     not verified.
              #     * An Add-On SKU (example, Vault or Drive) is missing the
              #     pre-requisite SKU (example, G Suite Basic).
              #     * (Developer accounts only) Reseller and resold domain must meet the
              #     following naming requirements:
              #         * Domain names must start with goog-test.
              #         * Domain names must include the reseller domain.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The ID of a long-running operation.
              #
              # To get the results of the operation, call the GetOperation method of
              # CloudChannelOperationsService. The response will contain
              # google.protobuf.Empty on success. The Operation metadata will contain an
              # instance of {::Google::Cloud::Channel::V1::OperationMetadata OperationMetadata}.
              #
              # @overload transfer_entitlements_to_google(request, options = nil)
              #   Pass arguments to `transfer_entitlements_to_google` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload transfer_entitlements_to_google(parent: nil, entitlements: nil, request_id: nil)
              #   Pass arguments to `transfer_entitlements_to_google` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the reseller's customer account where the
              #     entitlements transfer from. Parent uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}
              #   @param entitlements [::Array<::Google::Cloud::Channel::V1::Entitlement, ::Hash>]
              #     Required. The entitlements to transfer to Google.
              #   @param request_id [::String]
              #     Optional. You can specify an optional unique request ID, and if you need to
              #     retry your request, the server will know to ignore the request if it's
              #     complete.
              #
              #     For example, you make an initial request and the request times out. If you
              #     make the request again with the same request ID, the server can check if
              #     it received the original operation with the same request ID. If it did, it
              #     will ignore the second request.
              #
              #     The request ID must be a valid [UUID](https://tools.ietf.org/html/rfc4122)
              #     with the exception that zero UUID is not supported
              #     (`00000000-0000-0000-0000-000000000000`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest.new
              #
              #   # Call the transfer_entitlements_to_google method.
              #   result = client.transfer_entitlements_to_google request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def transfer_entitlements_to_google request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::TransferEntitlementsToGoogleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.transfer_entitlements_to_google.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.transfer_entitlements_to_google.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.transfer_entitlements_to_google.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.transfer_entitlements_to_google request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink}s
              # belonging to a distributor. You must be a distributor to call this method.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # Return value:
              # The list of the distributor account's
              # {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink} resources.
              #
              # @overload list_channel_partner_links(request, options = nil)
              #   Pass arguments to `list_channel_partner_links` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_channel_partner_links(parent: nil, page_size: nil, page_token: nil, view: nil)
              #   Pass arguments to `list_channel_partner_links` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the reseller account for listing channel
              #     partner links. Parent uses the format: accounts/\\{account_id}
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server might return fewer results than
              #     requested. If unspecified, server will pick a default size (25). The
              #     maximum value is 200; the server will coerce values above 200.
              #   @param page_token [::String]
              #     Optional. A token for a page of results other than the first page.
              #     Obtained using
              #     {::Google::Cloud::Channel::V1::ListChannelPartnerLinksResponse#next_page_token ListChannelPartnerLinksResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_channel_partner_links CloudChannelService.ListChannelPartnerLinks}
              #     call.
              #   @param view [::Google::Cloud::Channel::V1::ChannelPartnerLinkView]
              #     Optional. The level of granularity the ChannelPartnerLink will display.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::ChannelPartnerLink>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::ChannelPartnerLink>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest.new
              #
              #   # Call the list_channel_partner_links method.
              #   result = client.list_channel_partner_links request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::ChannelPartnerLink.
              #     p item
              #   end
              #
              def list_channel_partner_links request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListChannelPartnerLinksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_channel_partner_links.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_channel_partner_links.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_channel_partner_links.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_channel_partner_links request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_channel_partner_links, "channel_partner_links", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the requested
              # {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink} resource.
              # You must be a distributor to call this method.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: ChannelPartnerLink resource not found because of an
              # invalid channel partner link name.
              #
              # Return value:
              # The {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink}
              # resource.
              #
              # @overload get_channel_partner_link(request, options = nil)
              #   Pass arguments to `get_channel_partner_link` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_channel_partner_link(name: nil, view: nil)
              #   Pass arguments to `get_channel_partner_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the channel partner link to retrieve.
              #     Name uses the format: accounts/\\{account_id}/channelPartnerLinks/\\{id}
              #     where \\{id} is the Cloud Identity ID of the partner.
              #   @param view [::Google::Cloud::Channel::V1::ChannelPartnerLinkView]
              #     Optional. The level of granularity the ChannelPartnerLink will display.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::ChannelPartnerLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::ChannelPartnerLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest.new
              #
              #   # Call the get_channel_partner_link method.
              #   result = client.get_channel_partner_link request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::ChannelPartnerLink.
              #   p result
              #
              def get_channel_partner_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::GetChannelPartnerLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_channel_partner_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_channel_partner_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_channel_partner_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.get_channel_partner_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Initiates a channel partner link between a distributor and a reseller, or
              # between resellers in an n-tier reseller channel.
              # Invited partners need to follow the invite_link_uri provided in the
              # response to accept. After accepting the invitation, a link is set up
              # between the two parties.
              # You must be a distributor to call this method.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already
              # exists.
              # * NOT_FOUND: No Cloud Identity customer exists for provided domain.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The new {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink}
              # resource.
              #
              # @overload create_channel_partner_link(request, options = nil)
              #   Pass arguments to `create_channel_partner_link` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_channel_partner_link(parent: nil, channel_partner_link: nil)
              #   Pass arguments to `create_channel_partner_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Create a channel partner link for the provided reseller account's
              #     resource name.
              #     Parent uses the format: accounts/\\{account_id}
              #   @param channel_partner_link [::Google::Cloud::Channel::V1::ChannelPartnerLink, ::Hash]
              #     Required. The channel partner link to create.
              #     Either channel_partner_link.reseller_cloud_identity_id or domain can be
              #     used to create a link.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::ChannelPartnerLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::ChannelPartnerLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest.new
              #
              #   # Call the create_channel_partner_link method.
              #   result = client.create_channel_partner_link request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::ChannelPartnerLink.
              #   p result
              #
              def create_channel_partner_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::CreateChannelPartnerLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_channel_partner_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_channel_partner_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_channel_partner_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.create_channel_partner_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a channel partner link. Distributors call this method to change a
              # link's status. For example, to suspend a partner link.
              # You must be a distributor to call this method.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request is different
              # from the reseller account in the API request.
              # * INVALID_ARGUMENT:
              #     * Required request parameters are missing or invalid.
              #     * Link state cannot change from invited to active or suspended.
              #     * Cannot send reseller_cloud_identity_id, invite_url, or name in update
              #     mask.
              # * NOT_FOUND: ChannelPartnerLink resource not found.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The updated
              # {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink} resource.
              #
              # @overload update_channel_partner_link(request, options = nil)
              #   Pass arguments to `update_channel_partner_link` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_channel_partner_link(name: nil, channel_partner_link: nil, update_mask: nil)
              #   Pass arguments to `update_channel_partner_link` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the channel partner link to cancel.
              #     Name uses the format: accounts/\\{account_id}/channelPartnerLinks/\\{id}
              #     where \\{id} is the Cloud Identity ID of the partner.
              #   @param channel_partner_link [::Google::Cloud::Channel::V1::ChannelPartnerLink, ::Hash]
              #     Required. The channel partner link to update. Only
              #     channel_partner_link.link_state is allowed for updates.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask that applies to the resource.
              #     The only allowable value for an update mask is
              #     channel_partner_link.link_state.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::ChannelPartnerLink]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::ChannelPartnerLink]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest.new
              #
              #   # Call the update_channel_partner_link method.
              #   result = client.update_channel_partner_link request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::ChannelPartnerLink.
              #   p result
              #
              def update_channel_partner_link request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::UpdateChannelPartnerLinkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_channel_partner_link.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_channel_partner_link.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_channel_partner_link.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.update_channel_partner_link request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about how a Reseller modifies their bill before sending
              # it to a Customer.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # was not found.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # resource, otherwise returns an error.
              #
              # @overload get_customer_repricing_config(request, options = nil)
              #   Pass arguments to `get_customer_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_customer_repricing_config(name: nil)
              #   Pass arguments to `get_customer_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the CustomerRepricingConfig.
              #     Format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/customerRepricingConfigs/\\{id}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest.new
              #
              #   # Call the get_customer_repricing_config method.
              #   result = client.get_customer_repricing_config request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::CustomerRepricingConfig.
              #   p result
              #
              def get_customer_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::GetCustomerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_customer_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_customer_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_customer_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.get_customer_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists information about how a Reseller modifies their bill before sending
              # it to a Customer.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # specified does not exist or is not associated with the given account.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # resources. The data for each resource is displayed in the ascending order
              # of:
              #
              # * Customer ID
              # * {::Google::Cloud::Channel::V1::RepricingConfig::EntitlementGranularity#entitlement RepricingConfig.EntitlementGranularity.entitlement}
              # * {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # * {::Google::Cloud::Channel::V1::CustomerRepricingConfig#update_time CustomerRepricingConfig.update_time}
              #
              # If unsuccessful, returns an error.
              #
              # @overload list_customer_repricing_configs(request, options = nil)
              #   Pass arguments to `list_customer_repricing_configs` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_customer_repricing_configs(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_customer_repricing_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the customer.
              #     Parent uses the format: accounts/\\{account_id}/customers/\\{customer_id}.
              #     Supports accounts/\\{account_id}/customers/- to retrieve configs for all
              #     customers.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of repricing configs to return. The service
              #     may return fewer than this value. If unspecified, returns a maximum of 50
              #     rules. The maximum value is 100; values above 100 will be coerced to 100.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results beyond the first page.
              #     Obtained through
              #     {::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsResponse#next_page_token ListCustomerRepricingConfigsResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_customer_repricing_configs CloudChannelService.ListCustomerRepricingConfigs}
              #     call.
              #   @param filter [::String]
              #     Optional. A filter for [CloudChannelService.ListCustomerRepricingConfigs]
              #     results (customer only). You can use this filter when you support
              #     a BatchGet-like query.
              #     To use the filter, you must set `parent=accounts/{account_id}/customers/-`.
              #
              #     Example: customer = accounts/account_id/customers/c1 OR
              #     customer = accounts/account_id/customers/c2.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::CustomerRepricingConfig>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::CustomerRepricingConfig>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest.new
              #
              #   # Call the list_customer_repricing_configs method.
              #   result = client.list_customer_repricing_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::CustomerRepricingConfig.
              #     p item
              #   end
              #
              def list_customer_repricing_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListCustomerRepricingConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_customer_repricing_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_customer_repricing_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_customer_repricing_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_customer_repricing_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_customer_repricing_configs, "customer_repricing_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a CustomerRepricingConfig. Call this method to set modifications
              # for a specific customer's bill. You can only create configs if the
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # is a future month. If needed, you can create a config for the current
              # month, with some restrictions.
              #
              # When creating a config for a future month, make sure there are no existing
              # configs for that
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}.
              #
              # The following restrictions are for creating configs in the current month.
              #
              # * This functionality is reserved for recovering from an erroneous config,
              # and should not be used for regular business cases.
              # * The new config will not modify exports used with other configs.
              # Changes to the config may be immediate, but may take up to 24 hours.
              # * There is a limit of ten configs for any
              # {::Google::Cloud::Channel::V1::RepricingConfig::EntitlementGranularity#entitlement RepricingConfig.EntitlementGranularity.entitlement},
              # for any
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}.
              # * The contained
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig#repricing_config CustomerRepricingConfig.repricing_config}
              # value must be different from the value used in the current config for a
              # {::Google::Cloud::Channel::V1::RepricingConfig::EntitlementGranularity#entitlement RepricingConfig.EntitlementGranularity.entitlement}.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * INVALID_ARGUMENT: Missing or invalid required parameters in the
              # request. Also displays if the updated config is for the current month or
              # past months.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # specified does not exist or is not associated with the given account.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the updated
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # resource, otherwise returns an error.
              #
              # @overload create_customer_repricing_config(request, options = nil)
              #   Pass arguments to `create_customer_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_customer_repricing_config(parent: nil, customer_repricing_config: nil)
              #   Pass arguments to `create_customer_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the customer that will receive this
              #     repricing config. Parent uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}
              #   @param customer_repricing_config [::Google::Cloud::Channel::V1::CustomerRepricingConfig, ::Hash]
              #     Required. The CustomerRepricingConfig object to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest.new
              #
              #   # Call the create_customer_repricing_config method.
              #   result = client.create_customer_repricing_config request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::CustomerRepricingConfig.
              #   p result
              #
              def create_customer_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::CreateCustomerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_customer_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_customer_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_customer_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.create_customer_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a CustomerRepricingConfig. Call this method to set modifications
              # for a specific customer's bill. This method overwrites the existing
              # CustomerRepricingConfig.
              #
              # You can only update configs if the
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # is a future month. To make changes to configs for the current month, use
              # {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#create_customer_repricing_config CreateCustomerRepricingConfig},
              # taking note of its restrictions. You cannot update the
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}.
              #
              # When updating a config in the future:
              #
              # * This config must already exist.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * INVALID_ARGUMENT: Missing or invalid required parameters in the
              # request. Also displays if the updated config is for the current month or
              # past months.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # specified does not exist or is not associated with the given account.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the updated
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # resource, otherwise returns an error.
              #
              # @overload update_customer_repricing_config(request, options = nil)
              #   Pass arguments to `update_customer_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_customer_repricing_config(customer_repricing_config: nil)
              #   Pass arguments to `update_customer_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param customer_repricing_config [::Google::Cloud::Channel::V1::CustomerRepricingConfig, ::Hash]
              #     Required. The CustomerRepricingConfig object to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::CustomerRepricingConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest.new
              #
              #   # Call the update_customer_repricing_config method.
              #   result = client.update_customer_repricing_config request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::CustomerRepricingConfig.
              #   p result
              #
              def update_customer_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::UpdateCustomerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_customer_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_customer_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_customer_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.update_customer_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the given
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # permanently. You can only delete configs if their
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # is set to a date after the current month.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The account making the request does not own
              # this customer.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * FAILED_PRECONDITION: The
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # is active or in the past.
              # * NOT_FOUND: No
              # {::Google::Cloud::Channel::V1::CustomerRepricingConfig CustomerRepricingConfig}
              # found for the name in the request.
              #
              # @overload delete_customer_repricing_config(request, options = nil)
              #   Pass arguments to `delete_customer_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_customer_repricing_config(name: nil)
              #   Pass arguments to `delete_customer_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the customer repricing config rule to
              #     delete. Format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/customerRepricingConfigs/\\{id}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest.new
              #
              #   # Call the delete_customer_repricing_config method.
              #   result = client.delete_customer_repricing_config request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_customer_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::DeleteCustomerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_customer_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_customer_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_customer_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.delete_customer_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets information about how a Distributor modifies their bill before sending
              # it to a ChannelPartner.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # was not found.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # resource, otherwise returns an error.
              #
              # @overload get_channel_partner_repricing_config(request, options = nil)
              #   Pass arguments to `get_channel_partner_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_channel_partner_repricing_config(name: nil)
              #   Pass arguments to `get_channel_partner_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the ChannelPartnerRepricingConfig
              #     Format:
              #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}/channelPartnerRepricingConfigs/\\{id}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest.new
              #
              #   # Call the get_channel_partner_repricing_config method.
              #   result = client.get_channel_partner_repricing_config request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.
              #   p result
              #
              def get_channel_partner_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::GetChannelPartnerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_channel_partner_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_channel_partner_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_channel_partner_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.get_channel_partner_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists information about how a Reseller modifies their bill before sending
              # it to a ChannelPartner.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # specified does not exist or is not associated with the given account.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # resources. The data for each resource is displayed in the ascending order
              # of:
              #
              # * Channel Partner ID
              # * {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # * {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig#update_time ChannelPartnerRepricingConfig.update_time}
              #
              # If unsuccessful, returns an error.
              #
              # @overload list_channel_partner_repricing_configs(request, options = nil)
              #   Pass arguments to `list_channel_partner_repricing_configs` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_channel_partner_repricing_configs(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_channel_partner_repricing_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the account's
              #     {::Google::Cloud::Channel::V1::ChannelPartnerLink ChannelPartnerLink}. Parent
              #     uses the format:
              #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}.
              #     Supports accounts/\\{account_id}/channelPartnerLinks/- to retrieve configs
              #     for all channel partners.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of repricing configs to return. The service
              #     may return fewer than this value. If unspecified, returns a maximum of 50
              #     rules. The maximum value is 100; values above 100 will be coerced to 100.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results beyond the first page.
              #     Obtained through
              #     {::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsResponse#next_page_token ListChannelPartnerRepricingConfigsResponse.next_page_token}
              #     of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_channel_partner_repricing_configs CloudChannelService.ListChannelPartnerRepricingConfigs}
              #     call.
              #   @param filter [::String]
              #     Optional. A filter for
              #     [CloudChannelService.ListChannelPartnerRepricingConfigs] results
              #     (channel_partner_link only). You can use this filter when you support a
              #     BatchGet-like query. To use the filter, you must set
              #     `parent=accounts/{account_id}/channelPartnerLinks/-`.
              #
              #     Example: `channel_partner_link =
              #     accounts/account_id/channelPartnerLinks/c1` OR `channel_partner_link =
              #     accounts/account_id/channelPartnerLinks/c2`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest.new
              #
              #   # Call the list_channel_partner_repricing_configs method.
              #   result = client.list_channel_partner_repricing_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.
              #     p item
              #   end
              #
              def list_channel_partner_repricing_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListChannelPartnerRepricingConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_channel_partner_repricing_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_channel_partner_repricing_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_channel_partner_repricing_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_channel_partner_repricing_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_channel_partner_repricing_configs, "channel_partner_repricing_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a ChannelPartnerRepricingConfig. Call this method to set
              # modifications for a specific ChannelPartner's bill. You can only create
              # configs if the
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # is a future month. If needed, you can create a config for the current
              # month, with some restrictions.
              #
              # When creating a config for a future month, make sure there are no existing
              # configs for that
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}.
              #
              # The following restrictions are for creating configs in the current month.
              #
              # * This functionality is reserved for recovering from an erroneous config,
              # and should not be used for regular business cases.
              # * The new config will not modify exports used with other configs.
              # Changes to the config may be immediate, but may take up to 24 hours.
              # * There is a limit of ten configs for any ChannelPartner or
              # {::Google::Cloud::Channel::V1::RepricingConfig::EntitlementGranularity#entitlement RepricingConfig.EntitlementGranularity.entitlement},
              # for any
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}.
              # * The contained
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig#repricing_config ChannelPartnerRepricingConfig.repricing_config}
              # value must be different from the value used in the current config for a
              # ChannelPartner.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * INVALID_ARGUMENT: Missing or invalid required parameters in the
              # request. Also displays if the updated config is for the current month or
              # past months.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # specified does not exist or is not associated with the given account.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the updated
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # resource, otherwise returns an error.
              #
              # @overload create_channel_partner_repricing_config(request, options = nil)
              #   Pass arguments to `create_channel_partner_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_channel_partner_repricing_config(parent: nil, channel_partner_repricing_config: nil)
              #   Pass arguments to `create_channel_partner_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the ChannelPartner that will receive the
              #     repricing config. Parent uses the format:
              #     accounts/\\{account_id}/channelPartnerLinks/\\{channel_partner_id}
              #   @param channel_partner_repricing_config [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig, ::Hash]
              #     Required. The ChannelPartnerRepricingConfig object to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest.new
              #
              #   # Call the create_channel_partner_repricing_config method.
              #   result = client.create_channel_partner_repricing_config request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.
              #   p result
              #
              def create_channel_partner_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::CreateChannelPartnerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_channel_partner_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_channel_partner_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_channel_partner_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.create_channel_partner_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a ChannelPartnerRepricingConfig. Call this method to set
              # modifications for a specific ChannelPartner's bill. This method overwrites
              # the existing CustomerRepricingConfig.
              #
              # You can only update configs if the
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # is a future month. To make changes to configs for the current month, use
              # {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#create_channel_partner_repricing_config CreateChannelPartnerRepricingConfig},
              # taking note of its restrictions. You cannot update the
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}.
              #
              # When updating a config in the future:
              #
              # * This config must already exist.
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different.
              # * INVALID_ARGUMENT: Missing or invalid required parameters in the
              # request. Also displays if the updated config is for the current month or
              # past months.
              # * NOT_FOUND: The
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # specified does not exist or is not associated with the given account.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the updated
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # resource, otherwise returns an error.
              #
              # @overload update_channel_partner_repricing_config(request, options = nil)
              #   Pass arguments to `update_channel_partner_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_channel_partner_repricing_config(channel_partner_repricing_config: nil)
              #   Pass arguments to `update_channel_partner_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param channel_partner_repricing_config [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig, ::Hash]
              #     Required. The ChannelPartnerRepricingConfig object to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest.new
              #
              #   # Call the update_channel_partner_repricing_config method.
              #   result = client.update_channel_partner_repricing_config request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig.
              #   p result
              #
              def update_channel_partner_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::UpdateChannelPartnerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_channel_partner_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_channel_partner_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_channel_partner_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.update_channel_partner_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the given
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # permanently. You can only delete configs if their
              # {::Google::Cloud::Channel::V1::RepricingConfig#effective_invoice_month RepricingConfig.effective_invoice_month}
              # is set to a date after the current month.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The account making the request does not own
              # this customer.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * FAILED_PRECONDITION: The
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # is active or in the past.
              # * NOT_FOUND: No
              # {::Google::Cloud::Channel::V1::ChannelPartnerRepricingConfig ChannelPartnerRepricingConfig}
              # found for the name in the request.
              #
              # @overload delete_channel_partner_repricing_config(request, options = nil)
              #   Pass arguments to `delete_channel_partner_repricing_config` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_channel_partner_repricing_config(name: nil)
              #   Pass arguments to `delete_channel_partner_repricing_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the channel partner repricing config rule to
              #     delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest.new
              #
              #   # Call the delete_channel_partner_repricing_config method.
              #   result = client.delete_channel_partner_repricing_config request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_channel_partner_repricing_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::DeleteChannelPartnerRepricingConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_channel_partner_repricing_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_channel_partner_repricing_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_channel_partner_repricing_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.delete_channel_partner_repricing_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Rebilling supported SKU groups the account is authorized to
              # sell.
              # Reference: https://cloud.google.com/skus/sku-groups
              #
              # Possible Error Codes:
              #
              # * PERMISSION_DENIED: If the account making the request and the account
              # being queried are different, or the account doesn't exist.
              # * INTERNAL: Any non-user error related to technical issues in the
              # backend. In this case, contact Cloud Channel support.
              #
              # Return Value:
              # If successful, the {::Google::Cloud::Channel::V1::SkuGroup SkuGroup} resources.
              # The data for each resource is displayed in the alphabetical order of SKU
              # group display name.
              # The data for each resource is displayed in the ascending order of
              # {::Google::Cloud::Channel::V1::SkuGroup#display_name SkuGroup.display_name}
              #
              # If unsuccessful, returns an error.
              #
              # @overload list_sku_groups(request, options = nil)
              #   Pass arguments to `list_sku_groups` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListSkuGroupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListSkuGroupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_sku_groups(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_sku_groups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the account from which to list SKU groups.
              #     Parent uses the format: accounts/\\{account}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of SKU groups to return. The service may
              #     return fewer than this value. If unspecified, returns a maximum of 1000 SKU
              #     groups. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results beyond the first page.
              #     Obtained through
              #     [ListSkuGroups.next_page_token][] of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_sku_groups CloudChannelService.ListSkuGroups}
              #     call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::SkuGroup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::SkuGroup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListSkuGroupsRequest.new
              #
              #   # Call the list_sku_groups method.
              #   result = client.list_sku_groups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::SkuGroup.
              #     p item
              #   end
              #
              def list_sku_groups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListSkuGroupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_sku_groups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_sku_groups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_sku_groups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_sku_groups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_sku_groups, "sku_groups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Billable SKUs in a given SKU group.
              #
              # Possible error codes:
              # PERMISSION_DENIED: If the account making the request and the account
              # being queried for are different, or the account doesn't exist.
              # INVALID_ARGUMENT: Missing or invalid required parameters in the
              # request.
              # INTERNAL: Any non-user error related to technical issue in the
              # backend. In this case, contact cloud channel support.
              #
              # Return Value:
              # If successful, the {::Google::Cloud::Channel::V1::BillableSku BillableSku}
              # resources. The data for each resource is displayed in the ascending order
              # of:
              #
              # * {::Google::Cloud::Channel::V1::BillableSku#service_display_name BillableSku.service_display_name}
              # * {::Google::Cloud::Channel::V1::BillableSku#sku_display_name BillableSku.sku_display_name}
              #
              # If unsuccessful, returns an error.
              #
              # @overload list_sku_group_billable_skus(request, options = nil)
              #   Pass arguments to `list_sku_group_billable_skus` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_sku_group_billable_skus(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_sku_group_billable_skus` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the SKU group.
              #     Format: accounts/\\{account}/skuGroups/\\{sku_group}.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of SKUs to return. The service may return
              #     fewer than this value. If unspecified, returns a maximum of 100000 SKUs.
              #     The maximum value is 100000; values above 100000 will be coerced to 100000.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results beyond the first page.
              #     Obtained through
              #     [ListSkuGroupBillableSkus.next_page_token][] of the previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_sku_group_billable_skus CloudChannelService.ListSkuGroupBillableSkus}
              #     call.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::BillableSku>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::BillableSku>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest.new
              #
              #   # Call the list_sku_group_billable_skus method.
              #   result = client.list_sku_group_billable_skus request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::BillableSku.
              #     p item
              #   end
              #
              def list_sku_group_billable_skus request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListSkuGroupBillableSkusRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_sku_group_billable_skus.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_sku_group_billable_skus.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_sku_group_billable_skus.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_sku_group_billable_skus request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_sku_group_billable_skus, "billable_skus", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the requested {::Google::Cloud::Channel::V1::Offer Offer} resource.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The entitlement doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: Entitlement or offer was not found.
              #
              # Return value:
              # The {::Google::Cloud::Channel::V1::Offer Offer} resource.
              #
              # @overload lookup_offer(request, options = nil)
              #   Pass arguments to `lookup_offer` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::LookupOfferRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::LookupOfferRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload lookup_offer(entitlement: nil)
              #   Pass arguments to `lookup_offer` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param entitlement [::String]
              #     Required. The resource name of the entitlement to retrieve the Offer.
              #     Entitlement uses the format:
              #     accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::Offer]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::Offer]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::LookupOfferRequest.new
              #
              #   # Call the lookup_offer method.
              #   result = client.lookup_offer request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::Offer.
              #   p result
              #
              def lookup_offer request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::LookupOfferRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.lookup_offer.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.lookup_offer.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.lookup_offer.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.lookup_offer request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Products the reseller is authorized to sell.
              #
              # Possible error codes:
              #
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # @overload list_products(request, options = nil)
              #   Pass arguments to `list_products` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListProductsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListProductsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_products(account: nil, page_size: nil, page_token: nil, language_code: nil)
              #   Pass arguments to `list_products` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param account [::String]
              #     Required. The resource name of the reseller account.
              #     Format: accounts/\\{account_id}.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server might return fewer results than
              #     requested. If unspecified, returns at most 100 Products. The maximum value
              #     is 1000; the server will coerce values above 1000.
              #   @param page_token [::String]
              #     Optional. A token for a page of results other than the first page.
              #   @param language_code [::String]
              #     Optional. The BCP-47 language code. For example, "en-US". The
              #     response will localize in the corresponding language code, if specified.
              #     The default value is "en-US".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Product>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Product>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListProductsRequest.new
              #
              #   # Call the list_products method.
              #   result = client.list_products request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::Product.
              #     p item
              #   end
              #
              def list_products request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListProductsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_products.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_products.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_products.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_products request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_products, "products", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the SKUs for a product the reseller is authorized to sell.
              #
              # Possible error codes:
              #
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # @overload list_skus(request, options = nil)
              #   Pass arguments to `list_skus` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListSkusRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListSkusRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_skus(parent: nil, account: nil, page_size: nil, page_token: nil, language_code: nil)
              #   Pass arguments to `list_skus` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the Product to list SKUs for.
              #     Parent uses the format: products/\\{product_id}.
              #     Supports products/- to retrieve SKUs for all products.
              #   @param account [::String]
              #     Required. Resource name of the reseller.
              #     Format: accounts/\\{account_id}.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server might return fewer results than
              #     requested. If unspecified, returns at most 100 SKUs. The maximum value is
              #     1000; the server will coerce values above 1000.
              #   @param page_token [::String]
              #     Optional. A token for a page of results other than the first page.
              #     Optional.
              #   @param language_code [::String]
              #     Optional. The BCP-47 language code. For example, "en-US". The
              #     response will localize in the corresponding language code, if specified.
              #     The default value is "en-US".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Sku>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Sku>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListSkusRequest.new
              #
              #   # Call the list_skus method.
              #   result = client.list_skus request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::Sku.
              #     p item
              #   end
              #
              def list_skus request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListSkusRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_skus.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_skus.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_skus.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_skus request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_skus, "skus", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the Offers the reseller can sell.
              #
              # Possible error codes:
              #
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # @overload list_offers(request, options = nil)
              #   Pass arguments to `list_offers` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListOffersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListOffersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_offers(parent: nil, page_size: nil, page_token: nil, filter: nil, language_code: nil, show_future_offers: nil)
              #   Pass arguments to `list_offers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the reseller account from which to list
              #     Offers. Parent uses the format: accounts/\\{account_id}.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server might return fewer results than
              #     requested. If unspecified, returns at most 500 Offers. The maximum value is
              #     1000; the server will coerce values above 1000.
              #   @param page_token [::String]
              #     Optional. A token for a page of results other than the first page.
              #   @param filter [::String]
              #     Optional. The expression to filter results by name (name of
              #     the Offer), sku.name (name of the SKU), or sku.product.name (name of the
              #     Product).
              #     Example 1: sku.product.name=products/p1 AND sku.name!=products/p1/skus/s1
              #     Example 2: name=accounts/a1/offers/o1
              #   @param language_code [::String]
              #     Optional. The BCP-47 language code. For example, "en-US". The
              #     response will localize in the corresponding language code, if specified.
              #     The default value is "en-US".
              #   @param show_future_offers [::Boolean]
              #     Optional. A boolean flag that determines if a response returns future
              #     offers 30 days from now. If the show_future_offers is true, the response
              #     will only contain offers that are scheduled to be available 30 days from
              #     now.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Offer>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::Offer>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListOffersRequest.new
              #
              #   # Call the list_offers method.
              #   result = client.list_offers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::Offer.
              #     p item
              #   end
              #
              def list_offers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListOffersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_offers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_offers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_offers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_offers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_offers, "offers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the following:
              #
              # * SKUs that you can purchase for a customer
              # * SKUs that you can upgrade or downgrade for an entitlement.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # @overload list_purchasable_skus(request, options = nil)
              #   Pass arguments to `list_purchasable_skus` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListPurchasableSkusRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListPurchasableSkusRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_purchasable_skus(create_entitlement_purchase: nil, change_offer_purchase: nil, customer: nil, page_size: nil, page_token: nil, language_code: nil)
              #   Pass arguments to `list_purchasable_skus` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param create_entitlement_purchase [::Google::Cloud::Channel::V1::ListPurchasableSkusRequest::CreateEntitlementPurchase, ::Hash]
              #     List SKUs for CreateEntitlement purchase.
              #
              #     Note: The following parameters are mutually exclusive: `create_entitlement_purchase`, `change_offer_purchase`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param change_offer_purchase [::Google::Cloud::Channel::V1::ListPurchasableSkusRequest::ChangeOfferPurchase, ::Hash]
              #     List SKUs for ChangeOffer purchase with a new SKU.
              #
              #     Note: The following parameters are mutually exclusive: `change_offer_purchase`, `create_entitlement_purchase`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param customer [::String]
              #     Required. The resource name of the customer to list SKUs for.
              #     Format: accounts/\\{account_id}/customers/\\{customer_id}.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server might return fewer results than
              #     requested. If unspecified, returns at most 100 SKUs. The maximum value is
              #     1000; the server will coerce values above 1000.
              #   @param page_token [::String]
              #     Optional. A token for a page of results other than the first page.
              #   @param language_code [::String]
              #     Optional. The BCP-47 language code. For example, "en-US". The
              #     response will localize in the corresponding language code, if specified.
              #     The default value is "en-US".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::PurchasableSku>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::PurchasableSku>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListPurchasableSkusRequest.new
              #
              #   # Call the list_purchasable_skus method.
              #   result = client.list_purchasable_skus request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::PurchasableSku.
              #     p item
              #   end
              #
              def list_purchasable_skus request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListPurchasableSkusRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_purchasable_skus.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_purchasable_skus.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_purchasable_skus.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_purchasable_skus request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_purchasable_skus, "purchasable_skus", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the following:
              #
              # * Offers that you can purchase for a customer.
              # * Offers that you can change for an entitlement.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED:
              #     * The customer doesn't belong to the reseller
              #     * The reseller is not authorized to transact on this Product. See
              #     https://support.google.com/channelservices/answer/9759265
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # @overload list_purchasable_offers(request, options = nil)
              #   Pass arguments to `list_purchasable_offers` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListPurchasableOffersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListPurchasableOffersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_purchasable_offers(create_entitlement_purchase: nil, change_offer_purchase: nil, customer: nil, page_size: nil, page_token: nil, language_code: nil)
              #   Pass arguments to `list_purchasable_offers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param create_entitlement_purchase [::Google::Cloud::Channel::V1::ListPurchasableOffersRequest::CreateEntitlementPurchase, ::Hash]
              #     List Offers for CreateEntitlement purchase.
              #
              #     Note: The following parameters are mutually exclusive: `create_entitlement_purchase`, `change_offer_purchase`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param change_offer_purchase [::Google::Cloud::Channel::V1::ListPurchasableOffersRequest::ChangeOfferPurchase, ::Hash]
              #     List Offers for ChangeOffer purchase.
              #
              #     Note: The following parameters are mutually exclusive: `change_offer_purchase`, `create_entitlement_purchase`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param customer [::String]
              #     Required. The resource name of the customer to list Offers for.
              #     Format: accounts/\\{account_id}/customers/\\{customer_id}.
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server might return fewer results than
              #     requested. If unspecified, returns at most 100 Offers. The maximum value is
              #     1000; the server will coerce values above 1000.
              #   @param page_token [::String]
              #     Optional. A token for a page of results other than the first page.
              #   @param language_code [::String]
              #     Optional. The BCP-47 language code. For example, "en-US". The
              #     response will localize in the corresponding language code, if specified.
              #     The default value is "en-US".
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::PurchasableOffer>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::PurchasableOffer>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListPurchasableOffersRequest.new
              #
              #   # Call the list_purchasable_offers method.
              #   result = client.list_purchasable_offers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::PurchasableOffer.
              #     p item
              #   end
              #
              def list_purchasable_offers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListPurchasableOffersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_purchasable_offers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_purchasable_offers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_purchasable_offers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_purchasable_offers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_purchasable_offers, "purchasable_offers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the billing accounts that are eligible to purchase particular SKUs
              # for a given customer.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The customer doesn't belong to the reseller.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              #
              # Return value:
              # Based on the provided list of SKUs, returns a list of SKU groups that must
              # be purchased using the same billing account and the billing accounts
              # eligible to purchase each SKU group.
              #
              # @overload query_eligible_billing_accounts(request, options = nil)
              #   Pass arguments to `query_eligible_billing_accounts` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload query_eligible_billing_accounts(customer: nil, skus: nil)
              #   Pass arguments to `query_eligible_billing_accounts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param customer [::String]
              #     Required. The resource name of the customer to list eligible billing
              #     accounts for. Format: accounts/\\{account_id}/customers/\\{customer_id}.
              #   @param skus [::Array<::String>]
              #     Required. List of SKUs to list eligible billing accounts for. At least one
              #     SKU is required. Format: products/\\{product_id}/skus/\\{sku_id}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest.new
              #
              #   # Call the query_eligible_billing_accounts method.
              #   result = client.query_eligible_billing_accounts request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::QueryEligibleBillingAccountsResponse.
              #   p result
              #
              def query_eligible_billing_accounts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::QueryEligibleBillingAccountsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.query_eligible_billing_accounts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.query_eligible_billing_accounts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.query_eligible_billing_accounts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.query_eligible_billing_accounts request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Registers a service account with subscriber privileges on the Cloud Pub/Sub
              # topic for this Channel Services account. After you create a
              # subscriber, you get the events through
              # {::Google::Cloud::Channel::V1::SubscriberEvent SubscriberEvent}
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request and the
              # provided reseller account are different, or the impersonated user
              # is not a super admin.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The topic name with the registered service email address.
              #
              # @overload register_subscriber(request, options = nil)
              #   Pass arguments to `register_subscriber` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::RegisterSubscriberRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::RegisterSubscriberRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload register_subscriber(account: nil, service_account: nil)
              #   Pass arguments to `register_subscriber` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param account [::String]
              #     Required. Resource name of the account.
              #   @param service_account [::String]
              #     Required. Service account that provides subscriber access to the registered
              #     topic.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::RegisterSubscriberResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::RegisterSubscriberResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::RegisterSubscriberRequest.new
              #
              #   # Call the register_subscriber method.
              #   result = client.register_subscriber request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::RegisterSubscriberResponse.
              #   p result
              #
              def register_subscriber request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::RegisterSubscriberRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.register_subscriber.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.register_subscriber.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.register_subscriber.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.register_subscriber request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Unregisters a service account with subscriber privileges on the Cloud
              # Pub/Sub topic created for this Channel Services account. If there are no
              # service accounts left with subscriber privileges, this deletes the topic.
              # You can call ListSubscribers to check for these accounts.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request and the
              # provided reseller account are different, or the impersonated user
              # is not a super admin.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: The topic resource doesn't exist.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # The topic name that unregistered the service email address.
              # Returns a success response if the service email address wasn't registered
              # with the topic.
              #
              # @overload unregister_subscriber(request, options = nil)
              #   Pass arguments to `unregister_subscriber` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::UnregisterSubscriberRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::UnregisterSubscriberRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload unregister_subscriber(account: nil, service_account: nil)
              #   Pass arguments to `unregister_subscriber` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param account [::String]
              #     Required. Resource name of the account.
              #   @param service_account [::String]
              #     Required. Service account to unregister from subscriber access to the
              #     topic.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::UnregisterSubscriberResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::UnregisterSubscriberResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::UnregisterSubscriberRequest.new
              #
              #   # Call the unregister_subscriber method.
              #   result = client.unregister_subscriber request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::UnregisterSubscriberResponse.
              #   p result
              #
              def unregister_subscriber request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::UnregisterSubscriberRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.unregister_subscriber.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.unregister_subscriber.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.unregister_subscriber.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.unregister_subscriber request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists service accounts with subscriber privileges on the Cloud Pub/Sub
              # topic created for this Channel Services account.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request and the
              # provided reseller account are different, or the impersonated user
              # is not a super admin.
              # * INVALID_ARGUMENT: Required request parameters are missing or invalid.
              # * NOT_FOUND: The topic resource doesn't exist.
              # * INTERNAL: Any non-user error related to a technical issue in the
              # backend. Contact Cloud Channel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # Contact Cloud Channel support.
              #
              # Return value:
              # A list of service email addresses.
              #
              # @overload list_subscribers(request, options = nil)
              #   Pass arguments to `list_subscribers` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListSubscribersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListSubscribersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_subscribers(account: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_subscribers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param account [::String]
              #     Required. Resource name of the account.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of service accounts to return. The service may
              #     return fewer than this value. If unspecified, returns at most 100 service
              #     accounts. The maximum value is 1000; the server will coerce values above
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListSubscribers` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListSubscribers` must
              #     match the call that provided the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Channel::V1::ListSubscribersResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Channel::V1::ListSubscribersResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListSubscribersRequest.new
              #
              #   # Call the list_subscribers method.
              #   result = client.list_subscribers request
              #
              #   # The returned object is of type Google::Cloud::Channel::V1::ListSubscribersResponse.
              #   p result
              #
              def list_subscribers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListSubscribersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_subscribers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_subscribers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_subscribers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_subscribers request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List entitlement history.
              #
              # Possible error codes:
              #
              # * PERMISSION_DENIED: The reseller account making the request and the
              # provided reseller account are different.
              # * INVALID_ARGUMENT: Missing or invalid required fields in the request.
              # * NOT_FOUND: The parent resource doesn't exist. Usually the result of an
              # invalid name parameter.
              # * INTERNAL: Any non-user error related to a technical issue in the backend.
              # In this case, contact CloudChannel support.
              # * UNKNOWN: Any non-user error related to a technical issue in the backend.
              # In this case, contact Cloud Channel support.
              #
              # Return value:
              # List of {::Google::Cloud::Channel::V1::EntitlementChange EntitlementChange}s.
              #
              # @overload list_entitlement_changes(request, options = nil)
              #   Pass arguments to `list_entitlement_changes` via a request object, either of type
              #   {::Google::Cloud::Channel::V1::ListEntitlementChangesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Channel::V1::ListEntitlementChangesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_entitlement_changes(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_entitlement_changes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the entitlement for which to list
              #     entitlement changes. The `-` wildcard may be used to match entitlements
              #     across a customer. Formats:
              #
              #       * accounts/\\{account_id}/customers/\\{customer_id}/entitlements/\\{entitlement_id}
              #       * accounts/\\{account_id}/customers/\\{customer_id}/entitlements/-
              #   @param page_size [::Integer]
              #     Optional. The maximum number of entitlement changes to return. The service
              #     may return fewer than this value. If unspecified, returns at most 10
              #     entitlement changes. The maximum value is 50; the server will coerce values
              #     above 50.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_entitlement_changes CloudChannelService.ListEntitlementChanges}
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client#list_entitlement_changes CloudChannelService.ListEntitlementChanges}
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filters applied to the list results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::EntitlementChange>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Channel::V1::EntitlementChange>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/channel/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Channel::V1::ListEntitlementChangesRequest.new
              #
              #   # Call the list_entitlement_changes method.
              #   result = client.list_entitlement_changes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Channel::V1::EntitlementChange.
              #     p item
              #   end
              #
              def list_entitlement_changes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Channel::V1::ListEntitlementChangesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_entitlement_changes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Channel::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_entitlement_changes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_entitlement_changes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_channel_service_stub.list_entitlement_changes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_channel_service_stub, :list_entitlement_changes, "entitlement_changes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudChannelService REST API.
              #
              # This class represents the configuration for CloudChannelService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_customers to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_customers.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Channel::V1::CloudChannelService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_customers.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudchannel.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudChannelService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_customers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_customers
                  ##
                  # RPC-specific configuration for `get_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_customer
                  ##
                  # RPC-specific configuration for `check_cloud_identity_accounts_exist`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :check_cloud_identity_accounts_exist
                  ##
                  # RPC-specific configuration for `create_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_customer
                  ##
                  # RPC-specific configuration for `update_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_customer
                  ##
                  # RPC-specific configuration for `delete_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_customer
                  ##
                  # RPC-specific configuration for `import_customer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_customer
                  ##
                  # RPC-specific configuration for `provision_cloud_identity`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :provision_cloud_identity
                  ##
                  # RPC-specific configuration for `list_entitlements`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_entitlements
                  ##
                  # RPC-specific configuration for `list_transferable_skus`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_transferable_skus
                  ##
                  # RPC-specific configuration for `list_transferable_offers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_transferable_offers
                  ##
                  # RPC-specific configuration for `get_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_entitlement
                  ##
                  # RPC-specific configuration for `create_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_entitlement
                  ##
                  # RPC-specific configuration for `change_parameters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :change_parameters
                  ##
                  # RPC-specific configuration for `change_renewal_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :change_renewal_settings
                  ##
                  # RPC-specific configuration for `change_offer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :change_offer
                  ##
                  # RPC-specific configuration for `start_paid_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_paid_service
                  ##
                  # RPC-specific configuration for `suspend_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :suspend_entitlement
                  ##
                  # RPC-specific configuration for `cancel_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_entitlement
                  ##
                  # RPC-specific configuration for `activate_entitlement`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :activate_entitlement
                  ##
                  # RPC-specific configuration for `transfer_entitlements`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :transfer_entitlements
                  ##
                  # RPC-specific configuration for `transfer_entitlements_to_google`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :transfer_entitlements_to_google
                  ##
                  # RPC-specific configuration for `list_channel_partner_links`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_channel_partner_links
                  ##
                  # RPC-specific configuration for `get_channel_partner_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_channel_partner_link
                  ##
                  # RPC-specific configuration for `create_channel_partner_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_channel_partner_link
                  ##
                  # RPC-specific configuration for `update_channel_partner_link`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_channel_partner_link
                  ##
                  # RPC-specific configuration for `get_customer_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_customer_repricing_config
                  ##
                  # RPC-specific configuration for `list_customer_repricing_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_customer_repricing_configs
                  ##
                  # RPC-specific configuration for `create_customer_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_customer_repricing_config
                  ##
                  # RPC-specific configuration for `update_customer_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_customer_repricing_config
                  ##
                  # RPC-specific configuration for `delete_customer_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_customer_repricing_config
                  ##
                  # RPC-specific configuration for `get_channel_partner_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_channel_partner_repricing_config
                  ##
                  # RPC-specific configuration for `list_channel_partner_repricing_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_channel_partner_repricing_configs
                  ##
                  # RPC-specific configuration for `create_channel_partner_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_channel_partner_repricing_config
                  ##
                  # RPC-specific configuration for `update_channel_partner_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_channel_partner_repricing_config
                  ##
                  # RPC-specific configuration for `delete_channel_partner_repricing_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_channel_partner_repricing_config
                  ##
                  # RPC-specific configuration for `list_sku_groups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_sku_groups
                  ##
                  # RPC-specific configuration for `list_sku_group_billable_skus`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_sku_group_billable_skus
                  ##
                  # RPC-specific configuration for `lookup_offer`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :lookup_offer
                  ##
                  # RPC-specific configuration for `list_products`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_products
                  ##
                  # RPC-specific configuration for `list_skus`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_skus
                  ##
                  # RPC-specific configuration for `list_offers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_offers
                  ##
                  # RPC-specific configuration for `list_purchasable_skus`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_purchasable_skus
                  ##
                  # RPC-specific configuration for `list_purchasable_offers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_purchasable_offers
                  ##
                  # RPC-specific configuration for `query_eligible_billing_accounts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :query_eligible_billing_accounts
                  ##
                  # RPC-specific configuration for `register_subscriber`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :register_subscriber
                  ##
                  # RPC-specific configuration for `unregister_subscriber`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :unregister_subscriber
                  ##
                  # RPC-specific configuration for `list_subscribers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_subscribers
                  ##
                  # RPC-specific configuration for `list_entitlement_changes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_entitlement_changes

                  # @private
                  def initialize parent_rpcs = nil
                    list_customers_config = parent_rpcs.list_customers if parent_rpcs.respond_to? :list_customers
                    @list_customers = ::Gapic::Config::Method.new list_customers_config
                    get_customer_config = parent_rpcs.get_customer if parent_rpcs.respond_to? :get_customer
                    @get_customer = ::Gapic::Config::Method.new get_customer_config
                    check_cloud_identity_accounts_exist_config = parent_rpcs.check_cloud_identity_accounts_exist if parent_rpcs.respond_to? :check_cloud_identity_accounts_exist
                    @check_cloud_identity_accounts_exist = ::Gapic::Config::Method.new check_cloud_identity_accounts_exist_config
                    create_customer_config = parent_rpcs.create_customer if parent_rpcs.respond_to? :create_customer
                    @create_customer = ::Gapic::Config::Method.new create_customer_config
                    update_customer_config = parent_rpcs.update_customer if parent_rpcs.respond_to? :update_customer
                    @update_customer = ::Gapic::Config::Method.new update_customer_config
                    delete_customer_config = parent_rpcs.delete_customer if parent_rpcs.respond_to? :delete_customer
                    @delete_customer = ::Gapic::Config::Method.new delete_customer_config
                    import_customer_config = parent_rpcs.import_customer if parent_rpcs.respond_to? :import_customer
                    @import_customer = ::Gapic::Config::Method.new import_customer_config
                    provision_cloud_identity_config = parent_rpcs.provision_cloud_identity if parent_rpcs.respond_to? :provision_cloud_identity
                    @provision_cloud_identity = ::Gapic::Config::Method.new provision_cloud_identity_config
                    list_entitlements_config = parent_rpcs.list_entitlements if parent_rpcs.respond_to? :list_entitlements
                    @list_entitlements = ::Gapic::Config::Method.new list_entitlements_config
                    list_transferable_skus_config = parent_rpcs.list_transferable_skus if parent_rpcs.respond_to? :list_transferable_skus
                    @list_transferable_skus = ::Gapic::Config::Method.new list_transferable_skus_config
                    list_transferable_offers_config = parent_rpcs.list_transferable_offers if parent_rpcs.respond_to? :list_transferable_offers
                    @list_transferable_offers = ::Gapic::Config::Method.new list_transferable_offers_config
                    get_entitlement_config = parent_rpcs.get_entitlement if parent_rpcs.respond_to? :get_entitlement
                    @get_entitlement = ::Gapic::Config::Method.new get_entitlement_config
                    create_entitlement_config = parent_rpcs.create_entitlement if parent_rpcs.respond_to? :create_entitlement
                    @create_entitlement = ::Gapic::Config::Method.new create_entitlement_config
                    change_parameters_config = parent_rpcs.change_parameters if parent_rpcs.respond_to? :change_parameters
                    @change_parameters = ::Gapic::Config::Method.new change_parameters_config
                    change_renewal_settings_config = parent_rpcs.change_renewal_settings if parent_rpcs.respond_to? :change_renewal_settings
                    @change_renewal_settings = ::Gapic::Config::Method.new change_renewal_settings_config
                    change_offer_config = parent_rpcs.change_offer if parent_rpcs.respond_to? :change_offer
                    @change_offer = ::Gapic::Config::Method.new change_offer_config
                    start_paid_service_config = parent_rpcs.start_paid_service if parent_rpcs.respond_to? :start_paid_service
                    @start_paid_service = ::Gapic::Config::Method.new start_paid_service_config
                    suspend_entitlement_config = parent_rpcs.suspend_entitlement if parent_rpcs.respond_to? :suspend_entitlement
                    @suspend_entitlement = ::Gapic::Config::Method.new suspend_entitlement_config
                    cancel_entitlement_config = parent_rpcs.cancel_entitlement if parent_rpcs.respond_to? :cancel_entitlement
                    @cancel_entitlement = ::Gapic::Config::Method.new cancel_entitlement_config
                    activate_entitlement_config = parent_rpcs.activate_entitlement if parent_rpcs.respond_to? :activate_entitlement
                    @activate_entitlement = ::Gapic::Config::Method.new activate_entitlement_config
                    transfer_entitlements_config = parent_rpcs.transfer_entitlements if parent_rpcs.respond_to? :transfer_entitlements
                    @transfer_entitlements = ::Gapic::Config::Method.new transfer_entitlements_config
                    transfer_entitlements_to_google_config = parent_rpcs.transfer_entitlements_to_google if parent_rpcs.respond_to? :transfer_entitlements_to_google
                    @transfer_entitlements_to_google = ::Gapic::Config::Method.new transfer_entitlements_to_google_config
                    list_channel_partner_links_config = parent_rpcs.list_channel_partner_links if parent_rpcs.respond_to? :list_channel_partner_links
                    @list_channel_partner_links = ::Gapic::Config::Method.new list_channel_partner_links_config
                    get_channel_partner_link_config = parent_rpcs.get_channel_partner_link if parent_rpcs.respond_to? :get_channel_partner_link
                    @get_channel_partner_link = ::Gapic::Config::Method.new get_channel_partner_link_config
                    create_channel_partner_link_config = parent_rpcs.create_channel_partner_link if parent_rpcs.respond_to? :create_channel_partner_link
                    @create_channel_partner_link = ::Gapic::Config::Method.new create_channel_partner_link_config
                    update_channel_partner_link_config = parent_rpcs.update_channel_partner_link if parent_rpcs.respond_to? :update_channel_partner_link
                    @update_channel_partner_link = ::Gapic::Config::Method.new update_channel_partner_link_config
                    get_customer_repricing_config_config = parent_rpcs.get_customer_repricing_config if parent_rpcs.respond_to? :get_customer_repricing_config
                    @get_customer_repricing_config = ::Gapic::Config::Method.new get_customer_repricing_config_config
                    list_customer_repricing_configs_config = parent_rpcs.list_customer_repricing_configs if parent_rpcs.respond_to? :list_customer_repricing_configs
                    @list_customer_repricing_configs = ::Gapic::Config::Method.new list_customer_repricing_configs_config
                    create_customer_repricing_config_config = parent_rpcs.create_customer_repricing_config if parent_rpcs.respond_to? :create_customer_repricing_config
                    @create_customer_repricing_config = ::Gapic::Config::Method.new create_customer_repricing_config_config
                    update_customer_repricing_config_config = parent_rpcs.update_customer_repricing_config if parent_rpcs.respond_to? :update_customer_repricing_config
                    @update_customer_repricing_config = ::Gapic::Config::Method.new update_customer_repricing_config_config
                    delete_customer_repricing_config_config = parent_rpcs.delete_customer_repricing_config if parent_rpcs.respond_to? :delete_customer_repricing_config
                    @delete_customer_repricing_config = ::Gapic::Config::Method.new delete_customer_repricing_config_config
                    get_channel_partner_repricing_config_config = parent_rpcs.get_channel_partner_repricing_config if parent_rpcs.respond_to? :get_channel_partner_repricing_config
                    @get_channel_partner_repricing_config = ::Gapic::Config::Method.new get_channel_partner_repricing_config_config
                    list_channel_partner_repricing_configs_config = parent_rpcs.list_channel_partner_repricing_configs if parent_rpcs.respond_to? :list_channel_partner_repricing_configs
                    @list_channel_partner_repricing_configs = ::Gapic::Config::Method.new list_channel_partner_repricing_configs_config
                    create_channel_partner_repricing_config_config = parent_rpcs.create_channel_partner_repricing_config if parent_rpcs.respond_to? :create_channel_partner_repricing_config
                    @create_channel_partner_repricing_config = ::Gapic::Config::Method.new create_channel_partner_repricing_config_config
                    update_channel_partner_repricing_config_config = parent_rpcs.update_channel_partner_repricing_config if parent_rpcs.respond_to? :update_channel_partner_repricing_config
                    @update_channel_partner_repricing_config = ::Gapic::Config::Method.new update_channel_partner_repricing_config_config
                    delete_channel_partner_repricing_config_config = parent_rpcs.delete_channel_partner_repricing_config if parent_rpcs.respond_to? :delete_channel_partner_repricing_config
                    @delete_channel_partner_repricing_config = ::Gapic::Config::Method.new delete_channel_partner_repricing_config_config
                    list_sku_groups_config = parent_rpcs.list_sku_groups if parent_rpcs.respond_to? :list_sku_groups
                    @list_sku_groups = ::Gapic::Config::Method.new list_sku_groups_config
                    list_sku_group_billable_skus_config = parent_rpcs.list_sku_group_billable_skus if parent_rpcs.respond_to? :list_sku_group_billable_skus
                    @list_sku_group_billable_skus = ::Gapic::Config::Method.new list_sku_group_billable_skus_config
                    lookup_offer_config = parent_rpcs.lookup_offer if parent_rpcs.respond_to? :lookup_offer
                    @lookup_offer = ::Gapic::Config::Method.new lookup_offer_config
                    list_products_config = parent_rpcs.list_products if parent_rpcs.respond_to? :list_products
                    @list_products = ::Gapic::Config::Method.new list_products_config
                    list_skus_config = parent_rpcs.list_skus if parent_rpcs.respond_to? :list_skus
                    @list_skus = ::Gapic::Config::Method.new list_skus_config
                    list_offers_config = parent_rpcs.list_offers if parent_rpcs.respond_to? :list_offers
                    @list_offers = ::Gapic::Config::Method.new list_offers_config
                    list_purchasable_skus_config = parent_rpcs.list_purchasable_skus if parent_rpcs.respond_to? :list_purchasable_skus
                    @list_purchasable_skus = ::Gapic::Config::Method.new list_purchasable_skus_config
                    list_purchasable_offers_config = parent_rpcs.list_purchasable_offers if parent_rpcs.respond_to? :list_purchasable_offers
                    @list_purchasable_offers = ::Gapic::Config::Method.new list_purchasable_offers_config
                    query_eligible_billing_accounts_config = parent_rpcs.query_eligible_billing_accounts if parent_rpcs.respond_to? :query_eligible_billing_accounts
                    @query_eligible_billing_accounts = ::Gapic::Config::Method.new query_eligible_billing_accounts_config
                    register_subscriber_config = parent_rpcs.register_subscriber if parent_rpcs.respond_to? :register_subscriber
                    @register_subscriber = ::Gapic::Config::Method.new register_subscriber_config
                    unregister_subscriber_config = parent_rpcs.unregister_subscriber if parent_rpcs.respond_to? :unregister_subscriber
                    @unregister_subscriber = ::Gapic::Config::Method.new unregister_subscriber_config
                    list_subscribers_config = parent_rpcs.list_subscribers if parent_rpcs.respond_to? :list_subscribers
                    @list_subscribers = ::Gapic::Config::Method.new list_subscribers_config
                    list_entitlement_changes_config = parent_rpcs.list_entitlement_changes if parent_rpcs.respond_to? :list_entitlement_changes
                    @list_entitlement_changes = ::Gapic::Config::Method.new list_entitlement_changes_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
