# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Channel
      module V1
        module CloudChannelReportsService
          # Path helper methods for the CloudChannelReportsService API.
          module Paths
            ##
            # Create a fully-qualified Report resource string.
            #
            # The resource will be in the following format:
            #
            # `accounts/{account}/reports/{report}`
            #
            # @param account [String]
            # @param report [String]
            #
            # @return [::String]
            def report_path account:, report:
              raise ::ArgumentError, "account cannot contain /" if account.to_s.include? "/"

              "accounts/#{account}/reports/#{report}"
            end

            ##
            # Create a fully-qualified ReportJob resource string.
            #
            # The resource will be in the following format:
            #
            # `accounts/{account}/reportJobs/{report_job}`
            #
            # @param account [String]
            # @param report_job [String]
            #
            # @return [::String]
            def report_job_path account:, report_job:
              raise ::ArgumentError, "account cannot contain /" if account.to_s.include? "/"

              "accounts/#{account}/reportJobs/#{report_job}"
            end

            extend self
          end
        end
      end
    end
  end
end
