# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/certificatemanager/v1/certificate_manager_pb"
require "google/cloud/certificate_manager/v1/certificate_manager"

class ::Google::Cloud::CertificateManager::V1::CertificateManager::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_certificates
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::ListCertificatesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificates_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificates, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::ListCertificatesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificates_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificates ::Google::Cloud::CertificateManager::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificates(::Google::Cloud::CertificateManager::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificates_client_stub.call_rpc_count
    end
  end

  def test_get_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::Certificate.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::GetCertificateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate ::Google::Cloud::CertificateManager::V1::GetCertificateRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate(::Google::Cloud::CertificateManager::V1::GetCertificateRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_client_stub.call_rpc_count
    end
  end

  def test_create_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_id = "hello world"
    certificate = {}

    create_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_certificate, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::CreateCertificateRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["certificate_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::Certificate), request["certificate"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_certificate parent: parent, certificate_id: certificate_id, certificate: certificate do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_certificate ::Google::Cloud::CertificateManager::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_certificate(::Google::Cloud::CertificateManager::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_certificate_client_stub.call_rpc_count
    end
  end

  def test_update_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    certificate = {}
    update_mask = {}

    update_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_certificate, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::Certificate), request["certificate"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_certificate({ certificate: certificate, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_certificate certificate: certificate, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_certificate ::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_certificate({ certificate: certificate, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_certificate(::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_certificate_client_stub.call_rpc_count
    end
  end

  def test_delete_certificate
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_certificate, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_certificate_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_certificate({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_certificate name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_certificate ::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_certificate({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_certificate(::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_certificate_client_stub.call_rpc_count
    end
  end

  def test_list_certificate_maps
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::ListCertificateMapsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_maps_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificate_maps, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificate_maps_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificate_maps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificate_maps parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificate_maps ::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificate_maps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificate_maps(::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificate_maps_client_stub.call_rpc_count
    end
  end

  def test_get_certificate_map
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::CertificateMap.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate_map, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_map_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate_map({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate_map name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate_map ::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate_map({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate_map(::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_map_client_stub.call_rpc_count
    end
  end

  def test_create_certificate_map
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_map_id = "hello world"
    certificate_map = {}

    create_certificate_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_certificate_map, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["certificate_map_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::CertificateMap), request["certificate_map"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_certificate_map_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_certificate_map({ parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_certificate_map parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_certificate_map ::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest.new(parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_certificate_map({ parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_certificate_map(::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest.new(parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_certificate_map_client_stub.call_rpc_count
    end
  end

  def test_update_certificate_map
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    certificate_map = {}
    update_mask = {}

    update_certificate_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_certificate_map, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::CertificateMap), request["certificate_map"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_certificate_map_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_certificate_map({ certificate_map: certificate_map, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_certificate_map certificate_map: certificate_map, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_certificate_map ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest.new(certificate_map: certificate_map, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_certificate_map({ certificate_map: certificate_map, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_certificate_map(::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest.new(certificate_map: certificate_map, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_certificate_map_client_stub.call_rpc_count
    end
  end

  def test_delete_certificate_map
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_certificate_map, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_certificate_map_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_certificate_map({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_certificate_map name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_certificate_map ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_certificate_map({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_certificate_map(::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_certificate_map_client_stub.call_rpc_count
    end
  end

  def test_list_certificate_map_entries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_map_entries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificate_map_entries, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificate_map_entries_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificate_map_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificate_map_entries parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificate_map_entries ::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificate_map_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificate_map_entries(::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificate_map_entries_client_stub.call_rpc_count
    end
  end

  def test_get_certificate_map_entry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::CertificateMapEntry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_map_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate_map_entry, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_map_entry_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate_map_entry({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate_map_entry name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate_map_entry ::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate_map_entry({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate_map_entry(::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_map_entry_client_stub.call_rpc_count
    end
  end

  def test_create_certificate_map_entry
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_map_entry_id = "hello world"
    certificate_map_entry = {}

    create_certificate_map_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_certificate_map_entry, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["certificate_map_entry_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::CertificateMapEntry), request["certificate_map_entry"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_certificate_map_entry_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_certificate_map_entry({ parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_certificate_map_entry parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_certificate_map_entry ::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest.new(parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_certificate_map_entry({ parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_certificate_map_entry(::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest.new(parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_certificate_map_entry_client_stub.call_rpc_count
    end
  end

  def test_update_certificate_map_entry
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    certificate_map_entry = {}
    update_mask = {}

    update_certificate_map_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_certificate_map_entry, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::CertificateMapEntry), request["certificate_map_entry"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_certificate_map_entry_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_certificate_map_entry({ certificate_map_entry: certificate_map_entry, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_certificate_map_entry certificate_map_entry: certificate_map_entry, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_certificate_map_entry ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest.new(certificate_map_entry: certificate_map_entry, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_certificate_map_entry({ certificate_map_entry: certificate_map_entry, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_certificate_map_entry(::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest.new(certificate_map_entry: certificate_map_entry, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_certificate_map_entry_client_stub.call_rpc_count
    end
  end

  def test_delete_certificate_map_entry
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_map_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_certificate_map_entry, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_certificate_map_entry_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_certificate_map_entry({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_certificate_map_entry name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_certificate_map_entry ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_certificate_map_entry({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_certificate_map_entry(::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_certificate_map_entry_client_stub.call_rpc_count
    end
  end

  def test_list_dns_authorizations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_dns_authorizations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_dns_authorizations, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_dns_authorizations_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_dns_authorizations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_dns_authorizations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_dns_authorizations ::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_dns_authorizations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_dns_authorizations(::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_dns_authorizations_client_stub.call_rpc_count
    end
  end

  def test_get_dns_authorization
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::DnsAuthorization.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dns_authorization_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_dns_authorization, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_dns_authorization_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_dns_authorization({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_dns_authorization name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_dns_authorization ::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_dns_authorization({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_dns_authorization(::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_dns_authorization_client_stub.call_rpc_count
    end
  end

  def test_create_dns_authorization
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dns_authorization_id = "hello world"
    dns_authorization = {}

    create_dns_authorization_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_dns_authorization, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["dns_authorization_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::DnsAuthorization), request["dns_authorization"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_dns_authorization_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_dns_authorization({ parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_dns_authorization parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_dns_authorization ::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest.new(parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_dns_authorization({ parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_dns_authorization(::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest.new(parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_dns_authorization_client_stub.call_rpc_count
    end
  end

  def test_update_dns_authorization
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    dns_authorization = {}
    update_mask = {}

    update_dns_authorization_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_dns_authorization, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::DnsAuthorization), request["dns_authorization"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_dns_authorization_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_dns_authorization({ dns_authorization: dns_authorization, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_dns_authorization dns_authorization: dns_authorization, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_dns_authorization ::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest.new(dns_authorization: dns_authorization, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_dns_authorization({ dns_authorization: dns_authorization, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_dns_authorization(::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest.new(dns_authorization: dns_authorization, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_dns_authorization_client_stub.call_rpc_count
    end
  end

  def test_delete_dns_authorization
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_dns_authorization_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_dns_authorization, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_dns_authorization_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_dns_authorization({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_dns_authorization name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_dns_authorization ::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_dns_authorization({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_dns_authorization(::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_dns_authorization_client_stub.call_rpc_count
    end
  end

  def test_list_certificate_issuance_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_issuance_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_certificate_issuance_configs, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_certificate_issuance_configs_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_certificate_issuance_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_certificate_issuance_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_certificate_issuance_configs ::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_certificate_issuance_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_certificate_issuance_configs(::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_certificate_issuance_configs_client_stub.call_rpc_count
    end
  end

  def test_get_certificate_issuance_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_issuance_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_certificate_issuance_config, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_certificate_issuance_config_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_certificate_issuance_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_certificate_issuance_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_certificate_issuance_config ::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_certificate_issuance_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_certificate_issuance_config(::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_certificate_issuance_config_client_stub.call_rpc_count
    end
  end

  def test_create_certificate_issuance_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_issuance_config_id = "hello world"
    certificate_issuance_config = {}

    create_certificate_issuance_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_certificate_issuance_config, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["certificate_issuance_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig), request["certificate_issuance_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_certificate_issuance_config_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_certificate_issuance_config({ parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_certificate_issuance_config parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_certificate_issuance_config ::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest.new(parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_certificate_issuance_config({ parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_certificate_issuance_config(::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest.new(parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_certificate_issuance_config_client_stub.call_rpc_count
    end
  end

  def test_delete_certificate_issuance_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_issuance_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_certificate_issuance_config, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_certificate_issuance_config_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_certificate_issuance_config({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_certificate_issuance_config name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_certificate_issuance_config ::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_certificate_issuance_config({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_certificate_issuance_config(::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_certificate_issuance_config_client_stub.call_rpc_count
    end
  end

  def test_list_trust_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::ListTrustConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_trust_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_trust_configs, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_trust_configs_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_trust_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_trust_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_trust_configs ::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_trust_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_trust_configs(::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_trust_configs_client_stub.call_rpc_count
    end
  end

  def test_get_trust_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CertificateManager::V1::TrustConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_trust_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_trust_config, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_trust_config_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_trust_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_trust_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_trust_config ::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_trust_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_trust_config(::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_trust_config_client_stub.call_rpc_count
    end
  end

  def test_create_trust_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    trust_config_id = "hello world"
    trust_config = {}

    create_trust_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_trust_config, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["trust_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::TrustConfig), request["trust_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_trust_config_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_trust_config({ parent: parent, trust_config_id: trust_config_id, trust_config: trust_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_trust_config parent: parent, trust_config_id: trust_config_id, trust_config: trust_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_trust_config ::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest.new(parent: parent, trust_config_id: trust_config_id, trust_config: trust_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_trust_config({ parent: parent, trust_config_id: trust_config_id, trust_config: trust_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_trust_config(::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest.new(parent: parent, trust_config_id: trust_config_id, trust_config: trust_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_trust_config_client_stub.call_rpc_count
    end
  end

  def test_update_trust_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    trust_config = {}
    update_mask = {}

    update_trust_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_trust_config, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CertificateManager::V1::TrustConfig), request["trust_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_trust_config_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_trust_config({ trust_config: trust_config, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_trust_config trust_config: trust_config, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_trust_config ::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest.new(trust_config: trust_config, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_trust_config({ trust_config: trust_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_trust_config(::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest.new(trust_config: trust_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_trust_config_client_stub.call_rpc_count
    end
  end

  def test_delete_trust_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_trust_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_trust_config, name
      assert_kind_of ::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_trust_config_client_stub do
      # Create client
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_trust_config({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_trust_config name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_trust_config ::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_trust_config({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_trust_config(::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_trust_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CertificateManager::V1::CertificateManager::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::CertificateManager::V1::CertificateManager::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::CertificateManager::V1::CertificateManager::Operations, client.operations_client
  end
end
