# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/certificatemanager/v1/certificate_manager_pb"
require "google/cloud/certificate_manager/v1/certificate_manager/rest"


class ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_certificates
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::ListCertificatesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificates_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_list_certificates_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificates_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificates parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificates ::Google::Cloud::CertificateManager::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificates({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificates(::Google::Cloud::CertificateManager::V1::ListCertificatesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificates_client_stub.call_count
      end
    end
  end

  def test_get_certificate
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::Certificate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_get_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate ::Google::Cloud::CertificateManager::V1::GetCertificateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate(::Google::Cloud::CertificateManager::V1::GetCertificateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_client_stub.call_count
      end
    end
  end

  def test_create_certificate
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_id = "hello world"
    certificate = {}

    create_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_create_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate parent: parent, certificate_id: certificate_id, certificate: certificate do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate ::Google::Cloud::CertificateManager::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate({ parent: parent, certificate_id: certificate_id, certificate: certificate }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate(::Google::Cloud::CertificateManager::V1::CreateCertificateRequest.new(parent: parent, certificate_id: certificate_id, certificate: certificate), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_client_stub.call_count
      end
    end
  end

  def test_update_certificate
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate = {}
    update_mask = {}

    update_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_update_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate({ certificate: certificate, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate certificate: certificate, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate ::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate({ certificate: certificate, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate(::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest.new(certificate: certificate, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_client_stub.call_count
      end
    end
  end

  def test_delete_certificate
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_delete_certificate_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_certificate_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_certificate({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_certificate name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_certificate ::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_certificate({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_certificate(::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_certificate_client_stub.call_count
      end
    end
  end

  def test_list_certificate_maps
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::ListCertificateMapsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_maps_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_list_certificate_maps_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_maps_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_maps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_maps parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_maps ::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_maps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_maps(::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_maps_client_stub.call_count
      end
    end
  end

  def test_get_certificate_map
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::CertificateMap.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_get_certificate_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_map_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_map({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_map name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_map ::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_map({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_map(::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_map_client_stub.call_count
      end
    end
  end

  def test_create_certificate_map
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_map_id = "hello world"
    certificate_map = {}

    create_certificate_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_create_certificate_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_map_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate_map({ parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate_map parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate_map ::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest.new(parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate_map({ parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate_map(::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest.new(parent: parent, certificate_map_id: certificate_map_id, certificate_map: certificate_map), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_map_client_stub.call_count
      end
    end
  end

  def test_update_certificate_map
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate_map = {}
    update_mask = {}

    update_certificate_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_update_certificate_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_map_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate_map({ certificate_map: certificate_map, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate_map certificate_map: certificate_map, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate_map ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest.new(certificate_map: certificate_map, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate_map({ certificate_map: certificate_map, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate_map(::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest.new(certificate_map: certificate_map, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_map_client_stub.call_count
      end
    end
  end

  def test_delete_certificate_map
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_map_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_delete_certificate_map_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_certificate_map_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_certificate_map({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_certificate_map name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_certificate_map ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_certificate_map({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_certificate_map(::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_certificate_map_client_stub.call_count
      end
    end
  end

  def test_list_certificate_map_entries
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_map_entries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_list_certificate_map_entries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_map_entries_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_map_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_map_entries parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_map_entries ::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_map_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_map_entries(::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_map_entries_client_stub.call_count
      end
    end
  end

  def test_get_certificate_map_entry
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::CertificateMapEntry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_map_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_get_certificate_map_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_map_entry_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_map_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_map_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_map_entry ::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_map_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_map_entry(::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_map_entry_client_stub.call_count
      end
    end
  end

  def test_create_certificate_map_entry
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_map_entry_id = "hello world"
    certificate_map_entry = {}

    create_certificate_map_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_create_certificate_map_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_map_entry_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate_map_entry({ parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate_map_entry parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate_map_entry ::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest.new(parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate_map_entry({ parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate_map_entry(::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest.new(parent: parent, certificate_map_entry_id: certificate_map_entry_id, certificate_map_entry: certificate_map_entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_map_entry_client_stub.call_count
      end
    end
  end

  def test_update_certificate_map_entry
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    certificate_map_entry = {}
    update_mask = {}

    update_certificate_map_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_update_certificate_map_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_certificate_map_entry_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_certificate_map_entry({ certificate_map_entry: certificate_map_entry, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_certificate_map_entry certificate_map_entry: certificate_map_entry, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_certificate_map_entry ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest.new(certificate_map_entry: certificate_map_entry, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_certificate_map_entry({ certificate_map_entry: certificate_map_entry, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_certificate_map_entry(::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest.new(certificate_map_entry: certificate_map_entry, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_certificate_map_entry_client_stub.call_count
      end
    end
  end

  def test_delete_certificate_map_entry
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_map_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_delete_certificate_map_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_certificate_map_entry_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_certificate_map_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_certificate_map_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_certificate_map_entry ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_certificate_map_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_certificate_map_entry(::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_certificate_map_entry_client_stub.call_count
      end
    end
  end

  def test_list_dns_authorizations
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_dns_authorizations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_list_dns_authorizations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_dns_authorizations_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_dns_authorizations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_dns_authorizations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_dns_authorizations ::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_dns_authorizations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_dns_authorizations(::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_dns_authorizations_client_stub.call_count
      end
    end
  end

  def test_get_dns_authorization
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::DnsAuthorization.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dns_authorization_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_get_dns_authorization_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dns_authorization_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dns_authorization({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dns_authorization name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dns_authorization ::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dns_authorization({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dns_authorization(::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dns_authorization_client_stub.call_count
      end
    end
  end

  def test_create_dns_authorization
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dns_authorization_id = "hello world"
    dns_authorization = {}

    create_dns_authorization_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_create_dns_authorization_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dns_authorization_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dns_authorization({ parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dns_authorization parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dns_authorization ::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest.new(parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dns_authorization({ parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dns_authorization(::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest.new(parent: parent, dns_authorization_id: dns_authorization_id, dns_authorization: dns_authorization), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dns_authorization_client_stub.call_count
      end
    end
  end

  def test_update_dns_authorization
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    dns_authorization = {}
    update_mask = {}

    update_dns_authorization_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_update_dns_authorization_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dns_authorization_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dns_authorization({ dns_authorization: dns_authorization, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dns_authorization dns_authorization: dns_authorization, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dns_authorization ::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest.new(dns_authorization: dns_authorization, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dns_authorization({ dns_authorization: dns_authorization, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dns_authorization(::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest.new(dns_authorization: dns_authorization, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dns_authorization_client_stub.call_count
      end
    end
  end

  def test_delete_dns_authorization
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_dns_authorization_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_delete_dns_authorization_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dns_authorization_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dns_authorization({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dns_authorization name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dns_authorization ::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dns_authorization({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dns_authorization(::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dns_authorization_client_stub.call_count
      end
    end
  end

  def test_list_certificate_issuance_configs
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_certificate_issuance_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_list_certificate_issuance_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_certificate_issuance_configs_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_certificate_issuance_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_certificate_issuance_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_certificate_issuance_configs ::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_certificate_issuance_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_certificate_issuance_configs(::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_certificate_issuance_configs_client_stub.call_count
      end
    end
  end

  def test_get_certificate_issuance_config
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_certificate_issuance_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_get_certificate_issuance_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_certificate_issuance_config_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_certificate_issuance_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_certificate_issuance_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_certificate_issuance_config ::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_certificate_issuance_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_certificate_issuance_config(::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_certificate_issuance_config_client_stub.call_count
      end
    end
  end

  def test_create_certificate_issuance_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    certificate_issuance_config_id = "hello world"
    certificate_issuance_config = {}

    create_certificate_issuance_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_create_certificate_issuance_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_certificate_issuance_config_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_certificate_issuance_config({ parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_certificate_issuance_config parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_certificate_issuance_config ::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest.new(parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_certificate_issuance_config({ parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_certificate_issuance_config(::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest.new(parent: parent, certificate_issuance_config_id: certificate_issuance_config_id, certificate_issuance_config: certificate_issuance_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_certificate_issuance_config_client_stub.call_count
      end
    end
  end

  def test_delete_certificate_issuance_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_certificate_issuance_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_delete_certificate_issuance_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_certificate_issuance_config_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_certificate_issuance_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_certificate_issuance_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_certificate_issuance_config ::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_certificate_issuance_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_certificate_issuance_config(::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_certificate_issuance_config_client_stub.call_count
      end
    end
  end

  def test_list_trust_configs
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::ListTrustConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_trust_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_list_trust_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_trust_configs_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_trust_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_trust_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_trust_configs ::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_trust_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_trust_configs(::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_trust_configs_client_stub.call_count
      end
    end
  end

  def test_get_trust_config
    # Create test objects.
    client_result = ::Google::Cloud::CertificateManager::V1::TrustConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_trust_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_get_trust_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_trust_config_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_trust_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_trust_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_trust_config ::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_trust_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_trust_config(::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_trust_config_client_stub.call_count
      end
    end
  end

  def test_create_trust_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    trust_config_id = "hello world"
    trust_config = {}

    create_trust_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_create_trust_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_trust_config_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_trust_config({ parent: parent, trust_config_id: trust_config_id, trust_config: trust_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_trust_config parent: parent, trust_config_id: trust_config_id, trust_config: trust_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_trust_config ::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest.new(parent: parent, trust_config_id: trust_config_id, trust_config: trust_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_trust_config({ parent: parent, trust_config_id: trust_config_id, trust_config: trust_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_trust_config(::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest.new(parent: parent, trust_config_id: trust_config_id, trust_config: trust_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_trust_config_client_stub.call_count
      end
    end
  end

  def test_update_trust_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    trust_config = {}
    update_mask = {}

    update_trust_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_update_trust_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_trust_config_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_trust_config({ trust_config: trust_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_trust_config trust_config: trust_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_trust_config ::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest.new(trust_config: trust_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_trust_config({ trust_config: trust_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_trust_config(::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest.new(trust_config: trust_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_trust_config_client_stub.call_count
      end
    end
  end

  def test_delete_trust_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_trust_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::ServiceStub.stub :transcode_delete_trust_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_trust_config_client_stub do
        # Create client
        client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_trust_config({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_trust_config name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_trust_config ::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_trust_config({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_trust_config(::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_trust_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CertificateManager::V1::CertificateManager::Rest::Client::Configuration, config
  end
end
