# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CertificateManager
      module V1
        # Request for the `ListTrustConfigs` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the TrustConfigs should be
        #     listed, specified in the format `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of TrustConfigs to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListTrustConfigsResponse`. Indicates
        #     that this is a continuation of a prior `ListTrustConfigs` call, and that
        #     the system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter expression to restrict the TrustConfigs returned.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A list of TrustConfig field names used to specify the order of the
        #     returned results. The default sorting order is ascending. To specify
        #     descending order for a field, add a suffix `" desc"`.
        class ListTrustConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListTrustConfigs` method.
        # @!attribute [rw] trust_configs
        #   @return [::Array<::Google::Cloud::CertificateManager::V1::TrustConfig>]
        #     A list of TrustConfigs for the parent resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListTrustConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetTrustConfig` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the TrustConfig to describe. Must be in the format
        #     `projects/*/locations/*/trustConfigs/*`.
        class GetTrustConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CreateTrustConfig` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the TrustConfig. Must be in the format
        #     `projects/*/locations/*`.
        # @!attribute [rw] trust_config_id
        #   @return [::String]
        #     Required. A user-provided name of the TrustConfig. Must match the regexp
        #     `[a-z0-9-]{1,63}`.
        # @!attribute [rw] trust_config
        #   @return [::Google::Cloud::CertificateManager::V1::TrustConfig]
        #     Required. A definition of the TrustConfig to create.
        class CreateTrustConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateTrustConfig` method.
        # @!attribute [rw] trust_config
        #   @return [::Google::Cloud::CertificateManager::V1::TrustConfig]
        #     Required. A definition of the TrustConfig to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource. For the `FieldMask`
        #     definition, see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
        class UpdateTrustConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteTrustConfig` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the TrustConfig to delete. Must be in the format
        #     `projects/*/locations/*/trustConfigs/*`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The current etag of the TrustConfig.
        #     If an etag is provided and does not match the current etag of the resource,
        #     deletion will be blocked and an ABORTED error will be returned.
        class DeleteTrustConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines a trust config.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-defined name of the trust config. TrustConfig names must be
        #     unique globally and match pattern
        #     `projects/*/locations/*/trustConfigs/*`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of a TrustConfig.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of a TrustConfig.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Set of labels associated with a TrustConfig.
        # @!attribute [rw] description
        #   @return [::String]
        #     One or more paragraphs of text description of a TrustConfig.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] trust_stores
        #   @return [::Array<::Google::Cloud::CertificateManager::V1::TrustConfig::TrustStore>]
        #     Set of trust stores to perform validation against.
        #
        #     This field is supported when TrustConfig is configured with Load Balancers,
        #     currently not supported for SPIFFE certificate validation.
        #
        #     Only one TrustStore specified is currently allowed.
        class TrustConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines a trust anchor.
          # @!attribute [rw] pem_certificate
          #   @return [::String]
          #     PEM root certificate of the PKI used for validation.
          #
          #     Each certificate provided in PEM format may occupy up to 5kB.
          class TrustAnchor
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines an intermediate CA.
          # @!attribute [rw] pem_certificate
          #   @return [::String]
          #     PEM intermediate certificate used for building up paths
          #     for validation.
          #
          #     Each certificate provided in PEM format may occupy up to 5kB.
          class IntermediateCA
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines a trust store.
          # @!attribute [rw] trust_anchors
          #   @return [::Array<::Google::Cloud::CertificateManager::V1::TrustConfig::TrustAnchor>]
          #     List of Trust Anchors to be used while performing validation
          #     against a given TrustStore.
          # @!attribute [rw] intermediate_cas
          #   @return [::Array<::Google::Cloud::CertificateManager::V1::TrustConfig::IntermediateCA>]
          #     Set of intermediate CA certificates used for the path building
          #     phase of chain validation.
          #
          #     The field is currently not supported if TrustConfig is used for the
          #     workload certificate feature.
          class TrustStore
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
