# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CertificateManager
      module V1
        # Request for the `ListCertificates` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the certificate should be
        #     listed, specified in the format `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of certificates to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListCertificatesResponse`. Indicates that
        #     this is a continuation of a prior `ListCertificates` call, and that the
        #     system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter expression to restrict the Certificates returned.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A list of Certificate field names used to specify the order of the returned
        #     results. The default sorting order is ascending. To specify descending
        #     order for a field, add a suffix `" desc"`.
        class ListCertificatesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListCertificates` method.
        # @!attribute [rw] certificates
        #   @return [::Array<::Google::Cloud::CertificateManager::V1::Certificate>]
        #     A list of certificates for the parent resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     A list of locations that could not be reached.
        class ListCertificatesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetCertificate` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the certificate to describe. Must be in the format
        #     `projects/*/locations/*/certificates/*`.
        class GetCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CreateCertificate` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the certificate. Must be in the format
        #     `projects/*/locations/*`.
        # @!attribute [rw] certificate_id
        #   @return [::String]
        #     Required. A user-provided name of the certificate.
        # @!attribute [rw] certificate
        #   @return [::Google::Cloud::CertificateManager::V1::Certificate]
        #     Required. A definition of the certificate to create.
        class CreateCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateCertificate` method.
        # @!attribute [rw] certificate
        #   @return [::Google::Cloud::CertificateManager::V1::Certificate]
        #     Required. A definition of the certificate to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource. For the `FieldMask`
        #     definition, see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
        class UpdateCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteCertificate` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the certificate to delete. Must be in the format
        #     `projects/*/locations/*/certificates/*`.
        class DeleteCertificateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListCertificateMaps` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the certificate maps should
        #     be listed, specified in the format `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of certificate maps to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListCertificateMapsResponse`. Indicates
        #     that this is a continuation of a prior `ListCertificateMaps` call, and that
        #     the system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter expression to restrict the Certificates Maps returned.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A list of Certificate Map field names used to specify the order of the
        #     returned results. The default sorting order is ascending. To specify
        #     descending order for a field, add a suffix `" desc"`.
        class ListCertificateMapsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListCertificateMaps` method.
        # @!attribute [rw] certificate_maps
        #   @return [::Array<::Google::Cloud::CertificateManager::V1::CertificateMap>]
        #     A list of certificate maps for the parent resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListCertificateMapsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetCertificateMap` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the certificate map to describe. Must be in the format
        #     `projects/*/locations/*/certificateMaps/*`.
        class GetCertificateMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CreateCertificateMap` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the certificate map. Must be in the format
        #     `projects/*/locations/*`.
        # @!attribute [rw] certificate_map_id
        #   @return [::String]
        #     Required. A user-provided name of the certificate map.
        # @!attribute [rw] certificate_map
        #   @return [::Google::Cloud::CertificateManager::V1::CertificateMap]
        #     Required. A definition of the certificate map to create.
        class CreateCertificateMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateCertificateMap` method.
        # @!attribute [rw] certificate_map
        #   @return [::Google::Cloud::CertificateManager::V1::CertificateMap]
        #     Required. A definition of the certificate map to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource. For the `FieldMask`
        #     definition, see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
        class UpdateCertificateMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteCertificateMap` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the certificate map to delete. Must be in the format
        #     `projects/*/locations/*/certificateMaps/*`.
        class DeleteCertificateMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListCertificateMapEntries` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project, location and certificate map from which the
        #     certificate map entries should be listed, specified in the format
        #     `projects/*/locations/*/certificateMaps/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of certificate map entries to return. The service may return
        #     fewer than this value.
        #     If unspecified, at most 50 certificate map entries will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListCertificateMapEntriesResponse`.
        #     Indicates that this is a continuation of a prior
        #     `ListCertificateMapEntries` call, and that the system should return the
        #     next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter expression to restrict the returned Certificate Map Entries.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A list of Certificate Map Entry field names used to specify
        #     the order of the returned results. The default sorting order is ascending.
        #     To specify descending order for a field, add a suffix `" desc"`.
        class ListCertificateMapEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListCertificateMapEntries` method.
        # @!attribute [rw] certificate_map_entries
        #   @return [::Array<::Google::Cloud::CertificateManager::V1::CertificateMapEntry>]
        #     A list of certificate map entries for the parent resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListCertificateMapEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetCertificateMapEntry` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the certificate map entry to describe. Must be in the
        #     format `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        class GetCertificateMapEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CreateCertificateMapEntry` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the certificate map entry. Must be in the
        #     format `projects/*/locations/*/certificateMaps/*`.
        # @!attribute [rw] certificate_map_entry_id
        #   @return [::String]
        #     Required. A user-provided name of the certificate map entry.
        # @!attribute [rw] certificate_map_entry
        #   @return [::Google::Cloud::CertificateManager::V1::CertificateMapEntry]
        #     Required. A definition of the certificate map entry to create.
        class CreateCertificateMapEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateCertificateMapEntry` method.
        # @!attribute [rw] certificate_map_entry
        #   @return [::Google::Cloud::CertificateManager::V1::CertificateMapEntry]
        #     Required. A definition of the certificate map entry to create map entry.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource. For the `FieldMask`
        #     definition, see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
        class UpdateCertificateMapEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteCertificateMapEntry` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the certificate map entry to delete. Must be in the
        #     format `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        class DeleteCertificateMapEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `ListDnsAuthorizations` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the dns authorizations should
        #     be listed, specified in the format `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of dns authorizations to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListDnsAuthorizationsResponse`. Indicates
        #     that this is a continuation of a prior `ListDnsAuthorizations` call, and
        #     that the system should return the next page of data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter expression to restrict the Dns Authorizations returned.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A list of Dns Authorization field names used to specify the order of the
        #     returned results. The default sorting order is ascending. To specify
        #     descending order for a field, add a suffix `" desc"`.
        class ListDnsAuthorizationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListDnsAuthorizations` method.
        # @!attribute [rw] dns_authorizations
        #   @return [::Array<::Google::Cloud::CertificateManager::V1::DnsAuthorization>]
        #     A list of dns authorizations for the parent resource.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDnsAuthorizationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetDnsAuthorization` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the dns authorization to describe. Must be in the
        #     format `projects/*/locations/*/dnsAuthorizations/*`.
        class GetDnsAuthorizationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CreateDnsAuthorization` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the dns authorization. Must be in the
        #     format `projects/*/locations/*`.
        # @!attribute [rw] dns_authorization_id
        #   @return [::String]
        #     Required. A user-provided name of the dns authorization.
        # @!attribute [rw] dns_authorization
        #   @return [::Google::Cloud::CertificateManager::V1::DnsAuthorization]
        #     Required. A definition of the dns authorization to create.
        class CreateDnsAuthorizationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateDnsAuthorization` method.
        # @!attribute [rw] dns_authorization
        #   @return [::Google::Cloud::CertificateManager::V1::DnsAuthorization]
        #     Required. A definition of the dns authorization to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource. For the `FieldMask`
        #     definition, see
        #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
        class UpdateDnsAuthorizationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteDnsAuthorization` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the dns authorization to delete. Must be in the format
        #     `projects/*/locations/*/dnsAuthorizations/*`.
        class DeleteDnsAuthorizationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation. Output only.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] target
        #   @return [::String]
        #     Server-defined resource path for the target of the operation.
        # @!attribute [rw] verb
        #   @return [::String]
        #     Name of the verb executed by the operation.
        # @!attribute [rw] status_message
        #   @return [::String]
        #     Human-readable status of the operation, if any.
        # @!attribute [rw] requested_cancellation
        #   @return [::Boolean]
        #     Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [rw] api_version
        #   @return [::String]
        #     API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines TLS certificate.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-defined name of the certificate. Certificate names must be unique
        #     globally and match pattern `projects/*/locations/*/certificates/*`.
        # @!attribute [rw] description
        #   @return [::String]
        #     One or more paragraphs of text description of a certificate.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of a Certificate.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of a Certificate.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Set of labels associated with a Certificate.
        # @!attribute [rw] self_managed
        #   @return [::Google::Cloud::CertificateManager::V1::Certificate::SelfManagedCertificate]
        #     If set, defines data of a self-managed certificate.
        #
        #     Note: The following fields are mutually exclusive: `self_managed`, `managed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] managed
        #   @return [::Google::Cloud::CertificateManager::V1::Certificate::ManagedCertificate]
        #     If set, contains configuration and state of a managed certificate.
        #
        #     Note: The following fields are mutually exclusive: `managed`, `self_managed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] san_dnsnames
        #   @return [::Array<::String>]
        #     Output only. The list of Subject Alternative Names of dnsName type defined
        #     in the certificate (see RFC 5280 4.2.1.6). Managed certificates that
        #     haven't been provisioned yet have this field populated with a value of the
        #     managed.domains field.
        # @!attribute [r] pem_certificate
        #   @return [::String]
        #     Output only. The PEM-encoded certificate chain.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The expiry timestamp of a Certificate.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::CertificateManager::V1::Certificate::Scope]
        #     Immutable. The scope of the certificate.
        class Certificate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Certificate data for a SelfManaged Certificate.
          # SelfManaged Certificates are uploaded by the user. Updating such
          # certificates before they expire remains the user's responsibility.
          # @!attribute [rw] pem_certificate
          #   @return [::String]
          #     Input only. The PEM-encoded certificate chain.
          #     Leaf certificate comes first, followed by intermediate ones if any.
          # @!attribute [rw] pem_private_key
          #   @return [::String]
          #     Input only. The PEM-encoded private key of the leaf certificate.
          class SelfManagedCertificate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration and state of a Managed Certificate.
          # Certificate Manager provisions and renews Managed Certificates
          # automatically, for as long as it's authorized to do so.
          # @!attribute [rw] domains
          #   @return [::Array<::String>]
          #     Immutable. The domains for which a managed SSL certificate will be
          #     generated. Wildcard domains are only supported with DNS challenge
          #     resolution.
          # @!attribute [rw] dns_authorizations
          #   @return [::Array<::String>]
          #     Immutable. Authorizations that will be used for performing domain
          #     authorization.
          # @!attribute [rw] issuance_config
          #   @return [::String]
          #     Immutable. The resource name for a
          #     {::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig CertificateIssuanceConfig}
          #     used to configure private PKI certificates in the format
          #     `projects/*/locations/*/certificateIssuanceConfigs/*`.
          #     If this field is not set, the certificates will instead be publicly
          #     signed as documented at
          #     https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
          # @!attribute [r] state
          #   @return [::Google::Cloud::CertificateManager::V1::Certificate::ManagedCertificate::State]
          #     Output only. State of the managed certificate resource.
          # @!attribute [r] provisioning_issue
          #   @return [::Google::Cloud::CertificateManager::V1::Certificate::ManagedCertificate::ProvisioningIssue]
          #     Output only. Information about issues with provisioning a Managed
          #     Certificate.
          # @!attribute [r] authorization_attempt_info
          #   @return [::Array<::Google::Cloud::CertificateManager::V1::Certificate::ManagedCertificate::AuthorizationAttemptInfo>]
          #     Output only. Detailed state of the latest authorization attempt for each
          #     domain specified for managed certificate resource.
          class ManagedCertificate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Information about issues with provisioning a Managed Certificate.
            # @!attribute [r] reason
            #   @return [::Google::Cloud::CertificateManager::V1::Certificate::ManagedCertificate::ProvisioningIssue::Reason]
            #     Output only. Reason for provisioning failures.
            # @!attribute [r] details
            #   @return [::String]
            #     Output only. Human readable explanation about the issue. Provided to
            #     help address the configuration issues. Not guaranteed to be stable. For
            #     programmatic access use Reason enum.
            class ProvisioningIssue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Reason for provisioning failures.
              module Reason
                # Reason is unspecified.
                REASON_UNSPECIFIED = 0

                # Certificate provisioning failed due to an issue with one or more of
                # the domains on the certificate.
                # For details of which domains failed, consult the
                # `authorization_attempt_info` field.
                AUTHORIZATION_ISSUE = 1

                # Exceeded Certificate Authority quotas or internal rate limits of the
                # system. Provisioning may take longer to complete.
                RATE_LIMITED = 2
              end
            end

            # State of the latest attempt to authorize a domain for certificate
            # issuance.
            # @!attribute [rw] domain
            #   @return [::String]
            #     Domain name of the authorization attempt.
            # @!attribute [r] state
            #   @return [::Google::Cloud::CertificateManager::V1::Certificate::ManagedCertificate::AuthorizationAttemptInfo::State]
            #     Output only. State of the domain for managed certificate issuance.
            # @!attribute [r] failure_reason
            #   @return [::Google::Cloud::CertificateManager::V1::Certificate::ManagedCertificate::AuthorizationAttemptInfo::FailureReason]
            #     Output only. Reason for failure of the authorization attempt for the
            #     domain.
            # @!attribute [r] details
            #   @return [::String]
            #     Output only. Human readable explanation for reaching the state.
            #     Provided to help address the configuration issues. Not guaranteed to be
            #     stable. For programmatic access use FailureReason enum.
            class AuthorizationAttemptInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # State of the domain for managed certificate issuance.
              module State
                # State is unspecified.
                STATE_UNSPECIFIED = 0

                # Certificate provisioning for this domain is under way. Google Cloud
                # will attempt to authorize the domain.
                AUTHORIZING = 1

                # A managed certificate can be provisioned, no issues for this domain.
                AUTHORIZED = 6

                # Attempt to authorize the domain failed. This prevents the Managed
                # Certificate from being issued.
                # See `failure_reason` and `details` fields for more information.
                FAILED = 7
              end

              # Reason for failure of the authorization attempt for the domain.
              module FailureReason
                # FailureReason is unspecified.
                FAILURE_REASON_UNSPECIFIED = 0

                # There was a problem with the user's DNS or load balancer
                # configuration for this domain.
                CONFIG = 1

                # Certificate issuance forbidden by an explicit CAA record for the
                # domain or a failure to check CAA records for the domain.
                CAA = 2

                # Reached a CA or internal rate-limit for the domain,
                # e.g. for certificates per top-level private domain.
                RATE_LIMITED = 3
              end
            end

            # State of the managed certificate resource.
            module State
              # State is unspecified.
              STATE_UNSPECIFIED = 0

              # Certificate Manager attempts to provision or renew the certificate.
              # If the process takes longer than expected, consult the
              # `provisioning_issue` field.
              PROVISIONING = 1

              # Multiple certificate provisioning attempts failed and Certificate
              # Manager gave up. To try again, delete and create a new managed
              # Certificate resource.
              # For details see the `provisioning_issue` field.
              FAILED = 2

              # The certificate management is working, and a certificate has been
              # provisioned.
              ACTIVE = 3
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Certificate scope.
          module Scope
            # Certificates with default scope are served from core Google data centers.
            # If unsure, choose this option.
            DEFAULT = 0

            # Certificates with scope EDGE_CACHE are special-purposed certificates,
            # served from Edge Points of Presence.
            # See https://cloud.google.com/vpc/docs/edge-locations.
            EDGE_CACHE = 1

            # Certificates with ALL_REGIONS scope are served from all Google Cloud
            # regions. See https://cloud.google.com/compute/docs/regions-zones.
            ALL_REGIONS = 2
          end
        end

        # Defines a collection of certificate configurations.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-defined name of the Certificate Map. Certificate Map names must be
        #     unique globally and match pattern
        #     `projects/*/locations/*/certificateMaps/*`.
        # @!attribute [rw] description
        #   @return [::String]
        #     One or more paragraphs of text description of a certificate map.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of a Certificate Map.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp of a Certificate Map.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Set of labels associated with a Certificate Map.
        # @!attribute [r] gclb_targets
        #   @return [::Array<::Google::Cloud::CertificateManager::V1::CertificateMap::GclbTarget>]
        #     Output only. A list of GCLB targets that use this Certificate Map.
        #     A Target Proxy is only present on this list if it's attached to a
        #     Forwarding Rule.
        class CertificateMap
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes a Target Proxy that uses this Certificate Map.
          # @!attribute [r] target_https_proxy
          #   @return [::String]
          #     Output only. This field returns the resource name in the following
          #     format:
          #     `//compute.googleapis.com/projects/*/global/targetHttpsProxies/*`.
          #
          #     Note: The following fields are mutually exclusive: `target_https_proxy`, `target_ssl_proxy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] target_ssl_proxy
          #   @return [::String]
          #     Output only. This field returns the resource name in the following
          #     format:
          #     `//compute.googleapis.com/projects/*/global/targetSslProxies/*`.
          #
          #     Note: The following fields are mutually exclusive: `target_ssl_proxy`, `target_https_proxy`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] ip_configs
          #   @return [::Array<::Google::Cloud::CertificateManager::V1::CertificateMap::GclbTarget::IpConfig>]
          #     Output only. IP configurations for this Target Proxy where the
          #     Certificate Map is serving.
          class GclbTarget
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines IP configuration where this Certificate Map is serving.
            # @!attribute [r] ip_address
            #   @return [::String]
            #     Output only. An external IP address.
            # @!attribute [r] ports
            #   @return [::Array<::Integer>]
            #     Output only. Ports.
            class IpConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Defines a certificate map entry.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-defined name of the Certificate Map Entry. Certificate Map Entry
        #     names must be unique globally and match pattern
        #     `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        # @!attribute [rw] description
        #   @return [::String]
        #     One or more paragraphs of text description of a certificate map entry.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of a Certificate Map Entry.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update timestamp of a Certificate Map Entry.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Set of labels associated with a Certificate Map Entry.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
        #     (`*.example.com`) for a set of hostnames with common suffix. Used as
        #     Server Name Indication (SNI) for selecting a proper certificate.
        #
        #     Note: The following fields are mutually exclusive: `hostname`, `matcher`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] matcher
        #   @return [::Google::Cloud::CertificateManager::V1::CertificateMapEntry::Matcher]
        #     A predefined matcher for particular cases, other than SNI selection.
        #
        #     Note: The following fields are mutually exclusive: `matcher`, `hostname`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] certificates
        #   @return [::Array<::String>]
        #     A set of Certificates defines for the given `hostname`. There can be
        #     defined up to four certificates in each Certificate Map Entry. Each
        #     certificate must match pattern `projects/*/locations/*/certificates/*`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::CertificateManager::V1::ServingState]
        #     Output only. A serving state of this Certificate Map Entry.
        class CertificateMapEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines predefined cases other than SNI-hostname match when this
          # configuration should be applied.
          module Matcher
            # A matcher has't been recognized.
            MATCHER_UNSPECIFIED = 0

            # A primary certificate that is served when SNI wasn't specified in the
            # request or SNI couldn't be found in the map.
            PRIMARY = 1
          end
        end

        # A DnsAuthorization resource describes a way to perform domain authorization
        # for certificate issuance.
        # @!attribute [rw] name
        #   @return [::String]
        #     A user-defined name of the dns authorization. DnsAuthorization names must
        #     be unique globally and match pattern
        #     `projects/*/locations/*/dnsAuthorizations/*`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of a DnsAuthorization.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of a DnsAuthorization.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Set of labels associated with a DnsAuthorization.
        # @!attribute [rw] description
        #   @return [::String]
        #     One or more paragraphs of text description of a DnsAuthorization.
        # @!attribute [rw] domain
        #   @return [::String]
        #     Required. Immutable. A domain that is being authorized. A DnsAuthorization
        #     resource covers a single domain and its wildcard, e.g. authorization for
        #     `example.com` can be used to issue certificates for `example.com` and
        #     `*.example.com`.
        # @!attribute [r] dns_resource_record
        #   @return [::Google::Cloud::CertificateManager::V1::DnsAuthorization::DnsResourceRecord]
        #     Output only. DNS Resource Record that needs to be added to DNS
        #     configuration.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::CertificateManager::V1::DnsAuthorization::Type]
        #     Immutable. Type of DnsAuthorization. If unset during resource creation the
        #     following default will be used:
        #     - in location global: FIXED_RECORD.
        class DnsAuthorization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The structure describing the DNS Resource Record that needs to be added
          # to DNS configuration for the authorization to be usable by
          # certificate.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. Fully qualified name of the DNS Resource Record.
          #     e.g. `_acme-challenge.example.com`
          # @!attribute [r] type
          #   @return [::String]
          #     Output only. Type of the DNS Resource Record.
          #     Currently always set to "CNAME".
          # @!attribute [r] data
          #   @return [::String]
          #     Output only. Data of the DNS Resource Record.
          class DnsResourceRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # DnsAuthorization type.
          module Type
            # Type is unspecified.
            TYPE_UNSPECIFIED = 0

            # FIXED_RECORD DNS authorization uses DNS-01 validation method.
            FIXED_RECORD = 1

            # PER_PROJECT_RECORD DNS authorization allows for independent management
            # of Google-managed certificates with DNS authorization across multiple
            # projects.
            PER_PROJECT_RECORD = 2
          end
        end

        # Defines set of serving states associated with a resource.
        module ServingState
          # The status is undefined.
          SERVING_STATE_UNSPECIFIED = 0

          # The configuration is serving.
          ACTIVE = 1

          # Update is in progress. Some frontends may serve this configuration.
          PENDING = 2
        end
      end
    end
  end
end
