# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/certificatemanager/v1/certificate_manager_pb"
require "google/cloud/location"

module Google
  module Cloud
    module CertificateManager
      module V1
        module CertificateManager
          ##
          # Client for the CertificateManager service.
          #
          # API Overview
          #
          # Certificates Manager API allows customers to see and manage all their TLS
          # certificates.
          #
          # Certificates Manager API service provides methods to manage certificates,
          # group them into collections, and create serving configuration that can be
          # easily applied to other Cloud resources e.g. Target Proxies.
          #
          # Data Model
          #
          # The Certificates Manager service exposes the following resources:
          #
          # * `Certificate` that describes a single TLS certificate.
          # * `CertificateMap` that describes a collection of certificates that can be
          # attached to a target resource.
          # * `CertificateMapEntry` that describes a single configuration entry that
          # consists of a SNI and a group of certificates. It's a subresource of
          # CertificateMap.
          #
          # Certificate, CertificateMap and CertificateMapEntry IDs
          # have to fully match the regexp `[a-z0-9-]{1,63}`. In other words,
          # - only lower case letters, digits, and hyphen are allowed
          # - length of the resource ID has to be in [1,63] range.
          #
          # Provides methods to manage Cloud Certificate Manager entities.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "certificatemanager.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :certificate_manager_stub

            ##
            # Configure the CertificateManager Client class.
            #
            # See {::Google::Cloud::CertificateManager::V1::CertificateManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all CertificateManager clients
            #   ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "CertificateManager", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_certificates.timeout = 60.0
                default_config.rpcs.list_certificates.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_certificate.timeout = 60.0
                default_config.rpcs.get_certificate.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_certificate.timeout = 60.0
                default_config.rpcs.create_certificate.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_certificate.timeout = 60.0
                default_config.rpcs.update_certificate.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_certificate.timeout = 60.0
                default_config.rpcs.delete_certificate.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_certificate_maps.timeout = 60.0
                default_config.rpcs.list_certificate_maps.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_certificate_map.timeout = 60.0
                default_config.rpcs.get_certificate_map.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_certificate_map.timeout = 60.0
                default_config.rpcs.create_certificate_map.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_certificate_map.timeout = 60.0
                default_config.rpcs.update_certificate_map.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_certificate_map.timeout = 60.0
                default_config.rpcs.delete_certificate_map.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_certificate_map_entries.timeout = 60.0
                default_config.rpcs.list_certificate_map_entries.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_certificate_map_entry.timeout = 60.0
                default_config.rpcs.get_certificate_map_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_certificate_map_entry.timeout = 60.0
                default_config.rpcs.create_certificate_map_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_certificate_map_entry.timeout = 60.0
                default_config.rpcs.update_certificate_map_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_certificate_map_entry.timeout = 60.0
                default_config.rpcs.delete_certificate_map_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_dns_authorizations.timeout = 60.0
                default_config.rpcs.list_dns_authorizations.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_dns_authorization.timeout = 60.0
                default_config.rpcs.get_dns_authorization.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_dns_authorization.timeout = 60.0
                default_config.rpcs.create_dns_authorization.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_dns_authorization.timeout = 60.0
                default_config.rpcs.update_dns_authorization.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_dns_authorization.timeout = 60.0
                default_config.rpcs.delete_dns_authorization.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_certificate_issuance_configs.timeout = 60.0
                default_config.rpcs.list_certificate_issuance_configs.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_certificate_issuance_config.timeout = 60.0
                default_config.rpcs.get_certificate_issuance_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_certificate_issuance_config.timeout = 60.0
                default_config.rpcs.create_certificate_issuance_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_certificate_issuance_config.timeout = 60.0
                default_config.rpcs.delete_certificate_issuance_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the CertificateManager Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::CertificateManager::V1::CertificateManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @certificate_manager_stub.universe_domain
            end

            ##
            # Create a new CertificateManager client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the CertificateManager client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/certificatemanager/v1/certificate_manager_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @certificate_manager_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::CertificateManager::V1::CertificateManager::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @certificate_manager_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @certificate_manager_stub.endpoint
                config.universe_domain = @certificate_manager_stub.universe_domain
                config.logger = @certificate_manager_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::CertificateManager::V1::CertificateManager::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @certificate_manager_stub.logger
            end

            # Service calls

            ##
            # Lists Certificates in a given project and location.
            #
            # @overload list_certificates(request, options = nil)
            #   Pass arguments to `list_certificates` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::ListCertificatesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::ListCertificatesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_certificates(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_certificates` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the certificate should be
            #     listed, specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of certificates to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListCertificatesResponse`. Indicates that
            #     this is a continuation of a prior `ListCertificates` call, and that the
            #     system should return the next page of data.
            #   @param filter [::String]
            #     Filter expression to restrict the Certificates returned.
            #   @param order_by [::String]
            #     A list of Certificate field names used to specify the order of the returned
            #     results. The default sorting order is ascending. To specify descending
            #     order for a field, add a suffix `" desc"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::Certificate>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::Certificate>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::ListCertificatesRequest.new
            #
            #   # Call the list_certificates method.
            #   result = client.list_certificates request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CertificateManager::V1::Certificate.
            #     p item
            #   end
            #
            def list_certificates request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::ListCertificatesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_certificates.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_certificates.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_certificates.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :list_certificates, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @certificate_manager_stub, :list_certificates, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Certificate.
            #
            # @overload get_certificate(request, options = nil)
            #   Pass arguments to `get_certificate` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::GetCertificateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::GetCertificateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_certificate(name: nil)
            #   Pass arguments to `get_certificate` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate to describe. Must be in the format
            #     `projects/*/locations/*/certificates/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CertificateManager::V1::Certificate]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CertificateManager::V1::Certificate]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::GetCertificateRequest.new
            #
            #   # Call the get_certificate method.
            #   result = client.get_certificate request
            #
            #   # The returned object is of type Google::Cloud::CertificateManager::V1::Certificate.
            #   p result
            #
            def get_certificate request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::GetCertificateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_certificate.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_certificate.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_certificate.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :get_certificate, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Certificate in a given project and location.
            #
            # @overload create_certificate(request, options = nil)
            #   Pass arguments to `create_certificate` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::CreateCertificateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::CreateCertificateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_certificate(parent: nil, certificate_id: nil, certificate: nil)
            #   Pass arguments to `create_certificate` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the certificate. Must be in the format
            #     `projects/*/locations/*`.
            #   @param certificate_id [::String]
            #     Required. A user-provided name of the certificate.
            #   @param certificate [::Google::Cloud::CertificateManager::V1::Certificate, ::Hash]
            #     Required. A definition of the certificate to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::CreateCertificateRequest.new
            #
            #   # Call the create_certificate method.
            #   result = client.create_certificate request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_certificate request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::CreateCertificateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_certificate.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_certificate.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_certificate.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :create_certificate, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a Certificate.
            #
            # @overload update_certificate(request, options = nil)
            #   Pass arguments to `update_certificate` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_certificate(certificate: nil, update_mask: nil)
            #   Pass arguments to `update_certificate` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param certificate [::Google::Cloud::CertificateManager::V1::Certificate, ::Hash]
            #     Required. A definition of the certificate to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. For the `FieldMask`
            #     definition, see
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::UpdateCertificateRequest.new
            #
            #   # Call the update_certificate method.
            #   result = client.update_certificate request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_certificate request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::UpdateCertificateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_certificate.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.certificate&.name
                header_params["certificate.name"] = request.certificate.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_certificate.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_certificate.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :update_certificate, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Certificate.
            #
            # @overload delete_certificate(request, options = nil)
            #   Pass arguments to `delete_certificate` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_certificate(name: nil)
            #   Pass arguments to `delete_certificate` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate to delete. Must be in the format
            #     `projects/*/locations/*/certificates/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::DeleteCertificateRequest.new
            #
            #   # Call the delete_certificate method.
            #   result = client.delete_certificate request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_certificate request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::DeleteCertificateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_certificate.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_certificate.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_certificate.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :delete_certificate, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists CertificateMaps in a given project and location.
            #
            # @overload list_certificate_maps(request, options = nil)
            #   Pass arguments to `list_certificate_maps` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_certificate_maps(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_certificate_maps` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the certificate maps should
            #     be listed, specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of certificate maps to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListCertificateMapsResponse`. Indicates
            #     that this is a continuation of a prior `ListCertificateMaps` call, and that
            #     the system should return the next page of data.
            #   @param filter [::String]
            #     Filter expression to restrict the Certificates Maps returned.
            #   @param order_by [::String]
            #     A list of Certificate Map field names used to specify the order of the
            #     returned results. The default sorting order is ascending. To specify
            #     descending order for a field, add a suffix `" desc"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::CertificateMap>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::CertificateMap>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest.new
            #
            #   # Call the list_certificate_maps method.
            #   result = client.list_certificate_maps request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CertificateManager::V1::CertificateMap.
            #     p item
            #   end
            #
            def list_certificate_maps request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::ListCertificateMapsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_certificate_maps.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_certificate_maps.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_certificate_maps.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :list_certificate_maps, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @certificate_manager_stub, :list_certificate_maps, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single CertificateMap.
            #
            # @overload get_certificate_map(request, options = nil)
            #   Pass arguments to `get_certificate_map` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_certificate_map(name: nil)
            #   Pass arguments to `get_certificate_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate map to describe. Must be in the format
            #     `projects/*/locations/*/certificateMaps/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CertificateManager::V1::CertificateMap]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CertificateManager::V1::CertificateMap]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::GetCertificateMapRequest.new
            #
            #   # Call the get_certificate_map method.
            #   result = client.get_certificate_map request
            #
            #   # The returned object is of type Google::Cloud::CertificateManager::V1::CertificateMap.
            #   p result
            #
            def get_certificate_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::GetCertificateMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_certificate_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_certificate_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_certificate_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :get_certificate_map, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new CertificateMap in a given project and location.
            #
            # @overload create_certificate_map(request, options = nil)
            #   Pass arguments to `create_certificate_map` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_certificate_map(parent: nil, certificate_map_id: nil, certificate_map: nil)
            #   Pass arguments to `create_certificate_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the certificate map. Must be in the format
            #     `projects/*/locations/*`.
            #   @param certificate_map_id [::String]
            #     Required. A user-provided name of the certificate map.
            #   @param certificate_map [::Google::Cloud::CertificateManager::V1::CertificateMap, ::Hash]
            #     Required. A definition of the certificate map to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest.new
            #
            #   # Call the create_certificate_map method.
            #   result = client.create_certificate_map request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_certificate_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::CreateCertificateMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_certificate_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_certificate_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_certificate_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :create_certificate_map, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a CertificateMap.
            #
            # @overload update_certificate_map(request, options = nil)
            #   Pass arguments to `update_certificate_map` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_certificate_map(certificate_map: nil, update_mask: nil)
            #   Pass arguments to `update_certificate_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param certificate_map [::Google::Cloud::CertificateManager::V1::CertificateMap, ::Hash]
            #     Required. A definition of the certificate map to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. For the `FieldMask`
            #     definition, see
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest.new
            #
            #   # Call the update_certificate_map method.
            #   result = client.update_certificate_map request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_certificate_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_certificate_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.certificate_map&.name
                header_params["certificate_map.name"] = request.certificate_map.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_certificate_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_certificate_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :update_certificate_map, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single CertificateMap. A Certificate Map can't be deleted
            # if it contains Certificate Map Entries. Remove all the entries from
            # the map before calling this method.
            #
            # @overload delete_certificate_map(request, options = nil)
            #   Pass arguments to `delete_certificate_map` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_certificate_map(name: nil)
            #   Pass arguments to `delete_certificate_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate map to delete. Must be in the format
            #     `projects/*/locations/*/certificateMaps/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest.new
            #
            #   # Call the delete_certificate_map method.
            #   result = client.delete_certificate_map request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_certificate_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_certificate_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_certificate_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_certificate_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :delete_certificate_map, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists CertificateMapEntries in a given project and location.
            #
            # @overload list_certificate_map_entries(request, options = nil)
            #   Pass arguments to `list_certificate_map_entries` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_certificate_map_entries(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_certificate_map_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project, location and certificate map from which the
            #     certificate map entries should be listed, specified in the format
            #     `projects/*/locations/*/certificateMaps/*`.
            #   @param page_size [::Integer]
            #     Maximum number of certificate map entries to return. The service may return
            #     fewer than this value.
            #     If unspecified, at most 50 certificate map entries will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     The value returned by the last `ListCertificateMapEntriesResponse`.
            #     Indicates that this is a continuation of a prior
            #     `ListCertificateMapEntries` call, and that the system should return the
            #     next page of data.
            #   @param filter [::String]
            #     Filter expression to restrict the returned Certificate Map Entries.
            #   @param order_by [::String]
            #     A list of Certificate Map Entry field names used to specify
            #     the order of the returned results. The default sorting order is ascending.
            #     To specify descending order for a field, add a suffix `" desc"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::CertificateMapEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::CertificateMapEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest.new
            #
            #   # Call the list_certificate_map_entries method.
            #   result = client.list_certificate_map_entries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CertificateManager::V1::CertificateMapEntry.
            #     p item
            #   end
            #
            def list_certificate_map_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::ListCertificateMapEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_certificate_map_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_certificate_map_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_certificate_map_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :list_certificate_map_entries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @certificate_manager_stub, :list_certificate_map_entries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single CertificateMapEntry.
            #
            # @overload get_certificate_map_entry(request, options = nil)
            #   Pass arguments to `get_certificate_map_entry` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_certificate_map_entry(name: nil)
            #   Pass arguments to `get_certificate_map_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate map entry to describe. Must be in the
            #     format `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CertificateManager::V1::CertificateMapEntry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CertificateManager::V1::CertificateMapEntry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest.new
            #
            #   # Call the get_certificate_map_entry method.
            #   result = client.get_certificate_map_entry request
            #
            #   # The returned object is of type Google::Cloud::CertificateManager::V1::CertificateMapEntry.
            #   p result
            #
            def get_certificate_map_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::GetCertificateMapEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_certificate_map_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_certificate_map_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_certificate_map_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :get_certificate_map_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new CertificateMapEntry in a given project and location.
            #
            # @overload create_certificate_map_entry(request, options = nil)
            #   Pass arguments to `create_certificate_map_entry` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_certificate_map_entry(parent: nil, certificate_map_entry_id: nil, certificate_map_entry: nil)
            #   Pass arguments to `create_certificate_map_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the certificate map entry. Must be in the
            #     format `projects/*/locations/*/certificateMaps/*`.
            #   @param certificate_map_entry_id [::String]
            #     Required. A user-provided name of the certificate map entry.
            #   @param certificate_map_entry [::Google::Cloud::CertificateManager::V1::CertificateMapEntry, ::Hash]
            #     Required. A definition of the certificate map entry to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest.new
            #
            #   # Call the create_certificate_map_entry method.
            #   result = client.create_certificate_map_entry request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_certificate_map_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::CreateCertificateMapEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_certificate_map_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_certificate_map_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_certificate_map_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :create_certificate_map_entry, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a CertificateMapEntry.
            #
            # @overload update_certificate_map_entry(request, options = nil)
            #   Pass arguments to `update_certificate_map_entry` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_certificate_map_entry(certificate_map_entry: nil, update_mask: nil)
            #   Pass arguments to `update_certificate_map_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param certificate_map_entry [::Google::Cloud::CertificateManager::V1::CertificateMapEntry, ::Hash]
            #     Required. A definition of the certificate map entry to create map entry.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. For the `FieldMask`
            #     definition, see
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest.new
            #
            #   # Call the update_certificate_map_entry method.
            #   result = client.update_certificate_map_entry request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_certificate_map_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::UpdateCertificateMapEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_certificate_map_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.certificate_map_entry&.name
                header_params["certificate_map_entry.name"] = request.certificate_map_entry.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_certificate_map_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_certificate_map_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :update_certificate_map_entry, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single CertificateMapEntry.
            #
            # @overload delete_certificate_map_entry(request, options = nil)
            #   Pass arguments to `delete_certificate_map_entry` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_certificate_map_entry(name: nil)
            #   Pass arguments to `delete_certificate_map_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate map entry to delete. Must be in the
            #     format `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest.new
            #
            #   # Call the delete_certificate_map_entry method.
            #   result = client.delete_certificate_map_entry request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_certificate_map_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::DeleteCertificateMapEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_certificate_map_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_certificate_map_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_certificate_map_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :delete_certificate_map_entry, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists DnsAuthorizations in a given project and location.
            #
            # @overload list_dns_authorizations(request, options = nil)
            #   Pass arguments to `list_dns_authorizations` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_dns_authorizations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_dns_authorizations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the dns authorizations should
            #     be listed, specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of dns authorizations to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListDnsAuthorizationsResponse`. Indicates
            #     that this is a continuation of a prior `ListDnsAuthorizations` call, and
            #     that the system should return the next page of data.
            #   @param filter [::String]
            #     Filter expression to restrict the Dns Authorizations returned.
            #   @param order_by [::String]
            #     A list of Dns Authorization field names used to specify the order of the
            #     returned results. The default sorting order is ascending. To specify
            #     descending order for a field, add a suffix `" desc"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::DnsAuthorization>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::DnsAuthorization>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest.new
            #
            #   # Call the list_dns_authorizations method.
            #   result = client.list_dns_authorizations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CertificateManager::V1::DnsAuthorization.
            #     p item
            #   end
            #
            def list_dns_authorizations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::ListDnsAuthorizationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_dns_authorizations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_dns_authorizations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_dns_authorizations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :list_dns_authorizations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @certificate_manager_stub, :list_dns_authorizations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single DnsAuthorization.
            #
            # @overload get_dns_authorization(request, options = nil)
            #   Pass arguments to `get_dns_authorization` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_dns_authorization(name: nil)
            #   Pass arguments to `get_dns_authorization` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the dns authorization to describe. Must be in the
            #     format `projects/*/locations/*/dnsAuthorizations/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CertificateManager::V1::DnsAuthorization]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CertificateManager::V1::DnsAuthorization]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest.new
            #
            #   # Call the get_dns_authorization method.
            #   result = client.get_dns_authorization request
            #
            #   # The returned object is of type Google::Cloud::CertificateManager::V1::DnsAuthorization.
            #   p result
            #
            def get_dns_authorization request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::GetDnsAuthorizationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_dns_authorization.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_dns_authorization.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_dns_authorization.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :get_dns_authorization, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new DnsAuthorization in a given project and location.
            #
            # @overload create_dns_authorization(request, options = nil)
            #   Pass arguments to `create_dns_authorization` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_dns_authorization(parent: nil, dns_authorization_id: nil, dns_authorization: nil)
            #   Pass arguments to `create_dns_authorization` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the dns authorization. Must be in the
            #     format `projects/*/locations/*`.
            #   @param dns_authorization_id [::String]
            #     Required. A user-provided name of the dns authorization.
            #   @param dns_authorization [::Google::Cloud::CertificateManager::V1::DnsAuthorization, ::Hash]
            #     Required. A definition of the dns authorization to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest.new
            #
            #   # Call the create_dns_authorization method.
            #   result = client.create_dns_authorization request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_dns_authorization request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::CreateDnsAuthorizationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_dns_authorization.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_dns_authorization.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_dns_authorization.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :create_dns_authorization, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a DnsAuthorization.
            #
            # @overload update_dns_authorization(request, options = nil)
            #   Pass arguments to `update_dns_authorization` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_dns_authorization(dns_authorization: nil, update_mask: nil)
            #   Pass arguments to `update_dns_authorization` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param dns_authorization [::Google::Cloud::CertificateManager::V1::DnsAuthorization, ::Hash]
            #     Required. A definition of the dns authorization to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. For the `FieldMask`
            #     definition, see
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest.new
            #
            #   # Call the update_dns_authorization method.
            #   result = client.update_dns_authorization request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_dns_authorization request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::UpdateDnsAuthorizationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_dns_authorization.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.dns_authorization&.name
                header_params["dns_authorization.name"] = request.dns_authorization.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_dns_authorization.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_dns_authorization.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :update_dns_authorization, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single DnsAuthorization.
            #
            # @overload delete_dns_authorization(request, options = nil)
            #   Pass arguments to `delete_dns_authorization` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_dns_authorization(name: nil)
            #   Pass arguments to `delete_dns_authorization` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the dns authorization to delete. Must be in the format
            #     `projects/*/locations/*/dnsAuthorizations/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest.new
            #
            #   # Call the delete_dns_authorization method.
            #   result = client.delete_dns_authorization request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_dns_authorization request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::DeleteDnsAuthorizationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_dns_authorization.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_dns_authorization.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_dns_authorization.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :delete_dns_authorization, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists CertificateIssuanceConfigs in a given project and location.
            #
            # @overload list_certificate_issuance_configs(request, options = nil)
            #   Pass arguments to `list_certificate_issuance_configs` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_certificate_issuance_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_certificate_issuance_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the certificate should be
            #     listed, specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of certificate configs to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListCertificateIssuanceConfigsResponse`.
            #     Indicates that this is a continuation of a prior
            #     `ListCertificateIssuanceConfigs` call, and that the system should return
            #     the next page of data.
            #   @param filter [::String]
            #     Filter expression to restrict the Certificates Configs returned.
            #   @param order_by [::String]
            #     A list of Certificate Config field names used to specify the order of the
            #     returned results. The default sorting order is ascending. To specify
            #     descending order for a field, add a suffix `" desc"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest.new
            #
            #   # Call the list_certificate_issuance_configs method.
            #   result = client.list_certificate_issuance_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig.
            #     p item
            #   end
            #
            def list_certificate_issuance_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::ListCertificateIssuanceConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_certificate_issuance_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_certificate_issuance_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_certificate_issuance_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :list_certificate_issuance_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @certificate_manager_stub, :list_certificate_issuance_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single CertificateIssuanceConfig.
            #
            # @overload get_certificate_issuance_config(request, options = nil)
            #   Pass arguments to `get_certificate_issuance_config` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_certificate_issuance_config(name: nil)
            #   Pass arguments to `get_certificate_issuance_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate issuance config to describe. Must be in
            #     the format `projects/*/locations/*/certificateIssuanceConfigs/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest.new
            #
            #   # Call the get_certificate_issuance_config method.
            #   result = client.get_certificate_issuance_config request
            #
            #   # The returned object is of type Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig.
            #   p result
            #
            def get_certificate_issuance_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::GetCertificateIssuanceConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_certificate_issuance_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_certificate_issuance_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_certificate_issuance_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :get_certificate_issuance_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new CertificateIssuanceConfig in a given project and location.
            #
            # @overload create_certificate_issuance_config(request, options = nil)
            #   Pass arguments to `create_certificate_issuance_config` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_certificate_issuance_config(parent: nil, certificate_issuance_config_id: nil, certificate_issuance_config: nil)
            #   Pass arguments to `create_certificate_issuance_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the certificate issuance config. Must be
            #     in the format `projects/*/locations/*`.
            #   @param certificate_issuance_config_id [::String]
            #     Required. A user-provided name of the certificate config.
            #   @param certificate_issuance_config [::Google::Cloud::CertificateManager::V1::CertificateIssuanceConfig, ::Hash]
            #     Required. A definition of the certificate issuance config to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest.new
            #
            #   # Call the create_certificate_issuance_config method.
            #   result = client.create_certificate_issuance_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_certificate_issuance_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::CreateCertificateIssuanceConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_certificate_issuance_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_certificate_issuance_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_certificate_issuance_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :create_certificate_issuance_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single CertificateIssuanceConfig.
            #
            # @overload delete_certificate_issuance_config(request, options = nil)
            #   Pass arguments to `delete_certificate_issuance_config` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_certificate_issuance_config(name: nil)
            #   Pass arguments to `delete_certificate_issuance_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the certificate issuance config to delete. Must be in
            #     the format `projects/*/locations/*/certificateIssuanceConfigs/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest.new
            #
            #   # Call the delete_certificate_issuance_config method.
            #   result = client.delete_certificate_issuance_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_certificate_issuance_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::DeleteCertificateIssuanceConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_certificate_issuance_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_certificate_issuance_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_certificate_issuance_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :delete_certificate_issuance_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists TrustConfigs in a given project and location.
            #
            # @overload list_trust_configs(request, options = nil)
            #   Pass arguments to `list_trust_configs` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_trust_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_trust_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the TrustConfigs should be
            #     listed, specified in the format `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Maximum number of TrustConfigs to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListTrustConfigsResponse`. Indicates
            #     that this is a continuation of a prior `ListTrustConfigs` call, and that
            #     the system should return the next page of data.
            #   @param filter [::String]
            #     Filter expression to restrict the TrustConfigs returned.
            #   @param order_by [::String]
            #     A list of TrustConfig field names used to specify the order of the
            #     returned results. The default sorting order is ascending. To specify
            #     descending order for a field, add a suffix `" desc"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::TrustConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::CertificateManager::V1::TrustConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest.new
            #
            #   # Call the list_trust_configs method.
            #   result = client.list_trust_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::CertificateManager::V1::TrustConfig.
            #     p item
            #   end
            #
            def list_trust_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::ListTrustConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_trust_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_trust_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_trust_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :list_trust_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @certificate_manager_stub, :list_trust_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single TrustConfig.
            #
            # @overload get_trust_config(request, options = nil)
            #   Pass arguments to `get_trust_config` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_trust_config(name: nil)
            #   Pass arguments to `get_trust_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the TrustConfig to describe. Must be in the format
            #     `projects/*/locations/*/trustConfigs/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::CertificateManager::V1::TrustConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::CertificateManager::V1::TrustConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::GetTrustConfigRequest.new
            #
            #   # Call the get_trust_config method.
            #   result = client.get_trust_config request
            #
            #   # The returned object is of type Google::Cloud::CertificateManager::V1::TrustConfig.
            #   p result
            #
            def get_trust_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::GetTrustConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_trust_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_trust_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_trust_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :get_trust_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new TrustConfig in a given project and location.
            #
            # @overload create_trust_config(request, options = nil)
            #   Pass arguments to `create_trust_config` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_trust_config(parent: nil, trust_config_id: nil, trust_config: nil)
            #   Pass arguments to `create_trust_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the TrustConfig. Must be in the format
            #     `projects/*/locations/*`.
            #   @param trust_config_id [::String]
            #     Required. A user-provided name of the TrustConfig. Must match the regexp
            #     `[a-z0-9-]{1,63}`.
            #   @param trust_config [::Google::Cloud::CertificateManager::V1::TrustConfig, ::Hash]
            #     Required. A definition of the TrustConfig to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest.new
            #
            #   # Call the create_trust_config method.
            #   result = client.create_trust_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_trust_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::CreateTrustConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_trust_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_trust_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_trust_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :create_trust_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a TrustConfig.
            #
            # @overload update_trust_config(request, options = nil)
            #   Pass arguments to `update_trust_config` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_trust_config(trust_config: nil, update_mask: nil)
            #   Pass arguments to `update_trust_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param trust_config [::Google::Cloud::CertificateManager::V1::TrustConfig, ::Hash]
            #     Required. A definition of the TrustConfig to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The update mask applies to the resource. For the `FieldMask`
            #     definition, see
            #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest.new
            #
            #   # Call the update_trust_config method.
            #   result = client.update_trust_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_trust_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::UpdateTrustConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_trust_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.trust_config&.name
                header_params["trust_config.name"] = request.trust_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_trust_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_trust_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :update_trust_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single TrustConfig.
            #
            # @overload delete_trust_config(request, options = nil)
            #   Pass arguments to `delete_trust_config` via a request object, either of type
            #   {::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_trust_config(name: nil, etag: nil)
            #   Pass arguments to `delete_trust_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the TrustConfig to delete. Must be in the format
            #     `projects/*/locations/*/trustConfigs/*`.
            #   @param etag [::String]
            #     The current etag of the TrustConfig.
            #     If an etag is provided and does not match the current etag of the resource,
            #     deletion will be blocked and an ABORTED error will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/certificate_manager/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::CertificateManager::V1::CertificateManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest.new
            #
            #   # Call the delete_trust_config method.
            #   result = client.delete_trust_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_trust_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CertificateManager::V1::DeleteTrustConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_trust_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::CertificateManager::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_trust_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_trust_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @certificate_manager_stub.call_rpc :delete_trust_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the CertificateManager API.
            #
            # This class represents the configuration for CertificateManager,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::CertificateManager::V1::CertificateManager::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_certificates to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_certificates.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_certificates.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::CertificateManager::V1::CertificateManager::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "certificatemanager.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the CertificateManager API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_certificates`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_certificates
                ##
                # RPC-specific configuration for `get_certificate`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_certificate
                ##
                # RPC-specific configuration for `create_certificate`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_certificate
                ##
                # RPC-specific configuration for `update_certificate`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_certificate
                ##
                # RPC-specific configuration for `delete_certificate`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_certificate
                ##
                # RPC-specific configuration for `list_certificate_maps`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_certificate_maps
                ##
                # RPC-specific configuration for `get_certificate_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_certificate_map
                ##
                # RPC-specific configuration for `create_certificate_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_certificate_map
                ##
                # RPC-specific configuration for `update_certificate_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_certificate_map
                ##
                # RPC-specific configuration for `delete_certificate_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_certificate_map
                ##
                # RPC-specific configuration for `list_certificate_map_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_certificate_map_entries
                ##
                # RPC-specific configuration for `get_certificate_map_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_certificate_map_entry
                ##
                # RPC-specific configuration for `create_certificate_map_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_certificate_map_entry
                ##
                # RPC-specific configuration for `update_certificate_map_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_certificate_map_entry
                ##
                # RPC-specific configuration for `delete_certificate_map_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_certificate_map_entry
                ##
                # RPC-specific configuration for `list_dns_authorizations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_dns_authorizations
                ##
                # RPC-specific configuration for `get_dns_authorization`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_dns_authorization
                ##
                # RPC-specific configuration for `create_dns_authorization`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_dns_authorization
                ##
                # RPC-specific configuration for `update_dns_authorization`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_dns_authorization
                ##
                # RPC-specific configuration for `delete_dns_authorization`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_dns_authorization
                ##
                # RPC-specific configuration for `list_certificate_issuance_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_certificate_issuance_configs
                ##
                # RPC-specific configuration for `get_certificate_issuance_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_certificate_issuance_config
                ##
                # RPC-specific configuration for `create_certificate_issuance_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_certificate_issuance_config
                ##
                # RPC-specific configuration for `delete_certificate_issuance_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_certificate_issuance_config
                ##
                # RPC-specific configuration for `list_trust_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_trust_configs
                ##
                # RPC-specific configuration for `get_trust_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_trust_config
                ##
                # RPC-specific configuration for `create_trust_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_trust_config
                ##
                # RPC-specific configuration for `update_trust_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_trust_config
                ##
                # RPC-specific configuration for `delete_trust_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_trust_config

                # @private
                def initialize parent_rpcs = nil
                  list_certificates_config = parent_rpcs.list_certificates if parent_rpcs.respond_to? :list_certificates
                  @list_certificates = ::Gapic::Config::Method.new list_certificates_config
                  get_certificate_config = parent_rpcs.get_certificate if parent_rpcs.respond_to? :get_certificate
                  @get_certificate = ::Gapic::Config::Method.new get_certificate_config
                  create_certificate_config = parent_rpcs.create_certificate if parent_rpcs.respond_to? :create_certificate
                  @create_certificate = ::Gapic::Config::Method.new create_certificate_config
                  update_certificate_config = parent_rpcs.update_certificate if parent_rpcs.respond_to? :update_certificate
                  @update_certificate = ::Gapic::Config::Method.new update_certificate_config
                  delete_certificate_config = parent_rpcs.delete_certificate if parent_rpcs.respond_to? :delete_certificate
                  @delete_certificate = ::Gapic::Config::Method.new delete_certificate_config
                  list_certificate_maps_config = parent_rpcs.list_certificate_maps if parent_rpcs.respond_to? :list_certificate_maps
                  @list_certificate_maps = ::Gapic::Config::Method.new list_certificate_maps_config
                  get_certificate_map_config = parent_rpcs.get_certificate_map if parent_rpcs.respond_to? :get_certificate_map
                  @get_certificate_map = ::Gapic::Config::Method.new get_certificate_map_config
                  create_certificate_map_config = parent_rpcs.create_certificate_map if parent_rpcs.respond_to? :create_certificate_map
                  @create_certificate_map = ::Gapic::Config::Method.new create_certificate_map_config
                  update_certificate_map_config = parent_rpcs.update_certificate_map if parent_rpcs.respond_to? :update_certificate_map
                  @update_certificate_map = ::Gapic::Config::Method.new update_certificate_map_config
                  delete_certificate_map_config = parent_rpcs.delete_certificate_map if parent_rpcs.respond_to? :delete_certificate_map
                  @delete_certificate_map = ::Gapic::Config::Method.new delete_certificate_map_config
                  list_certificate_map_entries_config = parent_rpcs.list_certificate_map_entries if parent_rpcs.respond_to? :list_certificate_map_entries
                  @list_certificate_map_entries = ::Gapic::Config::Method.new list_certificate_map_entries_config
                  get_certificate_map_entry_config = parent_rpcs.get_certificate_map_entry if parent_rpcs.respond_to? :get_certificate_map_entry
                  @get_certificate_map_entry = ::Gapic::Config::Method.new get_certificate_map_entry_config
                  create_certificate_map_entry_config = parent_rpcs.create_certificate_map_entry if parent_rpcs.respond_to? :create_certificate_map_entry
                  @create_certificate_map_entry = ::Gapic::Config::Method.new create_certificate_map_entry_config
                  update_certificate_map_entry_config = parent_rpcs.update_certificate_map_entry if parent_rpcs.respond_to? :update_certificate_map_entry
                  @update_certificate_map_entry = ::Gapic::Config::Method.new update_certificate_map_entry_config
                  delete_certificate_map_entry_config = parent_rpcs.delete_certificate_map_entry if parent_rpcs.respond_to? :delete_certificate_map_entry
                  @delete_certificate_map_entry = ::Gapic::Config::Method.new delete_certificate_map_entry_config
                  list_dns_authorizations_config = parent_rpcs.list_dns_authorizations if parent_rpcs.respond_to? :list_dns_authorizations
                  @list_dns_authorizations = ::Gapic::Config::Method.new list_dns_authorizations_config
                  get_dns_authorization_config = parent_rpcs.get_dns_authorization if parent_rpcs.respond_to? :get_dns_authorization
                  @get_dns_authorization = ::Gapic::Config::Method.new get_dns_authorization_config
                  create_dns_authorization_config = parent_rpcs.create_dns_authorization if parent_rpcs.respond_to? :create_dns_authorization
                  @create_dns_authorization = ::Gapic::Config::Method.new create_dns_authorization_config
                  update_dns_authorization_config = parent_rpcs.update_dns_authorization if parent_rpcs.respond_to? :update_dns_authorization
                  @update_dns_authorization = ::Gapic::Config::Method.new update_dns_authorization_config
                  delete_dns_authorization_config = parent_rpcs.delete_dns_authorization if parent_rpcs.respond_to? :delete_dns_authorization
                  @delete_dns_authorization = ::Gapic::Config::Method.new delete_dns_authorization_config
                  list_certificate_issuance_configs_config = parent_rpcs.list_certificate_issuance_configs if parent_rpcs.respond_to? :list_certificate_issuance_configs
                  @list_certificate_issuance_configs = ::Gapic::Config::Method.new list_certificate_issuance_configs_config
                  get_certificate_issuance_config_config = parent_rpcs.get_certificate_issuance_config if parent_rpcs.respond_to? :get_certificate_issuance_config
                  @get_certificate_issuance_config = ::Gapic::Config::Method.new get_certificate_issuance_config_config
                  create_certificate_issuance_config_config = parent_rpcs.create_certificate_issuance_config if parent_rpcs.respond_to? :create_certificate_issuance_config
                  @create_certificate_issuance_config = ::Gapic::Config::Method.new create_certificate_issuance_config_config
                  delete_certificate_issuance_config_config = parent_rpcs.delete_certificate_issuance_config if parent_rpcs.respond_to? :delete_certificate_issuance_config
                  @delete_certificate_issuance_config = ::Gapic::Config::Method.new delete_certificate_issuance_config_config
                  list_trust_configs_config = parent_rpcs.list_trust_configs if parent_rpcs.respond_to? :list_trust_configs
                  @list_trust_configs = ::Gapic::Config::Method.new list_trust_configs_config
                  get_trust_config_config = parent_rpcs.get_trust_config if parent_rpcs.respond_to? :get_trust_config
                  @get_trust_config = ::Gapic::Config::Method.new get_trust_config_config
                  create_trust_config_config = parent_rpcs.create_trust_config if parent_rpcs.respond_to? :create_trust_config
                  @create_trust_config = ::Gapic::Config::Method.new create_trust_config_config
                  update_trust_config_config = parent_rpcs.update_trust_config if parent_rpcs.respond_to? :update_trust_config
                  @update_trust_config = ::Gapic::Config::Method.new update_trust_config_config
                  delete_trust_config_config = parent_rpcs.delete_trust_config if parent_rpcs.respond_to? :delete_trust_config
                  @delete_trust_config = ::Gapic::Config::Method.new delete_trust_config_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
