# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/capacityplanner/v1beta/usage_service_pb"
require "google/cloud/capacity_planner/v1beta/usage_service"

class ::Google::Cloud::CapacityPlanner::V1beta::UsageService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_query_usage_histories
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    location_level = :LOCATION_TYPE_UNSPECIFIED
    is_spot = true
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    confidential_mode = true
    gpu_type = "hello world"
    tpu_type = "hello world"
    cloud_resource_type = "hello world"
    usage_aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}

    query_usage_histories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_usage_histories, name
      assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal :LOCATION_TYPE_UNSPECIFIED, request["location_level"]
      assert_equal true, request["is_spot"]
      assert_equal "hello world", request["machine_family"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::MachineShape), request["machine_shape"]
      assert_equal "hello world", request["disk_type"]
      assert_equal true, request["confidential_mode"]
      assert_equal "hello world", request["gpu_type"]
      assert_equal "hello world", request["tpu_type"]
      assert_equal "hello world", request["cloud_resource_type"]
      assert_equal :AGGREGATION_METHOD_UNSPECIFIED, request["usage_aggregation_method"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["start_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["end_date"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_usage_histories_client_stub do
      # Create client
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_usage_histories({ parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_usage_histories parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_usage_histories ::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest.new(parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_usage_histories({ parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_usage_histories(::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest.new(parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_usage_histories_client_stub.call_rpc_count
    end
  end

  def test_query_forecasts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    confidential_mode = true
    gpu_type = "hello world"
    tpu_type = "hello world"
    cloud_resource_type = "hello world"
    forecast_type = :FORECAST_TYPE_UNSPECIFIED
    prediction_interval = :PREDICTION_INTERVAL_UNSPECIFIED
    aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED

    query_forecasts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_forecasts, name
      assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["machine_family"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::MachineShape), request["machine_shape"]
      assert_equal "hello world", request["disk_type"]
      assert_equal true, request["confidential_mode"]
      assert_equal "hello world", request["gpu_type"]
      assert_equal "hello world", request["tpu_type"]
      assert_equal "hello world", request["cloud_resource_type"]
      assert_equal :FORECAST_TYPE_UNSPECIFIED, request["forecast_type"]
      assert_equal :PREDICTION_INTERVAL_UNSPECIFIED, request["prediction_interval"]
      assert_equal :AGGREGATION_METHOD_UNSPECIFIED, request["aggregation_method"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_forecasts_client_stub do
      # Create client
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_forecasts parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_forecasts ::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_forecasts(::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_forecasts_client_stub.call_rpc_count
    end
  end

  def test_query_reservations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    location_level = :LOCATION_TYPE_UNSPECIFIED
    machine_family = "hello world"
    machine_shape = {}
    gpu_type = "hello world"
    cloud_resource_type = "hello world"
    reservation_type = :RESERVATION_TYPE_UNSPECIFIED
    share_type = :SHARE_TYPE_UNSPECIFIED
    ownership_type = :OWNERSHIP_TYPE_UNSPECIFIED
    reservation_data_level = :RESERVATION_DATA_LEVEL_UNSPECIFIED
    include_unapproved_reservations = true
    aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}

    query_reservations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_reservations, name
      assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal :LOCATION_TYPE_UNSPECIFIED, request["location_level"]
      assert_equal "hello world", request["machine_family"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::MachineShape), request["machine_shape"]
      assert_equal "hello world", request["gpu_type"]
      assert_equal "hello world", request["cloud_resource_type"]
      assert_equal :RESERVATION_TYPE_UNSPECIFIED, request["reservation_type"]
      assert_equal :SHARE_TYPE_UNSPECIFIED, request["share_type"]
      assert_equal :OWNERSHIP_TYPE_UNSPECIFIED, request["ownership_type"]
      assert_equal :RESERVATION_DATA_LEVEL_UNSPECIFIED, request["reservation_data_level"]
      assert_equal true, request["include_unapproved_reservations"]
      assert_equal :AGGREGATION_METHOD_UNSPECIFIED, request["aggregation_method"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["start_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["end_date"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_reservations_client_stub do
      # Create client
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_reservations({ parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_reservations parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_reservations ::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest.new(parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_reservations({ parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_reservations(::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest.new(parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_reservations_client_stub.call_rpc_count
    end
  end

  def test_export_usage_histories
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    is_spot = true
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    gpu_type = "hello world"
    tpu_type = "hello world"
    resource_type = "hello world"
    usage_aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}
    output_config = {}

    export_usage_histories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_usage_histories, name
      assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal true, request["is_spot"]
      assert_equal "hello world", request["machine_family"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::MachineShape), request["machine_shape"]
      assert_equal "hello world", request["disk_type"]
      assert_equal "hello world", request["gpu_type"]
      assert_equal "hello world", request["tpu_type"]
      assert_equal "hello world", request["resource_type"]
      assert_equal :AGGREGATION_METHOD_UNSPECIFIED, request["usage_aggregation_method"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["start_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["end_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::OutputConfig), request["output_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_usage_histories_client_stub do
      # Create client
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_usage_histories({ parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_usage_histories parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_usage_histories ::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest.new(parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_usage_histories({ parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_usage_histories(::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest.new(parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_usage_histories_client_stub.call_rpc_count
    end
  end

  def test_export_forecasts
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    gpu_type = "hello world"
    tpu_type = "hello world"
    resource_type = "hello world"
    prediction_interval = :PREDICTION_INTERVAL_UNSPECIFIED
    aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}
    output_config = {}

    export_forecasts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_forecasts, name
      assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["machine_family"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::MachineShape), request["machine_shape"]
      assert_equal "hello world", request["disk_type"]
      assert_equal "hello world", request["gpu_type"]
      assert_equal "hello world", request["tpu_type"]
      assert_equal "hello world", request["resource_type"]
      assert_equal :PREDICTION_INTERVAL_UNSPECIFIED, request["prediction_interval"]
      assert_equal :AGGREGATION_METHOD_UNSPECIFIED, request["aggregation_method"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["start_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["end_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::OutputConfig), request["output_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_forecasts_client_stub do
      # Create client
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_forecasts parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_forecasts ::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_forecasts(::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_forecasts_client_stub.call_rpc_count
    end
  end

  def test_export_reservations_usage
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    machine_family = "hello world"
    parent = "hello world"
    location_level = :LOCATION_TYPE_UNSPECIFIED
    cloud_resource_type = "hello world"
    usage_aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    share_type = :SHARE_TYPE_UNSPECIFIED
    start_date = {}
    end_date = {}
    output_config = {}

    export_reservations_usage_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_reservations_usage, name
      assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest, request
      assert_equal "hello world", request["machine_family"]
      assert_equal :machine_family, request.resource
      assert_equal "hello world", request["parent"]
      assert_equal :LOCATION_TYPE_UNSPECIFIED, request["location_level"]
      assert_equal "hello world", request["cloud_resource_type"]
      assert_equal :AGGREGATION_METHOD_UNSPECIFIED, request["usage_aggregation_method"]
      assert_equal :SHARE_TYPE_UNSPECIFIED, request["share_type"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["start_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["end_date"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::CapacityPlanner::V1beta::OutputConfig), request["output_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_reservations_usage_client_stub do
      # Create client
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_reservations_usage({ machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_reservations_usage machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_reservations_usage ::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest.new(machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_reservations_usage({ machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_reservations_usage(::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest.new(machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_reservations_usage_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Operations, client.operations_client
  end
end
