# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/capacityplanner/v1beta/usage_service_pb"
require "google/cloud/capacity_planner/v1beta/usage_service/rest"


class ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_query_usage_histories
    # Create test objects.
    client_result = ::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    location_level = :LOCATION_TYPE_UNSPECIFIED
    is_spot = true
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    confidential_mode = true
    gpu_type = "hello world"
    tpu_type = "hello world"
    cloud_resource_type = "hello world"
    usage_aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}

    query_usage_histories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ServiceStub.stub :transcode_query_usage_histories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_usage_histories_client_stub do
        # Create client
        client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_usage_histories({ parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_usage_histories parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_usage_histories ::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest.new(parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_usage_histories({ parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_usage_histories(::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest.new(parent: parent, location_level: location_level, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_usage_histories_client_stub.call_count
      end
    end
  end

  def test_query_forecasts
    # Create test objects.
    client_result = ::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    confidential_mode = true
    gpu_type = "hello world"
    tpu_type = "hello world"
    cloud_resource_type = "hello world"
    forecast_type = :FORECAST_TYPE_UNSPECIFIED
    prediction_interval = :PREDICTION_INTERVAL_UNSPECIFIED
    aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED

    query_forecasts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ServiceStub.stub :transcode_query_forecasts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_forecasts_client_stub do
        # Create client
        client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_forecasts parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_forecasts ::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_forecasts(::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, confidential_mode: confidential_mode, gpu_type: gpu_type, tpu_type: tpu_type, cloud_resource_type: cloud_resource_type, forecast_type: forecast_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_forecasts_client_stub.call_count
      end
    end
  end

  def test_query_reservations
    # Create test objects.
    client_result = ::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    location_level = :LOCATION_TYPE_UNSPECIFIED
    machine_family = "hello world"
    machine_shape = {}
    gpu_type = "hello world"
    cloud_resource_type = "hello world"
    reservation_type = :RESERVATION_TYPE_UNSPECIFIED
    share_type = :SHARE_TYPE_UNSPECIFIED
    ownership_type = :OWNERSHIP_TYPE_UNSPECIFIED
    reservation_data_level = :RESERVATION_DATA_LEVEL_UNSPECIFIED
    include_unapproved_reservations = true
    aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}

    query_reservations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ServiceStub.stub :transcode_query_reservations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_reservations_client_stub do
        # Create client
        client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_reservations({ parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_reservations parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_reservations ::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest.new(parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_reservations({ parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_reservations(::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest.new(parent: parent, location_level: location_level, machine_family: machine_family, machine_shape: machine_shape, gpu_type: gpu_type, cloud_resource_type: cloud_resource_type, reservation_type: reservation_type, share_type: share_type, ownership_type: ownership_type, reservation_data_level: reservation_data_level, include_unapproved_reservations: include_unapproved_reservations, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_reservations_client_stub.call_count
      end
    end
  end

  def test_export_usage_histories
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    is_spot = true
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    gpu_type = "hello world"
    tpu_type = "hello world"
    resource_type = "hello world"
    usage_aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}
    output_config = {}

    export_usage_histories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ServiceStub.stub :transcode_export_usage_histories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_usage_histories_client_stub do
        # Create client
        client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_usage_histories({ parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_usage_histories parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_usage_histories ::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest.new(parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_usage_histories({ parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_usage_histories(::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest.new(parent: parent, is_spot: is_spot, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, usage_aggregation_method: usage_aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_usage_histories_client_stub.call_count
      end
    end
  end

  def test_export_forecasts
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    machine_family = "hello world"
    machine_shape = {}
    disk_type = "hello world"
    gpu_type = "hello world"
    tpu_type = "hello world"
    resource_type = "hello world"
    prediction_interval = :PREDICTION_INTERVAL_UNSPECIFIED
    aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    start_date = {}
    end_date = {}
    output_config = {}

    export_forecasts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ServiceStub.stub :transcode_export_forecasts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_forecasts_client_stub do
        # Create client
        client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_forecasts parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_forecasts ::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_forecasts({ parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_forecasts(::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest.new(parent: parent, machine_family: machine_family, machine_shape: machine_shape, disk_type: disk_type, gpu_type: gpu_type, tpu_type: tpu_type, resource_type: resource_type, prediction_interval: prediction_interval, aggregation_method: aggregation_method, start_date: start_date, end_date: end_date, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_forecasts_client_stub.call_count
      end
    end
  end

  def test_export_reservations_usage
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    machine_family = "hello world"
    parent = "hello world"
    location_level = :LOCATION_TYPE_UNSPECIFIED
    cloud_resource_type = "hello world"
    usage_aggregation_method = :AGGREGATION_METHOD_UNSPECIFIED
    share_type = :SHARE_TYPE_UNSPECIFIED
    start_date = {}
    end_date = {}
    output_config = {}

    export_reservations_usage_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ServiceStub.stub :transcode_export_reservations_usage_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_reservations_usage_client_stub do
        # Create client
        client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_reservations_usage({ machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_reservations_usage machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_reservations_usage ::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest.new(machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_reservations_usage({ machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_reservations_usage(::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest.new(machine_family: machine_family, parent: parent, location_level: location_level, cloud_resource_type: cloud_resource_type, usage_aggregation_method: usage_aggregation_method, share_type: share_type, start_date: start_date, end_date: end_date, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_reservations_usage_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client::Configuration, config
  end
end
