# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CapacityPlanner
      module V1beta
        # The `QueryUsageHistories` request.
        # Next : 16
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The compute engine resource and location for the time series
        #     values to return. The format is:
        #
        #         projects/{project}/locations/{location} or
        #         organizations/{organization}/locations/{location} or
        #         folders/{folder}/locations/{location}
        # @!attribute [rw] location_level
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries::LocationType]
        #     Optional. The location level of the reservations usage timeseries.
        # @!attribute [rw] is_spot
        #   @return [::Boolean]
        #     Optional. The is_spot flag is used to fetch the usage data for preemptible
        #     Resources.
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     The machine family for the `UsageHistory` values to return. Possible values
        #     include "n1", and "n2d". See
        #     https://cloud.google.com/compute/docs/machine-types for more examples.
        #     Empty machine_family will return results matching all machine families.
        # @!attribute [rw] machine_shape
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::MachineShape]
        #     Optional. The machine shape for the `UsageHistory` values to return.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Optional. The disk_type for the `UsageHistory` values to return request
        #     with persistent-disk cloud_resource_type. Empty disk_type will return
        #     results matching all disk types.
        # @!attribute [rw] confidential_mode
        #   @return [::Boolean]
        #     Optional. Whether the persistent disk is in confidential mode.
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     Optional. The GPU type for the `UsageHistory` values to return. Sample
        #     values are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
        #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
        #     will return results matching all GPUs.
        # @!attribute [rw] tpu_type
        #   @return [::String]
        #     Optional. The TPU type for the `UsageHistory` values to return. Empty
        #     tpu_type will return results matching all TPUs.
        # @!attribute [rw] cloud_resource_type
        #   @return [::String]
        #     Required. The resource for the `UsageHistory` values to return. Possible
        #     values include "gce-vcpus", "gce-ram", "gce-local-ssd",
        #     "gce-persistent-disk", "gce-gpu" and "gce-tpu". Empty cloud_resource_type
        #     will return results matching all resources.
        # @!attribute [rw] usage_aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     The method that should be used to convert sampled usage data to daily
        #     usage values.
        #     AGGREGATION_METHOD_UNSPECIFIED will return results matching all the
        #     aggregation methods.
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     Optional. The start date of reservations usage.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     Optional. The end date of reservations usage.
        class QueryUsageHistoriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `QueryUsageHistories` response.
        # @!attribute [rw] usage_histories
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::UsageHistory>]
        #     The usage histories that match the request.
        class QueryUsageHistoriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `QueryForecasts` request.
        # Next : 14
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The compute engine resource and location for the time series
        #     values to return. The format is:
        #
        #     projects/\\{project}/locations/\\{location} or
        #     organizations/\\{organization}/locations/\\{location} or
        #     folders/\\{folder}/locations/\\{location}
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     The machine family to use to select the `Forecast` values to return.
        #     Possible values include "n1", and "n2d".
        #     Empty machine_family will return results matching all machine families.
        # @!attribute [rw] machine_shape
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::MachineShape]
        #     Optional. The machine shape for the time series values to return.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Optional. The disk_type for the `Forecast` values to return with request
        #     persistent-disk cloud_resource_type.
        #     Empty disk_type will return results matching all disk types.
        # @!attribute [rw] confidential_mode
        #   @return [::Boolean]
        #     Optional. Whether the persistent disk is in confidential mode.
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     Optional. The GPU type for the `Forecast` values to return. Sample values
        #     are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
        #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
        #     will return results matching all GPUs.
        # @!attribute [rw] tpu_type
        #   @return [::String]
        #     Optional. The TPU type for the `Forecast` values to return. Empty tpu_type
        #     will return results matching all TPUs.
        # @!attribute [rw] cloud_resource_type
        #   @return [::String]
        #     Required. The resource for the `Forecast` values to return. Possible values
        #     include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-persistent-disk",
        #     "gce-gpu" and "gce-tpu". Empty cloud_resource_type will return results
        #     matching all resources.
        # @!attribute [rw] forecast_type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Forecast::ForecastType]
        #     The type of forecast to use to select the `Forecast` values to return.
        #     FORECAST_TYPE_UNSPECIFIED will return results matching all the forecast
        #     types.
        # @!attribute [rw] prediction_interval
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Forecast::PredictionInterval]
        #     The prediction interval to use to select the `Forecast` values to return.
        #     PREDICTION_INTERVAL_UNSPECIFIED will return results matching all prediction
        #     intervals.
        # @!attribute [rw] aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     Aggregation Method of the historical usage for which the forecast is
        #     generated
        class QueryForecastsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `QueryForecasts` response.
        # @!attribute [rw] forecasts
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::Forecast>]
        #     The forecasts that match the request.
        class QueryForecastsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `QueryReservations` request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The compute engine resource and location for the time series
        #     values to return. The format is:
        #
        #     projects/\\{project}/locations/\\{location} or
        #     organizations/\\{organization}/locations/\\{location} or
        #     folders/\\{folder}/locations/\\{location}
        # @!attribute [rw] location_level
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries::LocationType]
        #     Optional. The location level of the reservations usage timeseries.
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     Optional. The machine family to use to select the aggregate reserved values
        #     to return. Possible values include "n1", and "n2d" etc. Empty
        #     machine_family will return results matching all machine families.
        # @!attribute [rw] machine_shape
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::MachineShape]
        #     Optional. The machine_shape as a filter to select matching reservations.
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     Optional. The GPU type for the reserved values to return. Sample values
        #     are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
        #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
        #     will return results matching all GPUs.
        # @!attribute [rw] cloud_resource_type
        #   @return [::String]
        #     Required. The resource for the reserved values to return. Possible values
        #     include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-gpu" and "gce-vm".
        # @!attribute [rw] reservation_type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::ReservationType]
        #     Required. The Reservation type for example, future reservation request and
        #     allocation. If unspecified, all types are
        #     included.
        # @!attribute [rw] share_type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::ShareType]
        #     Optional. Types of share settings to filter reservations in response. If
        #     unspecified, all types are included.
        # @!attribute [rw] ownership_type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::OwnershipType]
        #     Optional. Types of ownerships to filter reservations based on.
        #     In case of OWNED, it filters reservations which are owned by selected
        #     parent project/folder/organization. If unspecified, all types are
        #     included.
        # @!attribute [rw] reservation_data_level
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::ReservationDataLevel]
        #     Required. Reservations output data format.
        # @!attribute [rw] include_unapproved_reservations
        #   @return [::Boolean]
        #     Optional. Whether to include pending for approval reservations in the
        #     response. This field is only applicable for future reservations.
        # @!attribute [rw] aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     Optional. Aggregation Method of the historical reservation usage
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     Optional. The start date of reservations usage.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     Optional. The end date of reservations usage.
        class QueryReservationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of the reservation
          module ReservationType
            # No reservation type specified.
            RESERVATION_TYPE_UNSPECIFIED = 0

            # Allocation refers to realized reservation either auto created or created
            # by the users on demand.
            RESERVATION_TYPE_ALLOCATION = 1

            # Future Reservation requests created by users.
            RESERVATION_TYPE_FUTURE_RESERVATION = 2

            # All reservations.
            RESERVATION_TYPE_ALL = 3
          end

          # Possible scope in which the reservation can be shared.
          module ShareType
            # No share type specified.
            SHARE_TYPE_UNSPECIFIED = 0

            # Default value, for which reservation is open to only owner project.
            SHARE_TYPE_LOCAL = 1

            # Shared-reservation is open to specific projects.
            SHARE_TYPE_SPECIFIC_PROJECTS = 2
          end

          # Reservation ownership status to provide distinction for Capacity Planning.
          module OwnershipType
            # No ownership status specified.
            OWNERSHIP_TYPE_UNSPECIFIED = 0

            # For the reservations owned within selected Google Cloud Platform Resource
            # Container (project/folder/organization).
            OWNERSHIP_TYPE_OWNED = 1

            # For the reservations consumable within selected Google Cloud Platform
            # Resource Container (project/folder/organization), but not owned by them.
            OWNERSHIP_TYPE_SHARED_BY_OTHERS = 2
          end

          # The form in which data of reservations should be returned.
          # In case of AGGREGATED, timeseries for selected reservations is returned. If
          # unspecified, all levels are included.
          module ReservationDataLevel
            # No reservation data level specified.
            RESERVATION_DATA_LEVEL_UNSPECIFIED = 0

            # aggregated reservations data in a timeseries or aggregation over
            # timeseries.
            RESERVATION_DATA_LEVEL_AGGREGATED = 1

            # per reservation detail which is equivalent of Arcus Future Reservation or
            # Allocation with only limited fields which are useful for Capacity
            # Planning.
            RESERVATION_DATA_LEVEL_PER_RESERVATION = 2
          end
        end

        # The `QueryReservations` response.
        # @!attribute [rw] reservations
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::ReservationData>]
        #     The reservations data that match the request.
        class QueryReservationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single data point in a time series.
        # @!attribute [rw] event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time which the data point applies.
        # @!attribute [rw] value
        #   @return [::Float]
        #     The value of the data point.
        class Point
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of data points that describes the predicted time-varying values
        # of a resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the connection in the form of:
        #     `projects/{project_id}/locations/{location_id}/forecasts/{forecast_id}` or
        #     `organizations/{organization_id}/locations/{location_id}/forecasts/{forecast_id}`
        #     or `folders/{folder_id}/locations/{location_id}/forecasts/{forecast_id}`
        # @!attribute [rw] time_series
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries]
        #     The collection of data points that represent the predicted values. Note
        #     that some of these values may be in the past (if, for example, the forecast
        #     was created in the past and predicted values for the present day).
        # @!attribute [rw] forecast_type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Forecast::ForecastType]
        #     The type of forecast.
        # @!attribute [rw] bounds
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Forecast::Bounds]
        #     The bounds represented by this forecast time series.
        # @!attribute [rw] prediction_interval
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Forecast::PredictionInterval]
        #     The prediction interval represented by the time series.
        # @!attribute [rw] aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     Aggregation Method of the historical usage for which the forecast is
        #     generated
        class Forecast
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the forecast. This describes the method that was used to
          # produce future time series values from historical time series values.
          module ForecastType
            # No forecast type is specified.
            FORECAST_TYPE_UNSPECIFIED = 0

            # Statistical forecast.
            STATISTICAL = 1

            # Statistical forecast that attempts to predict the seasonal affects of
            # Black Friday and Cyber Monday.
            STATISTICAL_WITH_BFCM = 2

            # Yearly Seasonality model provides generic seasonality beyond BFCM.
            YEARLY_SEASONALITY = 3
          end

          # The bounds of the forecast time series.
          module Bounds
            # No bounds is specified.
            BOUNDS_UNSPECIFIED = 0

            # The time series represents the upper bound of the forecast.
            LOWER_BOUND = 1

            # The time series represents the median expected forecast value.
            MEDIAN = 2

            # The time series represents the lower bound of the forecast.
            UPPER_BOUND = 3
          end

          # The prediction interval represented by a forecast.
          module PredictionInterval
            # No prediction interval is specified.
            PREDICTION_INTERVAL_UNSPECIFIED = 0

            # This represents a prediction interval that has 90% confidence. For
            # example, for a symmetric prediction interval, a `PredictionInterval`
            # of `PREDICTION_INTERVAL_90` means that the `UPPER_BOUND` will represent
            # the 95th precentile.
            PREDICTION_INTERVAL_90 = 1

            # This represents a prediction interval that has 50% confidence. For
            # example, for a symmetric prediction interval, a `PredictionInterval`
            # of `PREDICTION_INTERVAL_50` means that the `UPPER_BOUND` will represent
            # the 75th precentile.
            PREDICTION_INTERVAL_50 = 2
          end
        end

        # A collection of data points that describes the historical time-varying values
        # of a resource.
        # @!attribute [rw] time_series
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries]
        #     The collection of data points that represent the historical values.
        # @!attribute [rw] aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     Method used to convert sampled usage data to time series values.
        class UsageHistory
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Methods for converting sampled data to time series values.
          module AggregationMethod
            # No aggregation method is specified.
            AGGREGATION_METHOD_UNSPECIFIED = 0

            MEDIAN = 1

            # Time series values represent the 99th percentile of the sampled values.
            PEAK = 2

            # Time series values represent the 50th(median) percentile of the sampled
            # values.
            P50 = 3

            # Time series values represent the 75th percentile of the sampled values.
            P75 = 4

            # Time series values represent the 99th percentile of the sampled values.
            P99 = 5
          end
        end

        # A collection of data points that describes the time-varying values of a
        # resource. A time series is identified by its ID.
        # Next : 13
        # @!attribute [rw] location_type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries::LocationType]
        #     Required. The type of location that the time series is summarizing.
        # @!attribute [rw] location
        #   @return [::String]
        #     Optional. The location of the usage data in time series.
        # @!attribute [rw] is_spot
        #   @return [::Boolean]
        #     Optional. The location of the usage data in time series.
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     The machine family for the time series values to return. Possible values
        #     include "n1" and "n2d".
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     The disk type for the time series values to return.
        # @!attribute [rw] confidential_mode
        #   @return [::Boolean]
        #     Optional. The confidential mode for disk.
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     The GPU type of the time series.
        # @!attribute [rw] tpu_type
        #   @return [::String]
        #     The TPU type of the time series.
        # @!attribute [rw] machine_shape
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::MachineShape]
        #     The machine shape of the time series.
        # @!attribute [rw] cloud_resource_type
        #   @return [::String]
        #     The resource for the time series values to return. Possible values include
        #     "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-persistent-disk", "gce-gpu",
        #     "gce-tpu" and "gce-vm".
        # @!attribute [rw] points
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::Point>]
        #     The data points of this time series. When listing time series, points are
        #     returned in chronological order.
        # @!attribute [rw] unit
        #   @return [::String]
        #     The units in which the values are reported.
        class TimeSeries
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of location that the time series is summarizing.
          module LocationType
            # No location type was specified.
            LOCATION_TYPE_UNSPECIFIED = 0

            # Time series values represent usage aggregated at the region level.
            REGIONAL = 1

            # Time series values represent usage aggregated at the zone level.
            ZONAL = 2
          end
        end

        # Response entity for reservations data.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the connection in the form of:
        #     `projects/{project_id}/locations/{location_id}/reservations/{reservation_id}`
        #     or
        #     `organizations/{organization_id}/locations/{location_id}/reservations/{reservation_id}`
        #     or
        #     `folders/{folder_id}/locations/{location_id}/reservations/{reservation_id}`
        # @!attribute [rw] time_series
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries]
        #     The collection of data points that represent the aggregated reserved value
        #     for reservations filtered by the criteria.
        # @!attribute [rw] used_reservation_values
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries]
        #     The collection of data points that represent the aggregated used value for
        #     reservations filtered by the criteria.
        # @!attribute [rw] future_reservations
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::FutureReservation>]
        #     Future reservations filtered by the criteria.
        # @!attribute [rw] allocations
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::Allocation>]
        #     Allocations filtered by the criteria.
        class ReservationData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Machine shape details
        # Next : 13
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     Optional. The VM family.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Optional. The characteristics of the sampled VM expressed as a string.
        # @!attribute [rw] machine_shape
        #   @return [::String]
        #     Optional. The customer visible string representing the type of VM.
        # @!attribute [rw] cpu_cores
        #   @return [::Float]
        #     Optional. Number of CPU cores per VM.
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     Optional. The type of GPU with the VM.
        # @!attribute [rw] gpu_compute_type
        #   @return [::String]
        #     Optional. The GPU name recognized by Compute Engine APIs.
        # @!attribute [rw] gpu_cores
        #   @return [::Integer]
        #     Optional. The number of GPU cores per VM.
        # @!attribute [rw] local_ssd_partitions
        #   @return [::Integer]
        #     Optional. The number of local SSD partitions per VM.
        # @!attribute [rw] local_ssd_gb
        #   @return [::Float]
        #     Optional. Total amount of local SSD storage.
        # @!attribute [rw] memory_gb
        #   @return [::Float]
        #     Optional. Total amount of memory with the VM.
        # @!attribute [rw] local_ssd_interface
        #   @return [::String]
        #     Optional. The local SSD interface used such as nvme or scsi
        # @!attribute [rw] min_cpu_platform
        #   @return [::String]
        #     Optional. The Min-cpu platform used such as icelake
        class MachineShape
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `ExportUsageHistories` request
        # Next : 12
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The compute engine resource and location for the time series
        #     values to return. The format is:
        #        projects/\\{project}/locations/\\{location} or
        #        organizations/\\{organization}/locations/\\{location} or
        #        folders/\\{folder}/locations/\\{location}
        # @!attribute [rw] is_spot
        #   @return [::Boolean]
        #     Optional. Set true to export usage for spot resources.
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     Optional. The machine family for the `UsageHistory` values to return.
        #     Possible values include "n1", and "n2d". See
        #     https://cloud.google.com/compute/docs/machine-types for more examples.
        # @!attribute [rw] machine_shape
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::MachineShape]
        #     Optional. The machine shape for the time series values to export.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Optional. The disk_type for the `UsageHistory` values to return request
        #     with persistent-disk resource_type. Possible values include "pd-ssd",
        #     "pd-standard", "pd-balanced", and "pd-extreme".
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     Optional. The GPU type for the `UsageHistory` values to return. Sample
        #     values are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
        #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
        #     will return results matching all GPUs.
        # @!attribute [rw] tpu_type
        #   @return [::String]
        #     Optional. The TPU type for the `UsageHistory` values to return. Empty
        #     tpu_type will return results matching all TPUs.
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     Required. The resource for the `UsageHistory` values to return. Possible
        #     values include "gce-vcpus", "gce-ram", "gce-local-ssd",
        #     "gce-persistent-disk", "gce-gpu" and "gce-tpu".
        # @!attribute [rw] usage_aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     Optional. The method that should be used to convert sampled usage data to
        #     daily usage values. AGGREGATION_METHOD_UNSPECIFIED will return results
        #     matching all the aggregation methods.
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     Optional. The start date of usage.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     Optional. The end date of usage.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::OutputConfig]
        #     Required. Output configuration indicating where the results will be output
        #     to.
        class ExportUsageHistoriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `ExportForecasts` request
        # Next : 13
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The compute engine resource and location for the time series
        #     values to return. The format is:
        #        projects/\\{project}/locations/\\{location} or
        #        organizations/\\{organization}/locations/\\{location} or
        #        folders/\\{folder}/locations/\\{location}
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     Optional. The machine family to use to select the `Forecast` values to
        #     return. Possible values include "n1", and "n2d".
        # @!attribute [rw] machine_shape
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::MachineShape]
        #     Optional. The machine shape for the time series values to export.
        # @!attribute [rw] disk_type
        #   @return [::String]
        #     Optional. The disk_type for the `Forecast` values to return with request
        #     persistent-disk resource_type.
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     Optional. The GPU type for the `Forecast` values to return. Sample values
        #     are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
        #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
        #     will return results matching all GPUs.
        # @!attribute [rw] tpu_type
        #   @return [::String]
        #     Optional. The TPU type for the `Forecast` values to return. Empty tpu_type
        #     will return results matching all TPUs.
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     Required. The resource for the `Forecast` values to return. Possible values
        #     include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-persistent-disk",
        #     "gce-gpu" and "gce-tpu".
        # @!attribute [rw] prediction_interval
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Forecast::PredictionInterval]
        #     Optional. The prediction interval to use to select the `Forecast` values to
        #     return. PREDICTION_INTERVAL_UNSPECIFIED will return results matching all
        #     prediction intervals.
        # @!attribute [rw] aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     Optional. Aggregation Method of the historical usage for which the forecast
        #     is generated.
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     Optional. The start date of forecasts.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     Optional. The end date of forecasts.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::OutputConfig]
        #     Required. Output configuration indicating where the results will be output
        #     to.
        class ExportForecastsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `ExportReservationsUsage` request
        # @!attribute [rw] machine_family
        #   @return [::String]
        #     Optional. The machine family to query reservations and usage by. For
        #     example: n1, n2d.
        #
        #     Note: The following fields are mutually exclusive: `machine_family`, `machine_shape`, `gpu_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] machine_shape
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::MachineShape]
        #     Optional. The machine_shape as a filter to select matching reservations
        #     and its usage.
        #
        #     Note: The following fields are mutually exclusive: `machine_shape`, `machine_family`, `gpu_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gpu_type
        #   @return [::String]
        #     Optional. The GPU type to query reservations and usage  by. For example:
        #     NVIDIA T4.
        #
        #     Note: The following fields are mutually exclusive: `gpu_type`, `machine_family`, `machine_shape`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The compute engine resource and location of the
        #     reservationsusage. The format is:
        #        projects/\\{project}/locations/\\{location} or
        #        organizations/\\{organization}/locations/\\{location} or
        #        folders/\\{folder}/locations/\\{location}
        # @!attribute [rw] location_level
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries::LocationType]
        #     Optional. The location level of the reservations usage timeseries.
        # @!attribute [rw] cloud_resource_type
        #   @return [::String]
        #     Required. The resource for the `ReservationsUsage` values to return.
        #     Possible values include "gce-vcpus", "gce-ram", "gce-local-ssd", and
        #     "gce-gpu".
        # @!attribute [rw] usage_aggregation_method
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
        #     Required. The method that should be used to convert sampled reservations
        #     data to daily usage values.
        # @!attribute [rw] share_type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest::ShareType]
        #     Optional. Type of share settings to filter reservations in response. If
        #     unspecified, all types are included.
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     Optional. The start date of reservations usage.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     Optional. The end date of reservations usage.
        # @!attribute [rw] output_config
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::OutputConfig]
        #     Required. Output configuration indicating where the results will be output
        #     to.
        class ExportReservationsUsageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible scope in which the reservation can be shared.
          module ShareType
            # No share type specified.
            SHARE_TYPE_UNSPECIFIED = 0

            # Default value, for which reservation is open to only owner project.
            SHARE_TYPE_LOCAL = 1

            # Shared-reservation is open to specific projects.
            SHARE_TYPE_SPECIFIC_PROJECTS = 2
          end
        end

        # Output configuration for export destination.
        # @!attribute [rw] gcs_destination
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::GcsDestination]
        #     Destination on Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `gcs_destination`, `bigquery_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_destination
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::BigQueryDestination]
        #     Destination on BigQuery.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_destination`, `gcs_destination`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OutputConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Cloud Storage location.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Optional. The path to the file in Cloud Storage where the export will be
        #     stored. The URI is in the form `gs://bucketName/fileName`. If the file
        #     already exists, the request succeeds, but the operation fails.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Required. The bucket name to which the export will be stored.
        # @!attribute [rw] object
        #   @return [::String]
        #     Required. The object name to which the export will be stored.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. Flag to indicate overwrite in case file already exists.
        class GcsDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A BigQuery destination for exporting assets to.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The BigQuery dataset in format
        #     "projects/\\{projectId}/datasets/\\{datasetId}", to which the snapshot result
        #     should be exported. If this dataset does not exist, the export call returns
        #     an INVALID_ARGUMENT error.
        # @!attribute [rw] table
        #   @return [::String]
        #     Required. The BigQuery table to which the snapshot result should be
        #     written.
        # @!attribute [rw] partition_key
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::BigQueryDestination::PartitionKey]
        #     Optional. The partition key for BigQuery partitioned table.
        # @!attribute [rw] write_disposition
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::BigQueryDestination::WriteDisposition]
        #     Optional. Specifies the action that occurs if the destination table or
        #     partition already exists.
        # @!attribute [rw] create_disposition
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::BigQueryDestination::CreateDisposition]
        #     Optional. Specifies the action that occurs if the destination table does
        #     not exist
        # @!attribute [rw] gcs_location
        #   @return [::String]
        #     Optional. Specifies the Cloud Storage location.
        #     Users can choose to provide a location for Cloud Storage bucket to store
        #     the exported data. (as it is possible that some locations are restricted
        #     via org policy for that project) Temporary Cloud Storage bucket creation is
        #     an interim step for BigQuery upload. If no value is provided, the default
        #     location used will be 'US'.
        class BigQueryDestination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This enum determines the partition key column for the BigQuery tables.
          # Partitioning can improve query performance and reduce query cost by
          # filtering partitions. Refer to
          # https://cloud.google.com/bigquery/docs/partitioned-tables for details.
          module PartitionKey
            # Unspecified partition key. Tables won't be partitioned using this
            # option.
            PARTITION_KEY_UNSPECIFIED = 0

            # The time when the request is received. If specified as partition key,
            # the result table(s) is partitioned by the RequestTime column, an
            # additional timestamp column representing when the request was received.
            REQUEST_TIME = 1
          end

          # Specifies the action that occurs if the destination table or partition
          # already exists. By default, the data will be appended to the existing
          # table.
          module WriteDisposition
            # Unspecified write disposition.
            WRITE_DISPOSITION_UNSPECIFIED = 0

            # If the table or partition already exists, BigQuery appends the data to
            # the table or the latest partition.
            WRITE_APPEND = 1

            # If the table or partition already exists, BigQuery overwrites the entire
            # table or all the partitions data.
            WRITE_TRUNCATE = 2

            # If the table already exists and contains data, an error is returned.
            WRITE_EMPTY = 3
          end

          # Specifies the action that occurs if the destination table does not exist.
          # By default, a new table will be created.
          module CreateDisposition
            # Unspecified create disposition.
            CREATE_DISPOSITION_UNSPECIFIED = 0

            # If the table does not exist, BigQuery creates the table.
            CREATE_IF_NEEDED = 1

            # If the table does not exist, an error will be returned.
            CREATE_NEVER = 2
          end
        end

        # Represents the metadata of a long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for [UsageService.ExportUsageHistories].
        # @!attribute [rw] response
        #   @return [::String]
        #     The response message for the usage history export. In case of bigquery,
        #     it will also contain job id.
        class ExportUsageHistoriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for [UsageService.ExportForecasts].
        # @!attribute [rw] response
        #   @return [::String]
        #     The response message for the forecast export. In case of bigquery,
        #     it will also contain job id.
        class ExportForecastsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A response message for [UsageService.ExportReservationsUsage].
        # @!attribute [rw] response
        #   @return [::String]
        #     The response message for the reservations usage export. In case of
        #     bigquery, it will also contain job id.
        class ExportReservationsUsageResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
