# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CapacityPlanner
      module V1beta
        # The resource container of Google Cloud Platform hierarchy such as a project.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::ResourceContainer::Type]
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. Identifier of the resource container. For example, project number
        #     for project type.
        class ResourceContainer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          module Type
            TYPE_UNSPECIFIED = 0

            PROJECT = 1

            FOLDER = 2

            ORG = 3
          end
        end

        # The id for a Google Cloud Platform resource key.
        # @!attribute [rw] resource_code
        #   @return [::String]
        #     Required. resource_code for the resource. eg: gce-ram, gce-vcpus,
        #     gce-gpu, gce-tpu, gce-vm, gce-persistent-disk, gce-local-ssd.
        # @!attribute [rw] resource_id
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::ResourceIdentifier]
        #     Required. Id of the resource.
        class ResourceIdKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The identifier for a Google Cloud Platform resource.
        # @!attribute [rw] service_name
        #   @return [::String]
        # @!attribute [rw] resource_name
        #   @return [::String]
        # @!attribute [rw] resource_attributes
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::ResourceAttribute>]
        class ResourceIdentifier
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An attribute of a Google Cloud Platform resource.
        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::ResourceValue]
        class ResourceAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] unit
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Unit]
        # @!attribute [rw] value
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Value]
        class ResourceValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] int64_value
        #   @return [::Integer]
        #     Note: The following fields are mutually exclusive: `int64_value`, `string_value`, `double_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     Note: The following fields are mutually exclusive: `string_value`, `int64_value`, `double_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] double_value
        #   @return [::Float]
        #     Note: The following fields are mutually exclusive: `double_value`, `int64_value`, `string_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     Note: The following fields are mutually exclusive: `bool_value`, `int64_value`, `string_value`, `double_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Value
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        module Unit
          UNIT_UNSPECIFIED = 0

          UNIT_COUNT = 1

          # Kilobytes (10^3 bytes)
          KB = 2

          # Gigabytes (10^9 bytes)
          GB = 3

          # Terabytes (10^12 bytes)
          TB = 4

          # Mebibytes (2^20 bytes)
          MIB = 17

          # Gibibytes (2^30 bytes)
          GIB = 5

          # Tebibytes (2^40 bytes)
          TIB = 6

          # Queries per second
          QPS = 7

          # Megabytes (10^6 bytes)
          MB = 8

          # Pebibytes (2^50 bytes)
          PIB = 9

          # Terabits (10^12 bits) per second
          TBPS = 10

          GBPS_BITS = 11

          GIB_BITS = 12

          MBPS_BITS = 13

          MBPS_BYTES = 14

          TBPS_BITS = 15

          TBPS_BYTES = 16

          KOPS = 18
        end
      end
    end
  end
end
