# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CapacityPlanner
      module V1beta
        # Identifier for a Google Cloud Platform location.
        # @!attribute [rw] location_level
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::LocationLevel]
        #     The location level such as a region.
        # @!attribute [rw] source
        #   @return [::String]
        #     Required. Location where resource is sourced. For Cloud Storage, the
        #     alphabetically first location is the source.
        # @!attribute [rw] linked_locations
        #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::LocationIdentifier::LinkedLocation>]
        #     Optional. Other linked locations.
        class LocationIdentifier
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] location_level
          #   @return [::Google::Cloud::CapacityPlanner::V1beta::LocationLevel]
          #     The location level such as a region.
          # @!attribute [rw] location
          #   @return [::String]
          #     Required. The linked cloud location.
          # @!attribute [rw] label
          #   @return [::String]
          class LinkedLocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The level of the Google Cloud Platform location.
        module LocationLevel
          # Location level is unspecified.
          LOCATION_LEVEL_UNSPECIFIED = 0

          # Cloud region.
          REGION = 1

          # Cloud zone.
          ZONE = 2

          # Globally.
          GLOBAL = 3

          # A metro.
          METRO = 4

          # Dual region pair.
          DUAL_REGION = 5

          # Multiple regions.
          MULTI_REGION = 6
        end
      end
    end
  end
end
