# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CapacityPlanner
      module V1beta
        # Repesents Future Reservation request which is part of aggregated
        # reservations data response of "QueryReservations".
        # @!attribute [rw] specific_sku_properties
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::FutureReservation::SpecificSKUProperties]
        #     Future Reservation configuration to indicate instance properties and
        #     total count.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     A unique identifier for this future reservation. The server
        #     defines this identifier.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation timestamp for this future reservation.
        # @!attribute [rw] zone
        #   @return [::String]
        #     URL of the Zone where this future reservation resides.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the future reservation provided by user.
        # @!attribute [rw] future_reservation
        #   @return [::String]
        #     The future reservation resource name.
        # @!attribute [rw] owner_project_id
        #   @return [::String]
        # @!attribute [rw] time_window
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::FutureReservation::TimeWindow]
        #     Time window for this Future Reservation.
        # @!attribute [rw] share_settings
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::ShareSettings]
        #     List of Projects/Folders to share with.
        # @!attribute [rw] name_prefix
        #   @return [::String]
        #     Name prefix for the reservations to be created at the time of
        #     delivery. The name prefix must comply with RFC1035.
        #     Maximum allowed length for name prefix is 20. Automatically created
        #     reservations name format will be <name-prefix>-date-####.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::FutureReservation::Status]
        #     Status of the Future Reservation
        # @!attribute [rw] auto_created_reservations_delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Future timestamp when the FR auto-created reservations will be deleted by
        #     Compute Engine. Format of this field must be a valid RFC3339 value.
        # @!attribute [rw] auto_delete_auto_created_reservations
        #   @return [::Boolean]
        #     Setting for enabling or disabling automatic deletion for auto-created
        #     reservation. If set to true, auto-created reservations will be
        #     deleted at Future Reservation's end time (default) or at user's defined
        #     timestamp if any of the
        #     [auto_created_reservations_delete_time, auto_created_reservations_duration]
        #     values is specified.
        #     For keeping auto-created reservation indefinitely, this value should be set
        #     to false.
        class FutureReservation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents specific SKU properties for the Future Reservation.
          # @!attribute [rw] instance_properties
          #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::SpecificSKUAllocation::AllocatedInstanceProperties]
          #     Properties of the SKU instances being reserved.
          # @!attribute [rw] total_count
          #   @return [::Integer]
          #     Total number of instances for which capacity assurance is requested at a
          #     future time period.
          class SpecificSKUProperties
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents time window for the Future Reservation.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Start time of the Future Reservation.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     End time of the Future Reservation.
          class TimeWindow
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents status related to the future reservation.
          # @!attribute [rw] procurement_status
          #   @return [::Google::Cloud::CapacityPlanner::V1beta::FutureReservation::Status::ProcurementStatus]
          #     Current state of this Future Reservation
          # @!attribute [rw] lock_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Time when Future Reservation would become LOCKED, after which no
          #     modifications to Future Reservation will be allowed. Applicable only
          #     after the Future Reservation is in the APPROVED state. The lock_time is
          #     an RFC3339 string. The procurement_status will transition to PROCURING
          #     state at this time.
          # @!attribute [rw] auto_created_reservations
          #   @return [::Array<::String>]
          #     Fully qualified urls of the automatically created reservations at
          #     start_time.
          # @!attribute [rw] fulfilled_count
          #   @return [::Integer]
          #     This count indicates the fulfilled capacity so far. This is set during
          #     "PROVISIONING" state. This count also includes capacity delivered as part
          #     of existing matching reservations.
          class Status
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents procurement status of the Future Reservation.
            module ProcurementStatus
              # This is unused status value.
              PROCUREMENT_STATUS_UNSPECIFIED = 0

              # Future reservation is pending approval by Google Cloud Platform.
              PENDING_APPROVAL = 1

              # Future reservation is approved by Google Cloud Platform.
              APPROVED = 2

              # Future reservation is committed by the customer.
              COMMITTED = 3

              # Future reservation is rejected by Google Cloud Platform.
              DECLINED = 4

              # Future reservation is cancelled by the customer.
              CANCELLED = 5

              # Future reservation is being procured by Google Cloud Platform. Beyond
              # this point, Future reservation is locked and no further modifications
              # are allowed.
              PROCURING = 6

              # Future reservation capacity is being provisioned. This state will be
              # entered after start_time, while reservations are being created to
              # provide total_count reserved instance slots. This state will not
              # persist past start_time + 24h.
              PROVISIONING = 7

              # Future reservation is fulfilled completely.
              FULFILLED = 8

              # Future reservation failed. No additional reservations were provided.
              FAILED = 9

              # Future reservation is partially fulfilled. Additional reservations were
              # provided but did not reach total_count reserved instance slots.
              FAILED_PARTIALLY_FULFILLED = 10

              # Related status for PlanningStatus.Draft. Transitions to
              # PENDING_APPROVAL upon user submitting FR.
              DRAFTING = 11

              # An Amendment to the Future Reservation has been requested. If the
              # Amendment is declined, the Future Reservation will be restored to the
              # last known good state.
              PENDING_AMENDMENT_APPROVAL = 12
            end
          end
        end
      end
    end
  end
end
