# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module CapacityPlanner
      module V1beta
        # Repesents Allocation which is part of aggregated
        # reservations data response of "QueryReservations".
        # @!attribute [rw] specific_allocation
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::SpecificSKUAllocation]
        #     Reservation for instances with specific machine shapes.
        # @!attribute [rw] id
        #   @return [::Integer]
        #     The unique identifier for the resource. This identifier is
        #     defined by the server.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation timestamp for this allocation.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Zone in which the reservation resides.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description while creating reservation.
        # @!attribute [rw] allocation
        #   @return [::String]
        #     The reservation resource name.
        # @!attribute [rw] owner_project_id
        #   @return [::String]
        # @!attribute [rw] status
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::Status]
        #     The status of the reservation.
        # @!attribute [rw] share_settings
        #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::ShareSettings]
        #     Specify share-settings to create a shared reservation.
        # @!attribute [rw] auto_delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Absolute time in future when the reservation will be
        #     auto-deleted by Compute Engine.
        class Allocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This reservation type allows to pre allocate specific instance
          # configuration.
          # @!attribute [rw] instance_properties
          #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::SpecificSKUAllocation::AllocatedInstanceProperties]
          #     The instance properties for the reservation.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     Specifies the number of resources that are allocated.
          # @!attribute [rw] used_count
          #   @return [::Integer]
          #     Indicates how many instances are in use.
          # @!attribute [rw] assured_count
          #   @return [::Integer]
          #     Indicates how many instances are actually usable currently.
          class SpecificSKUAllocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Properties of the SKU instances being reserved.
            # @!attribute [rw] machine_type
            #   @return [::String]
            #     Specifies type of machine (name only) which has fixed number of vCPUs
            #     and fixed amount of memory. This also includes specifying custom
            #     machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
            # @!attribute [rw] guest_accelerator
            #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::Allocation::SpecificSKUAllocation::AllocatedInstanceProperties::AcceleratorConfig>]
            #     Specifies accelerator type and count.
            # @!attribute [rw] min_cpu_platform
            #   @return [::String]
            #     Minimum cpu platform the reservation.
            # @!attribute [rw] local_ssd
            #   @return [::Array<::Google::Cloud::CapacityPlanner::V1beta::Allocation::SpecificSKUAllocation::AllocatedInstanceProperties::AllocatedDisk>]
            #     Specifies amount of local ssd to reserve with each instance. The type
            #     of disk is local-ssd.
            class AllocatedInstanceProperties
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # A specification of the type and number of accelerator cards attached to
              # the instance.
              # @!attribute [rw] type
              #   @return [::String]
              #     Accelerator name.
              #     See https://cloud.google.com/compute/docs/gpus/#introduction for a
              #     full list of accelerator types.
              # @!attribute [rw] count
              #   @return [::Integer]
              #     The number of the guest accelerator cards exposed to this instance.
              class AcceleratorConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # A specification of the interface and size of disk attached to
              # the instance.
              # @!attribute [rw] disk_size_gb
              #   @return [::Integer]
              #     Specifies the size of the disk in base-2 GB.
              # @!attribute [rw] disk_interface
              #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::SpecificSKUAllocation::AllocatedInstanceProperties::AllocatedDisk::DiskInterface]
              #     Specifies the disk interface to use for attaching this disk, which is
              #     either SCSI or NVME. The default is SCSI.
              class AllocatedDisk
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # guest device interface options to use for the disk.
                module DiskInterface
                  # Default value. This value is unused.
                  DISK_INTERFACE_UNSPECIFIED = 0

                  # SCSI disk interface.
                  SCSI = 1

                  # NVME disk interface.
                  NVME = 2

                  # NVDIMM disk interface.
                  NVDIMM = 3

                  # ISCSI disk interface.
                  ISCSI = 4
                end
              end
            end
          end

          # The share setting for reservation.
          # @!attribute [rw] share_type
          #   @return [::Google::Cloud::CapacityPlanner::V1beta::Allocation::ShareSettings::ShareType]
          #     Type of sharing for this shared-reservation
          # @!attribute [rw] projects
          #   @return [::Array<::String>]
          #     A List of Project names to specify consumer projects for this
          #     shared-reservation. This is only valid when share_type's value is
          #     SPECIFIC_PROJECTS.
          class ShareSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible scope in which the reservation can be shared. More granularity
            # can be added in future.
            module ShareType
              # Default value. This value is unused.
              SHARE_TYPE_UNSPECIFIED = 0

              # Shared-reservation is open to entire Organization
              ORGANIZATION = 1

              # Shared-reservation is open to specific projects
              SPECIFIC_PROJECTS = 2

              # Default value.
              LOCAL = 3

              # Shared-reservation is open to direct child projects of specific
              # folders.
              DIRECT_PROJECTS_UNDER_SPECIFIC_FOLDERS = 4
            end
          end

          # The status of the reservation.
          module Status
            # Default value. This value is unused.
            STATUS_UNSPECIFIED = 0

            # Invalid Reservation
            INVALID = 1

            # Resources are being allocated for the reservation.
            CREATING = 2

            # Reservation has allocated all its resources.
            READY = 3

            # Reservation is currently being deleted.
            DELETING = 4

            # Reservation is currently being resized.
            UPDATING = 5
          end
        end
      end
    end
  end
end
