# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/capacityplanner/v1beta/usage_service_pb"
require "google/cloud/capacity_planner/v1beta/usage_service/rest/service_stub"

module Google
  module Cloud
    module CapacityPlanner
      module V1beta
        module UsageService
          module Rest
            ##
            # REST client for the UsageService service.
            #
            # Provides access to historical and forecasted usage data.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "capacityplanner.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :usage_service_stub

              ##
              # Configure the UsageService Client class.
              #
              # See {::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all UsageService clients
              #   ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "CapacityPlanner", "V1beta"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4, 13]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the UsageService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @usage_service_stub.universe_domain
              end

              ##
              # Create a new UsageService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the UsageService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @usage_service_stub = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @usage_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @usage_service_stub.logger
              end

              # Service calls

              ##
              # Returns a list of the usage histories that are in the parent parameter
              # and match your specified filters.
              #
              # @overload query_usage_histories(request, options = nil)
              #   Pass arguments to `query_usage_histories` via a request object, either of type
              #   {::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload query_usage_histories(parent: nil, location_level: nil, is_spot: nil, machine_family: nil, machine_shape: nil, disk_type: nil, confidential_mode: nil, gpu_type: nil, tpu_type: nil, cloud_resource_type: nil, usage_aggregation_method: nil, start_date: nil, end_date: nil)
              #   Pass arguments to `query_usage_histories` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The compute engine resource and location for the time series
              #     values to return. The format is:
              #
              #         projects/{project}/locations/{location} or
              #         organizations/{organization}/locations/{location} or
              #         folders/{folder}/locations/{location}
              #   @param location_level [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries::LocationType]
              #     Optional. The location level of the reservations usage timeseries.
              #   @param is_spot [::Boolean]
              #     Optional. The is_spot flag is used to fetch the usage data for preemptible
              #     Resources.
              #   @param machine_family [::String]
              #     The machine family for the `UsageHistory` values to return. Possible values
              #     include "n1", and "n2d". See
              #     https://cloud.google.com/compute/docs/machine-types for more examples.
              #     Empty machine_family will return results matching all machine families.
              #   @param machine_shape [::Google::Cloud::CapacityPlanner::V1beta::MachineShape, ::Hash]
              #     Optional. The machine shape for the `UsageHistory` values to return.
              #   @param disk_type [::String]
              #     Optional. The disk_type for the `UsageHistory` values to return request
              #     with persistent-disk cloud_resource_type. Empty disk_type will return
              #     results matching all disk types.
              #   @param confidential_mode [::Boolean]
              #     Optional. Whether the persistent disk is in confidential mode.
              #   @param gpu_type [::String]
              #     Optional. The GPU type for the `UsageHistory` values to return. Sample
              #     values are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
              #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
              #     will return results matching all GPUs.
              #   @param tpu_type [::String]
              #     Optional. The TPU type for the `UsageHistory` values to return. Empty
              #     tpu_type will return results matching all TPUs.
              #   @param cloud_resource_type [::String]
              #     Required. The resource for the `UsageHistory` values to return. Possible
              #     values include "gce-vcpus", "gce-ram", "gce-local-ssd",
              #     "gce-persistent-disk", "gce-gpu" and "gce-tpu". Empty cloud_resource_type
              #     will return results matching all resources.
              #   @param usage_aggregation_method [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
              #     The method that should be used to convert sampled usage data to daily
              #     usage values.
              #     AGGREGATION_METHOD_UNSPECIFIED will return results matching all the
              #     aggregation methods.
              #   @param start_date [::Google::Type::Date, ::Hash]
              #     Optional. The start date of reservations usage.
              #   @param end_date [::Google::Type::Date, ::Hash]
              #     Optional. The end date of reservations usage.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/capacity_planner/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest.new
              #
              #   # Call the query_usage_histories method.
              #   result = client.query_usage_histories request
              #
              #   # The returned object is of type Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesResponse.
              #   p result
              #
              def query_usage_histories request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CapacityPlanner::V1beta::QueryUsageHistoriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.query_usage_histories.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CapacityPlanner::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.query_usage_histories.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.query_usage_histories.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @usage_service_stub.query_usage_histories request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of the forecasts that are in the parent parameter
              # and match your specified filters.
              #
              # @overload query_forecasts(request, options = nil)
              #   Pass arguments to `query_forecasts` via a request object, either of type
              #   {::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload query_forecasts(parent: nil, machine_family: nil, machine_shape: nil, disk_type: nil, confidential_mode: nil, gpu_type: nil, tpu_type: nil, cloud_resource_type: nil, forecast_type: nil, prediction_interval: nil, aggregation_method: nil)
              #   Pass arguments to `query_forecasts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The compute engine resource and location for the time series
              #     values to return. The format is:
              #
              #     projects/\\{project}/locations/\\{location} or
              #     organizations/\\{organization}/locations/\\{location} or
              #     folders/\\{folder}/locations/\\{location}
              #   @param machine_family [::String]
              #     The machine family to use to select the `Forecast` values to return.
              #     Possible values include "n1", and "n2d".
              #     Empty machine_family will return results matching all machine families.
              #   @param machine_shape [::Google::Cloud::CapacityPlanner::V1beta::MachineShape, ::Hash]
              #     Optional. The machine shape for the time series values to return.
              #   @param disk_type [::String]
              #     Optional. The disk_type for the `Forecast` values to return with request
              #     persistent-disk cloud_resource_type.
              #     Empty disk_type will return results matching all disk types.
              #   @param confidential_mode [::Boolean]
              #     Optional. Whether the persistent disk is in confidential mode.
              #   @param gpu_type [::String]
              #     Optional. The GPU type for the `Forecast` values to return. Sample values
              #     are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
              #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
              #     will return results matching all GPUs.
              #   @param tpu_type [::String]
              #     Optional. The TPU type for the `Forecast` values to return. Empty tpu_type
              #     will return results matching all TPUs.
              #   @param cloud_resource_type [::String]
              #     Required. The resource for the `Forecast` values to return. Possible values
              #     include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-persistent-disk",
              #     "gce-gpu" and "gce-tpu". Empty cloud_resource_type will return results
              #     matching all resources.
              #   @param forecast_type [::Google::Cloud::CapacityPlanner::V1beta::Forecast::ForecastType]
              #     The type of forecast to use to select the `Forecast` values to return.
              #     FORECAST_TYPE_UNSPECIFIED will return results matching all the forecast
              #     types.
              #   @param prediction_interval [::Google::Cloud::CapacityPlanner::V1beta::Forecast::PredictionInterval]
              #     The prediction interval to use to select the `Forecast` values to return.
              #     PREDICTION_INTERVAL_UNSPECIFIED will return results matching all prediction
              #     intervals.
              #   @param aggregation_method [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
              #     Aggregation Method of the historical usage for which the forecast is
              #     generated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/capacity_planner/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest.new
              #
              #   # Call the query_forecasts method.
              #   result = client.query_forecasts request
              #
              #   # The returned object is of type Google::Cloud::CapacityPlanner::V1beta::QueryForecastsResponse.
              #   p result
              #
              def query_forecasts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CapacityPlanner::V1beta::QueryForecastsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.query_forecasts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CapacityPlanner::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.query_forecasts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.query_forecasts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @usage_service_stub.query_forecasts request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of the reservations that are in the parent parameter
              # and match your specified filters.
              #
              # @overload query_reservations(request, options = nil)
              #   Pass arguments to `query_reservations` via a request object, either of type
              #   {::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload query_reservations(parent: nil, location_level: nil, machine_family: nil, machine_shape: nil, gpu_type: nil, cloud_resource_type: nil, reservation_type: nil, share_type: nil, ownership_type: nil, reservation_data_level: nil, include_unapproved_reservations: nil, aggregation_method: nil, start_date: nil, end_date: nil)
              #   Pass arguments to `query_reservations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The compute engine resource and location for the time series
              #     values to return. The format is:
              #
              #     projects/\\{project}/locations/\\{location} or
              #     organizations/\\{organization}/locations/\\{location} or
              #     folders/\\{folder}/locations/\\{location}
              #   @param location_level [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries::LocationType]
              #     Optional. The location level of the reservations usage timeseries.
              #   @param machine_family [::String]
              #     Optional. The machine family to use to select the aggregate reserved values
              #     to return. Possible values include "n1", and "n2d" etc. Empty
              #     machine_family will return results matching all machine families.
              #   @param machine_shape [::Google::Cloud::CapacityPlanner::V1beta::MachineShape, ::Hash]
              #     Optional. The machine_shape as a filter to select matching reservations.
              #   @param gpu_type [::String]
              #     Optional. The GPU type for the reserved values to return. Sample values
              #     are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
              #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
              #     will return results matching all GPUs.
              #   @param cloud_resource_type [::String]
              #     Required. The resource for the reserved values to return. Possible values
              #     include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-gpu" and "gce-vm".
              #   @param reservation_type [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::ReservationType]
              #     Required. The Reservation type for example, future reservation request and
              #     allocation. If unspecified, all types are
              #     included.
              #   @param share_type [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::ShareType]
              #     Optional. Types of share settings to filter reservations in response. If
              #     unspecified, all types are included.
              #   @param ownership_type [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::OwnershipType]
              #     Optional. Types of ownerships to filter reservations based on.
              #     In case of OWNED, it filters reservations which are owned by selected
              #     parent project/folder/organization. If unspecified, all types are
              #     included.
              #   @param reservation_data_level [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest::ReservationDataLevel]
              #     Required. Reservations output data format.
              #   @param include_unapproved_reservations [::Boolean]
              #     Optional. Whether to include pending for approval reservations in the
              #     response. This field is only applicable for future reservations.
              #   @param aggregation_method [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
              #     Optional. Aggregation Method of the historical reservation usage
              #   @param start_date [::Google::Type::Date, ::Hash]
              #     Optional. The start date of reservations usage.
              #   @param end_date [::Google::Type::Date, ::Hash]
              #     Optional. The end date of reservations usage.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/capacity_planner/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest.new
              #
              #   # Call the query_reservations method.
              #   result = client.query_reservations request
              #
              #   # The returned object is of type Google::Cloud::CapacityPlanner::V1beta::QueryReservationsResponse.
              #   p result
              #
              def query_reservations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CapacityPlanner::V1beta::QueryReservationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.query_reservations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CapacityPlanner::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.query_reservations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.query_reservations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @usage_service_stub.query_reservations request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports historical usage data requested by user into either an existing
              # Cloud Storage bucket or a BigQuery table.
              #
              # @overload export_usage_histories(request, options = nil)
              #   Pass arguments to `export_usage_histories` via a request object, either of type
              #   {::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_usage_histories(parent: nil, is_spot: nil, machine_family: nil, machine_shape: nil, disk_type: nil, gpu_type: nil, tpu_type: nil, resource_type: nil, usage_aggregation_method: nil, start_date: nil, end_date: nil, output_config: nil)
              #   Pass arguments to `export_usage_histories` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The compute engine resource and location for the time series
              #     values to return. The format is:
              #        projects/\\{project}/locations/\\{location} or
              #        organizations/\\{organization}/locations/\\{location} or
              #        folders/\\{folder}/locations/\\{location}
              #   @param is_spot [::Boolean]
              #     Optional. Set true to export usage for spot resources.
              #   @param machine_family [::String]
              #     Optional. The machine family for the `UsageHistory` values to return.
              #     Possible values include "n1", and "n2d". See
              #     https://cloud.google.com/compute/docs/machine-types for more examples.
              #   @param machine_shape [::Google::Cloud::CapacityPlanner::V1beta::MachineShape, ::Hash]
              #     Optional. The machine shape for the time series values to export.
              #   @param disk_type [::String]
              #     Optional. The disk_type for the `UsageHistory` values to return request
              #     with persistent-disk resource_type. Possible values include "pd-ssd",
              #     "pd-standard", "pd-balanced", and "pd-extreme".
              #   @param gpu_type [::String]
              #     Optional. The GPU type for the `UsageHistory` values to return. Sample
              #     values are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
              #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
              #     will return results matching all GPUs.
              #   @param tpu_type [::String]
              #     Optional. The TPU type for the `UsageHistory` values to return. Empty
              #     tpu_type will return results matching all TPUs.
              #   @param resource_type [::String]
              #     Required. The resource for the `UsageHistory` values to return. Possible
              #     values include "gce-vcpus", "gce-ram", "gce-local-ssd",
              #     "gce-persistent-disk", "gce-gpu" and "gce-tpu".
              #   @param usage_aggregation_method [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
              #     Optional. The method that should be used to convert sampled usage data to
              #     daily usage values. AGGREGATION_METHOD_UNSPECIFIED will return results
              #     matching all the aggregation methods.
              #   @param start_date [::Google::Type::Date, ::Hash]
              #     Optional. The start date of usage.
              #   @param end_date [::Google::Type::Date, ::Hash]
              #     Optional. The end date of usage.
              #   @param output_config [::Google::Cloud::CapacityPlanner::V1beta::OutputConfig, ::Hash]
              #     Required. Output configuration indicating where the results will be output
              #     to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/capacity_planner/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest.new
              #
              #   # Call the export_usage_histories method.
              #   result = client.export_usage_histories request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_usage_histories request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CapacityPlanner::V1beta::ExportUsageHistoriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_usage_histories.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CapacityPlanner::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_usage_histories.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_usage_histories.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @usage_service_stub.export_usage_histories request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports forecasted usage data requested by user into either an existing
              # Cloud Storage bucket or a BigQuery table.
              #
              # @overload export_forecasts(request, options = nil)
              #   Pass arguments to `export_forecasts` via a request object, either of type
              #   {::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_forecasts(parent: nil, machine_family: nil, machine_shape: nil, disk_type: nil, gpu_type: nil, tpu_type: nil, resource_type: nil, prediction_interval: nil, aggregation_method: nil, start_date: nil, end_date: nil, output_config: nil)
              #   Pass arguments to `export_forecasts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The compute engine resource and location for the time series
              #     values to return. The format is:
              #        projects/\\{project}/locations/\\{location} or
              #        organizations/\\{organization}/locations/\\{location} or
              #        folders/\\{folder}/locations/\\{location}
              #   @param machine_family [::String]
              #     Optional. The machine family to use to select the `Forecast` values to
              #     return. Possible values include "n1", and "n2d".
              #   @param machine_shape [::Google::Cloud::CapacityPlanner::V1beta::MachineShape, ::Hash]
              #     Optional. The machine shape for the time series values to export.
              #   @param disk_type [::String]
              #     Optional. The disk_type for the `Forecast` values to return with request
              #     persistent-disk resource_type.
              #   @param gpu_type [::String]
              #     Optional. The GPU type for the `Forecast` values to return. Sample values
              #     are "nvidia-tesla-t4", and "nvidia-tesla-a100". See
              #     https://cloud.google.com/compute/docs/gpus for a list. Empty gpu_type
              #     will return results matching all GPUs.
              #   @param tpu_type [::String]
              #     Optional. The TPU type for the `Forecast` values to return. Empty tpu_type
              #     will return results matching all TPUs.
              #   @param resource_type [::String]
              #     Required. The resource for the `Forecast` values to return. Possible values
              #     include "gce-vcpus", "gce-ram", "gce-local-ssd", "gce-persistent-disk",
              #     "gce-gpu" and "gce-tpu".
              #   @param prediction_interval [::Google::Cloud::CapacityPlanner::V1beta::Forecast::PredictionInterval]
              #     Optional. The prediction interval to use to select the `Forecast` values to
              #     return. PREDICTION_INTERVAL_UNSPECIFIED will return results matching all
              #     prediction intervals.
              #   @param aggregation_method [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
              #     Optional. Aggregation Method of the historical usage for which the forecast
              #     is generated.
              #   @param start_date [::Google::Type::Date, ::Hash]
              #     Optional. The start date of forecasts.
              #   @param end_date [::Google::Type::Date, ::Hash]
              #     Optional. The end date of forecasts.
              #   @param output_config [::Google::Cloud::CapacityPlanner::V1beta::OutputConfig, ::Hash]
              #     Required. Output configuration indicating where the results will be output
              #     to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/capacity_planner/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest.new
              #
              #   # Call the export_forecasts method.
              #   result = client.export_forecasts request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_forecasts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CapacityPlanner::V1beta::ExportForecastsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_forecasts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CapacityPlanner::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_forecasts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_forecasts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @usage_service_stub.export_forecasts request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports reservations usage data requested by user into either an existing
              # Cloud Storage bucket or a new/existing BigQuery table.
              #
              # @overload export_reservations_usage(request, options = nil)
              #   Pass arguments to `export_reservations_usage` via a request object, either of type
              #   {::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_reservations_usage(machine_family: nil, machine_shape: nil, gpu_type: nil, parent: nil, location_level: nil, cloud_resource_type: nil, usage_aggregation_method: nil, share_type: nil, start_date: nil, end_date: nil, output_config: nil)
              #   Pass arguments to `export_reservations_usage` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param machine_family [::String]
              #     Optional. The machine family to query reservations and usage by. For
              #     example: n1, n2d.
              #
              #     Note: The following parameters are mutually exclusive: `machine_family`, `machine_shape`, `gpu_type`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param machine_shape [::Google::Cloud::CapacityPlanner::V1beta::MachineShape, ::Hash]
              #     Optional. The machine_shape as a filter to select matching reservations
              #     and its usage.
              #
              #     Note: The following parameters are mutually exclusive: `machine_shape`, `machine_family`, `gpu_type`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param gpu_type [::String]
              #     Optional. The GPU type to query reservations and usage  by. For example:
              #     NVIDIA T4.
              #
              #     Note: The following parameters are mutually exclusive: `gpu_type`, `machine_family`, `machine_shape`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param parent [::String]
              #     Required. The compute engine resource and location of the
              #     reservationsusage. The format is:
              #        projects/\\{project}/locations/\\{location} or
              #        organizations/\\{organization}/locations/\\{location} or
              #        folders/\\{folder}/locations/\\{location}
              #   @param location_level [::Google::Cloud::CapacityPlanner::V1beta::TimeSeries::LocationType]
              #     Optional. The location level of the reservations usage timeseries.
              #   @param cloud_resource_type [::String]
              #     Required. The resource for the `ReservationsUsage` values to return.
              #     Possible values include "gce-vcpus", "gce-ram", "gce-local-ssd", and
              #     "gce-gpu".
              #   @param usage_aggregation_method [::Google::Cloud::CapacityPlanner::V1beta::UsageHistory::AggregationMethod]
              #     Required. The method that should be used to convert sampled reservations
              #     data to daily usage values.
              #   @param share_type [::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest::ShareType]
              #     Optional. Type of share settings to filter reservations in response. If
              #     unspecified, all types are included.
              #   @param start_date [::Google::Type::Date, ::Hash]
              #     Optional. The start date of reservations usage.
              #   @param end_date [::Google::Type::Date, ::Hash]
              #     Optional. The end date of reservations usage.
              #   @param output_config [::Google::Cloud::CapacityPlanner::V1beta::OutputConfig, ::Hash]
              #     Required. Output configuration indicating where the results will be output
              #     to.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/capacity_planner/v1beta"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest.new
              #
              #   # Call the export_reservations_usage method.
              #   result = client.export_reservations_usage request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_reservations_usage request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::CapacityPlanner::V1beta::ExportReservationsUsageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_reservations_usage.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::CapacityPlanner::V1beta::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_reservations_usage.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_reservations_usage.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @usage_service_stub.export_reservations_usage request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the UsageService REST API.
              #
              # This class represents the configuration for UsageService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # query_usage_histories to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.query_usage_histories.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::CapacityPlanner::V1beta::UsageService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.query_usage_histories.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "capacityplanner.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the UsageService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `query_usage_histories`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :query_usage_histories
                  ##
                  # RPC-specific configuration for `query_forecasts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :query_forecasts
                  ##
                  # RPC-specific configuration for `query_reservations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :query_reservations
                  ##
                  # RPC-specific configuration for `export_usage_histories`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_usage_histories
                  ##
                  # RPC-specific configuration for `export_forecasts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_forecasts
                  ##
                  # RPC-specific configuration for `export_reservations_usage`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_reservations_usage

                  # @private
                  def initialize parent_rpcs = nil
                    query_usage_histories_config = parent_rpcs.query_usage_histories if parent_rpcs.respond_to? :query_usage_histories
                    @query_usage_histories = ::Gapic::Config::Method.new query_usage_histories_config
                    query_forecasts_config = parent_rpcs.query_forecasts if parent_rpcs.respond_to? :query_forecasts
                    @query_forecasts = ::Gapic::Config::Method.new query_forecasts_config
                    query_reservations_config = parent_rpcs.query_reservations if parent_rpcs.respond_to? :query_reservations
                    @query_reservations = ::Gapic::Config::Method.new query_reservations_config
                    export_usage_histories_config = parent_rpcs.export_usage_histories if parent_rpcs.respond_to? :export_usage_histories
                    @export_usage_histories = ::Gapic::Config::Method.new export_usage_histories_config
                    export_forecasts_config = parent_rpcs.export_forecasts if parent_rpcs.respond_to? :export_forecasts
                    @export_forecasts = ::Gapic::Config::Method.new export_forecasts_config
                    export_reservations_usage_config = parent_rpcs.export_reservations_usage if parent_rpcs.respond_to? :export_reservations_usage
                    @export_reservations_usage = ::Gapic::Config::Method.new export_reservations_usage_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
