# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Build
      module V2
        module RepositoryManager
          # Path helper methods for the RepositoryManager API.
          module Paths
            ##
            # Create a fully-qualified Connection resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            #
            # @return [::String]
            def connection_path project:, location:, connection:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Repository resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}/repositories/{repository}`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            # @param repository [String]
            #
            # @return [::String]
            def repository_path project:, location:, connection:, repository:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "connection cannot contain /" if connection.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}/repositories/#{repository}"
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/secrets/{secret}/versions/{version}`
            #
            # @param project [String]
            # @param secret [String]
            # @param version [String]
            #
            # @return [::String]
            def secret_version_path project:, secret:, version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

              "projects/#{project}/secrets/#{secret}/versions/#{version}"
            end

            ##
            # Create a fully-qualified Service resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}`
            #
            # @param project [String]
            # @param location [String]
            # @param namespace [String]
            # @param service [String]
            #
            # @return [::String]
            def service_path project:, location:, namespace:, service:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "namespace cannot contain /" if namespace.to_s.include? "/"

              "projects/#{project}/locations/#{location}/namespaces/#{namespace}/services/#{service}"
            end

            extend self
          end
        end
      end
    end
  end
end
