# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/devtools/cloudbuild/v2/repositories_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Build
      module V2
        module RepositoryManager
          ##
          # Client for the RepositoryManager service.
          #
          # Manages connections to source code repositories.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "cloudbuild.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :repository_manager_stub

            ##
            # Configure the RepositoryManager Client class.
            #
            # See {::Google::Cloud::Build::V2::RepositoryManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all RepositoryManager clients
            #   ::Google::Cloud::Build::V2::RepositoryManager::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Build", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_connection.timeout = 60.0

                default_config.rpcs.get_connection.timeout = 60.0
                default_config.rpcs.get_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_connections.timeout = 60.0
                default_config.rpcs.list_connections.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_connection.timeout = 60.0

                default_config.rpcs.delete_connection.timeout = 60.0

                default_config.rpcs.create_repository.timeout = 60.0

                default_config.rpcs.get_repository.timeout = 60.0
                default_config.rpcs.get_repository.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_repositories.timeout = 60.0
                default_config.rpcs.list_repositories.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_repository.timeout = 60.0

                default_config.rpcs.fetch_read_write_token.timeout = 60.0
                default_config.rpcs.fetch_read_write_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.fetch_read_token.timeout = 60.0
                default_config.rpcs.fetch_read_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.fetch_linkable_repositories.timeout = 60.0
                default_config.rpcs.fetch_linkable_repositories.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the RepositoryManager Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Build::V2::RepositoryManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @repository_manager_stub.universe_domain
            end

            ##
            # Create a new RepositoryManager client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Build::V2::RepositoryManager::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the RepositoryManager client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/devtools/cloudbuild/v2/repositories_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @repository_manager_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Build::V2::RepositoryManager::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @repository_manager_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @repository_manager_stub.endpoint
                config.universe_domain = @repository_manager_stub.universe_domain
                config.logger = @repository_manager_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @repository_manager_stub.endpoint
                config.universe_domain = @repository_manager_stub.universe_domain
                config.logger = @repository_manager_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Build::V2::RepositoryManager::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @repository_manager_stub.logger
            end

            # Service calls

            ##
            # Creates a Connection.
            #
            # @overload create_connection(request, options = nil)
            #   Pass arguments to `create_connection` via a request object, either of type
            #   {::Google::Cloud::Build::V2::CreateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::CreateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_connection(parent: nil, connection: nil, connection_id: nil)
            #   Pass arguments to `create_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Project and location where the connection will be created.
            #     Format: `projects/*/locations/*`.
            #   @param connection [::Google::Cloud::Build::V2::Connection, ::Hash]
            #     Required. The Connection to create.
            #   @param connection_id [::String]
            #     Required. The ID to use for the Connection, which will become the final
            #     component of the Connection's resource name. Names must be unique
            #     per-project per-location. Allows alphanumeric characters and any of
            #     -._~%!$&'()*+,;=@.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::CreateConnectionRequest.new
            #
            #   # Call the create_connection method.
            #   result = client.create_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::CreateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :create_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single connection.
            #
            # @overload get_connection(request, options = nil)
            #   Pass arguments to `get_connection` via a request object, either of type
            #   {::Google::Cloud::Build::V2::GetConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::GetConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_connection(name: nil)
            #   Pass arguments to `get_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Connection to retrieve.
            #     Format: `projects/*/locations/*/connections/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Build::V2::Connection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Build::V2::Connection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::GetConnectionRequest.new
            #
            #   # Call the get_connection method.
            #   result = client.get_connection request
            #
            #   # The returned object is of type Google::Cloud::Build::V2::Connection.
            #   p result
            #
            def get_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::GetConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :get_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Connections in a given project and location.
            #
            # @overload list_connections(request, options = nil)
            #   Pass arguments to `list_connections` via a request object, either of type
            #   {::Google::Cloud::Build::V2::ListConnectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::ListConnectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_connections(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_connections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns this collection of Connections.
            #     Format: `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Number of results to return in the list.
            #   @param page_token [::String]
            #     Page start.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Build::V2::Connection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Build::V2::Connection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::ListConnectionsRequest.new
            #
            #   # Call the list_connections method.
            #   result = client.list_connections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Build::V2::Connection.
            #     p item
            #   end
            #
            def list_connections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::ListConnectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_connections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_connections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_connections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :list_connections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @repository_manager_stub, :list_connections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a single connection.
            #
            # @overload update_connection(request, options = nil)
            #   Pass arguments to `update_connection` via a request object, either of type
            #   {::Google::Cloud::Build::V2::UpdateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::UpdateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_connection(connection: nil, update_mask: nil, allow_missing: nil, etag: nil)
            #   Pass arguments to `update_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param connection [::Google::Cloud::Build::V2::Connection, ::Hash]
            #     Required. The Connection to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The list of fields to be updated.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the connection is not found a new connection
            #     will be created. In this situation `update_mask` is ignored.
            #     The creation will succeed only if the input connection has all the
            #     necessary information (e.g a github_config with both  user_oauth_token and
            #     installation_id properties).
            #   @param etag [::String]
            #     The current etag of the connection.
            #     If an etag is provided and does not match the current etag of the
            #     connection, update will be blocked and an ABORTED error will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::UpdateConnectionRequest.new
            #
            #   # Call the update_connection method.
            #   result = client.update_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::UpdateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.connection&.name
                header_params["connection.name"] = request.connection.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :update_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single connection.
            #
            # @overload delete_connection(request, options = nil)
            #   Pass arguments to `delete_connection` via a request object, either of type
            #   {::Google::Cloud::Build::V2::DeleteConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::DeleteConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_connection(name: nil, etag: nil, validate_only: nil)
            #   Pass arguments to `delete_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Connection to delete.
            #     Format: `projects/*/locations/*/connections/*`.
            #   @param etag [::String]
            #     The current etag of the connection.
            #     If an etag is provided and does not match the current etag of the
            #     connection, deletion will be blocked and an ABORTED error will be returned.
            #   @param validate_only [::Boolean]
            #     If set, validate the request, but do not actually post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::DeleteConnectionRequest.new
            #
            #   # Call the delete_connection method.
            #   result = client.delete_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::DeleteConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :delete_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a Repository.
            #
            # @overload create_repository(request, options = nil)
            #   Pass arguments to `create_repository` via a request object, either of type
            #   {::Google::Cloud::Build::V2::CreateRepositoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::CreateRepositoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_repository(parent: nil, repository: nil, repository_id: nil)
            #   Pass arguments to `create_repository` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The connection to contain the repository. If the request is part
            #     of a BatchCreateRepositoriesRequest, this field should be empty or match
            #     the parent specified there.
            #   @param repository [::Google::Cloud::Build::V2::Repository, ::Hash]
            #     Required. The repository to create.
            #   @param repository_id [::String]
            #     Required. The ID to use for the repository, which will become the final
            #     component of the repository's resource name. This ID should be unique in
            #     the connection. Allows alphanumeric characters and any of
            #     -._~%!$&'()*+,;=@.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::CreateRepositoryRequest.new
            #
            #   # Call the create_repository method.
            #   result = client.create_repository request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_repository request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::CreateRepositoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_repository.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_repository.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_repository.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :create_repository, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates multiple repositories inside a connection.
            #
            # @overload batch_create_repositories(request, options = nil)
            #   Pass arguments to `batch_create_repositories` via a request object, either of type
            #   {::Google::Cloud::Build::V2::BatchCreateRepositoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::BatchCreateRepositoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_create_repositories(parent: nil, requests: nil)
            #   Pass arguments to `batch_create_repositories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The connection to contain all the repositories being created.
            #     Format: projects/*/locations/*/connections/*
            #     The parent field in the CreateRepositoryRequest messages
            #     must either be empty or match this field.
            #   @param requests [::Array<::Google::Cloud::Build::V2::CreateRepositoryRequest, ::Hash>]
            #     Required. The request messages specifying the repositories to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::BatchCreateRepositoriesRequest.new
            #
            #   # Call the batch_create_repositories method.
            #   result = client.batch_create_repositories request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_create_repositories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::BatchCreateRepositoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_create_repositories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_create_repositories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_create_repositories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :batch_create_repositories, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single repository.
            #
            # @overload get_repository(request, options = nil)
            #   Pass arguments to `get_repository` via a request object, either of type
            #   {::Google::Cloud::Build::V2::GetRepositoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::GetRepositoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_repository(name: nil)
            #   Pass arguments to `get_repository` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Repository to retrieve.
            #     Format: `projects/*/locations/*/connections/*/repositories/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Build::V2::Repository]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Build::V2::Repository]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::GetRepositoryRequest.new
            #
            #   # Call the get_repository method.
            #   result = client.get_repository request
            #
            #   # The returned object is of type Google::Cloud::Build::V2::Repository.
            #   p result
            #
            def get_repository request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::GetRepositoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_repository.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_repository.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_repository.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :get_repository, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Repositories in a given connection.
            #
            # @overload list_repositories(request, options = nil)
            #   Pass arguments to `list_repositories` via a request object, either of type
            #   {::Google::Cloud::Build::V2::ListRepositoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::ListRepositoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_repositories(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_repositories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent, which owns this collection of Repositories.
            #     Format: `projects/*/locations/*/connections/*`.
            #   @param page_size [::Integer]
            #     Number of results to return in the list.
            #   @param page_token [::String]
            #     Page start.
            #   @param filter [::String]
            #     A filter expression that filters resources listed in the response.
            #     Expressions must follow API improvement proposal
            #     [AIP-160](https://google.aip.dev/160). e.g.
            #     `remote_uri:"https://github.com*"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Build::V2::Repository>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Build::V2::Repository>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::ListRepositoriesRequest.new
            #
            #   # Call the list_repositories method.
            #   result = client.list_repositories request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Build::V2::Repository.
            #     p item
            #   end
            #
            def list_repositories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::ListRepositoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_repositories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_repositories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_repositories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :list_repositories, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @repository_manager_stub, :list_repositories, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single repository.
            #
            # @overload delete_repository(request, options = nil)
            #   Pass arguments to `delete_repository` via a request object, either of type
            #   {::Google::Cloud::Build::V2::DeleteRepositoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::DeleteRepositoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_repository(name: nil, etag: nil, validate_only: nil)
            #   Pass arguments to `delete_repository` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Repository to delete.
            #     Format: `projects/*/locations/*/connections/*/repositories/*`.
            #   @param etag [::String]
            #     The current etag of the repository.
            #     If an etag is provided and does not match the current etag of the
            #     repository, deletion will be blocked and an ABORTED error will be returned.
            #   @param validate_only [::Boolean]
            #     If set, validate the request, but do not actually post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::DeleteRepositoryRequest.new
            #
            #   # Call the delete_repository method.
            #   result = client.delete_repository request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_repository request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::DeleteRepositoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_repository.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_repository.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_repository.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :delete_repository, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches read/write token of a given repository.
            #
            # @overload fetch_read_write_token(request, options = nil)
            #   Pass arguments to `fetch_read_write_token` via a request object, either of type
            #   {::Google::Cloud::Build::V2::FetchReadWriteTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::FetchReadWriteTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_read_write_token(repository: nil)
            #   Pass arguments to `fetch_read_write_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param repository [::String]
            #     Required. The resource name of the repository in the format
            #     `projects/*/locations/*/connections/*/repositories/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Build::V2::FetchReadWriteTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Build::V2::FetchReadWriteTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::FetchReadWriteTokenRequest.new
            #
            #   # Call the fetch_read_write_token method.
            #   result = client.fetch_read_write_token request
            #
            #   # The returned object is of type Google::Cloud::Build::V2::FetchReadWriteTokenResponse.
            #   p result
            #
            def fetch_read_write_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::FetchReadWriteTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_read_write_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.repository
                header_params["repository"] = request.repository
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_read_write_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_read_write_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :fetch_read_write_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches read token of a given repository.
            #
            # @overload fetch_read_token(request, options = nil)
            #   Pass arguments to `fetch_read_token` via a request object, either of type
            #   {::Google::Cloud::Build::V2::FetchReadTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::FetchReadTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_read_token(repository: nil)
            #   Pass arguments to `fetch_read_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param repository [::String]
            #     Required. The resource name of the repository in the format
            #     `projects/*/locations/*/connections/*/repositories/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Build::V2::FetchReadTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Build::V2::FetchReadTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::FetchReadTokenRequest.new
            #
            #   # Call the fetch_read_token method.
            #   result = client.fetch_read_token request
            #
            #   # The returned object is of type Google::Cloud::Build::V2::FetchReadTokenResponse.
            #   p result
            #
            def fetch_read_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::FetchReadTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_read_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.repository
                header_params["repository"] = request.repository
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_read_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_read_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :fetch_read_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # FetchLinkableRepositories get repositories from SCM that are
            # accessible and could be added to the connection.
            #
            # @overload fetch_linkable_repositories(request, options = nil)
            #   Pass arguments to `fetch_linkable_repositories` via a request object, either of type
            #   {::Google::Cloud::Build::V2::FetchLinkableRepositoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::FetchLinkableRepositoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_linkable_repositories(connection: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `fetch_linkable_repositories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param connection [::String]
            #     Required. The name of the Connection.
            #     Format: `projects/*/locations/*/connections/*`.
            #   @param page_size [::Integer]
            #     Number of results to return in the list. Default to 20.
            #   @param page_token [::String]
            #     Page start.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Build::V2::Repository>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Build::V2::Repository>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::FetchLinkableRepositoriesRequest.new
            #
            #   # Call the fetch_linkable_repositories method.
            #   result = client.fetch_linkable_repositories request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Build::V2::Repository.
            #     p item
            #   end
            #
            def fetch_linkable_repositories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::FetchLinkableRepositoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_linkable_repositories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.connection
                header_params["connection"] = request.connection
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_linkable_repositories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_linkable_repositories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :fetch_linkable_repositories, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @repository_manager_stub, :fetch_linkable_repositories, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch the list of branches or tags for a given repository.
            #
            # @overload fetch_git_refs(request, options = nil)
            #   Pass arguments to `fetch_git_refs` via a request object, either of type
            #   {::Google::Cloud::Build::V2::FetchGitRefsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Build::V2::FetchGitRefsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_git_refs(repository: nil, ref_type: nil)
            #   Pass arguments to `fetch_git_refs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param repository [::String]
            #     Required. The resource name of the repository in the format
            #     `projects/*/locations/*/connections/*/repositories/*`.
            #   @param ref_type [::Google::Cloud::Build::V2::FetchGitRefsRequest::RefType]
            #     Type of refs to fetch
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Build::V2::FetchGitRefsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Build::V2::FetchGitRefsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/build/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Build::V2::RepositoryManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Build::V2::FetchGitRefsRequest.new
            #
            #   # Call the fetch_git_refs method.
            #   result = client.fetch_git_refs request
            #
            #   # The returned object is of type Google::Cloud::Build::V2::FetchGitRefsResponse.
            #   p result
            #
            def fetch_git_refs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V2::FetchGitRefsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_git_refs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Build::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.repository
                header_params["repository"] = request.repository
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_git_refs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_git_refs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @repository_manager_stub.call_rpc :fetch_git_refs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the RepositoryManager API.
            #
            # This class represents the configuration for RepositoryManager,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Build::V2::RepositoryManager::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_connection to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Build::V2::RepositoryManager::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_connection.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Build::V2::RepositoryManager::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_connection.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Build::V2::RepositoryManager::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "cloudbuild.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the RepositoryManager API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_connection
                ##
                # RPC-specific configuration for `get_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_connection
                ##
                # RPC-specific configuration for `list_connections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_connections
                ##
                # RPC-specific configuration for `update_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_connection
                ##
                # RPC-specific configuration for `delete_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_connection
                ##
                # RPC-specific configuration for `create_repository`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_repository
                ##
                # RPC-specific configuration for `batch_create_repositories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_create_repositories
                ##
                # RPC-specific configuration for `get_repository`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_repository
                ##
                # RPC-specific configuration for `list_repositories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_repositories
                ##
                # RPC-specific configuration for `delete_repository`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_repository
                ##
                # RPC-specific configuration for `fetch_read_write_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_read_write_token
                ##
                # RPC-specific configuration for `fetch_read_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_read_token
                ##
                # RPC-specific configuration for `fetch_linkable_repositories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_linkable_repositories
                ##
                # RPC-specific configuration for `fetch_git_refs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_git_refs

                # @private
                def initialize parent_rpcs = nil
                  create_connection_config = parent_rpcs.create_connection if parent_rpcs.respond_to? :create_connection
                  @create_connection = ::Gapic::Config::Method.new create_connection_config
                  get_connection_config = parent_rpcs.get_connection if parent_rpcs.respond_to? :get_connection
                  @get_connection = ::Gapic::Config::Method.new get_connection_config
                  list_connections_config = parent_rpcs.list_connections if parent_rpcs.respond_to? :list_connections
                  @list_connections = ::Gapic::Config::Method.new list_connections_config
                  update_connection_config = parent_rpcs.update_connection if parent_rpcs.respond_to? :update_connection
                  @update_connection = ::Gapic::Config::Method.new update_connection_config
                  delete_connection_config = parent_rpcs.delete_connection if parent_rpcs.respond_to? :delete_connection
                  @delete_connection = ::Gapic::Config::Method.new delete_connection_config
                  create_repository_config = parent_rpcs.create_repository if parent_rpcs.respond_to? :create_repository
                  @create_repository = ::Gapic::Config::Method.new create_repository_config
                  batch_create_repositories_config = parent_rpcs.batch_create_repositories if parent_rpcs.respond_to? :batch_create_repositories
                  @batch_create_repositories = ::Gapic::Config::Method.new batch_create_repositories_config
                  get_repository_config = parent_rpcs.get_repository if parent_rpcs.respond_to? :get_repository
                  @get_repository = ::Gapic::Config::Method.new get_repository_config
                  list_repositories_config = parent_rpcs.list_repositories if parent_rpcs.respond_to? :list_repositories
                  @list_repositories = ::Gapic::Config::Method.new list_repositories_config
                  delete_repository_config = parent_rpcs.delete_repository if parent_rpcs.respond_to? :delete_repository
                  @delete_repository = ::Gapic::Config::Method.new delete_repository_config
                  fetch_read_write_token_config = parent_rpcs.fetch_read_write_token if parent_rpcs.respond_to? :fetch_read_write_token
                  @fetch_read_write_token = ::Gapic::Config::Method.new fetch_read_write_token_config
                  fetch_read_token_config = parent_rpcs.fetch_read_token if parent_rpcs.respond_to? :fetch_read_token
                  @fetch_read_token = ::Gapic::Config::Method.new fetch_read_token_config
                  fetch_linkable_repositories_config = parent_rpcs.fetch_linkable_repositories if parent_rpcs.respond_to? :fetch_linkable_repositories
                  @fetch_linkable_repositories = ::Gapic::Config::Method.new fetch_linkable_repositories_config
                  fetch_git_refs_config = parent_rpcs.fetch_git_refs if parent_rpcs.respond_to? :fetch_git_refs
                  @fetch_git_refs = ::Gapic::Config::Method.new fetch_git_refs_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
