# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/devtools/cloudbuild/v1/cloudbuild_pb"
require "google/cloud/build/v1/cloud_build"

class ::Google::Cloud::Build::V1::CloudBuild::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_build
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    build = {}

    create_build_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_build, name
      assert_kind_of ::Google::Cloud::Build::V1::CreateBuildRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["project_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Build::V1::Build), request["build"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_build_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_build({ parent: parent, project_id: project_id, build: build }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_build parent: parent, project_id: project_id, build: build do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_build ::Google::Cloud::Build::V1::CreateBuildRequest.new(parent: parent, project_id: project_id, build: build) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_build({ parent: parent, project_id: project_id, build: build }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_build(::Google::Cloud::Build::V1::CreateBuildRequest.new(parent: parent, project_id: project_id, build: build), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_build_client_stub.call_rpc_count
    end
  end

  def test_get_build
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::Build.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    id = "hello world"

    get_build_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_build, name
      assert_kind_of ::Google::Cloud::Build::V1::GetBuildRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_build_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_build({ name: name, project_id: project_id, id: id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_build name: name, project_id: project_id, id: id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_build ::Google::Cloud::Build::V1::GetBuildRequest.new(name: name, project_id: project_id, id: id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_build({ name: name, project_id: project_id, id: id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_build(::Google::Cloud::Build::V1::GetBuildRequest.new(name: name, project_id: project_id, id: id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_build_client_stub.call_rpc_count
    end
  end

  def test_list_builds
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::ListBuildsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_builds_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_builds, name
      assert_kind_of ::Google::Cloud::Build::V1::ListBuildsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["project_id"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_builds_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_builds({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_builds parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_builds ::Google::Cloud::Build::V1::ListBuildsRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_builds({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_builds(::Google::Cloud::Build::V1::ListBuildsRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_builds_client_stub.call_rpc_count
    end
  end

  def test_cancel_build
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::Build.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    id = "hello world"

    cancel_build_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_build, name
      assert_kind_of ::Google::Cloud::Build::V1::CancelBuildRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_build_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_build({ name: name, project_id: project_id, id: id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_build name: name, project_id: project_id, id: id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_build ::Google::Cloud::Build::V1::CancelBuildRequest.new(name: name, project_id: project_id, id: id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_build({ name: name, project_id: project_id, id: id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_build(::Google::Cloud::Build::V1::CancelBuildRequest.new(name: name, project_id: project_id, id: id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_build_client_stub.call_rpc_count
    end
  end

  def test_retry_build
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    id = "hello world"

    retry_build_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retry_build, name
      assert_kind_of ::Google::Cloud::Build::V1::RetryBuildRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retry_build_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retry_build({ name: name, project_id: project_id, id: id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retry_build name: name, project_id: project_id, id: id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retry_build ::Google::Cloud::Build::V1::RetryBuildRequest.new(name: name, project_id: project_id, id: id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retry_build({ name: name, project_id: project_id, id: id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retry_build(::Google::Cloud::Build::V1::RetryBuildRequest.new(name: name, project_id: project_id, id: id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retry_build_client_stub.call_rpc_count
    end
  end

  def test_approve_build
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    approval_result = {}

    approve_build_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :approve_build, name
      assert_kind_of ::Google::Cloud::Build::V1::ApproveBuildRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Build::V1::ApprovalResult), request["approval_result"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, approve_build_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.approve_build({ name: name, approval_result: approval_result }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.approve_build name: name, approval_result: approval_result do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.approve_build ::Google::Cloud::Build::V1::ApproveBuildRequest.new(name: name, approval_result: approval_result) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.approve_build({ name: name, approval_result: approval_result }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.approve_build(::Google::Cloud::Build::V1::ApproveBuildRequest.new(name: name, approval_result: approval_result), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, approve_build_client_stub.call_rpc_count
    end
  end

  def test_create_build_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::BuildTrigger.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    trigger = {}

    create_build_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_build_trigger, name
      assert_kind_of ::Google::Cloud::Build::V1::CreateBuildTriggerRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["project_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Build::V1::BuildTrigger), request["trigger"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_build_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_build_trigger({ parent: parent, project_id: project_id, trigger: trigger }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_build_trigger parent: parent, project_id: project_id, trigger: trigger do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_build_trigger ::Google::Cloud::Build::V1::CreateBuildTriggerRequest.new(parent: parent, project_id: project_id, trigger: trigger) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_build_trigger({ parent: parent, project_id: project_id, trigger: trigger }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_build_trigger(::Google::Cloud::Build::V1::CreateBuildTriggerRequest.new(parent: parent, project_id: project_id, trigger: trigger), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_build_trigger_client_stub.call_rpc_count
    end
  end

  def test_get_build_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::BuildTrigger.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    trigger_id = "hello world"

    get_build_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_build_trigger, name
      assert_kind_of ::Google::Cloud::Build::V1::GetBuildTriggerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["trigger_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_build_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_build_trigger name: name, project_id: project_id, trigger_id: trigger_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_build_trigger ::Google::Cloud::Build::V1::GetBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_build_trigger(::Google::Cloud::Build::V1::GetBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_build_trigger_client_stub.call_rpc_count
    end
  end

  def test_list_build_triggers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::ListBuildTriggersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    page_size = 42
    page_token = "hello world"

    list_build_triggers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_build_triggers, name
      assert_kind_of ::Google::Cloud::Build::V1::ListBuildTriggersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["project_id"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_build_triggers_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_build_triggers({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_build_triggers parent: parent, project_id: project_id, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_build_triggers ::Google::Cloud::Build::V1::ListBuildTriggersRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_build_triggers({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_build_triggers(::Google::Cloud::Build::V1::ListBuildTriggersRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_build_triggers_client_stub.call_rpc_count
    end
  end

  def test_delete_build_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    trigger_id = "hello world"

    delete_build_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_build_trigger, name
      assert_kind_of ::Google::Cloud::Build::V1::DeleteBuildTriggerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["trigger_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_build_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_build_trigger name: name, project_id: project_id, trigger_id: trigger_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_build_trigger ::Google::Cloud::Build::V1::DeleteBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_build_trigger(::Google::Cloud::Build::V1::DeleteBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_build_trigger_client_stub.call_rpc_count
    end
  end

  def test_update_build_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::BuildTrigger.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    trigger_id = "hello world"
    trigger = {}
    update_mask = {}

    update_build_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_build_trigger, name
      assert_kind_of ::Google::Cloud::Build::V1::UpdateBuildTriggerRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["trigger_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Build::V1::BuildTrigger), request["trigger"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_build_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_build_trigger({ project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_build_trigger project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_build_trigger ::Google::Cloud::Build::V1::UpdateBuildTriggerRequest.new(project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_build_trigger({ project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_build_trigger(::Google::Cloud::Build::V1::UpdateBuildTriggerRequest.new(project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_build_trigger_client_stub.call_rpc_count
    end
  end

  def test_run_build_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    trigger_id = "hello world"
    source = {}

    run_build_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :run_build_trigger, name
      assert_kind_of ::Google::Cloud::Build::V1::RunBuildTriggerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["trigger_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Build::V1::RepoSource), request["source"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, run_build_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.run_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id, source: source }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.run_build_trigger name: name, project_id: project_id, trigger_id: trigger_id, source: source do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.run_build_trigger ::Google::Cloud::Build::V1::RunBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id, source: source) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.run_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id, source: source }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.run_build_trigger(::Google::Cloud::Build::V1::RunBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id, source: source), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, run_build_trigger_client_stub.call_rpc_count
    end
  end

  def test_receive_trigger_webhook
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::ReceiveTriggerWebhookResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    body = {}
    project_id = "hello world"
    trigger = "hello world"
    secret = "hello world"

    receive_trigger_webhook_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :receive_trigger_webhook, name
      assert_kind_of ::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Api::HttpBody), request["body"]
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["trigger"]
      assert_equal "hello world", request["secret"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, receive_trigger_webhook_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.receive_trigger_webhook({ name: name, body: body, project_id: project_id, trigger: trigger, secret: secret }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.receive_trigger_webhook name: name, body: body, project_id: project_id, trigger: trigger, secret: secret do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.receive_trigger_webhook ::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest.new(name: name, body: body, project_id: project_id, trigger: trigger, secret: secret) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.receive_trigger_webhook({ name: name, body: body, project_id: project_id, trigger: trigger, secret: secret }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.receive_trigger_webhook(::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest.new(name: name, body: body, project_id: project_id, trigger: trigger, secret: secret), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, receive_trigger_webhook_client_stub.call_rpc_count
    end
  end

  def test_create_worker_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    worker_pool = {}
    worker_pool_id = "hello world"
    validate_only = true

    create_worker_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_worker_pool, name
      assert_kind_of ::Google::Cloud::Build::V1::CreateWorkerPoolRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Build::V1::WorkerPool), request["worker_pool"]
      assert_equal "hello world", request["worker_pool_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_worker_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_worker_pool({ parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_worker_pool parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_worker_pool ::Google::Cloud::Build::V1::CreateWorkerPoolRequest.new(parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_worker_pool({ parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_worker_pool(::Google::Cloud::Build::V1::CreateWorkerPoolRequest.new(parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_worker_pool_client_stub.call_rpc_count
    end
  end

  def test_get_worker_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::WorkerPool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_worker_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_worker_pool, name
      assert_kind_of ::Google::Cloud::Build::V1::GetWorkerPoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_worker_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_worker_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_worker_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_worker_pool ::Google::Cloud::Build::V1::GetWorkerPoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_worker_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_worker_pool(::Google::Cloud::Build::V1::GetWorkerPoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_worker_pool_client_stub.call_rpc_count
    end
  end

  def test_delete_worker_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_worker_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_worker_pool, name
      assert_kind_of ::Google::Cloud::Build::V1::DeleteWorkerPoolRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_worker_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_worker_pool({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_worker_pool name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_worker_pool ::Google::Cloud::Build::V1::DeleteWorkerPoolRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_worker_pool({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_worker_pool(::Google::Cloud::Build::V1::DeleteWorkerPoolRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_worker_pool_client_stub.call_rpc_count
    end
  end

  def test_update_worker_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    worker_pool = {}
    update_mask = {}
    validate_only = true

    update_worker_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_worker_pool, name
      assert_kind_of ::Google::Cloud::Build::V1::UpdateWorkerPoolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Build::V1::WorkerPool), request["worker_pool"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_worker_pool_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_worker_pool({ worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_worker_pool worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_worker_pool ::Google::Cloud::Build::V1::UpdateWorkerPoolRequest.new(worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_worker_pool({ worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_worker_pool(::Google::Cloud::Build::V1::UpdateWorkerPoolRequest.new(worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_worker_pool_client_stub.call_rpc_count
    end
  end

  def test_list_worker_pools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::ListWorkerPoolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_worker_pools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_worker_pools, name
      assert_kind_of ::Google::Cloud::Build::V1::ListWorkerPoolsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_worker_pools_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_worker_pools({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_worker_pools parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_worker_pools ::Google::Cloud::Build::V1::ListWorkerPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_worker_pools({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_worker_pools(::Google::Cloud::Build::V1::ListWorkerPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_worker_pools_client_stub.call_rpc_count
    end
  end

  def test_get_default_service_account
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Build::V1::DefaultServiceAccount.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_default_service_account_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_default_service_account, name
      assert_kind_of ::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_default_service_account_client_stub do
      # Create client
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_default_service_account({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_default_service_account name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_default_service_account ::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_default_service_account({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_default_service_account(::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_default_service_account_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Build::V1::CloudBuild::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Build::V1::CloudBuild::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Build::V1::CloudBuild::Operations, client.operations_client
  end
end
