# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/devtools/cloudbuild/v1/cloudbuild_pb"
require "google/cloud/build/v1/cloud_build/rest"


class ::Google::Cloud::Build::V1::CloudBuild::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_build
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    build = {}

    create_build_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_create_build_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_build_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_build({ parent: parent, project_id: project_id, build: build }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_build parent: parent, project_id: project_id, build: build do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_build ::Google::Cloud::Build::V1::CreateBuildRequest.new(parent: parent, project_id: project_id, build: build) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_build({ parent: parent, project_id: project_id, build: build }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_build(::Google::Cloud::Build::V1::CreateBuildRequest.new(parent: parent, project_id: project_id, build: build), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_build_client_stub.call_count
      end
    end
  end

  def test_get_build
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::Build.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    id = "hello world"

    get_build_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_get_build_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_build_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_build({ name: name, project_id: project_id, id: id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_build name: name, project_id: project_id, id: id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_build ::Google::Cloud::Build::V1::GetBuildRequest.new(name: name, project_id: project_id, id: id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_build({ name: name, project_id: project_id, id: id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_build(::Google::Cloud::Build::V1::GetBuildRequest.new(name: name, project_id: project_id, id: id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_build_client_stub.call_count
      end
    end
  end

  def test_list_builds
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::ListBuildsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_builds_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_list_builds_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_builds_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_builds({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_builds parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_builds ::Google::Cloud::Build::V1::ListBuildsRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_builds({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_builds(::Google::Cloud::Build::V1::ListBuildsRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_builds_client_stub.call_count
      end
    end
  end

  def test_cancel_build
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::Build.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    id = "hello world"

    cancel_build_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_cancel_build_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_build_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_build({ name: name, project_id: project_id, id: id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_build name: name, project_id: project_id, id: id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_build ::Google::Cloud::Build::V1::CancelBuildRequest.new(name: name, project_id: project_id, id: id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_build({ name: name, project_id: project_id, id: id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_build(::Google::Cloud::Build::V1::CancelBuildRequest.new(name: name, project_id: project_id, id: id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_build_client_stub.call_count
      end
    end
  end

  def test_retry_build
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    id = "hello world"

    retry_build_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_retry_build_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, retry_build_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.retry_build({ name: name, project_id: project_id, id: id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.retry_build name: name, project_id: project_id, id: id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.retry_build ::Google::Cloud::Build::V1::RetryBuildRequest.new(name: name, project_id: project_id, id: id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.retry_build({ name: name, project_id: project_id, id: id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.retry_build(::Google::Cloud::Build::V1::RetryBuildRequest.new(name: name, project_id: project_id, id: id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, retry_build_client_stub.call_count
      end
    end
  end

  def test_approve_build
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    approval_result = {}

    approve_build_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_approve_build_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, approve_build_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.approve_build({ name: name, approval_result: approval_result }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.approve_build name: name, approval_result: approval_result do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.approve_build ::Google::Cloud::Build::V1::ApproveBuildRequest.new(name: name, approval_result: approval_result) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.approve_build({ name: name, approval_result: approval_result }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.approve_build(::Google::Cloud::Build::V1::ApproveBuildRequest.new(name: name, approval_result: approval_result), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, approve_build_client_stub.call_count
      end
    end
  end

  def test_create_build_trigger
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::BuildTrigger.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    trigger = {}

    create_build_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_create_build_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_build_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_build_trigger({ parent: parent, project_id: project_id, trigger: trigger }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_build_trigger parent: parent, project_id: project_id, trigger: trigger do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_build_trigger ::Google::Cloud::Build::V1::CreateBuildTriggerRequest.new(parent: parent, project_id: project_id, trigger: trigger) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_build_trigger({ parent: parent, project_id: project_id, trigger: trigger }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_build_trigger(::Google::Cloud::Build::V1::CreateBuildTriggerRequest.new(parent: parent, project_id: project_id, trigger: trigger), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_build_trigger_client_stub.call_count
      end
    end
  end

  def test_get_build_trigger
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::BuildTrigger.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    trigger_id = "hello world"

    get_build_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_get_build_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_build_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_build_trigger name: name, project_id: project_id, trigger_id: trigger_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_build_trigger ::Google::Cloud::Build::V1::GetBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_build_trigger(::Google::Cloud::Build::V1::GetBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_build_trigger_client_stub.call_count
      end
    end
  end

  def test_list_build_triggers
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::ListBuildTriggersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    project_id = "hello world"
    page_size = 42
    page_token = "hello world"

    list_build_triggers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_list_build_triggers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_build_triggers_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_build_triggers({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_build_triggers parent: parent, project_id: project_id, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_build_triggers ::Google::Cloud::Build::V1::ListBuildTriggersRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_build_triggers({ parent: parent, project_id: project_id, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_build_triggers(::Google::Cloud::Build::V1::ListBuildTriggersRequest.new(parent: parent, project_id: project_id, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_build_triggers_client_stub.call_count
      end
    end
  end

  def test_delete_build_trigger
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    trigger_id = "hello world"

    delete_build_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_delete_build_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_build_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_build_trigger name: name, project_id: project_id, trigger_id: trigger_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_build_trigger ::Google::Cloud::Build::V1::DeleteBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_build_trigger(::Google::Cloud::Build::V1::DeleteBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_build_trigger_client_stub.call_count
      end
    end
  end

  def test_update_build_trigger
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::BuildTrigger.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    trigger_id = "hello world"
    trigger = {}
    update_mask = {}

    update_build_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_update_build_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_build_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_build_trigger({ project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_build_trigger project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_build_trigger ::Google::Cloud::Build::V1::UpdateBuildTriggerRequest.new(project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_build_trigger({ project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_build_trigger(::Google::Cloud::Build::V1::UpdateBuildTriggerRequest.new(project_id: project_id, trigger_id: trigger_id, trigger: trigger, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_build_trigger_client_stub.call_count
      end
    end
  end

  def test_run_build_trigger
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    project_id = "hello world"
    trigger_id = "hello world"
    source = {}

    run_build_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_run_build_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_build_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id, source: source }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_build_trigger name: name, project_id: project_id, trigger_id: trigger_id, source: source do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_build_trigger ::Google::Cloud::Build::V1::RunBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id, source: source) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_build_trigger({ name: name, project_id: project_id, trigger_id: trigger_id, source: source }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_build_trigger(::Google::Cloud::Build::V1::RunBuildTriggerRequest.new(name: name, project_id: project_id, trigger_id: trigger_id, source: source), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_build_trigger_client_stub.call_count
      end
    end
  end

  def test_receive_trigger_webhook
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::ReceiveTriggerWebhookResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    body = {}
    project_id = "hello world"
    trigger = "hello world"
    secret = "hello world"

    receive_trigger_webhook_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_receive_trigger_webhook_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, receive_trigger_webhook_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.receive_trigger_webhook({ name: name, body: body, project_id: project_id, trigger: trigger, secret: secret }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.receive_trigger_webhook name: name, body: body, project_id: project_id, trigger: trigger, secret: secret do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.receive_trigger_webhook ::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest.new(name: name, body: body, project_id: project_id, trigger: trigger, secret: secret) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.receive_trigger_webhook({ name: name, body: body, project_id: project_id, trigger: trigger, secret: secret }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.receive_trigger_webhook(::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest.new(name: name, body: body, project_id: project_id, trigger: trigger, secret: secret), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, receive_trigger_webhook_client_stub.call_count
      end
    end
  end

  def test_create_worker_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    worker_pool = {}
    worker_pool_id = "hello world"
    validate_only = true

    create_worker_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_create_worker_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_worker_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_worker_pool({ parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_worker_pool parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_worker_pool ::Google::Cloud::Build::V1::CreateWorkerPoolRequest.new(parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_worker_pool({ parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_worker_pool(::Google::Cloud::Build::V1::CreateWorkerPoolRequest.new(parent: parent, worker_pool: worker_pool, worker_pool_id: worker_pool_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_worker_pool_client_stub.call_count
      end
    end
  end

  def test_get_worker_pool
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::WorkerPool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_worker_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_get_worker_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_worker_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_worker_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_worker_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_worker_pool ::Google::Cloud::Build::V1::GetWorkerPoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_worker_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_worker_pool(::Google::Cloud::Build::V1::GetWorkerPoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_worker_pool_client_stub.call_count
      end
    end
  end

  def test_delete_worker_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_worker_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_delete_worker_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_worker_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_worker_pool({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_worker_pool name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_worker_pool ::Google::Cloud::Build::V1::DeleteWorkerPoolRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_worker_pool({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_worker_pool(::Google::Cloud::Build::V1::DeleteWorkerPoolRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_worker_pool_client_stub.call_count
      end
    end
  end

  def test_update_worker_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    worker_pool = {}
    update_mask = {}
    validate_only = true

    update_worker_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_update_worker_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_worker_pool_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_worker_pool({ worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_worker_pool worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_worker_pool ::Google::Cloud::Build::V1::UpdateWorkerPoolRequest.new(worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_worker_pool({ worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_worker_pool(::Google::Cloud::Build::V1::UpdateWorkerPoolRequest.new(worker_pool: worker_pool, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_worker_pool_client_stub.call_count
      end
    end
  end

  def test_list_worker_pools
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::ListWorkerPoolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_worker_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_list_worker_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_worker_pools_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_worker_pools({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_worker_pools parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_worker_pools ::Google::Cloud::Build::V1::ListWorkerPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_worker_pools({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_worker_pools(::Google::Cloud::Build::V1::ListWorkerPoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_worker_pools_client_stub.call_count
      end
    end
  end

  def test_get_default_service_account
    # Create test objects.
    client_result = ::Google::Cloud::Build::V1::DefaultServiceAccount.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_default_service_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.stub :transcode_get_default_service_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_default_service_account_client_stub do
        # Create client
        client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_default_service_account({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_default_service_account name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_default_service_account ::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_default_service_account({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_default_service_account(::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_default_service_account_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Build::V1::CloudBuild::Rest::Client::Configuration, config
  end
end
