# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/build/v1/cloud_build"

class ::Google::Cloud::Build::V1::CloudBuild::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_build_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.build_path project: "value0", build: "value1"
      assert_equal "projects/value0/builds/value1", path

      path = client.build_path project: "value0", location: "value1", build: "value2"
      assert_equal "projects/value0/locations/value1/builds/value2", path
    end
  end

  def test_build_trigger_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.build_trigger_path project: "value0", trigger: "value1"
      assert_equal "projects/value0/triggers/value1", path

      path = client.build_trigger_path project: "value0", location: "value1", trigger: "value2"
      assert_equal "projects/value0/locations/value1/triggers/value2", path
    end
  end

  def test_crypto_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.crypto_key_path project: "value0", location: "value1", keyring: "value2", key: "value3"
      assert_equal "projects/value0/locations/value1/keyRings/value2/cryptoKeys/value3", path
    end
  end

  def test_default_service_account_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.default_service_account_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/defaultServiceAccount", path
    end
  end

  def test_git_repository_link_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.git_repository_link_path project: "value0", location: "value1", connection: "value2", git_repository_link: "value3"
      assert_equal "projects/value0/locations/value1/connections/value2/gitRepositoryLinks/value3", path
    end
  end

  def test_github_enterprise_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.github_enterprise_config_path project: "value0", config: "value1"
      assert_equal "projects/value0/githubEnterpriseConfigs/value1", path

      path = client.github_enterprise_config_path project: "value0", location: "value1", config: "value2"
      assert_equal "projects/value0/locations/value1/githubEnterpriseConfigs/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_path project: "value0", network: "value1"
      assert_equal "projects/value0/global/networks/value1", path
    end
  end

  def test_network_attachment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_attachment_path project: "value0", region: "value1", networkattachment: "value2"
      assert_equal "projects/value0/regions/value1/networkAttachments/value2", path
    end
  end

  def test_project_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.project_path project: "value0"
      assert_equal "projects/value0", path
    end
  end

  def test_repository_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.repository_path project: "value0", location: "value1", connection: "value2", repository: "value3"
      assert_equal "projects/value0/locations/value1/connections/value2/repositories/value3", path
    end
  end

  def test_secret_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.secret_version_path project: "value0", secret: "value1", version: "value2"
      assert_equal "projects/value0/secrets/value1/versions/value2", path
    end
  end

  def test_service_account_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.service_account_path project: "value0", service_account: "value1"
      assert_equal "projects/value0/serviceAccounts/value1", path
    end
  end

  def test_subscription_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.subscription_path project: "value0", subscription: "value1"
      assert_equal "projects/value0/subscriptions/value1", path
    end
  end

  def test_topic_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.topic_path project: "value0", topic: "value1"
      assert_equal "projects/value0/topics/value1", path
    end
  end

  def test_worker_pool_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Build::V1::CloudBuild::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.worker_pool_path project: "value0", location: "value1", worker_pool: "value2"
      assert_equal "projects/value0/locations/value1/workerPools/value2", path
    end
  end
end
