# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Build
      module V1
        # Returns the default service account that will be used for `Builds`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `DefaultServiceAccount` to retrieve.
        #     Format:
        #     `projects/{project}/locations/{location}/defaultServiceAccount`
        class GetDefaultServiceAccountRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The default service account used for `Builds`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Format:
        #     `projects/{project}/locations/{location}/defaultServiceAccount`
        # @!attribute [r] service_account_email
        #   @return [::String]
        #     Output only. The email address of the service account identity that will be
        #     used for a build by default.
        #
        #     This is returned in the format
        #     `projects/{project}/serviceAccounts/{service_account}` where
        #     `{service_account}` could be the legacy Cloud Build SA, in the format
        #     [PROJECT_NUMBER]@cloudbuild.gserviceaccount.com or the Compute SA, in the
        #     format [PROJECT_NUMBER]-compute@developer.gserviceaccount.com.
        #
        #     If no service account will be used by default, this will be empty.
        class DefaultServiceAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies a build to retry.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the `Build` to retry.
        #     Format: `projects/{project}/locations/{location}/builds/{build}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. Build ID of the original build.
        class RetryBuildRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies a build trigger to run and the source to use.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the `Trigger` to run.
        #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project.
        # @!attribute [rw] trigger_id
        #   @return [::String]
        #     Required. ID of the trigger.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::Build::V1::RepoSource]
        #     Source to build against this trigger.
        #     Branch and tag names cannot consist of regular expressions.
        class RunBuildTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of the source in an archive file in Cloud Storage.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Cloud Storage bucket containing the source (see
        #     [Bucket Name
        #     Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        # @!attribute [rw] object
        #   @return [::String]
        #     Required. Cloud Storage object containing the source.
        #
        #     This object must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`)
        #     containing source to build.
        # @!attribute [rw] generation
        #   @return [::Integer]
        #     Optional. Cloud Storage generation for the object. If the generation is
        #     omitted, the latest generation will be used.
        # @!attribute [rw] source_fetcher
        #   @return [::Google::Cloud::Build::V1::StorageSource::SourceFetcher]
        #     Optional. Option to specify the tool to fetch the source file for the
        #     build.
        class StorageSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the tool to fetch the source file for the build.
          module SourceFetcher
            # Unspecified defaults to GSUTIL.
            SOURCE_FETCHER_UNSPECIFIED = 0

            # Use the "gsutil" tool to download the source file.
            GSUTIL = 1

            # Use the Cloud Storage Fetcher tool to download the source file.
            GCS_FETCHER = 2
          end
        end

        # Location of the source in any accessible Git repository.
        # @!attribute [rw] url
        #   @return [::String]
        #     Required. Location of the Git repo to build.
        #
        #     This will be used as a `git remote`, see
        #     https://git-scm.com/docs/git-remote.
        # @!attribute [rw] dir
        #   @return [::String]
        #     Optional. Directory, relative to the source root, in which to run the
        #     build.
        #
        #     This must be a relative path. If a step's `dir` is specified and is an
        #     absolute path, this value is ignored for that step's execution.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Optional. The revision to fetch from the Git repository such as a branch, a
        #     tag, a commit SHA, or any Git ref.
        #
        #     Cloud Build uses `git fetch` to fetch the revision from the Git
        #     repository; therefore make sure that the string you provide for `revision`
        #     is parsable  by the command. For information on string values accepted by
        #     `git fetch`, see
        #     https://git-scm.com/docs/gitrevisions#_specifying_revisions. For
        #     information on `git fetch`, see https://git-scm.com/docs/git-fetch.
        class GitSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of the source in a Google Cloud Source Repository.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Optional. ID of the project that owns the Cloud Source Repository. If
        #     omitted, the project ID requesting the build is assumed.
        # @!attribute [rw] repo_name
        #   @return [::String]
        #     Required. Name of the Cloud Source Repository.
        # @!attribute [rw] branch_name
        #   @return [::String]
        #     Regex matching branches to build.
        #
        #     The syntax of the regular expressions accepted is the syntax accepted by
        #     RE2 and described at https://github.com/google/re2/wiki/Syntax
        #
        #     Note: The following fields are mutually exclusive: `branch_name`, `tag_name`, `commit_sha`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_name
        #   @return [::String]
        #     Regex matching tags to build.
        #
        #     The syntax of the regular expressions accepted is the syntax accepted by
        #     RE2 and described at https://github.com/google/re2/wiki/Syntax
        #
        #     Note: The following fields are mutually exclusive: `tag_name`, `branch_name`, `commit_sha`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] commit_sha
        #   @return [::String]
        #     Explicit commit SHA to build.
        #
        #     Note: The following fields are mutually exclusive: `commit_sha`, `branch_name`, `tag_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dir
        #   @return [::String]
        #     Optional. Directory, relative to the source root, in which to run the
        #     build.
        #
        #     This must be a relative path. If a step's `dir` is specified and is an
        #     absolute path, this value is ignored for that step's execution.
        # @!attribute [rw] invert_regex
        #   @return [::Boolean]
        #     Optional. Only trigger a build if the revision regex does NOT match the
        #     revision regex.
        # @!attribute [rw] substitutions
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Substitutions to use in a triggered build.
        #     Should only be used with RunBuildTrigger
        class RepoSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class SubstitutionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Location of the source manifest in Cloud Storage.
        # This feature is in Preview; see description
        # [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Required. Cloud Storage bucket containing the source manifest (see [Bucket
        #     Name
        #     Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        # @!attribute [rw] object
        #   @return [::String]
        #     Required. Cloud Storage object containing the source manifest.
        #
        #     This object must be a JSON file.
        # @!attribute [rw] generation
        #   @return [::Integer]
        #     Cloud Storage generation for the object. If the generation is
        #     omitted, the latest generation will be used.
        class StorageSourceManifest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of the source in a 2nd-gen Google Cloud Build repository resource.
        # @!attribute [rw] repository
        #   @return [::String]
        #     Required. Name of the Google Cloud Build repository, formatted as
        #     `projects/*/locations/*/connections/*/repositories/*`.
        # @!attribute [rw] dir
        #   @return [::String]
        #     Optional. Directory, relative to the source root, in which to run the
        #     build.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Required. The revision to fetch from the Git repository such as a branch, a
        #     tag, a commit SHA, or any Git ref.
        class ConnectedRepository
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of the source in a supported storage service.
        # @!attribute [rw] storage_source
        #   @return [::Google::Cloud::Build::V1::StorageSource]
        #     If provided, get the source from this location in Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `storage_source`, `repo_source`, `git_source`, `storage_source_manifest`, `connected_repository`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] repo_source
        #   @return [::Google::Cloud::Build::V1::RepoSource]
        #     If provided, get the source from this location in a Cloud Source
        #     Repository.
        #
        #     Note: The following fields are mutually exclusive: `repo_source`, `storage_source`, `git_source`, `storage_source_manifest`, `connected_repository`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] git_source
        #   @return [::Google::Cloud::Build::V1::GitSource]
        #     If provided, get the source from this Git repository.
        #
        #     Note: The following fields are mutually exclusive: `git_source`, `storage_source`, `repo_source`, `storage_source_manifest`, `connected_repository`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] storage_source_manifest
        #   @return [::Google::Cloud::Build::V1::StorageSourceManifest]
        #     If provided, get the source from this manifest in Cloud Storage.
        #     This feature is in Preview; see description
        #     [here](https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
        #
        #     Note: The following fields are mutually exclusive: `storage_source_manifest`, `storage_source`, `repo_source`, `git_source`, `connected_repository`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] connected_repository
        #   @return [::Google::Cloud::Build::V1::ConnectedRepository]
        #     Optional. If provided, get the source from this 2nd-gen Google Cloud
        #     Build repository resource.
        #
        #     Note: The following fields are mutually exclusive: `connected_repository`, `storage_source`, `repo_source`, `git_source`, `storage_source_manifest`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Source
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An image built by the pipeline.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name used to push the container image to Google Container Registry, as
        #     presented to `docker push`.
        # @!attribute [rw] digest
        #   @return [::String]
        #     Docker Registry 2.0 digest.
        # @!attribute [r] push_timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Output only. Stores timing information for pushing the specified image.
        # @!attribute [r] artifact_registry_package
        #   @return [::String]
        #     Output only. Path to the artifact in Artifact Registry.
        class BuiltImage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Artifact uploaded using the PythonPackage directive.
        # @!attribute [rw] uri
        #   @return [::String]
        #     URI of the uploaded artifact.
        # @!attribute [rw] file_hashes
        #   @return [::Google::Cloud::Build::V1::FileHashes]
        #     Hash types and values of the Python Artifact.
        # @!attribute [r] push_timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Output only. Stores timing information for pushing the specified artifact.
        # @!attribute [r] artifact_registry_package
        #   @return [::String]
        #     Output only. Path to the artifact in Artifact Registry.
        class UploadedPythonPackage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Maven artifact uploaded using the MavenArtifact directive.
        # @!attribute [rw] uri
        #   @return [::String]
        #     URI of the uploaded artifact.
        # @!attribute [rw] file_hashes
        #   @return [::Google::Cloud::Build::V1::FileHashes]
        #     Hash types and values of the Maven Artifact.
        # @!attribute [r] push_timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Output only. Stores timing information for pushing the specified artifact.
        # @!attribute [r] artifact_registry_package
        #   @return [::String]
        #     Output only. Path to the artifact in Artifact Registry.
        class UploadedMavenArtifact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Go module artifact uploaded to Artifact Registry using the GoModule
        # directive.
        # @!attribute [rw] uri
        #   @return [::String]
        #     URI of the uploaded artifact.
        # @!attribute [rw] file_hashes
        #   @return [::Google::Cloud::Build::V1::FileHashes]
        #     Hash types and values of the Go Module Artifact.
        # @!attribute [r] push_timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Output only. Stores timing information for pushing the specified artifact.
        # @!attribute [r] artifact_registry_package
        #   @return [::String]
        #     Output only. Path to the artifact in Artifact Registry.
        class UploadedGoModule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An npm package uploaded to Artifact Registry using the NpmPackage
        # directive.
        # @!attribute [rw] uri
        #   @return [::String]
        #     URI of the uploaded npm package.
        # @!attribute [rw] file_hashes
        #   @return [::Google::Cloud::Build::V1::FileHashes]
        #     Hash types and values of the npm package.
        # @!attribute [r] push_timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Output only. Stores timing information for pushing the specified artifact.
        # @!attribute [r] artifact_registry_package
        #   @return [::String]
        #     Output only. Path to the artifact in Artifact Registry.
        class UploadedNpmPackage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A step in the build pipeline.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the container image that will run this particular
        #     build step.
        #
        #     If the image is available in the host's Docker daemon's cache, it
        #     will be run directly. If not, the host will attempt to pull the image
        #     first, using the builder service account's credentials if necessary.
        #
        #     The Docker daemon's cache will already have the latest versions of all of
        #     the officially supported build steps
        #     ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
        #     The Docker daemon will also have cached many of the layers for some popular
        #     images, like "ubuntu", "debian", but they will be refreshed at the time you
        #     attempt to use them.
        #
        #     If you built an image in a previous build step, it will be stored in the
        #     host's Docker daemon's cache and is available to use as the name for a
        #     later build step.
        # @!attribute [rw] env
        #   @return [::Array<::String>]
        #     A list of environment variable definitions to be used when running a step.
        #
        #     The elements are of the form "KEY=VALUE" for the environment variable "KEY"
        #     being given the value "VALUE".
        # @!attribute [rw] args
        #   @return [::Array<::String>]
        #     A list of arguments that will be presented to the step when it is started.
        #
        #     If the image used to run the step's container has an entrypoint, the `args`
        #     are used as arguments to that entrypoint. If the image does not define
        #     an entrypoint, the first element in args is used as the entrypoint,
        #     and the remainder will be used as arguments.
        # @!attribute [rw] dir
        #   @return [::String]
        #     Working directory to use when running this step's container.
        #
        #     If this value is a relative path, it is relative to the build's working
        #     directory. If this value is absolute, it may be outside the build's working
        #     directory, in which case the contents of the path may not be persisted
        #     across build step executions, unless a `volume` for that path is specified.
        #
        #     If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
        #     which specifies an absolute path, the `RepoSource` `dir` is ignored for
        #     the step's execution.
        # @!attribute [rw] id
        #   @return [::String]
        #     Unique identifier for this build step, used in `wait_for` to
        #     reference this build step as a dependency.
        # @!attribute [rw] wait_for
        #   @return [::Array<::String>]
        #     The ID(s) of the step(s) that this build step depends on.
        #     This build step will not start until all the build steps in `wait_for`
        #     have completed successfully. If `wait_for` is empty, this build step will
        #     start when all previous build steps in the `Build.Steps` list have
        #     completed successfully.
        # @!attribute [rw] entrypoint
        #   @return [::String]
        #     Entrypoint to be used instead of the build step image's default entrypoint.
        #     If unset, the image's default entrypoint is used.
        # @!attribute [rw] secret_env
        #   @return [::Array<::String>]
        #     A list of environment variables which are encrypted using a Cloud Key
        #     Management Service crypto key. These values must be specified in the
        #     build's `Secret`.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::Build::V1::Volume>]
        #     List of volumes to mount into the build step.
        #
        #     Each volume is created as an empty volume prior to execution of the
        #     build step. Upon completion of the build, volumes and their contents are
        #     discarded.
        #
        #     Using a named volume in only one step is not valid as it is indicative
        #     of a build request with an incorrect configuration.
        # @!attribute [r] timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Output only. Stores timing information for executing this build step.
        # @!attribute [r] pull_timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Output only. Stores timing information for pulling this build step's
        #     builder image only.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Time limit for executing this build step. If not defined, the step has no
        #     time limit and will be allowed to continue to run until either it completes
        #     or the build itself times out.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Build::V1::Build::Status]
        #     Output only. Status of the build step. At this time, build step status is
        #     only updated on build completion; step status is not updated in real-time
        #     as the build progresses.
        # @!attribute [rw] allow_failure
        #   @return [::Boolean]
        #     Allow this build step to fail without failing the entire build.
        #
        #     If false, the entire build will fail if this step fails. Otherwise, the
        #     build will succeed, but this step will still have a failure status.
        #     Error information will be reported in the failure_detail field.
        # @!attribute [r] exit_code
        #   @return [::Integer]
        #     Output only. Return code from running the step.
        # @!attribute [rw] allow_exit_codes
        #   @return [::Array<::Integer>]
        #     Allow this build step to fail without failing the entire build if and
        #     only if the exit code is one of the specified codes. If allow_failure
        #     is also specified, this field will take precedence.
        # @!attribute [rw] script
        #   @return [::String]
        #     A shell script to be executed in the step.
        #
        #     When script is provided, the user cannot specify the entrypoint or args.
        # @!attribute [rw] automap_substitutions
        #   @return [::Boolean]
        #     Option to include built-in and custom substitutions as env variables
        #     for this build step. This option will override the global option
        #     in BuildOption.
        class BuildStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Volume describes a Docker container volume which is mounted into build steps
        # in order to persist files across build step execution.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the volume to mount.
        #
        #     Volume names must be unique per build step and must be valid names for
        #     Docker volumes. Each named volume must be used by at least two build steps.
        # @!attribute [rw] path
        #   @return [::String]
        #     Path at which to mount the volume.
        #
        #     Paths must be absolute and cannot conflict with other volume paths on the
        #     same build step or with certain reserved volume paths.
        class Volume
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Artifacts created by the build pipeline.
        # @!attribute [rw] images
        #   @return [::Array<::Google::Cloud::Build::V1::BuiltImage>]
        #     Container images that were built as a part of the build.
        # @!attribute [rw] build_step_images
        #   @return [::Array<::String>]
        #     List of build step digests, in the order corresponding to build step
        #     indices.
        # @!attribute [rw] artifact_manifest
        #   @return [::String]
        #     Path to the artifact manifest for non-container artifacts uploaded to Cloud
        #     Storage. Only populated when artifacts are uploaded to Cloud Storage.
        # @!attribute [rw] num_artifacts
        #   @return [::Integer]
        #     Number of non-container artifacts uploaded to Cloud Storage. Only populated
        #     when artifacts are uploaded to Cloud Storage.
        # @!attribute [rw] build_step_outputs
        #   @return [::Array<::String>]
        #     List of build step outputs, produced by builder images, in the order
        #     corresponding to build step indices.
        #
        #     [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
        #     can produce this output by writing to `$BUILDER_OUTPUT/output`. Only the
        #     first 50KB of data is stored. Note that the `$BUILDER_OUTPUT` variable is
        #     read-only and can't be substituted.
        # @!attribute [rw] artifact_timing
        #   @return [::Google::Cloud::Build::V1::TimeSpan]
        #     Time to push all non-container artifacts to Cloud Storage.
        # @!attribute [rw] python_packages
        #   @return [::Array<::Google::Cloud::Build::V1::UploadedPythonPackage>]
        #     Python artifacts uploaded to Artifact Registry at the end of the build.
        # @!attribute [rw] maven_artifacts
        #   @return [::Array<::Google::Cloud::Build::V1::UploadedMavenArtifact>]
        #     Maven artifacts uploaded to Artifact Registry at the end of the build.
        # @!attribute [rw] go_modules
        #   @return [::Array<::Google::Cloud::Build::V1::UploadedGoModule>]
        #     Optional. Go module artifacts uploaded to Artifact Registry at the end of
        #     the build.
        # @!attribute [rw] npm_packages
        #   @return [::Array<::Google::Cloud::Build::V1::UploadedNpmPackage>]
        #     Npm packages uploaded to Artifact Registry at the end of the build.
        class Results
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An artifact that was uploaded during a build. This
        # is a single record in the artifact manifest JSON file.
        # @!attribute [rw] location
        #   @return [::String]
        #     The path of an artifact in a Cloud Storage bucket, with the
        #     generation number. For example,
        #     `gs://mybucket/path/to/output.jar#generation`.
        # @!attribute [rw] file_hash
        #   @return [::Array<::Google::Cloud::Build::V1::FileHashes>]
        #     The file hash of the artifact.
        class ArtifactResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A build resource in the Cloud Build API.
        #
        # At a high level, a `Build` describes where to find source code, how to build
        # it (for example, the builder image to run on the source), and where to store
        # the built artifacts.
        #
        # Fields can include the following variables, which will be expanded when the
        # build is created:
        #
        # - $PROJECT_ID: the project ID of the build.
        # - $PROJECT_NUMBER: the project number of the build.
        # - $LOCATION: the location/region of the build.
        # - $BUILD_ID: the autogenerated ID of the build.
        # - $REPO_NAME: the source repository name specified by RepoSource.
        # - $BRANCH_NAME: the branch name specified by RepoSource.
        # - $TAG_NAME: the tag name specified by RepoSource.
        # - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
        #   resolved from the specified branch or tag.
        # - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The 'Build' name with format:
        #     `projects/{project}/locations/{location}/builds/{build}`, where \\{build}
        #     is a unique identifier generated by the service.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. Unique identifier of the build.
        # @!attribute [r] project_id
        #   @return [::String]
        #     Output only. ID of the project.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Build::V1::Build::Status]
        #     Output only. Status of the build.
        # @!attribute [r] status_detail
        #   @return [::String]
        #     Output only. Customer-readable message about the current status.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::Build::V1::Source]
        #     Optional. The location of the source files to build.
        # @!attribute [rw] steps
        #   @return [::Array<::Google::Cloud::Build::V1::BuildStep>]
        #     Required. The operations to be performed on the workspace.
        # @!attribute [r] results
        #   @return [::Google::Cloud::Build::V1::Results]
        #     Output only. Results of the build.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the request to create the build was received.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which execution of the build was started.
        # @!attribute [r] finish_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which execution of the build was finished.
        #
        #     The difference between finish_time and start_time is the duration of the
        #     build's execution.
        # @!attribute [rw] timeout
        #   @return [::Google::Protobuf::Duration]
        #     Amount of time that this build should be allowed to run, to second
        #     granularity. If this amount of time elapses, work on the build will cease
        #     and the build status will be `TIMEOUT`.
        #
        #     `timeout` starts ticking from `startTime`.
        #
        #     Default time is 60 minutes.
        # @!attribute [rw] images
        #   @return [::Array<::String>]
        #     A list of images to be pushed upon the successful completion of all build
        #     steps.
        #
        #     The images are pushed using the builder service account's credentials.
        #
        #     The digests of the pushed images will be stored in the `Build` resource's
        #     results field.
        #
        #     If any of the images fail to be pushed, the build status is marked
        #     `FAILURE`.
        # @!attribute [rw] queue_ttl
        #   @return [::Google::Protobuf::Duration]
        #     TTL in queue for this build. If provided and the build is enqueued longer
        #     than this value, the build will expire and the build status will be
        #     `EXPIRED`.
        #
        #     The TTL starts ticking from create_time.
        # @!attribute [rw] artifacts
        #   @return [::Google::Cloud::Build::V1::Artifacts]
        #     Artifacts produced by the build that should be uploaded upon
        #     successful completion of all build steps.
        # @!attribute [rw] logs_bucket
        #   @return [::String]
        #     Cloud Storage bucket where logs should be written (see
        #     [Bucket Name
        #     Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        #     Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
        # @!attribute [r] source_provenance
        #   @return [::Google::Cloud::Build::V1::SourceProvenance]
        #     Output only. A permanent fixed identifier for source.
        # @!attribute [r] build_trigger_id
        #   @return [::String]
        #     Output only. The ID of the `BuildTrigger` that triggered this build, if it
        #     was triggered automatically.
        # @!attribute [rw] options
        #   @return [::Google::Cloud::Build::V1::BuildOptions]
        #     Special options for this build.
        # @!attribute [r] log_url
        #   @return [::String]
        #     Output only. URL to logs for this build in Google Cloud Console.
        # @!attribute [rw] substitutions
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Substitutions data for `Build` resource.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Tags for annotation of a `Build`. These are not docker tags.
        # @!attribute [rw] secrets
        #   @return [::Array<::Google::Cloud::Build::V1::Secret>]
        #     Secrets to decrypt using Cloud Key Management Service.
        #     Note: Secret Manager is the recommended technique
        #     for managing sensitive data with Cloud Build. Use `available_secrets` to
        #     configure builds to access secrets from Secret Manager. For instructions,
        #     see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
        # @!attribute [r] timing
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Build::V1::TimeSpan}]
        #     Output only. Stores timing information for phases of the build. Valid keys
        #     are:
        #
        #     * BUILD: time to execute all build steps.
        #     * PUSH: time to push all artifacts including docker images and non docker
        #     artifacts.
        #     * FETCHSOURCE: time to fetch source.
        #     * SETUPBUILD: time to set up build.
        #
        #     If the build does not specify source or images,
        #     these keys will not be included.
        # @!attribute [r] approval
        #   @return [::Google::Cloud::Build::V1::BuildApproval]
        #     Output only. Describes this build's approval configuration, status,
        #     and result.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     IAM service account whose credentials will be used at build runtime.
        #     Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
        #     ACCOUNT can be email address or uniqueId of the service account.
        # @!attribute [rw] available_secrets
        #   @return [::Google::Cloud::Build::V1::Secrets]
        #     Secrets and secret environment variables.
        # @!attribute [r] warnings
        #   @return [::Array<::Google::Cloud::Build::V1::Build::Warning>]
        #     Output only. Non-fatal problems encountered during the execution of the
        #     build.
        # @!attribute [rw] git_config
        #   @return [::Google::Cloud::Build::V1::GitConfig]
        #     Optional. Configuration for git operations.
        # @!attribute [r] failure_info
        #   @return [::Google::Cloud::Build::V1::Build::FailureInfo]
        #     Output only. Contains information about the build when status=FAILURE.
        # @!attribute [rw] dependencies
        #   @return [::Array<::Google::Cloud::Build::V1::Dependency>]
        #     Optional. Dependencies that the Cloud Build worker will fetch before
        #     executing user steps.
        class Build
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A non-fatal problem encountered during the execution of the build.
          # @!attribute [rw] text
          #   @return [::String]
          #     Explanation of the warning generated.
          # @!attribute [rw] priority
          #   @return [::Google::Cloud::Build::V1::Build::Warning::Priority]
          #     The priority for this warning.
          class Warning
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The relative importance of this warning.
            module Priority
              # Should not be used.
              PRIORITY_UNSPECIFIED = 0

              # e.g. deprecation warnings and alternative feature highlights.
              INFO = 1

              # e.g. automated detection of possible issues with the build.
              WARNING = 2

              # e.g. alerts that a feature used in the build is pending removal
              ALERT = 3
            end
          end

          # A fatal problem encountered during the execution of the build.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Build::V1::Build::FailureInfo::FailureType]
          #     The name of the failure.
          # @!attribute [rw] detail
          #   @return [::String]
          #     Explains the failure issue in more detail using hard-coded text.
          class FailureInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The name of a fatal problem encountered during the execution of the
            # build.
            module FailureType
              # Type unspecified
              FAILURE_TYPE_UNSPECIFIED = 0

              # Unable to push the image to the repository.
              PUSH_FAILED = 1

              # Final image not found.
              PUSH_IMAGE_NOT_FOUND = 2

              # Unauthorized push of the final image.
              PUSH_NOT_AUTHORIZED = 3

              # Backend logging failures. Should retry.
              LOGGING_FAILURE = 4

              # A build step has failed.
              USER_BUILD_STEP = 5

              # The source fetching has failed.
              FETCH_SOURCE_FAILED = 6
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class SubstitutionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Build::V1::TimeSpan]
          class TimingEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible status of a build or build step.
          module Status
            # Status of the build is unknown.
            STATUS_UNKNOWN = 0

            # Build has been created and is pending execution and queuing. It has not
            # been queued.
            PENDING = 10

            # Build or step is queued; work has not yet begun.
            QUEUED = 1

            # Build or step is being executed.
            WORKING = 2

            # Build or step finished successfully.
            SUCCESS = 3

            # Build or step failed to complete successfully.
            FAILURE = 4

            # Build or step failed due to an internal cause.
            INTERNAL_ERROR = 5

            # Build or step took longer than was allowed.
            TIMEOUT = 6

            # Build or step was canceled by a user.
            CANCELLED = 7

            # Build was enqueued for longer than the value of `queue_ttl`.
            EXPIRED = 9
          end
        end

        # A dependency that the Cloud Build worker will fetch before executing user
        # steps.
        # @!attribute [rw] empty
        #   @return [::Boolean]
        #     If set to true disable all dependency fetching (ignoring the default
        #     source as well).
        #
        #     Note: The following fields are mutually exclusive: `empty`, `git_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] git_source
        #   @return [::Google::Cloud::Build::V1::Dependency::GitSourceDependency]
        #     Represents a git repository as a build dependency.
        #
        #     Note: The following fields are mutually exclusive: `git_source`, `empty`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Dependency
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a git repository as a build dependency.
          # @!attribute [rw] repository
          #   @return [::Google::Cloud::Build::V1::Dependency::GitSourceRepository]
          #     Required. The kind of repo (url or dev connect).
          # @!attribute [rw] revision
          #   @return [::String]
          #     Required. The revision that we will fetch the repo at.
          # @!attribute [rw] recurse_submodules
          #   @return [::Boolean]
          #     Optional. True if submodules should be fetched too (default false).
          # @!attribute [rw] depth
          #   @return [::Integer]
          #     Optional. How much history should be fetched for the build (default 1, -1
          #     for all history).
          # @!attribute [rw] dest_path
          #   @return [::String]
          #     Required. Where should the files be placed on the worker.
          class GitSourceDependency
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A repository for a git source.
          # @!attribute [rw] url
          #   @return [::String]
          #     Location of the Git repository.
          #
          #     Note: The following fields are mutually exclusive: `url`, `developer_connect`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] developer_connect
          #   @return [::String]
          #     The Developer Connect Git repository link formatted as
          #     `projects/*/locations/*/connections/*/gitRepositoryLink/*`
          #
          #     Note: The following fields are mutually exclusive: `developer_connect`, `url`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class GitSourceRepository
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # GitConfig is a configuration for git operations.
        # @!attribute [rw] http
        #   @return [::Google::Cloud::Build::V1::GitConfig::HttpConfig]
        #     Configuration for HTTP related git operations.
        class GitConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # HttpConfig is a configuration for HTTP related git operations.
          # @!attribute [rw] proxy_secret_version_name
          #   @return [::String]
          #     SecretVersion resource of the HTTP proxy URL. The Service Account used in
          #     the build (either the default Service Account or
          #     user-specified Service Account) should have
          #     `secretmanager.versions.access` permissions on this secret. The proxy URL
          #     should be in format `[protocol://][user[:password]@]proxyhost[:port]`.
          class HttpConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Artifacts produced by a build that should be uploaded upon
        # successful completion of all build steps.
        # @!attribute [rw] images
        #   @return [::Array<::String>]
        #     A list of images to be pushed upon the successful completion of all build
        #     steps.
        #
        #     The images will be pushed using the builder service account's credentials.
        #
        #     The digests of the pushed images will be stored in the Build resource's
        #     results field.
        #
        #     If any of the images fail to be pushed, the build is marked FAILURE.
        # @!attribute [rw] objects
        #   @return [::Google::Cloud::Build::V1::Artifacts::ArtifactObjects]
        #     A list of objects to be uploaded to Cloud Storage upon successful
        #     completion of all build steps.
        #
        #     Files in the workspace matching specified paths globs will be uploaded to
        #     the specified Cloud Storage location using the builder service account's
        #     credentials.
        #
        #     The location and generation of the uploaded objects will be stored in the
        #     Build resource's results field.
        #
        #     If any objects fail to be pushed, the build is marked FAILURE.
        # @!attribute [rw] maven_artifacts
        #   @return [::Array<::Google::Cloud::Build::V1::Artifacts::MavenArtifact>]
        #     A list of Maven artifacts to be uploaded to Artifact Registry upon
        #     successful completion of all build steps.
        #
        #     Artifacts in the workspace matching specified paths globs will be uploaded
        #     to the specified Artifact Registry repository using the builder service
        #     account's credentials.
        #
        #     If any artifacts fail to be pushed, the build is marked FAILURE.
        # @!attribute [rw] go_modules
        #   @return [::Array<::Google::Cloud::Build::V1::Artifacts::GoModule>]
        #     Optional. A list of Go modules to be uploaded to Artifact Registry upon
        #     successful completion of all build steps.
        #
        #     If any objects fail to be pushed, the build is marked FAILURE.
        # @!attribute [rw] python_packages
        #   @return [::Array<::Google::Cloud::Build::V1::Artifacts::PythonPackage>]
        #     A list of Python packages to be uploaded to Artifact Registry upon
        #     successful completion of all build steps.
        #
        #     The build service account credentials will be used to perform the upload.
        #
        #     If any objects fail to be pushed, the build is marked FAILURE.
        # @!attribute [rw] npm_packages
        #   @return [::Array<::Google::Cloud::Build::V1::Artifacts::NpmPackage>]
        #     A list of npm packages to be uploaded to Artifact Registry upon
        #     successful completion of all build steps.
        #
        #     Npm packages in the specified paths will be uploaded
        #     to the specified Artifact Registry repository using the builder service
        #     account's credentials.
        #
        #     If any packages fail to be pushed, the build is marked FAILURE.
        class Artifacts
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Files in the workspace to upload to Cloud Storage upon successful
          # completion of all build steps.
          # @!attribute [rw] location
          #   @return [::String]
          #     Cloud Storage bucket and optional object path, in the form
          #     "gs://bucket/path/to/somewhere/". (see [Bucket Name
          #     Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
          #
          #     Files in the workspace matching any path pattern will be uploaded to
          #     Cloud Storage with this location as a prefix.
          # @!attribute [rw] paths
          #   @return [::Array<::String>]
          #     Path globs used to match files in the build's workspace.
          # @!attribute [r] timing
          #   @return [::Google::Cloud::Build::V1::TimeSpan]
          #     Output only. Stores timing information for pushing all artifact objects.
          class ArtifactObjects
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A Maven artifact to upload to Artifact Registry upon successful completion
          # of all build steps.
          # @!attribute [rw] repository
          #   @return [::String]
          #     Artifact Registry repository, in the form
          #     "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
          #
          #     Artifact in the workspace specified by path will be uploaded to
          #     Artifact Registry with this location as a prefix.
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. Path to an artifact in the build's workspace to be uploaded to
          #     Artifact Registry.
          #     This can be either an absolute path,
          #     e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar
          #     or a relative path from /workspace,
          #     e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
          # @!attribute [rw] artifact_id
          #   @return [::String]
          #     Maven `artifactId` value used when uploading the artifact to Artifact
          #     Registry.
          # @!attribute [rw] group_id
          #   @return [::String]
          #     Maven `groupId` value used when uploading the artifact to Artifact
          #     Registry.
          # @!attribute [rw] version
          #   @return [::String]
          #     Maven `version` value used when uploading the artifact to Artifact
          #     Registry.
          class MavenArtifact
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Go module to upload to Artifact Registry upon successful completion of all
          # build steps. A module refers to all dependencies in a go.mod file.
          # @!attribute [rw] repository_name
          #   @return [::String]
          #     Optional. Artifact Registry repository name.
          #
          #     Specified Go modules will be zipped and uploaded to Artifact Registry
          #     with this location as a prefix.
          #     e.g. my-go-repo
          # @!attribute [rw] repository_location
          #   @return [::String]
          #     Optional. Location of the Artifact Registry repository. i.e. us-east1
          #     Defaults to the build’s location.
          # @!attribute [rw] repository_project_id
          #   @return [::String]
          #     Optional. Project ID of the Artifact Registry repository.
          #     Defaults to the build project.
          # @!attribute [rw] source_path
          #   @return [::String]
          #     Optional. Source path of the go.mod file in the build's workspace. If not
          #     specified, this will default to the current directory.
          #     e.g. ~/code/go/mypackage
          # @!attribute [rw] module_path
          #   @return [::String]
          #     Optional. The Go module's "module path".
          #     e.g. example.com/foo/v2
          # @!attribute [rw] module_version
          #   @return [::String]
          #     Optional. The Go module's semantic version in the form vX.Y.Z. e.g.
          #     v0.1.1 Pre-release identifiers can also be added by appending a dash and
          #     dot separated ASCII alphanumeric characters and hyphens.
          #     e.g. v0.2.3-alpha.x.12m.5
          class GoModule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Python package to upload to Artifact Registry upon successful completion
          # of all build steps. A package can encapsulate multiple objects to be
          # uploaded to a single repository.
          # @!attribute [rw] repository
          #   @return [::String]
          #     Artifact Registry repository, in the form
          #     "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
          #
          #     Files in the workspace matching any path pattern will be uploaded to
          #     Artifact Registry with this location as a prefix.
          # @!attribute [rw] paths
          #   @return [::Array<::String>]
          #     Path globs used to match files in the build's workspace. For Python/
          #     Twine, this is usually `dist/*`, and sometimes additionally an `.asc`
          #     file.
          class PythonPackage
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Npm package to upload to Artifact Registry upon successful completion
          # of all build steps.
          # @!attribute [rw] repository
          #   @return [::String]
          #     Artifact Registry repository, in the form
          #     "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
          #
          #     Npm package in the workspace specified by path will be zipped and
          #     uploaded to Artifact Registry with this location as a prefix.
          # @!attribute [rw] package_path
          #   @return [::String]
          #     Optional. Path to the package.json.
          #     e.g. workspace/path/to/package
          #
          #     Only one of `archive` or `package_path` can be specified.
          class NpmPackage
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Start and end times for a build execution phase.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Start of time span.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     End of time span.
        class TimeSpan
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for build operations.
        # @!attribute [rw] build
        #   @return [::Google::Cloud::Build::V1::Build]
        #     The build that the operation is tracking.
        class BuildOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Provenance of the source. Ways to find the original source, or verify that
        # some source was used for this build.
        # @!attribute [rw] resolved_storage_source
        #   @return [::Google::Cloud::Build::V1::StorageSource]
        #     A copy of the build's `source.storage_source`, if exists, with any
        #     generations resolved.
        # @!attribute [rw] resolved_repo_source
        #   @return [::Google::Cloud::Build::V1::RepoSource]
        #     A copy of the build's `source.repo_source`, if exists, with any
        #     revisions resolved.
        # @!attribute [rw] resolved_storage_source_manifest
        #   @return [::Google::Cloud::Build::V1::StorageSourceManifest]
        #     A copy of the build's `source.storage_source_manifest`, if exists, with any
        #     revisions resolved.
        #     This feature is in Preview.
        # @!attribute [r] resolved_connected_repository
        #   @return [::Google::Cloud::Build::V1::ConnectedRepository]
        #     Output only. A copy of the build's `source.connected_repository`, if
        #     exists, with any revisions resolved.
        # @!attribute [r] resolved_git_source
        #   @return [::Google::Cloud::Build::V1::GitSource]
        #     Output only. A copy of the build's `source.git_source`, if exists, with any
        #     revisions resolved.
        # @!attribute [r] file_hashes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Build::V1::FileHashes}]
        #     Output only. Hash(es) of the build source, which can be used to verify that
        #     the original source integrity was maintained in the build. Note that
        #     `FileHashes` will only be populated if `BuildOptions` has requested a
        #     `SourceProvenanceHash`.
        #
        #     The keys to this map are file paths used as build source and the values
        #     contain the hash values for those files.
        #
        #     If the build source came in a single package such as a gzipped tarfile
        #     (`.tar.gz`), the `FileHash` will be for the single path to that file.
        class SourceProvenance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Build::V1::FileHashes]
          class FileHashesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Container message for hashes of byte content of files, used in
        # SourceProvenance messages to verify integrity of source input to the build.
        # @!attribute [rw] file_hash
        #   @return [::Array<::Google::Cloud::Build::V1::Hash>]
        #     Collection of file hashes.
        class FileHashes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Container message for hash values.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Build::V1::Hash::HashType]
        #     The type of hash that was performed.
        # @!attribute [rw] value
        #   @return [::String]
        #     The hash value.
        class Hash
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the hash algorithm, if any.
          module HashType
            # No hash requested.
            NONE = 0

            # Use a sha256 hash.
            SHA256 = 1

            # Use a md5 hash.
            MD5 = 2

            # Dirhash of a Go module's source code which is then hex-encoded.
            GO_MODULE_H1 = 3

            # Use a sha512 hash.
            SHA512 = 4
          end
        end

        # Secrets and secret environment variables.
        # @!attribute [rw] secret_manager
        #   @return [::Array<::Google::Cloud::Build::V1::SecretManagerSecret>]
        #     Secrets in Secret Manager and associated secret environment variable.
        # @!attribute [rw] inline
        #   @return [::Array<::Google::Cloud::Build::V1::InlineSecret>]
        #     Secrets encrypted with KMS key and the associated secret environment
        #     variable.
        class Secrets
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Pairs a set of secret environment variables mapped to encrypted
        # values with the Cloud KMS key to use to decrypt the value.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Resource name of Cloud KMS crypto key to decrypt the encrypted value.
        #     In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        # @!attribute [rw] env_map
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Map of environment variable name to its encrypted value.
        #
        #     Secret environment variables must be unique across all of a build's
        #     secrets, and must be used by at least one build step. Values can be at most
        #     64 KB in size. There can be at most 100 secret values across all of a
        #     build's secrets.
        class InlineSecret
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class EnvMapEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Pairs a secret environment variable with a SecretVersion in Secret Manager.
        # @!attribute [rw] version_name
        #   @return [::String]
        #     Resource name of the SecretVersion. In format:
        #     projects/*/secrets/*/versions/*
        # @!attribute [rw] env
        #   @return [::String]
        #     Environment variable name to associate with the secret.
        #     Secret environment variables must be unique across all of a build's
        #     secrets, and must be used by at least one build step.
        class SecretManagerSecret
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Pairs a set of secret environment variables containing encrypted
        # values with the Cloud KMS key to use to decrypt the value.
        # Note: Use `kmsKeyName` with  `available_secrets` instead of using
        # `kmsKeyName` with `secret`. For instructions see:
        # https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Cloud KMS key name to use to decrypt these envs.
        # @!attribute [rw] secret_env
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Map of environment variable name to its encrypted value.
        #
        #     Secret environment variables must be unique across all of a build's
        #     secrets, and must be used by at least one build step. Values can be at most
        #     64 KB in size. There can be at most 100 secret values across all of a
        #     build's secrets.
        class Secret
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class SecretEnvEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request to create a new build.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent resource where this build will be created.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project.
        # @!attribute [rw] build
        #   @return [::Google::Cloud::Build::V1::Build]
        #     Required. Build resource to create.
        class CreateBuildRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a build.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the `Build` to retrieve.
        #     Format: `projects/{project}/locations/{location}/builds/{build}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the build.
        class GetBuildRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list builds.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent of the collection of `Builds`.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Number of results to return in the list.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token for the next page of Builds.
        #
        #     If unspecified, the first page of results is returned.
        #
        #     If the token is rejected for any reason, INVALID_ARGUMENT will be thrown.
        #     In this case, the token should be discarded, and pagination should be
        #     restarted from the first page of results.
        #
        #     See https://google.aip.dev/158 for more.
        # @!attribute [rw] filter
        #   @return [::String]
        #     The raw filter text to constrain the results.
        class ListBuildsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response including listed builds.
        # @!attribute [rw] builds
        #   @return [::Array<::Google::Cloud::Build::V1::Build>]
        #     Builds will be sorted by `create_time`, descending.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to receive the next page of results.
        #     This will be absent if the end of the response list has been reached.
        class ListBuildsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to cancel an ongoing build.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the `Build` to cancel.
        #     Format: `projects/{project}/locations/{location}/builds/{build}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the build.
        class CancelBuildRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to approve or reject a pending build.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the target build.
        #     For example: "projects/\\{$project_id}/builds/\\{$build_id}"
        # @!attribute [rw] approval_result
        #   @return [::Google::Cloud::Build::V1::ApprovalResult]
        #     Approval decision and metadata.
        class ApproveBuildRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BuildApproval describes a build's approval configuration, state, and
        # result.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Build::V1::BuildApproval::State]
        #     Output only. The state of this build's approval.
        # @!attribute [r] config
        #   @return [::Google::Cloud::Build::V1::ApprovalConfig]
        #     Output only. Configuration for manual approval of this build.
        # @!attribute [r] result
        #   @return [::Google::Cloud::Build::V1::ApprovalResult]
        #     Output only. Result of manual approval for this Build.
        class BuildApproval
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies the current state of a build's approval.
          module State
            # Default enum type. This should not be used.
            STATE_UNSPECIFIED = 0

            # Build approval is pending.
            PENDING = 1

            # Build approval has been approved.
            APPROVED = 2

            # Build approval has been rejected.
            REJECTED = 3

            # Build was cancelled while it was still pending approval.
            CANCELLED = 5
          end
        end

        # ApprovalConfig describes configuration for manual approval of a build.
        # @!attribute [rw] approval_required
        #   @return [::Boolean]
        #     Whether or not approval is needed. If this is set on a build, it will
        #     become pending when created, and will need to be explicitly approved
        #     to start.
        class ApprovalConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ApprovalResult describes the decision and associated metadata of a manual
        # approval of a build.
        # @!attribute [r] approver_account
        #   @return [::String]
        #     Output only. Email of the user that called the ApproveBuild API to
        #     approve or reject a build at the time that the API was called.
        # @!attribute [r] approval_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the approval decision was made.
        # @!attribute [rw] decision
        #   @return [::Google::Cloud::Build::V1::ApprovalResult::Decision]
        #     Required. The decision of this manual approval.
        # @!attribute [rw] comment
        #   @return [::String]
        #     Optional. An optional comment for this manual approval result.
        # @!attribute [rw] url
        #   @return [::String]
        #     Optional. An optional URL tied to this manual approval result. This field
        #     is essentially the same as comment, except that it will be rendered by the
        #     UI differently. An example use case is a link to an external job that
        #     approved this Build.
        class ApprovalResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies whether or not this manual approval result is to approve
          # or reject a build.
          module Decision
            # Default enum type. This should not be used.
            DECISION_UNSPECIFIED = 0

            # Build is approved.
            APPROVED = 1

            # Build is rejected.
            REJECTED = 2
          end
        end

        # GitRepoSource describes a repo and ref of a code repository.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the repo (e.g. https://github.com/user/repo.git).
        #     Either `uri` or `repository` can be specified and is required.
        # @!attribute [rw] repository
        #   @return [::String]
        #     The connected repository resource name, in the format
        #     `projects/*/locations/*/connections/*/repositories/*`. Either `uri` or
        #     `repository` can be specified and is required.
        # @!attribute [rw] ref
        #   @return [::String]
        #     The branch or tag to use. Must start with "refs/" (required).
        # @!attribute [rw] repo_type
        #   @return [::Google::Cloud::Build::V1::GitFileSource::RepoType]
        #     See RepoType below.
        # @!attribute [rw] github_enterprise_config
        #   @return [::String]
        #     The full resource name of the github enterprise config.
        #     Format:
        #     `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
        #     `projects/{project}/githubEnterpriseConfigs/{id}`.
        class GitRepoSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GitFileSource describes a file within a (possibly remote) code repository.
        # @!attribute [rw] path
        #   @return [::String]
        #     The path of the file, with the repo root as the root of the path.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the repo.
        #     Either uri or repository can be specified.
        #     If unspecified, the repo from which the trigger invocation originated is
        #     assumed to be the repo from which to read the specified path.
        # @!attribute [rw] repository
        #   @return [::String]
        #     The fully qualified resource name of the Repos API repository.
        #     Either URI or repository can be specified.
        #     If unspecified, the repo from which the trigger invocation originated is
        #     assumed to be the repo from which to read the specified path.
        # @!attribute [rw] repo_type
        #   @return [::Google::Cloud::Build::V1::GitFileSource::RepoType]
        #     See RepoType above.
        # @!attribute [rw] revision
        #   @return [::String]
        #     The branch, tag, arbitrary ref, or SHA version of the repo to use when
        #     resolving the filename (optional).
        #     This field respects the same syntax/resolution as described here:
        #     https://git-scm.com/docs/gitrevisions
        #     If unspecified, the revision from which the trigger invocation originated
        #     is assumed to be the revision from which to read the specified path.
        # @!attribute [rw] github_enterprise_config
        #   @return [::String]
        #     The full resource name of the github enterprise config.
        #     Format:
        #     `projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}`.
        #     `projects/{project}/githubEnterpriseConfigs/{id}`.
        class GitFileSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the repo, since it may not be explicit from the `repo` field
          # (e.g from a URL).
          module RepoType
            # The default, unknown repo type. Don't use it, instead use one of
            # the other repo types.
            UNKNOWN = 0

            # A Google Cloud Source Repositories-hosted repo.
            CLOUD_SOURCE_REPOSITORIES = 1

            # A GitHub-hosted repo not necessarily on "github.com" (i.e. GitHub
            # Enterprise).
            GITHUB = 2

            # A Bitbucket Server-hosted repo.
            BITBUCKET_SERVER = 3

            # A GitLab-hosted repo.
            GITLAB = 4
          end
        end

        # Configuration for an automated build in response to source repository
        # changes.
        # @!attribute [rw] resource_name
        #   @return [::String]
        #     The `Trigger` name with format:
        #     `projects/{project}/locations/{location}/triggers/{trigger}`, where
        #     \\{trigger} is a unique identifier generated by the service.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. Unique identifier of the trigger.
        # @!attribute [rw] description
        #   @return [::String]
        #     Human-readable description of this trigger.
        # @!attribute [rw] name
        #   @return [::String]
        #     User-assigned name of the trigger. Must be unique within the project.
        #     Trigger names must meet the following requirements:
        #
        #     + They must contain only alphanumeric characters and dashes.
        #     + They can be 1-64 characters long.
        #     + They must begin and end with an alphanumeric character.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Tags for annotation of a `BuildTrigger`
        # @!attribute [rw] trigger_template
        #   @return [::Google::Cloud::Build::V1::RepoSource]
        #     Template describing the types of source changes to trigger a build.
        #
        #     Branch and tag names in trigger templates are interpreted as regular
        #     expressions. Any branch or tag change that matches that regular expression
        #     will trigger a build.
        #
        #     Mutually exclusive with `github`.
        # @!attribute [rw] github
        #   @return [::Google::Cloud::Build::V1::GitHubEventsConfig]
        #     GitHubEventsConfig describes the configuration of a trigger that creates
        #     a build whenever a GitHub event is received.
        #
        #     Mutually exclusive with `trigger_template`.
        # @!attribute [rw] pubsub_config
        #   @return [::Google::Cloud::Build::V1::PubsubConfig]
        #     PubsubConfig describes the configuration of a trigger that
        #     creates a build whenever a Pub/Sub message is published.
        # @!attribute [rw] webhook_config
        #   @return [::Google::Cloud::Build::V1::WebhookConfig]
        #     WebhookConfig describes the configuration of a trigger that
        #     creates a build whenever a webhook is sent to a trigger's webhook URL.
        # @!attribute [rw] autodetect
        #   @return [::Boolean]
        #     Autodetect build configuration.  The following precedence is used (case
        #     insensitive):
        #
        #     1. cloudbuild.yaml
        #     2. cloudbuild.yml
        #     3. cloudbuild.json
        #     4. Dockerfile
        #
        #     Currently only available for GitHub App Triggers.
        #
        #     Note: The following fields are mutually exclusive: `autodetect`, `build`, `filename`, `git_file_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] build
        #   @return [::Google::Cloud::Build::V1::Build]
        #     Contents of the build template.
        #
        #     Note: The following fields are mutually exclusive: `build`, `autodetect`, `filename`, `git_file_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] filename
        #   @return [::String]
        #     Path, from the source root, to the build configuration file
        #     (i.e. cloudbuild.yaml).
        #
        #     Note: The following fields are mutually exclusive: `filename`, `autodetect`, `build`, `git_file_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] git_file_source
        #   @return [::Google::Cloud::Build::V1::GitFileSource]
        #     The file source describing the local or remote Build template.
        #
        #     Note: The following fields are mutually exclusive: `git_file_source`, `autodetect`, `build`, `filename`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the trigger was created.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     If true, the trigger will never automatically execute a build.
        # @!attribute [rw] substitutions
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Substitutions for Build resource. The keys must match the following
        #     regular expression: `^_[A-Z0-9_]+$`.
        # @!attribute [rw] ignored_files
        #   @return [::Array<::String>]
        #     ignored_files and included_files are file glob matches using
        #     https://golang.org/pkg/path/filepath/#Match extended with support for "**".
        #
        #     If ignored_files and changed files are both empty, then they are
        #     not used to determine whether or not to trigger a build.
        #
        #     If ignored_files is not empty, then we ignore any files that match
        #     any of the ignored_file globs. If the change has no files that are
        #     outside of the ignored_files globs, then we do not trigger a build.
        # @!attribute [rw] included_files
        #   @return [::Array<::String>]
        #     If any of the files altered in the commit pass the ignored_files
        #     filter and included_files is empty, then as far as this filter is
        #     concerned, we should trigger the build.
        #
        #     If any of the files altered in the commit pass the ignored_files
        #     filter and included_files is not empty, then we make sure that at
        #     least one of those files matches a included_files glob. If not,
        #     then we do not trigger a build.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A Common Expression Language string.
        # @!attribute [rw] source_to_build
        #   @return [::Google::Cloud::Build::V1::GitRepoSource]
        #     The repo and ref of the repository from which to build. This field
        #     is used only for those triggers that do not respond to SCM events.
        #     Triggers that respond to such events build source at whatever commit
        #     caused the event.
        #     This field is currently only used by Webhook, Pub/Sub, Manual, and Cron
        #     triggers.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account used for all user-controlled operations including
        #     UpdateBuildTrigger, RunBuildTrigger, CreateBuild, and CancelBuild.
        #     If no service account is set and the legacy Cloud Build service account
        #     (`[PROJECT_NUM]@cloudbuild.gserviceaccount.com`) is the default for the
        #     project then it will be used instead.
        #     Format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}`
        # @!attribute [rw] repository_event_config
        #   @return [::Google::Cloud::Build::V1::RepositoryEventConfig]
        #     The configuration of a trigger that creates a build whenever an event from
        #     Repo API is received.
        class BuildTrigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class SubstitutionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The configuration of a trigger that creates a build whenever an event from
        # Repo API is received.
        # @!attribute [rw] repository
        #   @return [::String]
        #     The resource name of the Repo API resource.
        # @!attribute [r] repository_type
        #   @return [::Google::Cloud::Build::V1::RepositoryEventConfig::RepositoryType]
        #     Output only. The type of the SCM vendor the repository points to.
        # @!attribute [rw] pull_request
        #   @return [::Google::Cloud::Build::V1::PullRequestFilter]
        #     Filter to match changes in pull requests.
        #
        #     Note: The following fields are mutually exclusive: `pull_request`, `push`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] push
        #   @return [::Google::Cloud::Build::V1::PushFilter]
        #     Filter to match changes in refs like branches, tags.
        #
        #     Note: The following fields are mutually exclusive: `push`, `pull_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RepositoryEventConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # All possible SCM repo types from Repo API.
          module RepositoryType
            # If unspecified, RepositoryType defaults to GITHUB.
            REPOSITORY_TYPE_UNSPECIFIED = 0

            # The SCM repo is GITHUB.
            GITHUB = 1

            # The SCM repo is GITHUB Enterprise.
            GITHUB_ENTERPRISE = 2

            # The SCM repo is GITLAB Enterprise.
            GITLAB_ENTERPRISE = 3
          end
        end

        # GitHubEventsConfig describes the configuration of a trigger that creates a
        # build whenever a GitHub event is received.
        # @!attribute [rw] installation_id
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     The installationID that emits the GitHub event.
        # @!attribute [rw] owner
        #   @return [::String]
        #     Owner of the repository. For example: The owner for
        #     https://github.com/googlecloudplatform/cloud-builders is
        #     "googlecloudplatform".
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the repository. For example: The name for
        #     https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        # @!attribute [rw] pull_request
        #   @return [::Google::Cloud::Build::V1::PullRequestFilter]
        #     filter to match changes in pull requests.
        #
        #     Note: The following fields are mutually exclusive: `pull_request`, `push`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] push
        #   @return [::Google::Cloud::Build::V1::PushFilter]
        #     filter to match changes in refs like branches, tags.
        #
        #     Note: The following fields are mutually exclusive: `push`, `pull_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class GitHubEventsConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PubsubConfig describes the configuration of a trigger that
        # creates a build whenever a Pub/Sub message is published.
        # @!attribute [r] subscription
        #   @return [::String]
        #     Output only. Name of the subscription. Format is
        #     `projects/{project}/subscriptions/{subscription}`.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Optional. The name of the topic from which this subscription is receiving
        #     messages. Format is `projects/{project}/topics/{topic}`.
        # @!attribute [rw] service_account_email
        #   @return [::String]
        #     Service account that will make the push request.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Build::V1::PubsubConfig::State]
        #     Potential issues with the underlying Pub/Sub subscription configuration.
        #     Only populated on get requests.
        class PubsubConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumerates potential issues with the underlying Pub/Sub subscription
          # configuration.
          module State
            # The subscription configuration has not been checked.
            STATE_UNSPECIFIED = 0

            # The Pub/Sub subscription is properly configured.
            OK = 1

            # The subscription has been deleted.
            SUBSCRIPTION_DELETED = 2

            # The topic has been deleted.
            TOPIC_DELETED = 3

            # Some of the subscription's field are misconfigured.
            SUBSCRIPTION_MISCONFIGURED = 4
          end
        end

        # WebhookConfig describes the configuration of a trigger that
        # creates a build whenever a webhook is sent to a trigger's webhook URL.
        # @!attribute [rw] secret
        #   @return [::String]
        #     Required. Resource name for the secret required as a URL parameter.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Build::V1::WebhookConfig::State]
        #     Potential issues with the underlying Pub/Sub subscription configuration.
        #     Only populated on get requests.
        class WebhookConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumerates potential issues with the Secret Manager secret provided by the
          # user.
          module State
            # The webhook auth configuration not been checked.
            STATE_UNSPECIFIED = 0

            # The auth configuration is properly setup.
            OK = 1

            # The secret provided in auth_method has been deleted.
            SECRET_DELETED = 2
          end
        end

        # PullRequestFilter contains filter properties for matching GitHub Pull
        # Requests.
        # @!attribute [rw] branch
        #   @return [::String]
        #     Regex of branches to match.
        #
        #     The syntax of the regular expressions accepted is the syntax accepted by
        #     RE2 and described at https://github.com/google/re2/wiki/Syntax
        # @!attribute [rw] comment_control
        #   @return [::Google::Cloud::Build::V1::PullRequestFilter::CommentControl]
        #     If CommentControl is enabled, depending on the setting, builds may not
        #     fire until a repository writer comments `/gcbrun` on a pull
        #     request or `/gcbrun` is in the pull request description.
        #     Only PR comments that contain `/gcbrun` will trigger builds.
        #
        #     If CommentControl is set to disabled, comments with `/gcbrun` from a user
        #     with repository write permission or above will
        #     still trigger builds to run.
        # @!attribute [rw] invert_regex
        #   @return [::Boolean]
        #     If true, branches that do NOT match the git_ref will trigger a build.
        class PullRequestFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Controls whether or not a `/gcbrun` comment is required from a user with
          #  repository write permission or above in order to
          #  trigger Build runs for pull requests. Pull Request update events differ
          #  between repo types.
          #  Check repo specific guides
          # ([GitHub](https://cloud.google.com/build/docs/automating-builds/github/build-repos-from-github-enterprise#creating_a_github_enterprise_trigger),
          # [Bitbucket](https://cloud.google.com/build/docs/automating-builds/bitbucket/build-repos-from-bitbucket-server#creating_a_bitbucket_server_trigger),
          # [GitLab](https://cloud.google.com/build/docs/automating-builds/gitlab/build-repos-from-gitlab#creating_a_gitlab_trigger)
          #  for details.
          module CommentControl
            # Do not require `/gcbrun` comments from a user with repository write
            # permission or above on pull requests before builds are triggered.
            # Comments that contain `/gcbrun` will still fire builds so this should
            # be thought of as comments not required.
            COMMENTS_DISABLED = 0

            # Builds will only fire in response to pull requests if:
            # 1. The pull request author has repository write permission or above and
            # `/gcbrun` is in the PR description.
            # 2. A user with repository writer permissions or above comments `/gcbrun`
            # on a pull request authored by any user.
            COMMENTS_ENABLED = 1

            # Builds will only fire in response to pull requests if:
            # 1. The pull request author is a repository writer or above.
            # 2. If the author does not have write permissions, a user with write
            # permissions or above must comment `/gcbrun` in order to fire a build.
            COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY = 2
          end
        end

        # Push contains filter properties for matching GitHub git pushes.
        # @!attribute [rw] branch
        #   @return [::String]
        #     Regexes matching branches to build.
        #
        #     The syntax of the regular expressions accepted is the syntax accepted by
        #     RE2 and described at https://github.com/google/re2/wiki/Syntax
        #
        #     Note: The following fields are mutually exclusive: `branch`, `tag`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag
        #   @return [::String]
        #     Regexes matching tags to build.
        #
        #     The syntax of the regular expressions accepted is the syntax accepted by
        #     RE2 and described at https://github.com/google/re2/wiki/Syntax
        #
        #     Note: The following fields are mutually exclusive: `tag`, `branch`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] invert_regex
        #   @return [::Boolean]
        #     When true, only trigger a build if the revision regex does NOT match the
        #     git_ref regex.
        class PushFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to create a new `BuildTrigger`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent resource where this trigger will be created.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project for which to configure automatic builds.
        # @!attribute [rw] trigger
        #   @return [::Google::Cloud::Build::V1::BuildTrigger]
        #     Required. `BuildTrigger` to create.
        class CreateBuildTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Returns the `BuildTrigger` with the specified ID.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the `Trigger` to retrieve.
        #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project that owns the trigger.
        # @!attribute [rw] trigger_id
        #   @return [::String]
        #     Required. Identifier (`id` or `name`) of the `BuildTrigger` to get.
        class GetBuildTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list existing `BuildTriggers`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent of the collection of `Triggers`.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project for which to list BuildTriggers.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Number of results to return in the list.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token to provide to skip to a particular spot in the list.
        class ListBuildTriggersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response containing existing `BuildTriggers`.
        # @!attribute [rw] triggers
        #   @return [::Array<::Google::Cloud::Build::V1::BuildTrigger>]
        #     `BuildTriggers` for the project, sorted by `create_time` descending.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to receive the next page of results.
        class ListBuildTriggersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete a `BuildTrigger`.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the `Trigger` to delete.
        #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project that owns the trigger.
        # @!attribute [rw] trigger_id
        #   @return [::String]
        #     Required. ID of the `BuildTrigger` to delete.
        class DeleteBuildTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to update an existing `BuildTrigger`.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. ID of the project that owns the trigger.
        # @!attribute [rw] trigger_id
        #   @return [::String]
        #     Required. ID of the `BuildTrigger` to update.
        # @!attribute [rw] trigger
        #   @return [::Google::Cloud::Build::V1::BuildTrigger]
        #     Required. `BuildTrigger` to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Update mask for the resource. If this is set,
        #     the server will only update the fields specified in the field mask.
        #     Otherwise, a full update of the mutable resource fields will be performed.
        class UpdateBuildTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Optional arguments to enable specific features of builds.
        # @!attribute [rw] source_provenance_hash
        #   @return [::Array<::Google::Cloud::Build::V1::Hash::HashType>]
        #     Requested hash for SourceProvenance.
        # @!attribute [rw] requested_verify_option
        #   @return [::Google::Cloud::Build::V1::BuildOptions::VerifyOption]
        #     Requested verifiability options.
        # @!attribute [rw] machine_type
        #   @return [::Google::Cloud::Build::V1::BuildOptions::MachineType]
        #     Compute Engine machine type on which to run the build.
        # @!attribute [rw] disk_size_gb
        #   @return [::Integer]
        #     Requested disk size for the VM that runs the build. Note that this is *NOT*
        #     "disk free"; some of the space will be used by the operating system and
        #     build utilities. Also note that this is the minimum disk size that will be
        #     allocated for the build -- the build may run with a larger disk than
        #     requested. At present, the maximum disk size is 4000GB; builds that request
        #     more than the maximum are rejected with an error.
        # @!attribute [rw] substitution_option
        #   @return [::Google::Cloud::Build::V1::BuildOptions::SubstitutionOption]
        #     Option to specify behavior when there is an error in the substitution
        #     checks.
        #
        #     NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot
        #     be overridden in the build configuration file.
        # @!attribute [rw] dynamic_substitutions
        #   @return [::Boolean]
        #     Option to specify whether or not to apply bash style string
        #     operations to the substitutions.
        #
        #     NOTE: this is always enabled for triggered builds and cannot be
        #     overridden in the build configuration file.
        # @!attribute [rw] automap_substitutions
        #   @return [::Boolean]
        #     Option to include built-in and custom substitutions as env variables
        #     for all build steps.
        # @!attribute [rw] log_streaming_option
        #   @return [::Google::Cloud::Build::V1::BuildOptions::LogStreamingOption]
        #     Option to define build log streaming behavior to Cloud
        #     Storage.
        # @!attribute [rw] worker_pool
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     This field deprecated; please use `pool.name` instead.
        # @!attribute [rw] pool
        #   @return [::Google::Cloud::Build::V1::BuildOptions::PoolOption]
        #     Optional. Specification for execution on a `WorkerPool`.
        #
        #     See [running builds in a private
        #     pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool)
        #     for more information.
        # @!attribute [rw] logging
        #   @return [::Google::Cloud::Build::V1::BuildOptions::LoggingMode]
        #     Option to specify the logging mode, which determines if and where build
        #     logs are stored.
        # @!attribute [rw] env
        #   @return [::Array<::String>]
        #     A list of global environment variable definitions that will exist for all
        #     build steps in this build. If a variable is defined in both globally and in
        #     a build step, the variable will use the build step value.
        #
        #     The elements are of the form "KEY=VALUE" for the environment variable "KEY"
        #     being given the value "VALUE".
        # @!attribute [rw] secret_env
        #   @return [::Array<::String>]
        #     A list of global environment variables, which are encrypted using a Cloud
        #     Key Management Service crypto key. These values must be specified in the
        #     build's `Secret`. These variables will be available to all build steps
        #     in this build.
        # @!attribute [rw] volumes
        #   @return [::Array<::Google::Cloud::Build::V1::Volume>]
        #     Global list of volumes to mount for ALL build steps
        #
        #     Each volume is created as an empty volume prior to starting the build
        #     process. Upon completion of the build, volumes and their contents are
        #     discarded. Global volume names and paths cannot conflict with the volumes
        #     defined a build step.
        #
        #     Using a global volume in a build with only one step is not valid as
        #     it is indicative of a build request with an incorrect configuration.
        # @!attribute [rw] default_logs_bucket_behavior
        #   @return [::Google::Cloud::Build::V1::BuildOptions::DefaultLogsBucketBehavior]
        #     Optional. Option to specify how default logs buckets are setup.
        # @!attribute [rw] enable_structured_logging
        #   @return [::Boolean]
        #     Optional. Option to specify whether structured logging is enabled.
        #
        #     If true, JSON-formatted logs are parsed as structured logs.
        class BuildOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Details about how a build should be executed on a `WorkerPool`.
          #
          # See [running builds in a private
          # pool](https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool)
          # for more information.
          # @!attribute [rw] name
          #   @return [::String]
          #     The `WorkerPool` resource to execute the build on.
          #     You must have `cloudbuild.workerpools.use` on the project hosting the
          #     WorkerPool.
          #
          #     Format projects/\\{project}/locations/\\{location}/workerPools/\\{workerPoolId}
          class PoolOption
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Specifies the manner in which the build should be verified, if at all.
          #
          # If a verified build is requested, and any part of the process to generate
          # and upload provenance fails, the build will also fail.
          #
          # If the build does not request verification then that process may occur, but
          # is not guaranteed to. If it does occur and fails, the build will not fail.
          #
          # For more information, see [Viewing Build
          # Provenance](https://cloud.google.com/build/docs/securing-builds/view-build-provenance).
          module VerifyOption
            # Not a verifiable build (the default).
            NOT_VERIFIED = 0

            # Build must be verified.
            VERIFIED = 1
          end

          # Supported Compute Engine machine types.
          # For more information, see [Machine
          # types](https://cloud.google.com/compute/docs/machine-types).
          module MachineType
            # Standard machine type.
            UNSPECIFIED = 0

            # Highcpu machine with 8 CPUs.
            N1_HIGHCPU_8 = 1

            # Highcpu machine with 32 CPUs.
            N1_HIGHCPU_32 = 2

            # Highcpu e2 machine with 8 CPUs.
            E2_HIGHCPU_8 = 5

            # Highcpu e2 machine with 32 CPUs.
            E2_HIGHCPU_32 = 6

            # E2 machine with 1 CPU.
            E2_MEDIUM = 7
          end

          # Specifies the behavior when there is an error in the substitution checks.
          module SubstitutionOption
            # Fails the build if error in substitutions checks, like missing
            # a substitution in the template or in the map.
            MUST_MATCH = 0

            # Do not fail the build if error in substitutions checks.
            ALLOW_LOOSE = 1
          end

          # Specifies the behavior when writing build logs to Cloud Storage.
          module LogStreamingOption
            # Service may automatically determine build log streaming behavior.
            STREAM_DEFAULT = 0

            # Build logs should be streamed to Cloud Storage.
            STREAM_ON = 1

            # Build logs should not be streamed to Cloud Storage; they will be
            # written when the build is completed.
            STREAM_OFF = 2
          end

          # Specifies the logging mode.
          module LoggingMode
            # The service determines the logging mode. The default is `LEGACY`. Do not
            # rely on the default logging behavior as it may change in the future.
            LOGGING_UNSPECIFIED = 0

            # Build logs are stored in Cloud Logging and Cloud Storage.
            LEGACY = 1

            # Build logs are stored in Cloud Storage.
            GCS_ONLY = 2

            # This option is the same as CLOUD_LOGGING_ONLY.
            STACKDRIVER_ONLY = 3

            # Build logs are stored in Cloud Logging. Selecting this option will not
            # allow [logs
            # streaming](https://cloud.google.com/sdk/gcloud/reference/builds/log).
            CLOUD_LOGGING_ONLY = 5

            # Turn off all logging. No build logs will be captured.
            NONE = 4
          end

          # Default Cloud Storage log bucket behavior options.
          module DefaultLogsBucketBehavior
            # Unspecified.
            DEFAULT_LOGS_BUCKET_BEHAVIOR_UNSPECIFIED = 0

            # Bucket is located in user-owned project in the same region as the
            # build. The builder service account must have access to create and write
            # to Cloud Storage buckets in the build project.
            REGIONAL_USER_OWNED_BUCKET = 1

            # Bucket is located in a Google-owned project and is not regionalized.
            LEGACY_BUCKET = 2
          end
        end

        # ReceiveTriggerWebhookRequest [Experimental] is the request object accepted by
        # the ReceiveTriggerWebhook method.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the `ReceiveTriggerWebhook` to retrieve.
        #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
        # @!attribute [rw] body
        #   @return [::Google::Api::HttpBody]
        #     HTTP request body.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project in which the specified trigger lives
        # @!attribute [rw] trigger
        #   @return [::String]
        #     Name of the trigger to run the payload against
        # @!attribute [rw] secret
        #   @return [::String]
        #     Secret token used for authorization if an OAuth token isn't provided.
        class ReceiveTriggerWebhookRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ReceiveTriggerWebhookResponse [Experimental] is the response object for the
        # ReceiveTriggerWebhook method.
        class ReceiveTriggerWebhookResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GitHubEnterpriseConfig represents a configuration for a GitHub Enterprise
        # server.
        # @!attribute [rw] name
        #   @return [::String]
        #     The full resource name for the GitHubEnterpriseConfig
        #     For example:
        #     "projects/\\{$project_id}/locations/\\{$location_id}/githubEnterpriseConfigs/\\{$config_id}"
        # @!attribute [rw] host_url
        #   @return [::String]
        #     The URL of the github enterprise host the configuration is for.
        # @!attribute [rw] app_id
        #   @return [::Integer]
        #     Required. The GitHub app id of the Cloud Build app on the GitHub Enterprise
        #     server.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the installation was associated with the project.
        # @!attribute [rw] webhook_key
        #   @return [::String]
        #     The key that should be attached to webhook calls to the ReceiveWebhook
        #     endpoint.
        # @!attribute [rw] peered_network
        #   @return [::String]
        #     Optional. The network to be used when reaching out to the GitHub
        #     Enterprise server. The VPC network must be enabled for private
        #     service connection. This should be set if the GitHub Enterprise server is
        #     hosted on-premises and not reachable by public internet.
        #     If this field is left empty, no network peering will occur and calls to
        #     the GitHub Enterprise server will be made over the public internet.
        #     Must be in the format
        #     `projects/{project}/global/networks/{network}`, where \\{project}
        #     is a project number or id and \\{network} is the name of a
        #     VPC network in the project.
        # @!attribute [rw] secrets
        #   @return [::Google::Cloud::Build::V1::GitHubEnterpriseSecrets]
        #     Optional. Names of secrets in Secret Manager.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Name to display for this config.
        # @!attribute [rw] ssl_ca
        #   @return [::String]
        #     Optional. SSL certificate to use for requests to GitHub Enterprise.
        class GitHubEnterpriseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GitHubEnterpriseSecrets represents the names of all necessary secrets in
        # Secret Manager for a GitHub Enterprise server.
        # Format is: projects/<project number>/secrets/<secret name>.
        # @!attribute [rw] private_key_version_name
        #   @return [::String]
        #     The resource name for the private key secret version.
        # @!attribute [rw] webhook_secret_version_name
        #   @return [::String]
        #     The resource name for the webhook secret secret version in Secret Manager.
        # @!attribute [rw] oauth_secret_version_name
        #   @return [::String]
        #     The resource name for the OAuth secret secret version in Secret Manager.
        # @!attribute [rw] oauth_client_id_version_name
        #   @return [::String]
        #     The resource name for the OAuth client ID secret version in Secret Manager.
        class GitHubEnterpriseSecrets
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a `WorkerPool`.
        #
        # Cloud Build owns and maintains a pool of workers for general use and have no
        # access to a project's private network. By default, builds submitted to
        # Cloud Build will use a worker from this pool.
        #
        # If your build needs access to resources on a private network,
        # create and use a `WorkerPool` to run your builds. Private `WorkerPool`s give
        # your builds access to any single VPC network that you
        # administer, including any on-prem resources connected to that VPC
        # network. For an overview of private pools, see
        # [Private pools
        # overview](https://cloud.google.com/build/docs/private-pools/private-pools-overview).
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the `WorkerPool`, with format
        #     `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
        #     The value of `{worker_pool}` is provided by `worker_pool_id` in
        #     `CreateWorkerPool` request and the value of `{location}` is determined by
        #     the endpoint accessed.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     A user-specified, human-readable name for the `WorkerPool`. If provided,
        #     this value must be 1-63 characters.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A unique identifier for the `WorkerPool`.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User specified annotations. See https://google.aip.dev/128#annotations
        #     for more details such as format and size limitations.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the request to create the `WorkerPool` was
        #     received.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the request to update the `WorkerPool` was
        #     received.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the request to delete the `WorkerPool` was
        #     received.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Build::V1::WorkerPool::State]
        #     Output only. `WorkerPool` state.
        # @!attribute [rw] private_pool_v1_config
        #   @return [::Google::Cloud::Build::V1::PrivatePoolV1Config]
        #     Private Pool configuration.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. Checksum computed by the server. May be sent on update and
        #     delete requests to ensure that the client has an up-to-date value before
        #     proceeding.
        class WorkerPool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of the `WorkerPool`.
          module State
            # State of the `WorkerPool` is unknown.
            STATE_UNSPECIFIED = 0

            # `WorkerPool` is being created.
            CREATING = 1

            # `WorkerPool` is running.
            RUNNING = 2

            # `WorkerPool` is being deleted: cancelling builds and draining workers.
            DELETING = 3

            # `WorkerPool` is deleted.
            DELETED = 4

            # `WorkerPool` is being updated; new builds cannot be run.
            UPDATING = 5
          end
        end

        # Configuration for a V1 `PrivatePool`.
        # @!attribute [rw] worker_config
        #   @return [::Google::Cloud::Build::V1::PrivatePoolV1Config::WorkerConfig]
        #     Machine configuration for the workers in the pool.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::Build::V1::PrivatePoolV1Config::NetworkConfig]
        #     Network configuration for the pool.
        # @!attribute [rw] private_service_connect
        #   @return [::Google::Cloud::Build::V1::PrivatePoolV1Config::PrivateServiceConnect]
        #     Immutable. Private Service Connect(PSC) Network configuration for the pool.
        class PrivatePoolV1Config
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines the configuration to be used for creating workers in
          # the pool.
          # @!attribute [rw] machine_type
          #   @return [::String]
          #     Optional. Machine type of a worker, such as `e2-medium`.
          #     See [Worker pool config
          #     file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
          #     If left blank, Cloud Build will use a sensible default.
          # @!attribute [rw] disk_size_gb
          #   @return [::Integer]
          #     Size of the disk attached to the worker, in GB.
          #     See [Worker pool config
          #     file](https://cloud.google.com/build/docs/private-pools/worker-pool-config-file-schema).
          #     Specify a value of up to 4000. If `0` is specified, Cloud Build will use
          #     a standard disk size.
          # @!attribute [rw] enable_nested_virtualization
          #   @return [::Boolean]
          #     Optional. Enable nested virtualization on the worker, if supported by the
          #     machine type. By default, nested virtualization is disabled.
          class WorkerConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines the network configuration for the pool.
          # @!attribute [rw] peered_network
          #   @return [::String]
          #     Required. Immutable. The network definition that the workers are peered
          #     to. If this section is left empty, the workers will be peered to
          #     `WorkerPool.project_id` on the service producer network. Must be in the
          #     format `projects/{project}/global/networks/{network}`, where `{project}`
          #     is a project number, such as `12345`, and `{network}` is the name of a
          #     VPC network in the project. See
          #     [Understanding network configuration
          #     options](https://cloud.google.com/build/docs/private-pools/set-up-private-pool-environment)
          # @!attribute [rw] egress_option
          #   @return [::Google::Cloud::Build::V1::PrivatePoolV1Config::NetworkConfig::EgressOption]
          #     Option to configure network egress for the workers.
          # @!attribute [rw] peered_network_ip_range
          #   @return [::String]
          #     Immutable. Subnet IP range within the peered network. This is specified
          #     in CIDR notation with a slash and the subnet prefix size. You can
          #     optionally specify an IP address before the subnet prefix value. e.g.
          #     `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a
          #     prefix size of 29 bits.
          #     `/16` would specify a prefix size of 16 bits, with an automatically
          #     determined IP within the peered VPC.
          #     If unspecified, a value of `/24` will be used.
          class NetworkConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the egress option for the pool.
            module EgressOption
              # If set, defaults to PUBLIC_EGRESS.
              EGRESS_OPTION_UNSPECIFIED = 0

              # If set, workers are created without any public address, which prevents
              # network egress to public IPs unless a network proxy is configured.
              NO_PUBLIC_EGRESS = 1

              # If set, workers are created with a public address which allows for
              # public internet egress.
              PUBLIC_EGRESS = 2
            end
          end

          # Defines the Private Service Connect network configuration for the pool.
          # @!attribute [rw] network_attachment
          #   @return [::String]
          #     Required. Immutable. The network attachment that the worker network
          #     interface is peered to. Must be in the format
          #     `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`.
          #     The region of network attachment must be the same as the worker pool.
          #     See [Network
          #     Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
          # @!attribute [rw] public_ip_address_disabled
          #   @return [::Boolean]
          #     Required. Immutable. Disable public IP on the primary network interface.
          #
          #     If true, workers are created without any public address, which prevents
          #     network egress to public IPs unless a network proxy is configured.
          #     If false, workers are created with a public address which allows for
          #     public internet egress. The public address only applies to traffic
          #     through the primary network interface.
          #     If `route_all_traffic` is set to true, all traffic will go through the
          #     non-primary network interface, this boolean has no effect.
          # @!attribute [rw] route_all_traffic
          #   @return [::Boolean]
          #     Immutable. Route all traffic through PSC interface. Enable this if you
          #     want full control of traffic in the private pool. Configure Cloud NAT for
          #     the subnet of network attachment if you need to access public Internet.
          #
          #     If false, Only route RFC 1918 (10.0.0.0/8, 172.16.0.0/12, and
          #     192.168.0.0/16) and RFC 6598 (100.64.0.0/10) through PSC interface.
          class PrivateServiceConnect
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request to create a new `WorkerPool`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this worker pool will be created.
        #     Format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] worker_pool
        #   @return [::Google::Cloud::Build::V1::WorkerPool]
        #     Required. `WorkerPool` resource to create.
        # @!attribute [rw] worker_pool_id
        #   @return [::String]
        #     Required. Immutable. The ID to use for the `WorkerPool`, which will become
        #     the final component of the resource name.
        #
        #     This value should be 1-63 characters, and valid characters
        #     are /[a-z][0-9]-/.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the response, but do not actually
        #     post it.
        class CreateWorkerPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a `WorkerPool` with the specified name.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `WorkerPool` to retrieve.
        #     Format: `projects/{project}/locations/{location}/workerPools/{workerPool}`.
        class GetWorkerPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete a `WorkerPool`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `WorkerPool` to delete.
        #     Format:
        #     `projects/{project}/locations/{location}/workerPools/{workerPool}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If provided, it must match the server's etag on the workerpool
        #     for the request to be processed.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     If set to true, and the `WorkerPool` is not found, the request will succeed
        #     but no action will be taken on the server.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the response, but do not actually
        #     post it.
        class DeleteWorkerPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to update a `WorkerPool`.
        # @!attribute [rw] worker_pool
        #   @return [::Google::Cloud::Build::V1::WorkerPool]
        #     Required. The `WorkerPool` to update.
        #
        #     The `name` field is used to identify the `WorkerPool` to update.
        #     Format: `projects/{project}/locations/{location}/workerPools/{workerPool}`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. A mask specifying which fields in `worker_pool` to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     If set, validate the request and preview the response, but do not actually
        #     post it.
        class UpdateWorkerPoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list `WorkerPool`s.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the collection of `WorkerPools`.
        #     Format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of `WorkerPool`s to return. The service may return
        #     fewer than this value. If omitted, the server will use a sensible default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListWorkerPools` call. Provide this
        #     to retrieve the subsequent page.
        class ListWorkerPoolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response containing existing `WorkerPools`.
        # @!attribute [rw] worker_pools
        #   @return [::Array<::Google::Cloud::Build::V1::WorkerPool>]
        #     `WorkerPools` for the specified project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Continuation token used to page through large result sets. Provide this
        #     value in a subsequent ListWorkerPoolsRequest to return the next page of
        #     results.
        class ListWorkerPoolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for the `CreateWorkerPool` operation.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     The resource name of the `WorkerPool` to create.
        #     Format:
        #     `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the operation was created.
        # @!attribute [rw] complete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the operation was completed.
        class CreateWorkerPoolOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for the `UpdateWorkerPool` operation.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     The resource name of the `WorkerPool` being updated.
        #     Format:
        #     `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the operation was created.
        # @!attribute [rw] complete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the operation was completed.
        class UpdateWorkerPoolOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for the `DeleteWorkerPool` operation.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     The resource name of the `WorkerPool` being deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the operation was created.
        # @!attribute [rw] complete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the operation was completed.
        class DeleteWorkerPoolOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
