# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/devtools/cloudbuild/v1/cloudbuild_pb"
require "google/cloud/build/v1/cloud_build/rest/service_stub"

module Google
  module Cloud
    module Build
      module V1
        module CloudBuild
          module Rest
            ##
            # REST client for the CloudBuild service.
            #
            # Creates and manages builds on Google Cloud Platform.
            #
            # The main concept used by this API is a `Build`, which describes the location
            # of the source to build, how to build the source, and where to store the
            # built artifacts, if any.
            #
            # A user can list previously-requested builds or get builds by their ID to
            # determine the status of the build.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudbuild.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_build_stub

              ##
              # Configure the CloudBuild Client class.
              #
              # See {::Google::Cloud::Build::V1::CloudBuild::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudBuild clients
              #   ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Build", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_build.timeout = 600.0

                  default_config.rpcs.get_build.timeout = 600.0
                  default_config.rpcs.get_build.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_builds.timeout = 600.0
                  default_config.rpcs.list_builds.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.cancel_build.timeout = 600.0

                  default_config.rpcs.retry_build.timeout = 600.0

                  default_config.rpcs.create_build_trigger.timeout = 600.0

                  default_config.rpcs.get_build_trigger.timeout = 600.0
                  default_config.rpcs.get_build_trigger.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_build_triggers.timeout = 600.0
                  default_config.rpcs.list_build_triggers.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_build_trigger.timeout = 600.0
                  default_config.rpcs.delete_build_trigger.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.update_build_trigger.timeout = 600.0

                  default_config.rpcs.run_build_trigger.timeout = 600.0

                  default_config.rpcs.create_worker_pool.timeout = 600.0

                  default_config.rpcs.get_worker_pool.timeout = 600.0
                  default_config.rpcs.get_worker_pool.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_worker_pool.timeout = 600.0

                  default_config.rpcs.update_worker_pool.timeout = 600.0

                  default_config.rpcs.list_worker_pools.timeout = 600.0
                  default_config.rpcs.list_worker_pools.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudBuild Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Build::V1::CloudBuild::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_build_stub.universe_domain
              end

              ##
              # Create a new CloudBuild REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudBuild client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @cloud_build_stub = ::Google::Cloud::Build::V1::CloudBuild::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_build_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Build::V1::CloudBuild::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_build_stub.logger
              end

              # Service calls

              ##
              # Starts a build with the specified configuration.
              #
              # This method returns a long-running `Operation`, which includes the build
              # ID. Pass the build ID to `GetBuild` to determine the build status (such as
              # `SUCCESS` or `FAILURE`).
              #
              # @overload create_build(request, options = nil)
              #   Pass arguments to `create_build` via a request object, either of type
              #   {::Google::Cloud::Build::V1::CreateBuildRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::CreateBuildRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_build(parent: nil, project_id: nil, build: nil)
              #   Pass arguments to `create_build` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     The parent resource where this build will be created.
              #     Format: `projects/{project}/locations/{location}`
              #   @param project_id [::String]
              #     Required. ID of the project.
              #   @param build [::Google::Cloud::Build::V1::Build, ::Hash]
              #     Required. Build resource to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::CreateBuildRequest.new
              #
              #   # Call the create_build method.
              #   result = client.create_build request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_build request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::CreateBuildRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_build.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_build.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_build.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.create_build request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns information about a previously requested build.
              #
              # The `Build` that is returned includes its status (such as `SUCCESS`,
              # `FAILURE`, or `WORKING`), and timing information.
              #
              # @overload get_build(request, options = nil)
              #   Pass arguments to `get_build` via a request object, either of type
              #   {::Google::Cloud::Build::V1::GetBuildRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::GetBuildRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_build(name: nil, project_id: nil, id: nil)
              #   Pass arguments to `get_build` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the `Build` to retrieve.
              #     Format: `projects/{project}/locations/{location}/builds/{build}`
              #   @param project_id [::String]
              #     Required. ID of the project.
              #   @param id [::String]
              #     Required. ID of the build.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::Build]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::Build]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::GetBuildRequest.new
              #
              #   # Call the get_build method.
              #   result = client.get_build request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::Build.
              #   p result
              #
              def get_build request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::GetBuildRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_build.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_build.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_build.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.get_build request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists previously requested builds.
              #
              # Previously requested builds may still be in-progress, or may have finished
              # successfully or unsuccessfully.
              #
              # @overload list_builds(request, options = nil)
              #   Pass arguments to `list_builds` via a request object, either of type
              #   {::Google::Cloud::Build::V1::ListBuildsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::ListBuildsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_builds(parent: nil, project_id: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_builds` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     The parent of the collection of `Builds`.
              #     Format: `projects/{project}/locations/{location}`
              #   @param project_id [::String]
              #     Required. ID of the project.
              #   @param page_size [::Integer]
              #     Number of results to return in the list.
              #   @param page_token [::String]
              #     The page token for the next page of Builds.
              #
              #     If unspecified, the first page of results is returned.
              #
              #     If the token is rejected for any reason, INVALID_ARGUMENT will be thrown.
              #     In this case, the token should be discarded, and pagination should be
              #     restarted from the first page of results.
              #
              #     See https://google.aip.dev/158 for more.
              #   @param filter [::String]
              #     The raw filter text to constrain the results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Build::V1::Build>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Build::V1::Build>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::ListBuildsRequest.new
              #
              #   # Call the list_builds method.
              #   result = client.list_builds request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Build::V1::Build.
              #     p item
              #   end
              #
              def list_builds request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::ListBuildsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_builds.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_builds.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_builds.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.list_builds request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_build_stub, :list_builds, "builds", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancels a build in progress.
              #
              # @overload cancel_build(request, options = nil)
              #   Pass arguments to `cancel_build` via a request object, either of type
              #   {::Google::Cloud::Build::V1::CancelBuildRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::CancelBuildRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_build(name: nil, project_id: nil, id: nil)
              #   Pass arguments to `cancel_build` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the `Build` to cancel.
              #     Format: `projects/{project}/locations/{location}/builds/{build}`
              #   @param project_id [::String]
              #     Required. ID of the project.
              #   @param id [::String]
              #     Required. ID of the build.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::Build]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::Build]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::CancelBuildRequest.new
              #
              #   # Call the cancel_build method.
              #   result = client.cancel_build request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::Build.
              #   p result
              #
              def cancel_build request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::CancelBuildRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_build.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_build.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_build.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.cancel_build request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new build based on the specified build.
              #
              # This method creates a new build using the original build request, which may
              # or may not result in an identical build.
              #
              # For triggered builds:
              #
              # * Triggered builds resolve to a precise revision; therefore a retry of a
              # triggered build will result in a build that uses the same revision.
              #
              # For non-triggered builds that specify `RepoSource`:
              #
              # * If the original build built from the tip of a branch, the retried build
              # will build from the tip of that branch, which may not be the same revision
              # as the original build.
              # * If the original build specified a commit sha or revision ID, the retried
              # build will use the identical source.
              #
              # For builds that specify `StorageSource`:
              #
              # * If the original build pulled source from Cloud Storage without
              # specifying the generation of the object, the new build will use the current
              # object, which may be different from the original build source.
              # * If the original build pulled source from Cloud Storage and specified the
              # generation of the object, the new build will attempt to use the same
              # object, which may or may not be available depending on the bucket's
              # lifecycle management settings.
              #
              # @overload retry_build(request, options = nil)
              #   Pass arguments to `retry_build` via a request object, either of type
              #   {::Google::Cloud::Build::V1::RetryBuildRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::RetryBuildRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retry_build(name: nil, project_id: nil, id: nil)
              #   Pass arguments to `retry_build` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the `Build` to retry.
              #     Format: `projects/{project}/locations/{location}/builds/{build}`
              #   @param project_id [::String]
              #     Required. ID of the project.
              #   @param id [::String]
              #     Required. Build ID of the original build.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::RetryBuildRequest.new
              #
              #   # Call the retry_build method.
              #   result = client.retry_build request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def retry_build request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::RetryBuildRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retry_build.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retry_build.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retry_build.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.retry_build request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Approves or rejects a pending build.
              #
              # If approved, the returned long-running operation (LRO) will be analogous to
              # the LRO returned from a CreateBuild call.
              #
              # If rejected, the returned LRO will be immediately done.
              #
              # @overload approve_build(request, options = nil)
              #   Pass arguments to `approve_build` via a request object, either of type
              #   {::Google::Cloud::Build::V1::ApproveBuildRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::ApproveBuildRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload approve_build(name: nil, approval_result: nil)
              #   Pass arguments to `approve_build` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the target build.
              #     For example: "projects/\\{$project_id}/builds/\\{$build_id}"
              #   @param approval_result [::Google::Cloud::Build::V1::ApprovalResult, ::Hash]
              #     Approval decision and metadata.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::ApproveBuildRequest.new
              #
              #   # Call the approve_build method.
              #   result = client.approve_build request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def approve_build request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::ApproveBuildRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.approve_build.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.approve_build.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.approve_build.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.approve_build request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new `BuildTrigger`.
              #
              # @overload create_build_trigger(request, options = nil)
              #   Pass arguments to `create_build_trigger` via a request object, either of type
              #   {::Google::Cloud::Build::V1::CreateBuildTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::CreateBuildTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_build_trigger(parent: nil, project_id: nil, trigger: nil)
              #   Pass arguments to `create_build_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     The parent resource where this trigger will be created.
              #     Format: `projects/{project}/locations/{location}`
              #   @param project_id [::String]
              #     Required. ID of the project for which to configure automatic builds.
              #   @param trigger [::Google::Cloud::Build::V1::BuildTrigger, ::Hash]
              #     Required. `BuildTrigger` to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::BuildTrigger]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::BuildTrigger]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::CreateBuildTriggerRequest.new
              #
              #   # Call the create_build_trigger method.
              #   result = client.create_build_trigger request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::BuildTrigger.
              #   p result
              #
              def create_build_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::CreateBuildTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_build_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_build_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_build_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.create_build_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns information about a `BuildTrigger`.
              #
              # @overload get_build_trigger(request, options = nil)
              #   Pass arguments to `get_build_trigger` via a request object, either of type
              #   {::Google::Cloud::Build::V1::GetBuildTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::GetBuildTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_build_trigger(name: nil, project_id: nil, trigger_id: nil)
              #   Pass arguments to `get_build_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the `Trigger` to retrieve.
              #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
              #   @param project_id [::String]
              #     Required. ID of the project that owns the trigger.
              #   @param trigger_id [::String]
              #     Required. Identifier (`id` or `name`) of the `BuildTrigger` to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::BuildTrigger]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::BuildTrigger]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::GetBuildTriggerRequest.new
              #
              #   # Call the get_build_trigger method.
              #   result = client.get_build_trigger request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::BuildTrigger.
              #   p result
              #
              def get_build_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::GetBuildTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_build_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_build_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_build_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.get_build_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists existing `BuildTrigger`s.
              #
              # @overload list_build_triggers(request, options = nil)
              #   Pass arguments to `list_build_triggers` via a request object, either of type
              #   {::Google::Cloud::Build::V1::ListBuildTriggersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::ListBuildTriggersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_build_triggers(parent: nil, project_id: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_build_triggers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     The parent of the collection of `Triggers`.
              #     Format: `projects/{project}/locations/{location}`
              #   @param project_id [::String]
              #     Required. ID of the project for which to list BuildTriggers.
              #   @param page_size [::Integer]
              #     Number of results to return in the list.
              #   @param page_token [::String]
              #     Token to provide to skip to a particular spot in the list.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Build::V1::BuildTrigger>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Build::V1::BuildTrigger>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::ListBuildTriggersRequest.new
              #
              #   # Call the list_build_triggers method.
              #   result = client.list_build_triggers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Build::V1::BuildTrigger.
              #     p item
              #   end
              #
              def list_build_triggers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::ListBuildTriggersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_build_triggers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_build_triggers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_build_triggers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.list_build_triggers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_build_stub, :list_build_triggers, "triggers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a `BuildTrigger` by its project ID and trigger ID.
              #
              # @overload delete_build_trigger(request, options = nil)
              #   Pass arguments to `delete_build_trigger` via a request object, either of type
              #   {::Google::Cloud::Build::V1::DeleteBuildTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::DeleteBuildTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_build_trigger(name: nil, project_id: nil, trigger_id: nil)
              #   Pass arguments to `delete_build_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the `Trigger` to delete.
              #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
              #   @param project_id [::String]
              #     Required. ID of the project that owns the trigger.
              #   @param trigger_id [::String]
              #     Required. ID of the `BuildTrigger` to delete.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::DeleteBuildTriggerRequest.new
              #
              #   # Call the delete_build_trigger method.
              #   result = client.delete_build_trigger request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_build_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::DeleteBuildTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_build_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_build_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_build_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.delete_build_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a `BuildTrigger` by its project ID and trigger ID.
              #
              # @overload update_build_trigger(request, options = nil)
              #   Pass arguments to `update_build_trigger` via a request object, either of type
              #   {::Google::Cloud::Build::V1::UpdateBuildTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::UpdateBuildTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_build_trigger(project_id: nil, trigger_id: nil, trigger: nil, update_mask: nil)
              #   Pass arguments to `update_build_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. ID of the project that owns the trigger.
              #   @param trigger_id [::String]
              #     Required. ID of the `BuildTrigger` to update.
              #   @param trigger [::Google::Cloud::Build::V1::BuildTrigger, ::Hash]
              #     Required. `BuildTrigger` to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Update mask for the resource. If this is set,
              #     the server will only update the fields specified in the field mask.
              #     Otherwise, a full update of the mutable resource fields will be performed.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::BuildTrigger]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::BuildTrigger]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::UpdateBuildTriggerRequest.new
              #
              #   # Call the update_build_trigger method.
              #   result = client.update_build_trigger request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::BuildTrigger.
              #   p result
              #
              def update_build_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::UpdateBuildTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_build_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_build_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_build_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.update_build_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Runs a `BuildTrigger` at a particular source revision.
              #
              # To run a regional or global trigger, use the POST request
              # that includes the location endpoint in the path (ex.
              # v1/projects/\\{projectId}/locations/\\{region}/triggers/\\{triggerId}:run). The
              # POST request that does not include the location endpoint in the path can
              # only be used when running global triggers.
              #
              # @overload run_build_trigger(request, options = nil)
              #   Pass arguments to `run_build_trigger` via a request object, either of type
              #   {::Google::Cloud::Build::V1::RunBuildTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::RunBuildTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_build_trigger(name: nil, project_id: nil, trigger_id: nil, source: nil)
              #   Pass arguments to `run_build_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the `Trigger` to run.
              #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
              #   @param project_id [::String]
              #     Required. ID of the project.
              #   @param trigger_id [::String]
              #     Required. ID of the trigger.
              #   @param source [::Google::Cloud::Build::V1::RepoSource, ::Hash]
              #     Source to build against this trigger.
              #     Branch and tag names cannot consist of regular expressions.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::RunBuildTriggerRequest.new
              #
              #   # Call the run_build_trigger method.
              #   result = client.run_build_trigger request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def run_build_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::RunBuildTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_build_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_build_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_build_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.run_build_trigger request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # ReceiveTriggerWebhook [Experimental] is called when the API receives a
              # webhook request targeted at a specific trigger.
              #
              # @overload receive_trigger_webhook(request, options = nil)
              #   Pass arguments to `receive_trigger_webhook` via a request object, either of type
              #   {::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload receive_trigger_webhook(name: nil, body: nil, project_id: nil, trigger: nil, secret: nil)
              #   Pass arguments to `receive_trigger_webhook` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     The name of the `ReceiveTriggerWebhook` to retrieve.
              #     Format: `projects/{project}/locations/{location}/triggers/{trigger}`
              #   @param body [::Google::Api::HttpBody, ::Hash]
              #     HTTP request body.
              #   @param project_id [::String]
              #     Project in which the specified trigger lives
              #   @param trigger [::String]
              #     Name of the trigger to run the payload against
              #   @param secret [::String]
              #     Secret token used for authorization if an OAuth token isn't provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::ReceiveTriggerWebhookResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::ReceiveTriggerWebhookResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest.new
              #
              #   # Call the receive_trigger_webhook method.
              #   result = client.receive_trigger_webhook request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::ReceiveTriggerWebhookResponse.
              #   p result
              #
              def receive_trigger_webhook request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::ReceiveTriggerWebhookRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.receive_trigger_webhook.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.receive_trigger_webhook.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.receive_trigger_webhook.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.receive_trigger_webhook request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a `WorkerPool`.
              #
              # @overload create_worker_pool(request, options = nil)
              #   Pass arguments to `create_worker_pool` via a request object, either of type
              #   {::Google::Cloud::Build::V1::CreateWorkerPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::CreateWorkerPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_worker_pool(parent: nil, worker_pool: nil, worker_pool_id: nil, validate_only: nil)
              #   Pass arguments to `create_worker_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this worker pool will be created.
              #     Format: `projects/{project}/locations/{location}`.
              #   @param worker_pool [::Google::Cloud::Build::V1::WorkerPool, ::Hash]
              #     Required. `WorkerPool` resource to create.
              #   @param worker_pool_id [::String]
              #     Required. Immutable. The ID to use for the `WorkerPool`, which will become
              #     the final component of the resource name.
              #
              #     This value should be 1-63 characters, and valid characters
              #     are /[a-z][0-9]-/.
              #   @param validate_only [::Boolean]
              #     If set, validate the request and preview the response, but do not actually
              #     post it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::CreateWorkerPoolRequest.new
              #
              #   # Call the create_worker_pool method.
              #   result = client.create_worker_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_worker_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::CreateWorkerPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_worker_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_worker_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_worker_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.create_worker_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns details of a `WorkerPool`.
              #
              # @overload get_worker_pool(request, options = nil)
              #   Pass arguments to `get_worker_pool` via a request object, either of type
              #   {::Google::Cloud::Build::V1::GetWorkerPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::GetWorkerPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_worker_pool(name: nil)
              #   Pass arguments to `get_worker_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `WorkerPool` to retrieve.
              #     Format: `projects/{project}/locations/{location}/workerPools/{workerPool}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::WorkerPool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::WorkerPool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::GetWorkerPoolRequest.new
              #
              #   # Call the get_worker_pool method.
              #   result = client.get_worker_pool request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::WorkerPool.
              #   p result
              #
              def get_worker_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::GetWorkerPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_worker_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_worker_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_worker_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.get_worker_pool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a `WorkerPool`.
              #
              # @overload delete_worker_pool(request, options = nil)
              #   Pass arguments to `delete_worker_pool` via a request object, either of type
              #   {::Google::Cloud::Build::V1::DeleteWorkerPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::DeleteWorkerPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_worker_pool(name: nil, etag: nil, allow_missing: nil, validate_only: nil)
              #   Pass arguments to `delete_worker_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `WorkerPool` to delete.
              #     Format:
              #     `projects/{project}/locations/{location}/workerPools/{workerPool}`.
              #   @param etag [::String]
              #     Optional. If provided, it must match the server's etag on the workerpool
              #     for the request to be processed.
              #   @param allow_missing [::Boolean]
              #     If set to true, and the `WorkerPool` is not found, the request will succeed
              #     but no action will be taken on the server.
              #   @param validate_only [::Boolean]
              #     If set, validate the request and preview the response, but do not actually
              #     post it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::DeleteWorkerPoolRequest.new
              #
              #   # Call the delete_worker_pool method.
              #   result = client.delete_worker_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_worker_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::DeleteWorkerPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_worker_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_worker_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_worker_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.delete_worker_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a `WorkerPool`.
              #
              # @overload update_worker_pool(request, options = nil)
              #   Pass arguments to `update_worker_pool` via a request object, either of type
              #   {::Google::Cloud::Build::V1::UpdateWorkerPoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::UpdateWorkerPoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_worker_pool(worker_pool: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `update_worker_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param worker_pool [::Google::Cloud::Build::V1::WorkerPool, ::Hash]
              #     Required. The `WorkerPool` to update.
              #
              #     The `name` field is used to identify the `WorkerPool` to update.
              #     Format: `projects/{project}/locations/{location}/workerPools/{workerPool}`.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. A mask specifying which fields in `worker_pool` to update.
              #   @param validate_only [::Boolean]
              #     If set, validate the request and preview the response, but do not actually
              #     post it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::UpdateWorkerPoolRequest.new
              #
              #   # Call the update_worker_pool method.
              #   result = client.update_worker_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_worker_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::UpdateWorkerPoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_worker_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_worker_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_worker_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.update_worker_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists `WorkerPool`s.
              #
              # @overload list_worker_pools(request, options = nil)
              #   Pass arguments to `list_worker_pools` via a request object, either of type
              #   {::Google::Cloud::Build::V1::ListWorkerPoolsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::ListWorkerPoolsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_worker_pools(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_worker_pools` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent of the collection of `WorkerPools`.
              #     Format: `projects/{project}/locations/{location}`.
              #   @param page_size [::Integer]
              #     The maximum number of `WorkerPool`s to return. The service may return
              #     fewer than this value. If omitted, the server will use a sensible default.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListWorkerPools` call. Provide this
              #     to retrieve the subsequent page.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Build::V1::WorkerPool>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Build::V1::WorkerPool>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::ListWorkerPoolsRequest.new
              #
              #   # Call the list_worker_pools method.
              #   result = client.list_worker_pools request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Build::V1::WorkerPool.
              #     p item
              #   end
              #
              def list_worker_pools request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::ListWorkerPoolsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_worker_pools.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_worker_pools.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_worker_pools.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.list_worker_pools request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_build_stub, :list_worker_pools, "worker_pools", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the `DefaultServiceAccount` used by the project.
              #
              # @overload get_default_service_account(request, options = nil)
              #   Pass arguments to `get_default_service_account` via a request object, either of type
              #   {::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_default_service_account(name: nil)
              #   Pass arguments to `get_default_service_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `DefaultServiceAccount` to retrieve.
              #     Format:
              #     `projects/{project}/locations/{location}/defaultServiceAccount`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Build::V1::DefaultServiceAccount]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Build::V1::DefaultServiceAccount]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/build/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Build::V1::CloudBuild::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Build::V1::GetDefaultServiceAccountRequest.new
              #
              #   # Call the get_default_service_account method.
              #   result = client.get_default_service_account request
              #
              #   # The returned object is of type Google::Cloud::Build::V1::DefaultServiceAccount.
              #   p result
              #
              def get_default_service_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Build::V1::GetDefaultServiceAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_default_service_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Build::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_default_service_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_default_service_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_build_stub.get_default_service_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudBuild REST API.
              #
              # This class represents the configuration for CloudBuild REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Build::V1::CloudBuild::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_build to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_build.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Build::V1::CloudBuild::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_build.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudbuild.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudBuild API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_build`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_build
                  ##
                  # RPC-specific configuration for `get_build`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_build
                  ##
                  # RPC-specific configuration for `list_builds`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_builds
                  ##
                  # RPC-specific configuration for `cancel_build`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_build
                  ##
                  # RPC-specific configuration for `retry_build`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retry_build
                  ##
                  # RPC-specific configuration for `approve_build`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :approve_build
                  ##
                  # RPC-specific configuration for `create_build_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_build_trigger
                  ##
                  # RPC-specific configuration for `get_build_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_build_trigger
                  ##
                  # RPC-specific configuration for `list_build_triggers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_build_triggers
                  ##
                  # RPC-specific configuration for `delete_build_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_build_trigger
                  ##
                  # RPC-specific configuration for `update_build_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_build_trigger
                  ##
                  # RPC-specific configuration for `run_build_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_build_trigger
                  ##
                  # RPC-specific configuration for `receive_trigger_webhook`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :receive_trigger_webhook
                  ##
                  # RPC-specific configuration for `create_worker_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_worker_pool
                  ##
                  # RPC-specific configuration for `get_worker_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_worker_pool
                  ##
                  # RPC-specific configuration for `delete_worker_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_worker_pool
                  ##
                  # RPC-specific configuration for `update_worker_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_worker_pool
                  ##
                  # RPC-specific configuration for `list_worker_pools`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_worker_pools
                  ##
                  # RPC-specific configuration for `get_default_service_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_default_service_account

                  # @private
                  def initialize parent_rpcs = nil
                    create_build_config = parent_rpcs.create_build if parent_rpcs.respond_to? :create_build
                    @create_build = ::Gapic::Config::Method.new create_build_config
                    get_build_config = parent_rpcs.get_build if parent_rpcs.respond_to? :get_build
                    @get_build = ::Gapic::Config::Method.new get_build_config
                    list_builds_config = parent_rpcs.list_builds if parent_rpcs.respond_to? :list_builds
                    @list_builds = ::Gapic::Config::Method.new list_builds_config
                    cancel_build_config = parent_rpcs.cancel_build if parent_rpcs.respond_to? :cancel_build
                    @cancel_build = ::Gapic::Config::Method.new cancel_build_config
                    retry_build_config = parent_rpcs.retry_build if parent_rpcs.respond_to? :retry_build
                    @retry_build = ::Gapic::Config::Method.new retry_build_config
                    approve_build_config = parent_rpcs.approve_build if parent_rpcs.respond_to? :approve_build
                    @approve_build = ::Gapic::Config::Method.new approve_build_config
                    create_build_trigger_config = parent_rpcs.create_build_trigger if parent_rpcs.respond_to? :create_build_trigger
                    @create_build_trigger = ::Gapic::Config::Method.new create_build_trigger_config
                    get_build_trigger_config = parent_rpcs.get_build_trigger if parent_rpcs.respond_to? :get_build_trigger
                    @get_build_trigger = ::Gapic::Config::Method.new get_build_trigger_config
                    list_build_triggers_config = parent_rpcs.list_build_triggers if parent_rpcs.respond_to? :list_build_triggers
                    @list_build_triggers = ::Gapic::Config::Method.new list_build_triggers_config
                    delete_build_trigger_config = parent_rpcs.delete_build_trigger if parent_rpcs.respond_to? :delete_build_trigger
                    @delete_build_trigger = ::Gapic::Config::Method.new delete_build_trigger_config
                    update_build_trigger_config = parent_rpcs.update_build_trigger if parent_rpcs.respond_to? :update_build_trigger
                    @update_build_trigger = ::Gapic::Config::Method.new update_build_trigger_config
                    run_build_trigger_config = parent_rpcs.run_build_trigger if parent_rpcs.respond_to? :run_build_trigger
                    @run_build_trigger = ::Gapic::Config::Method.new run_build_trigger_config
                    receive_trigger_webhook_config = parent_rpcs.receive_trigger_webhook if parent_rpcs.respond_to? :receive_trigger_webhook
                    @receive_trigger_webhook = ::Gapic::Config::Method.new receive_trigger_webhook_config
                    create_worker_pool_config = parent_rpcs.create_worker_pool if parent_rpcs.respond_to? :create_worker_pool
                    @create_worker_pool = ::Gapic::Config::Method.new create_worker_pool_config
                    get_worker_pool_config = parent_rpcs.get_worker_pool if parent_rpcs.respond_to? :get_worker_pool
                    @get_worker_pool = ::Gapic::Config::Method.new get_worker_pool_config
                    delete_worker_pool_config = parent_rpcs.delete_worker_pool if parent_rpcs.respond_to? :delete_worker_pool
                    @delete_worker_pool = ::Gapic::Config::Method.new delete_worker_pool_config
                    update_worker_pool_config = parent_rpcs.update_worker_pool if parent_rpcs.respond_to? :update_worker_pool
                    @update_worker_pool = ::Gapic::Config::Method.new update_worker_pool_config
                    list_worker_pools_config = parent_rpcs.list_worker_pools if parent_rpcs.respond_to? :list_worker_pools
                    @list_worker_pools = ::Gapic::Config::Method.new list_worker_pools_config
                    get_default_service_account_config = parent_rpcs.get_default_service_account if parent_rpcs.respond_to? :get_default_service_account
                    @get_default_service_account = ::Gapic::Config::Method.new get_default_service_account_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
