# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/binaryauthorization/v1/service_pb"

module Google
  module Cloud
    module BinaryAuthorization
      module V1
        module BinauthzManagementService
          ##
          # Client for the BinauthzManagementService service.
          #
          # Google Cloud Management Service for Binary Authorization admission policies
          # and attestation authorities.
          #
          # This API implements a REST model with the following objects:
          #
          # * {::Google::Cloud::BinaryAuthorization::V1::Policy Policy}
          # * {::Google::Cloud::BinaryAuthorization::V1::Attestor Attestor}
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "binaryauthorization.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :binauthz_management_service_stub

            ##
            # Configure the BinauthzManagementService Client class.
            #
            # See {::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all BinauthzManagementService clients
            #   ::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "BinaryAuthorization", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.get_policy.timeout = 600.0
                default_config.rpcs.get_policy.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.update_policy.timeout = 600.0
                default_config.rpcs.update_policy.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.create_attestor.timeout = 600.0

                default_config.rpcs.get_attestor.timeout = 600.0
                default_config.rpcs.get_attestor.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.update_attestor.timeout = 600.0
                default_config.rpcs.update_attestor.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_attestors.timeout = 600.0
                default_config.rpcs.list_attestors.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.delete_attestor.timeout = 600.0
                default_config.rpcs.delete_attestor.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the BinauthzManagementService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @binauthz_management_service_stub.universe_domain
            end

            ##
            # Create a new BinauthzManagementService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the BinauthzManagementService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/binaryauthorization/v1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @binauthz_management_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementServiceV1::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @binauthz_management_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @binauthz_management_service_stub.logger
            end

            # Service calls

            ##
            # A {::Google::Cloud::BinaryAuthorization::V1::Policy policy} specifies the {::Google::Cloud::BinaryAuthorization::V1::Attestor attestors} that must attest to
            # a container image, before the project is allowed to deploy that
            # image. There is at most one policy per project. All image admission
            # requests are permitted if a project has no policy.
            #
            # Gets the {::Google::Cloud::BinaryAuthorization::V1::Policy policy} for this project. Returns a default
            # {::Google::Cloud::BinaryAuthorization::V1::Policy policy} if the project does not have one.
            #
            # @overload get_policy(request, options = nil)
            #   Pass arguments to `get_policy` via a request object, either of type
            #   {::Google::Cloud::BinaryAuthorization::V1::GetPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BinaryAuthorization::V1::GetPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_policy(name: nil)
            #   Pass arguments to `get_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the {::Google::Cloud::BinaryAuthorization::V1::Policy policy} to retrieve,
            #     in the format `projects/*/policy`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BinaryAuthorization::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BinaryAuthorization::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/binary_authorization/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BinaryAuthorization::V1::GetPolicyRequest.new
            #
            #   # Call the get_policy method.
            #   result = client.get_policy request
            #
            #   # The returned object is of type Google::Cloud::BinaryAuthorization::V1::Policy.
            #   p result
            #
            def get_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BinaryAuthorization::V1::GetPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BinaryAuthorization::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @binauthz_management_service_stub.call_rpc :get_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates or updates a project's {::Google::Cloud::BinaryAuthorization::V1::Policy policy}, and returns a copy of the
            # new {::Google::Cloud::BinaryAuthorization::V1::Policy policy}. A policy is always updated as a whole, to avoid race
            # conditions with concurrent policy enforcement (or management!)
            # requests. Returns NOT_FOUND if the project does not exist, INVALID_ARGUMENT
            # if the request is malformed.
            #
            # @overload update_policy(request, options = nil)
            #   Pass arguments to `update_policy` via a request object, either of type
            #   {::Google::Cloud::BinaryAuthorization::V1::UpdatePolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BinaryAuthorization::V1::UpdatePolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_policy(policy: nil)
            #   Pass arguments to `update_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param policy [::Google::Cloud::BinaryAuthorization::V1::Policy, ::Hash]
            #     Required. A new or updated {::Google::Cloud::BinaryAuthorization::V1::Policy policy} value. The service will
            #     overwrite the {::Google::Cloud::BinaryAuthorization::V1::Policy#name policy name} field with the resource name in
            #     the request URL, in the format `projects/*/policy`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BinaryAuthorization::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BinaryAuthorization::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/binary_authorization/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BinaryAuthorization::V1::UpdatePolicyRequest.new
            #
            #   # Call the update_policy method.
            #   result = client.update_policy request
            #
            #   # The returned object is of type Google::Cloud::BinaryAuthorization::V1::Policy.
            #   p result
            #
            def update_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BinaryAuthorization::V1::UpdatePolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BinaryAuthorization::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.policy&.name
                header_params["policy.name"] = request.policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @binauthz_management_service_stub.call_rpc :update_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor}, and returns a copy of the new
            # {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor}. Returns NOT_FOUND if the project does not exist,
            # INVALID_ARGUMENT if the request is malformed, ALREADY_EXISTS if the
            # {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor} already exists.
            #
            # @overload create_attestor(request, options = nil)
            #   Pass arguments to `create_attestor` via a request object, either of type
            #   {::Google::Cloud::BinaryAuthorization::V1::CreateAttestorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BinaryAuthorization::V1::CreateAttestorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_attestor(parent: nil, attestor_id: nil, attestor: nil)
            #   Pass arguments to `create_attestor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of this {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor}.
            #   @param attestor_id [::String]
            #     Required. The {::Google::Cloud::BinaryAuthorization::V1::Attestor attestors} ID.
            #   @param attestor [::Google::Cloud::BinaryAuthorization::V1::Attestor, ::Hash]
            #     Required. The initial {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor} value. The service will
            #     overwrite the {::Google::Cloud::BinaryAuthorization::V1::Attestor#name attestor name} field with the resource name,
            #     in the format `projects/*/attestors/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BinaryAuthorization::V1::Attestor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BinaryAuthorization::V1::Attestor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/binary_authorization/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BinaryAuthorization::V1::CreateAttestorRequest.new
            #
            #   # Call the create_attestor method.
            #   result = client.create_attestor request
            #
            #   # The returned object is of type Google::Cloud::BinaryAuthorization::V1::Attestor.
            #   p result
            #
            def create_attestor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BinaryAuthorization::V1::CreateAttestorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_attestor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BinaryAuthorization::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_attestor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_attestor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @binauthz_management_service_stub.call_rpc :create_attestor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor}.
            # Returns NOT_FOUND if the {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor} does not exist.
            #
            # @overload get_attestor(request, options = nil)
            #   Pass arguments to `get_attestor` via a request object, either of type
            #   {::Google::Cloud::BinaryAuthorization::V1::GetAttestorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BinaryAuthorization::V1::GetAttestorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_attestor(name: nil)
            #   Pass arguments to `get_attestor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor} to retrieve, in the format
            #     `projects/*/attestors/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BinaryAuthorization::V1::Attestor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BinaryAuthorization::V1::Attestor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/binary_authorization/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BinaryAuthorization::V1::GetAttestorRequest.new
            #
            #   # Call the get_attestor method.
            #   result = client.get_attestor request
            #
            #   # The returned object is of type Google::Cloud::BinaryAuthorization::V1::Attestor.
            #   p result
            #
            def get_attestor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BinaryAuthorization::V1::GetAttestorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_attestor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BinaryAuthorization::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_attestor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_attestor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @binauthz_management_service_stub.call_rpc :get_attestor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor}.
            # Returns NOT_FOUND if the {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor} does not exist.
            #
            # @overload update_attestor(request, options = nil)
            #   Pass arguments to `update_attestor` via a request object, either of type
            #   {::Google::Cloud::BinaryAuthorization::V1::UpdateAttestorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BinaryAuthorization::V1::UpdateAttestorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_attestor(attestor: nil)
            #   Pass arguments to `update_attestor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param attestor [::Google::Cloud::BinaryAuthorization::V1::Attestor, ::Hash]
            #     Required. The updated {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor} value. The service will
            #     overwrite the {::Google::Cloud::BinaryAuthorization::V1::Attestor#name attestor name} field with the resource name
            #     in the request URL, in the format `projects/*/attestors/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::BinaryAuthorization::V1::Attestor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::BinaryAuthorization::V1::Attestor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/binary_authorization/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BinaryAuthorization::V1::UpdateAttestorRequest.new
            #
            #   # Call the update_attestor method.
            #   result = client.update_attestor request
            #
            #   # The returned object is of type Google::Cloud::BinaryAuthorization::V1::Attestor.
            #   p result
            #
            def update_attestor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BinaryAuthorization::V1::UpdateAttestorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_attestor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BinaryAuthorization::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.attestor&.name
                header_params["attestor.name"] = request.attestor.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_attestor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_attestor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @binauthz_management_service_stub.call_rpc :update_attestor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists {::Google::Cloud::BinaryAuthorization::V1::Attestor attestors}.
            # Returns INVALID_ARGUMENT if the project does not exist.
            #
            # @overload list_attestors(request, options = nil)
            #   Pass arguments to `list_attestors` via a request object, either of type
            #   {::Google::Cloud::BinaryAuthorization::V1::ListAttestorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BinaryAuthorization::V1::ListAttestorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_attestors(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_attestors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the project associated with the
            #     {::Google::Cloud::BinaryAuthorization::V1::Attestor attestors}, in the format `projects/*`.
            #   @param page_size [::Integer]
            #     Requested page size. The server may return fewer results than requested. If
            #     unspecified, the server will pick an appropriate default.
            #   @param page_token [::String]
            #     A token identifying a page of results the server should return. Typically,
            #     this is the value of {::Google::Cloud::BinaryAuthorization::V1::ListAttestorsResponse#next_page_token ListAttestorsResponse.next_page_token} returned
            #     from the previous call to the `ListAttestors` method.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::BinaryAuthorization::V1::Attestor>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::BinaryAuthorization::V1::Attestor>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/binary_authorization/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BinaryAuthorization::V1::ListAttestorsRequest.new
            #
            #   # Call the list_attestors method.
            #   result = client.list_attestors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::BinaryAuthorization::V1::Attestor.
            #     p item
            #   end
            #
            def list_attestors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BinaryAuthorization::V1::ListAttestorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_attestors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BinaryAuthorization::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_attestors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_attestors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @binauthz_management_service_stub.call_rpc :list_attestors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @binauthz_management_service_stub, :list_attestors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor}. Returns NOT_FOUND if the
            # {::Google::Cloud::BinaryAuthorization::V1::Attestor attestor} does not exist.
            #
            # @overload delete_attestor(request, options = nil)
            #   Pass arguments to `delete_attestor` via a request object, either of type
            #   {::Google::Cloud::BinaryAuthorization::V1::DeleteAttestorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::BinaryAuthorization::V1::DeleteAttestorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_attestor(name: nil)
            #   Pass arguments to `delete_attestor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the {::Google::Cloud::BinaryAuthorization::V1::Attestor attestors} to delete, in the format
            #     `projects/*/attestors/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/binary_authorization/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::BinaryAuthorization::V1::DeleteAttestorRequest.new
            #
            #   # Call the delete_attestor method.
            #   result = client.delete_attestor request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_attestor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::BinaryAuthorization::V1::DeleteAttestorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_attestor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::BinaryAuthorization::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_attestor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_attestor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @binauthz_management_service_stub.call_rpc :delete_attestor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the BinauthzManagementService API.
            #
            # This class represents the configuration for BinauthzManagementService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_policy to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_policy.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_policy.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::BinaryAuthorization::V1::BinauthzManagementService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "binaryauthorization.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the BinauthzManagementService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_policy
                ##
                # RPC-specific configuration for `update_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_policy
                ##
                # RPC-specific configuration for `create_attestor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_attestor
                ##
                # RPC-specific configuration for `get_attestor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_attestor
                ##
                # RPC-specific configuration for `update_attestor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_attestor
                ##
                # RPC-specific configuration for `list_attestors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_attestors
                ##
                # RPC-specific configuration for `delete_attestor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_attestor

                # @private
                def initialize parent_rpcs = nil
                  get_policy_config = parent_rpcs.get_policy if parent_rpcs.respond_to? :get_policy
                  @get_policy = ::Gapic::Config::Method.new get_policy_config
                  update_policy_config = parent_rpcs.update_policy if parent_rpcs.respond_to? :update_policy
                  @update_policy = ::Gapic::Config::Method.new update_policy_config
                  create_attestor_config = parent_rpcs.create_attestor if parent_rpcs.respond_to? :create_attestor
                  @create_attestor = ::Gapic::Config::Method.new create_attestor_config
                  get_attestor_config = parent_rpcs.get_attestor if parent_rpcs.respond_to? :get_attestor
                  @get_attestor = ::Gapic::Config::Method.new get_attestor_config
                  update_attestor_config = parent_rpcs.update_attestor if parent_rpcs.respond_to? :update_attestor
                  @update_attestor = ::Gapic::Config::Method.new update_attestor_config
                  list_attestors_config = parent_rpcs.list_attestors if parent_rpcs.respond_to? :list_attestors
                  @list_attestors = ::Gapic::Config::Method.new list_attestors_config
                  delete_attestor_config = parent_rpcs.delete_attestor if parent_rpcs.respond_to? :delete_attestor
                  @delete_attestor = ::Gapic::Config::Method.new delete_attestor_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
