# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Billing
      module V1
        # Encapsulates a single service in Google Cloud Platform.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name for the service.
        #     Example: "services/6F81-5844-456A"
        # @!attribute [rw] service_id
        #   @return [::String]
        #     The identifier for the service.
        #     Example: "6F81-5844-456A"
        # @!attribute [rw] display_name
        #   @return [::String]
        #     A human readable display name for this service.
        # @!attribute [rw] business_entity_name
        #   @return [::String]
        #     The business under which the service is offered.
        #     Ex. "businessEntities/GCP", "businessEntities/Maps"
        class Service
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Encapsulates a single SKU in Google Cloud
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name for the SKU.
        #     Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
        # @!attribute [rw] sku_id
        #   @return [::String]
        #     The identifier for the SKU.
        #     Example: "D041-B8A1-6E0B"
        # @!attribute [rw] description
        #   @return [::String]
        #     A human readable description of the SKU, has a maximum length of 256
        #     characters.
        # @!attribute [rw] category
        #   @return [::Google::Cloud::Billing::V1::Category]
        #     The category hierarchy of this SKU, purely for organizational purpose.
        # @!attribute [rw] service_regions
        #   @return [::Array<::String>]
        #     List of service regions this SKU is offered at.
        #     Example: "asia-east1"
        #     Service regions can be found at https://cloud.google.com/about/locations/
        # @!attribute [rw] pricing_info
        #   @return [::Array<::Google::Cloud::Billing::V1::PricingInfo>]
        #     A timeline of pricing info for this SKU in chronological order.
        # @!attribute [rw] service_provider_name
        #   @return [::String]
        #     Identifies the service provider.
        #     This is 'Google' for first party services in Google Cloud Platform.
        # @!attribute [rw] geo_taxonomy
        #   @return [::Google::Cloud::Billing::V1::GeoTaxonomy]
        #     The geographic taxonomy for this sku.
        class Sku
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the category hierarchy of a SKU.
        # @!attribute [rw] service_display_name
        #   @return [::String]
        #     The display name of the service this SKU belongs to.
        # @!attribute [rw] resource_family
        #   @return [::String]
        #     The type of product the SKU refers to.
        #     Example: "Compute", "Storage", "Network", "ApplicationServices" etc.
        # @!attribute [rw] resource_group
        #   @return [::String]
        #     A group classification for related SKUs.
        #     Example: "RAM", "GPU", "Prediction", "Ops", "GoogleEgress" etc.
        # @!attribute [rw] usage_type
        #   @return [::String]
        #     Represents how the SKU is consumed.
        #     Example: "OnDemand", "Preemptible", "Commit1Mo", "Commit1Yr" etc.
        class Category
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the pricing information for a SKU at a single point of time.
        # @!attribute [rw] effective_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp from which this pricing was effective within the requested
        #     time range. This is guaranteed to be greater than or equal to the
        #     start_time field in the request and less than the end_time field in the
        #     request. If a time range was not specified in the request this field will
        #     be equivalent to a time within the last 12 hours, indicating the latest
        #     pricing info.
        # @!attribute [rw] summary
        #   @return [::String]
        #     An optional human readable summary of the pricing information, has a
        #     maximum length of 256 characters.
        # @!attribute [rw] pricing_expression
        #   @return [::Google::Cloud::Billing::V1::PricingExpression]
        #     Expresses the pricing formula. See `PricingExpression` for an example.
        # @!attribute [rw] aggregation_info
        #   @return [::Google::Cloud::Billing::V1::AggregationInfo]
        #     Aggregation Info. This can be left unspecified if the pricing expression
        #     doesn't require aggregation.
        # @!attribute [rw] currency_conversion_rate
        #   @return [::Float]
        #     Conversion rate used for currency conversion, from USD to the currency
        #     specified in the request. This includes any surcharge collected for billing
        #     in non USD currency. If a currency is not specified in the request this
        #     defaults to 1.0.
        #     Example: USD * currency_conversion_rate = JPY
        class PricingInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Expresses a mathematical pricing formula. For Example:-
        #
        # `usage_unit: GBy`
        # `tiered_rates:`
        #    `[start_usage_amount: 20, unit_price: $10]`
        #    `[start_usage_amount: 100, unit_price: $5]`
        #
        # The above expresses a pricing formula where the first 20GB is free, the
        # next 80GB is priced at $10 per GB followed by $5 per GB for additional
        # usage.
        # @!attribute [rw] usage_unit
        #   @return [::String]
        #     The short hand for unit of usage this pricing is specified in.
        #     Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
        # @!attribute [rw] display_quantity
        #   @return [::Float]
        #     The recommended quantity of units for displaying pricing info. When
        #     displaying pricing info it is recommended to display:
        #     (unit_price * display_quantity) per display_quantity usage_unit.
        #     This field does not affect the pricing formula and is for display purposes
        #     only.
        #     Example: If the unit_price is "0.0001 USD", the usage_unit is "GB" and
        #     the display_quantity is "1000" then the recommended way of displaying the
        #     pricing info is "0.10 USD per 1000 GB"
        # @!attribute [rw] tiered_rates
        #   @return [::Array<::Google::Cloud::Billing::V1::PricingExpression::TierRate>]
        #     The list of tiered rates for this pricing. The total cost is computed by
        #     applying each of the tiered rates on usage. This repeated list is sorted
        #     by ascending order of start_usage_amount.
        # @!attribute [rw] usage_unit_description
        #   @return [::String]
        #     The unit of usage in human readable form.
        #     Example: "gibi byte".
        # @!attribute [rw] base_unit
        #   @return [::String]
        #     The base unit for the SKU which is the unit used in usage exports.
        #     Example: "By"
        # @!attribute [rw] base_unit_description
        #   @return [::String]
        #     The base unit in human readable form.
        #     Example: "byte".
        # @!attribute [rw] base_unit_conversion_factor
        #   @return [::Float]
        #     Conversion factor for converting from price per usage_unit to price per
        #     base_unit, and start_usage_amount to start_usage_amount in base_unit.
        #     unit_price / base_unit_conversion_factor = price per base_unit.
        #     start_usage_amount * base_unit_conversion_factor = start_usage_amount in
        #     base_unit.
        class PricingExpression
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The price rate indicating starting usage and its corresponding price.
          # @!attribute [rw] start_usage_amount
          #   @return [::Float]
          #     Usage is priced at this rate only after this amount.
          #     Example: start_usage_amount of 10 indicates that the usage will be priced
          #     at the unit_price after the first 10 usage_units.
          # @!attribute [rw] unit_price
          #   @return [::Google::Type::Money]
          #     The price per unit of usage.
          #     Example: unit_price of amount $10 indicates that each unit will cost $10.
          class TierRate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents the aggregation level and interval for pricing of a single SKU.
        # @!attribute [rw] aggregation_level
        #   @return [::Google::Cloud::Billing::V1::AggregationInfo::AggregationLevel]
        # @!attribute [rw] aggregation_interval
        #   @return [::Google::Cloud::Billing::V1::AggregationInfo::AggregationInterval]
        # @!attribute [rw] aggregation_count
        #   @return [::Integer]
        #     The number of intervals to aggregate over.
        #     Example: If aggregation_level is "DAILY" and aggregation_count is 14,
        #     aggregation will be over 14 days.
        class AggregationInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The level at which usage is aggregated to compute cost.
          # Example: "ACCOUNT" aggregation level indicates that usage for tiered
          # pricing is aggregated across all projects in a single account.
          module AggregationLevel
            AGGREGATION_LEVEL_UNSPECIFIED = 0

            ACCOUNT = 1

            PROJECT = 2
          end

          # The interval at which usage is aggregated to compute cost.
          # Example: "MONTHLY" aggregation interval indicates that usage for tiered
          # pricing is aggregated every month.
          module AggregationInterval
            AGGREGATION_INTERVAL_UNSPECIFIED = 0

            DAILY = 1

            MONTHLY = 2
          end
        end

        # Encapsulates the geographic taxonomy data for a sku.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Billing::V1::GeoTaxonomy::Type]
        #     The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
        # @!attribute [rw] regions
        #   @return [::Array<::String>]
        #     The list of regions associated with a sku. Empty for Global skus, which are
        #     associated with all Google Cloud regions.
        class GeoTaxonomy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
          module Type
            # The type is not specified.
            TYPE_UNSPECIFIED = 0

            # The sku is global in nature, e.g. a license sku. Global skus are
            # available in all regions, and so have an empty region list.
            GLOBAL = 1

            # The sku is available in a specific region, e.g. "us-west2".
            REGIONAL = 2

            # The sku is associated with multiple regions, e.g. "us-west2" and
            # "us-east1".
            MULTI_REGIONAL = 3
          end
        end

        # Request message for `ListServices`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Defaults to 5000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results to return. This should be a
        #     `next_page_token` value returned from a previous `ListServices`
        #     call. If unspecified, the first page of results is returned.
        class ListServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `ListServices`.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::Billing::V1::Service>]
        #     A list of services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. To retrieve the next page,
        #     call `ListServices` again with the `page_token` field set to this
        #     value. This field is empty if there are no more results to retrieve.
        class ListServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for `ListSkus`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the service.
        #     Example: "services/6F81-5844-456A"
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional inclusive start time of the time range for which the pricing
        #     versions will be returned. Timestamps in the future are not allowed.
        #     The time range has to be within a single calendar month in
        #     America/Los_Angeles timezone. Time range as a whole is optional. If not
        #     specified, the latest pricing will be returned (up to 12 hours old at
        #     most).
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional exclusive end time of the time range for which the pricing
        #     versions will be returned. Timestamps in the future are not allowed.
        #     The time range has to be within a single calendar month in
        #     America/Los_Angeles timezone. Time range as a whole is optional. If not
        #     specified, the latest pricing will be returned (up to 12 hours old at
        #     most).
        # @!attribute [rw] currency_code
        #   @return [::String]
        #     The ISO 4217 currency code for the pricing info in the response proto.
        #     Will use the conversion rate as of start_time.
        #     Optional. If not specified USD will be used.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Defaults to 5000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results to return. This should be a
        #     `next_page_token` value returned from a previous `ListSkus`
        #     call. If unspecified, the first page of results is returned.
        class ListSkusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for `ListSkus`.
        # @!attribute [rw] skus
        #   @return [::Array<::Google::Cloud::Billing::V1::Sku>]
        #     The list of public SKUs of the given service.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. To retrieve the next page,
        #     call `ListSkus` again with the `page_token` field set to this
        #     value. This field is empty if there are no more results to retrieve.
        class ListSkusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
