# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/billing/v1/cloud_billing_pb"
require "google/cloud/billing/v1/cloud_billing/rest/service_stub"

module Google
  module Cloud
    module Billing
      module V1
        module CloudBilling
          module Rest
            ##
            # REST client for the CloudBilling service.
            #
            # Retrieves the Google Cloud Console billing accounts and associates them with
            # projects.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "cloudbilling.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_billing_stub

              ##
              # Configure the CloudBilling Client class.
              #
              # See {::Google::Cloud::Billing::V1::CloudBilling::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudBilling clients
              #   ::Google::Cloud::Billing::V1::CloudBilling::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Billing", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.get_billing_account.timeout = 60.0
                  default_config.rpcs.get_billing_account.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_billing_accounts.timeout = 60.0
                  default_config.rpcs.list_billing_accounts.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_billing_account.timeout = 60.0
                  default_config.rpcs.update_billing_account.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_billing_account.timeout = 60.0

                  default_config.rpcs.list_project_billing_info.timeout = 60.0
                  default_config.rpcs.list_project_billing_info.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_project_billing_info.timeout = 60.0
                  default_config.rpcs.get_project_billing_info.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_project_billing_info.timeout = 60.0
                  default_config.rpcs.update_project_billing_info.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_iam_policy.timeout = 60.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.set_iam_policy.timeout = 60.0
                  default_config.rpcs.set_iam_policy.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.test_iam_permissions.timeout = 60.0
                  default_config.rpcs.test_iam_permissions.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudBilling Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Billing::V1::CloudBilling::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_billing_stub.universe_domain
              end

              ##
              # Create a new CloudBilling REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudBilling client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @cloud_billing_stub = ::Google::Cloud::Billing::V1::CloudBilling::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_billing_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_billing_stub.logger
              end

              # Service calls

              ##
              # Gets information about a billing account. The current authenticated user
              # must be a [viewer of the billing
              # account](https://cloud.google.com/billing/docs/how-to/billing-access).
              #
              # @overload get_billing_account(request, options = nil)
              #   Pass arguments to `get_billing_account` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::GetBillingAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::GetBillingAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_billing_account(name: nil)
              #   Pass arguments to `get_billing_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the billing account to retrieve. For
              #     example, `billingAccounts/012345-567890-ABCDEF`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Billing::V1::BillingAccount]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Billing::V1::BillingAccount]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::GetBillingAccountRequest.new
              #
              #   # Call the get_billing_account method.
              #   result = client.get_billing_account request
              #
              #   # The returned object is of type Google::Cloud::Billing::V1::BillingAccount.
              #   p result
              #
              def get_billing_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::GetBillingAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_billing_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_billing_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_billing_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.get_billing_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the billing accounts that the current authenticated user has
              # permission to
              # [view](https://cloud.google.com/billing/docs/how-to/billing-access).
              #
              # @overload list_billing_accounts(request, options = nil)
              #   Pass arguments to `list_billing_accounts` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::ListBillingAccountsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::ListBillingAccountsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_billing_accounts(page_size: nil, page_token: nil, filter: nil, parent: nil)
              #   Pass arguments to `list_billing_accounts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param page_size [::Integer]
              #     Requested page size. The maximum page size is 100; this is also the
              #     default.
              #   @param page_token [::String]
              #     A token identifying a page of results to return. This should be a
              #     `next_page_token` value returned from a previous `ListBillingAccounts`
              #     call. If unspecified, the first page of results is returned.
              #   @param filter [::String]
              #     Options for how to filter the returned billing accounts.
              #     This only supports filtering for
              #     [subaccounts](https://cloud.google.com/billing/docs/concepts) under a
              #     single provided parent billing account.
              #     (for example,
              #     `master_billing_account=billingAccounts/012345-678901-ABCDEF`).
              #     Boolean algebra and other fields are not currently supported.
              #   @param parent [::String]
              #     Optional. The parent resource to list billing accounts from.
              #     Format:
              #       - `organizations/{organization_id}`, for example,
              #         `organizations/12345678`
              #       - `billingAccounts/{billing_account_id}`, for example,
              #         `billingAccounts/012345-567890-ABCDEF`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Billing::V1::BillingAccount>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Billing::V1::BillingAccount>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::ListBillingAccountsRequest.new
              #
              #   # Call the list_billing_accounts method.
              #   result = client.list_billing_accounts request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Billing::V1::BillingAccount.
              #     p item
              #   end
              #
              def list_billing_accounts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::ListBillingAccountsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_billing_accounts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_billing_accounts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_billing_accounts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.list_billing_accounts request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_billing_stub, :list_billing_accounts, "billing_accounts", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a billing account's fields.
              # Currently the only field that can be edited is `display_name`.
              # The current authenticated user must have the `billing.accounts.update`
              # IAM permission, which is typically given to the
              # [administrator](https://cloud.google.com/billing/docs/how-to/billing-access)
              # of the billing account.
              #
              # @overload update_billing_account(request, options = nil)
              #   Pass arguments to `update_billing_account` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::UpdateBillingAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::UpdateBillingAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_billing_account(name: nil, account: nil, update_mask: nil)
              #   Pass arguments to `update_billing_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the billing account resource to be updated.
              #   @param account [::Google::Cloud::Billing::V1::BillingAccount, ::Hash]
              #     Required. The billing account resource to replace the resource on the
              #     server.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The update mask applied to the resource.
              #     Only "display_name" is currently supported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Billing::V1::BillingAccount]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Billing::V1::BillingAccount]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::UpdateBillingAccountRequest.new
              #
              #   # Call the update_billing_account method.
              #   result = client.update_billing_account request
              #
              #   # The returned object is of type Google::Cloud::Billing::V1::BillingAccount.
              #   p result
              #
              def update_billing_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::UpdateBillingAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_billing_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_billing_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_billing_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.update_billing_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # This method creates [billing
              # subaccounts](https://cloud.google.com/billing/docs/concepts#subaccounts).
              #
              # Google Cloud resellers should use the
              # Channel Services APIs,
              # [accounts.customers.create](https://cloud.google.com/channel/docs/reference/rest/v1/accounts.customers/create)
              # and
              # [accounts.customers.entitlements.create](https://cloud.google.com/channel/docs/reference/rest/v1/accounts.customers.entitlements/create).
              #
              # When creating a subaccount, the current authenticated user must have the
              # `billing.accounts.update` IAM permission on the parent account, which is
              # typically given to billing account
              # [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
              # This method will return an error if the parent account has not been
              # provisioned for subaccounts.
              #
              # @overload create_billing_account(request, options = nil)
              #   Pass arguments to `create_billing_account` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::CreateBillingAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::CreateBillingAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_billing_account(billing_account: nil, parent: nil)
              #   Pass arguments to `create_billing_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param billing_account [::Google::Cloud::Billing::V1::BillingAccount, ::Hash]
              #     Required. The billing account resource to create.
              #     Currently CreateBillingAccount only supports subaccount creation, so
              #     any created billing accounts must be under a provided parent billing
              #     account.
              #   @param parent [::String]
              #     Optional. The parent to create a billing account from.
              #     Format:
              #       - `billingAccounts/{billing_account_id}`, for example,
              #          `billingAccounts/012345-567890-ABCDEF`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Billing::V1::BillingAccount]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Billing::V1::BillingAccount]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::CreateBillingAccountRequest.new
              #
              #   # Call the create_billing_account method.
              #   result = client.create_billing_account request
              #
              #   # The returned object is of type Google::Cloud::Billing::V1::BillingAccount.
              #   p result
              #
              def create_billing_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::CreateBillingAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_billing_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_billing_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_billing_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.create_billing_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the projects associated with a billing account. The current
              # authenticated user must have the `billing.resourceAssociations.list` IAM
              # permission, which is often given to billing account
              # [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
              #
              # @overload list_project_billing_info(request, options = nil)
              #   Pass arguments to `list_project_billing_info` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::ListProjectBillingInfoRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::ListProjectBillingInfoRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_project_billing_info(name: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_project_billing_info` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the billing account associated with the
              #     projects that you want to list. For example,
              #     `billingAccounts/012345-567890-ABCDEF`.
              #   @param page_size [::Integer]
              #     Requested page size. The maximum page size is 100; this is also the
              #     default.
              #   @param page_token [::String]
              #     A token identifying a page of results to be returned. This should be a
              #     `next_page_token` value returned from a previous `ListProjectBillingInfo`
              #     call. If unspecified, the first page of results is returned.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Billing::V1::ProjectBillingInfo>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Billing::V1::ProjectBillingInfo>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::ListProjectBillingInfoRequest.new
              #
              #   # Call the list_project_billing_info method.
              #   result = client.list_project_billing_info request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Billing::V1::ProjectBillingInfo.
              #     p item
              #   end
              #
              def list_project_billing_info request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::ListProjectBillingInfoRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_project_billing_info.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_project_billing_info.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_project_billing_info.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.list_project_billing_info request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_billing_stub, :list_project_billing_info, "project_billing_info", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the billing information for a project. The current authenticated user
              # must have the `resourcemanager.projects.get` permission for the project,
              # which can be granted by assigning the [Project
              # Viewer](https://cloud.google.com/iam/docs/understanding-roles#predefined_roles)
              # role.
              #
              # @overload get_project_billing_info(request, options = nil)
              #   Pass arguments to `get_project_billing_info` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::GetProjectBillingInfoRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::GetProjectBillingInfoRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_project_billing_info(name: nil)
              #   Pass arguments to `get_project_billing_info` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the project for which billing information is
              #     retrieved. For example, `projects/tokyo-rain-123`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Billing::V1::ProjectBillingInfo]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Billing::V1::ProjectBillingInfo]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::GetProjectBillingInfoRequest.new
              #
              #   # Call the get_project_billing_info method.
              #   result = client.get_project_billing_info request
              #
              #   # The returned object is of type Google::Cloud::Billing::V1::ProjectBillingInfo.
              #   p result
              #
              def get_project_billing_info request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::GetProjectBillingInfoRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_project_billing_info.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_project_billing_info.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_project_billing_info.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.get_project_billing_info request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets or updates the billing account associated with a project. You specify
              # the new billing account by setting the `billing_account_name` in the
              # `ProjectBillingInfo` resource to the resource name of a billing account.
              # Associating a project with an open billing account enables billing on the
              # project and allows charges for resource usage. If the project already had a
              # billing account, this method changes the billing account used for resource
              # usage charges.
              #
              # *Note:* Incurred charges that have not yet been reported in the transaction
              # history of the Google Cloud Console might be billed to the new billing
              # account, even if the charge occurred before the new billing account was
              # assigned to the project.
              #
              # The current authenticated user must have ownership privileges for both
              # the
              # [project](https://cloud.google.com/docs/permissions-overview#h.bgs0oxofvnoo
              # ) and the [billing
              # account](https://cloud.google.com/billing/docs/how-to/billing-access).
              #
              # You can disable billing on the project by setting the
              # `billing_account_name` field to empty. This action disassociates the
              # current billing account from the project. Any billable activity of your
              # in-use services will stop, and your application could stop functioning as
              # expected. Any unbilled charges to date will be billed to the previously
              # associated account. The current authenticated user must be either an owner
              # of the project or an owner of the billing account for the project.
              #
              # Note that associating a project with a *closed* billing account will have
              # much the same effect as disabling billing on the project: any paid
              # resources used by the project will be shut down. Thus, unless you wish to
              # disable billing, you should always call this method with the name of an
              # *open* billing account.
              #
              # @overload update_project_billing_info(request, options = nil)
              #   Pass arguments to `update_project_billing_info` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::UpdateProjectBillingInfoRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::UpdateProjectBillingInfoRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_project_billing_info(name: nil, project_billing_info: nil)
              #   Pass arguments to `update_project_billing_info` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the project associated with the billing
              #     information that you want to update. For example,
              #     `projects/tokyo-rain-123`.
              #   @param project_billing_info [::Google::Cloud::Billing::V1::ProjectBillingInfo, ::Hash]
              #     The new billing information for the project. Output-only fields are
              #     ignored; thus, you can leave empty all fields except
              #     `billing_account_name`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Billing::V1::ProjectBillingInfo]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Billing::V1::ProjectBillingInfo]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::UpdateProjectBillingInfoRequest.new
              #
              #   # Call the update_project_billing_info method.
              #   result = client.update_project_billing_info request
              #
              #   # The returned object is of type Google::Cloud::Billing::V1::ProjectBillingInfo.
              #   p result
              #
              def update_project_billing_info request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::UpdateProjectBillingInfoRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_project_billing_info.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_project_billing_info.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_project_billing_info.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.update_project_billing_info request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a billing account.
              # The caller must have the `billing.accounts.getIamPolicy` permission on the
              # account, which is often given to billing account
              # [viewers](https://cloud.google.com/billing/docs/how-to/billing-access).
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy for a billing account. Replaces any existing
              # policy.
              # The caller must have the `billing.accounts.setIamPolicy` permission on the
              # account, which is often given to billing account
              # [administrators](https://cloud.google.com/billing/docs/how-to/billing-access).
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Tests the access control policy for a billing account. This method takes
              # the resource and a set of permissions as input and returns the subset of
              # the input permissions that the caller is allowed for that resource.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Changes which parent organization a billing account belongs to.
              #
              # @overload move_billing_account(request, options = nil)
              #   Pass arguments to `move_billing_account` via a request object, either of type
              #   {::Google::Cloud::Billing::V1::MoveBillingAccountRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Billing::V1::MoveBillingAccountRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload move_billing_account(name: nil, destination_parent: nil)
              #   Pass arguments to `move_billing_account` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the billing account to move.
              #     Must be of the form `billingAccounts/{billing_account_id}`.
              #     The specified billing account cannot be a subaccount, since a subaccount
              #     always belongs to the same organization as its parent account.
              #   @param destination_parent [::String]
              #     Required. The resource name of the Organization to move
              #     the billing account under.
              #     Must be of the form `organizations/{organization_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Billing::V1::BillingAccount]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Billing::V1::BillingAccount]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/billing/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Billing::V1::MoveBillingAccountRequest.new
              #
              #   # Call the move_billing_account method.
              #   result = client.move_billing_account request
              #
              #   # The returned object is of type Google::Cloud::Billing::V1::BillingAccount.
              #   p result
              #
              def move_billing_account request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Billing::V1::MoveBillingAccountRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.move_billing_account.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Billing::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.move_billing_account.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.move_billing_account.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_billing_stub.move_billing_account request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudBilling REST API.
              #
              # This class represents the configuration for CloudBilling REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Billing::V1::CloudBilling::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_billing_account to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Billing::V1::CloudBilling::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_billing_account.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_billing_account.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "cloudbilling.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudBilling API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_billing_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_billing_account
                  ##
                  # RPC-specific configuration for `list_billing_accounts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_billing_accounts
                  ##
                  # RPC-specific configuration for `update_billing_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_billing_account
                  ##
                  # RPC-specific configuration for `create_billing_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_billing_account
                  ##
                  # RPC-specific configuration for `list_project_billing_info`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_project_billing_info
                  ##
                  # RPC-specific configuration for `get_project_billing_info`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_project_billing_info
                  ##
                  # RPC-specific configuration for `update_project_billing_info`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_project_billing_info
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `move_billing_account`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :move_billing_account

                  # @private
                  def initialize parent_rpcs = nil
                    get_billing_account_config = parent_rpcs.get_billing_account if parent_rpcs.respond_to? :get_billing_account
                    @get_billing_account = ::Gapic::Config::Method.new get_billing_account_config
                    list_billing_accounts_config = parent_rpcs.list_billing_accounts if parent_rpcs.respond_to? :list_billing_accounts
                    @list_billing_accounts = ::Gapic::Config::Method.new list_billing_accounts_config
                    update_billing_account_config = parent_rpcs.update_billing_account if parent_rpcs.respond_to? :update_billing_account
                    @update_billing_account = ::Gapic::Config::Method.new update_billing_account_config
                    create_billing_account_config = parent_rpcs.create_billing_account if parent_rpcs.respond_to? :create_billing_account
                    @create_billing_account = ::Gapic::Config::Method.new create_billing_account_config
                    list_project_billing_info_config = parent_rpcs.list_project_billing_info if parent_rpcs.respond_to? :list_project_billing_info
                    @list_project_billing_info = ::Gapic::Config::Method.new list_project_billing_info_config
                    get_project_billing_info_config = parent_rpcs.get_project_billing_info if parent_rpcs.respond_to? :get_project_billing_info
                    @get_project_billing_info = ::Gapic::Config::Method.new get_project_billing_info_config
                    update_project_billing_info_config = parent_rpcs.update_project_billing_info if parent_rpcs.respond_to? :update_project_billing_info
                    @update_project_billing_info = ::Gapic::Config::Method.new update_project_billing_info_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    move_billing_account_config = parent_rpcs.move_billing_account if parent_rpcs.respond_to? :move_billing_account
                    @move_billing_account = ::Gapic::Config::Method.new move_billing_account_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
