# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Billing
      module V1
        module CloudBilling
          # Path helper methods for the CloudBilling API.
          module Paths
            ##
            # Create a fully-qualified BillingAccount resource string.
            #
            # @overload billing_account_path(billing_account:)
            #   The resource will be in the following format:
            #
            #   `billingAccounts/{billing_account}`
            #
            #   @param billing_account [String]
            #
            # @overload billing_account_path(organization:, billing_account:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/billingAccounts/{billing_account}`
            #
            #   @param organization [String]
            #   @param billing_account [String]
            #
            # @return [::String]
            def billing_account_path **args
              resources = {
                "billing_account" => (proc do |billing_account:|
                  "billingAccounts/#{billing_account}"
                end),
                "billing_account:organization" => (proc do |organization:, billing_account:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/billingAccounts/#{billing_account}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Organization resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}`
            #
            # @param organization [String]
            #
            # @return [::String]
            def organization_path organization:
              "organizations/#{organization}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified ProjectBillingInfo resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/billingInfo`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_billing_info_path project:
              "projects/#{project}/billingInfo"
            end

            extend self
          end
        end
      end
    end
  end
end
