# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/billing/v1/version"

require "google/cloud/billing/v1/cloud_billing/credentials"
require "google/cloud/billing/v1/cloud_billing/paths"
require "google/cloud/billing/v1/cloud_billing/client"
require "google/cloud/billing/v1/cloud_billing/rest"

module Google
  module Cloud
    module Billing
      module V1
        ##
        # Retrieves the Google Cloud Console billing accounts and associates them with
        # projects.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/billing/v1/cloud_billing"
        #     client = ::Google::Cloud::Billing::V1::CloudBilling::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/billing/v1/cloud_billing/rest"
        #     client = ::Google::Cloud::Billing::V1::CloudBilling::Rest::Client.new
        #
        module CloudBilling
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "cloud_billing", "helpers.rb"
require "google/cloud/billing/v1/cloud_billing/helpers" if ::File.file? helper_path
