# Copyright 2018 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


module Google
  module Cloud
    module Bigtable
      ##
      # Invalid read row state error
      class InvalidRowStateError < Google::Cloud::Error
        ##
        # Invalid row chunk data
        attr_reader :data

        def initialize message, data = nil
          super message
          @data = data if data
        end
      end

      ##
      # Row filter error.
      class RowFilterError < Google::Cloud::Error
      end
    end
  end
end
