# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/bigtable/v2/bigtable_pb"
require "google/cloud/bigtable/v2/bigtable"

class ::Google::Cloud::Bigtable::V2::Bigtable::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_read_rows
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::ReadRowsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    table_name = "hello world"
    authorized_view_name = "hello world"
    materialized_view_name = "hello world"
    app_profile_id = "hello world"
    rows = {}
    filter = {}
    rows_limit = 42
    request_stats_view = :REQUEST_STATS_VIEW_UNSPECIFIED
    reversed = true

    read_rows_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :read_rows, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::ReadRowsRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["authorized_view_name"]
      assert_equal "hello world", request["materialized_view_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigtable::V2::RowSet), request["rows"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigtable::V2::RowFilter), request["filter"]
      assert_equal 42, request["rows_limit"]
      assert_equal :REQUEST_STATS_VIEW_UNSPECIFIED, request["request_stats_view"]
      assert_equal true, request["reversed"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_rows_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_rows({ table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id, rows: rows, filter: filter, rows_limit: rows_limit, request_stats_view: request_stats_view, reversed: reversed }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_rows table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id, rows: rows, filter: filter, rows_limit: rows_limit, request_stats_view: request_stats_view, reversed: reversed do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_rows ::Google::Cloud::Bigtable::V2::ReadRowsRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id, rows: rows, filter: filter, rows_limit: rows_limit, request_stats_view: request_stats_view, reversed: reversed) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_rows({ table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id, rows: rows, filter: filter, rows_limit: rows_limit, request_stats_view: request_stats_view, reversed: reversed }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_rows(::Google::Cloud::Bigtable::V2::ReadRowsRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id, rows: rows, filter: filter, rows_limit: rows_limit, request_stats_view: request_stats_view, reversed: reversed), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_rows_client_stub.call_rpc_count
    end
  end

  def test_sample_row_keys
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::SampleRowKeysResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    table_name = "hello world"
    authorized_view_name = "hello world"
    materialized_view_name = "hello world"
    app_profile_id = "hello world"

    sample_row_keys_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :sample_row_keys, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::SampleRowKeysRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["authorized_view_name"]
      assert_equal "hello world", request["materialized_view_name"]
      assert_equal "hello world", request["app_profile_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, sample_row_keys_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.sample_row_keys({ table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::SampleRowKeysResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.sample_row_keys table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::SampleRowKeysResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.sample_row_keys ::Google::Cloud::Bigtable::V2::SampleRowKeysRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::SampleRowKeysResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.sample_row_keys({ table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::SampleRowKeysResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.sample_row_keys(::Google::Cloud::Bigtable::V2::SampleRowKeysRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, materialized_view_name: materialized_view_name, app_profile_id: app_profile_id), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::SampleRowKeysResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, sample_row_keys_client_stub.call_rpc_count
    end
  end

  def test_mutate_row
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::MutateRowResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    table_name = "hello world"
    authorized_view_name = "hello world"
    app_profile_id = "hello world"
    row_key = "hello world"
    mutations = [{}]
    idempotency = {}

    mutate_row_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mutate_row, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["authorized_view_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_equal "hello world", request["row_key"]
      assert_kind_of ::Google::Cloud::Bigtable::V2::Mutation, request["mutations"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigtable::V2::Idempotency), request["idempotency"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mutate_row_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mutate_row({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, mutations: mutations, idempotency: idempotency }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mutate_row table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, mutations: mutations, idempotency: idempotency do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mutate_row ::Google::Cloud::Bigtable::V2::MutateRowRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, mutations: mutations, idempotency: idempotency) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mutate_row({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, mutations: mutations, idempotency: idempotency }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mutate_row(::Google::Cloud::Bigtable::V2::MutateRowRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, mutations: mutations, idempotency: idempotency), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mutate_row_client_stub.call_rpc_count
    end
  end

  def test_mutate_rows
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::MutateRowsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    table_name = "hello world"
    authorized_view_name = "hello world"
    app_profile_id = "hello world"
    entries = [{}]

    mutate_rows_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :mutate_rows, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowsRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["authorized_view_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowsRequest::Entry, request["entries"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mutate_rows_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mutate_rows({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, entries: entries }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mutate_rows table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, entries: entries do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mutate_rows ::Google::Cloud::Bigtable::V2::MutateRowsRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, entries: entries) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mutate_rows({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, entries: entries }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mutate_rows(::Google::Cloud::Bigtable::V2::MutateRowsRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, entries: entries), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::MutateRowsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mutate_rows_client_stub.call_rpc_count
    end
  end

  def test_check_and_mutate_row
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::CheckAndMutateRowResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    table_name = "hello world"
    authorized_view_name = "hello world"
    app_profile_id = "hello world"
    row_key = "hello world"
    predicate_filter = {}
    true_mutations = [{}]
    false_mutations = [{}]

    check_and_mutate_row_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :check_and_mutate_row, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["authorized_view_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_equal "hello world", request["row_key"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigtable::V2::RowFilter), request["predicate_filter"]
      assert_kind_of ::Google::Cloud::Bigtable::V2::Mutation, request["true_mutations"].first
      assert_kind_of ::Google::Cloud::Bigtable::V2::Mutation, request["false_mutations"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, check_and_mutate_row_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.check_and_mutate_row({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, predicate_filter: predicate_filter, true_mutations: true_mutations, false_mutations: false_mutations }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.check_and_mutate_row table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, predicate_filter: predicate_filter, true_mutations: true_mutations, false_mutations: false_mutations do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.check_and_mutate_row ::Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, predicate_filter: predicate_filter, true_mutations: true_mutations, false_mutations: false_mutations) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.check_and_mutate_row({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, predicate_filter: predicate_filter, true_mutations: true_mutations, false_mutations: false_mutations }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.check_and_mutate_row(::Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, predicate_filter: predicate_filter, true_mutations: true_mutations, false_mutations: false_mutations), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, check_and_mutate_row_client_stub.call_rpc_count
    end
  end

  def test_ping_and_warm
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::PingAndWarmResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    app_profile_id = "hello world"

    ping_and_warm_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :ping_and_warm, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::PingAndWarmRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["app_profile_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, ping_and_warm_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.ping_and_warm({ name: name, app_profile_id: app_profile_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.ping_and_warm name: name, app_profile_id: app_profile_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.ping_and_warm ::Google::Cloud::Bigtable::V2::PingAndWarmRequest.new(name: name, app_profile_id: app_profile_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.ping_and_warm({ name: name, app_profile_id: app_profile_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.ping_and_warm(::Google::Cloud::Bigtable::V2::PingAndWarmRequest.new(name: name, app_profile_id: app_profile_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, ping_and_warm_client_stub.call_rpc_count
    end
  end

  def test_read_modify_write_row
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::ReadModifyWriteRowResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    table_name = "hello world"
    authorized_view_name = "hello world"
    app_profile_id = "hello world"
    row_key = "hello world"
    rules = [{}]

    read_modify_write_row_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read_modify_write_row, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["authorized_view_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_equal "hello world", request["row_key"]
      assert_kind_of ::Google::Cloud::Bigtable::V2::ReadModifyWriteRule, request["rules"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_modify_write_row_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_modify_write_row({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, rules: rules }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_modify_write_row table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, rules: rules do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_modify_write_row ::Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, rules: rules) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_modify_write_row({ table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, rules: rules }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_modify_write_row(::Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest.new(table_name: table_name, authorized_view_name: authorized_view_name, app_profile_id: app_profile_id, row_key: row_key, rules: rules), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_modify_write_row_client_stub.call_rpc_count
    end
  end

  def test_generate_initial_change_stream_partitions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    table_name = "hello world"
    app_profile_id = "hello world"

    generate_initial_change_stream_partitions_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :generate_initial_change_stream_partitions, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["app_profile_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_initial_change_stream_partitions_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_initial_change_stream_partitions({ table_name: table_name, app_profile_id: app_profile_id }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_initial_change_stream_partitions table_name: table_name, app_profile_id: app_profile_id do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_initial_change_stream_partitions ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest.new(table_name: table_name, app_profile_id: app_profile_id) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_initial_change_stream_partitions({ table_name: table_name, app_profile_id: app_profile_id }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_initial_change_stream_partitions(::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest.new(table_name: table_name, app_profile_id: app_profile_id), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_initial_change_stream_partitions_client_stub.call_rpc_count
    end
  end

  def test_read_change_stream
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    table_name = "hello world"
    app_profile_id = "hello world"
    partition = {}
    start_time = {}
    end_time = {}
    heartbeat_duration = {}

    read_change_stream_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :read_change_stream, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::ReadChangeStreamRequest, request
      assert_equal "hello world", request["table_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigtable::V2::StreamPartition), request["partition"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["start_time"]
      assert_equal :start_time, request.start_from
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["end_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["heartbeat_duration"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_change_stream_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_change_stream({ table_name: table_name, app_profile_id: app_profile_id, partition: partition, start_time: start_time, end_time: end_time, heartbeat_duration: heartbeat_duration }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_change_stream table_name: table_name, app_profile_id: app_profile_id, partition: partition, start_time: start_time, end_time: end_time, heartbeat_duration: heartbeat_duration do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_change_stream ::Google::Cloud::Bigtable::V2::ReadChangeStreamRequest.new(table_name: table_name, app_profile_id: app_profile_id, partition: partition, start_time: start_time, end_time: end_time, heartbeat_duration: heartbeat_duration) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_change_stream({ table_name: table_name, app_profile_id: app_profile_id, partition: partition, start_time: start_time, end_time: end_time, heartbeat_duration: heartbeat_duration }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_change_stream(::Google::Cloud::Bigtable::V2::ReadChangeStreamRequest.new(table_name: table_name, app_profile_id: app_profile_id, partition: partition, start_time: start_time, end_time: end_time, heartbeat_duration: heartbeat_duration), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_change_stream_client_stub.call_rpc_count
    end
  end

  def test_prepare_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::PrepareQueryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    instance_name = "hello world"
    app_profile_id = "hello world"
    query = "hello world"
    proto_format = {}
    param_types = {}

    prepare_query_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :prepare_query, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::PrepareQueryRequest, request
      assert_equal "hello world", request["instance_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_equal "hello world", request["query"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigtable::V2::ProtoFormat), request["proto_format"]
      assert_equal :proto_format, request.data_format
      assert_equal({}, request["param_types"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, prepare_query_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.prepare_query({ instance_name: instance_name, app_profile_id: app_profile_id, query: query, proto_format: proto_format, param_types: param_types }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.prepare_query instance_name: instance_name, app_profile_id: app_profile_id, query: query, proto_format: proto_format, param_types: param_types do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.prepare_query ::Google::Cloud::Bigtable::V2::PrepareQueryRequest.new(instance_name: instance_name, app_profile_id: app_profile_id, query: query, proto_format: proto_format, param_types: param_types) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.prepare_query({ instance_name: instance_name, app_profile_id: app_profile_id, query: query, proto_format: proto_format, param_types: param_types }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.prepare_query(::Google::Cloud::Bigtable::V2::PrepareQueryRequest.new(instance_name: instance_name, app_profile_id: app_profile_id, query: query, proto_format: proto_format, param_types: param_types), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, prepare_query_client_stub.call_rpc_count
    end
  end

  def test_execute_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Bigtable::V2::ExecuteQueryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    instance_name = "hello world"
    app_profile_id = "hello world"
    query = "hello world"
    prepared_query = "hello world"
    proto_format = {}
    resume_token = "hello world"
    params = {}

    execute_query_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :execute_query, name
      assert_kind_of ::Google::Cloud::Bigtable::V2::ExecuteQueryRequest, request
      assert_equal "hello world", request["instance_name"]
      assert_equal "hello world", request["app_profile_id"]
      assert_equal "hello world", request["query"]
      assert_equal "hello world", request["prepared_query"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Bigtable::V2::ProtoFormat), request["proto_format"]
      assert_equal :proto_format, request.data_format
      assert_equal "hello world", request["resume_token"]
      assert_equal({}, request["params"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_query_client_stub do
      # Create client
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_query({ instance_name: instance_name, app_profile_id: app_profile_id, query: query, prepared_query: prepared_query, proto_format: proto_format, resume_token: resume_token, params: params }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ExecuteQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_query instance_name: instance_name, app_profile_id: app_profile_id, query: query, prepared_query: prepared_query, proto_format: proto_format, resume_token: resume_token, params: params do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ExecuteQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_query ::Google::Cloud::Bigtable::V2::ExecuteQueryRequest.new(instance_name: instance_name, app_profile_id: app_profile_id, query: query, prepared_query: prepared_query, proto_format: proto_format, resume_token: resume_token, params: params) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ExecuteQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_query({ instance_name: instance_name, app_profile_id: app_profile_id, query: query, prepared_query: prepared_query, proto_format: proto_format, resume_token: resume_token, params: params }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ExecuteQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_query(::Google::Cloud::Bigtable::V2::ExecuteQueryRequest.new(instance_name: instance_name, app_profile_id: app_profile_id, query: query, prepared_query: prepared_query, proto_format: proto_format, resume_token: resume_token, params: params), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::Bigtable::V2::ExecuteQueryResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_query_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Bigtable::V2::Bigtable::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Bigtable::V2::Bigtable::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
