# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigtable
      module V2
        # PeerInfo contains information about the peer that the client is
        # connecting to.
        # @!attribute [rw] google_frontend_id
        #   @return [::Integer]
        #     An opaque identifier for the Google Frontend which serviced this request.
        #     Only set when not using DirectAccess.
        # @!attribute [rw] application_frontend_id
        #   @return [::Integer]
        #     An opaque identifier for the application frontend which serviced this
        #     request.
        # @!attribute [rw] application_frontend_zone
        #   @return [::String]
        #     The Cloud zone of the application frontend that served this request.
        # @!attribute [rw] application_frontend_subzone
        #   @return [::String]
        #     The subzone of the application frontend that served this request, e.g. an
        #     identifier for where within the zone the application frontend is.
        # @!attribute [rw] transport_type
        #   @return [::Google::Cloud::Bigtable::V2::PeerInfo::TransportType]
        class PeerInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The transport type that the client used to connect to this peer.
          module TransportType
            # The transport type is unknown.
            TRANSPORT_TYPE_UNKNOWN = 0

            # The client connected to this peer via an external network
            # (e.g. outside Google Coud).
            TRANSPORT_TYPE_EXTERNAL = 1

            # The client connected to this peer via CloudPath.
            TRANSPORT_TYPE_CLOUD_PATH = 2

            # The client connected to this peer via DirectAccess.
            TRANSPORT_TYPE_DIRECT_ACCESS = 3

            # The client connected to this peer via Bigtable Sessions using an unknown
            # transport type.
            TRANSPORT_TYPE_SESSION_UNKNOWN = 4

            # The client connected to this peer via Bigtable Sessions on an external
            # network (e.g. outside Google Cloud).
            TRANSPORT_TYPE_SESSION_EXTERNAL = 5

            # The client connected to this peer via Bigtable Sessions using CloudPath.
            TRANSPORT_TYPE_SESSION_CLOUD_PATH = 6

            # The client connected to this peer via Bigtable Sessions using
            # DirectAccess.
            TRANSPORT_TYPE_SESSION_DIRECT_ACCESS = 7
          end
        end
      end
    end
  end
end
