# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigtable
      module V2
        module Bigtable
          # Path helper methods for the Bigtable API.
          module Paths
            ##
            # Create a fully-qualified AuthorizedView resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
            #
            # @param project [String]
            # @param instance [String]
            # @param table [String]
            # @param authorized_view [String]
            #
            # @return [::String]
            def authorized_view_path project:, instance:, table:, authorized_view:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"
              raise ::ArgumentError, "table cannot contain /" if table.to_s.include? "/"

              "projects/#{project}/instances/#{instance}/tables/#{table}/authorizedViews/#{authorized_view}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}`
            #
            # @param project [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified MaterializedView resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}/materializedViews/{materialized_view}`
            #
            # @param project [String]
            # @param instance [String]
            # @param materialized_view [String]
            #
            # @return [::String]
            def materialized_view_path project:, instance:, materialized_view:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project}/instances/#{instance}/materializedViews/#{materialized_view}"
            end

            ##
            # Create a fully-qualified Table resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/instances/{instance}/tables/{table}`
            #
            # @param project [String]
            # @param instance [String]
            # @param table [String]
            #
            # @return [::String]
            def table_path project:, instance:, table:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project}/instances/#{instance}/tables/#{table}"
            end

            extend self
          end
        end
      end
    end
  end
end
