# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/bigtable/v2/bigtable_pb"

module Google
  module Cloud
    module Bigtable
      module V2
        module Bigtable
          ##
          # Client for the Bigtable service.
          #
          # Service for reading from and writing to existing Bigtable tables.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "bigtable.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :bigtable_stub

            ##
            # Configure the Bigtable Client class.
            #
            # See {::Google::Cloud::Bigtable::V2::Bigtable::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Bigtable clients
            #   ::Google::Cloud::Bigtable::V2::Bigtable::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Bigtable", "V2"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.read_rows.timeout = 43_200.0

                default_config.rpcs.sample_row_keys.timeout = 60.0

                default_config.rpcs.mutate_row.timeout = 60.0
                default_config.rpcs.mutate_row.retry_policy = {
                  initial_delay: 0.01, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                }

                default_config.rpcs.mutate_rows.timeout = 600.0

                default_config.rpcs.check_and_mutate_row.timeout = 20.0

                default_config.rpcs.read_modify_write_row.timeout = 20.0

                default_config.rpcs.generate_initial_change_stream_partitions.timeout = 60.0

                default_config.rpcs.read_change_stream.timeout = 43_200.0

                default_config.rpcs.execute_query.timeout = 43_200.0
                default_config.rpcs.execute_query.retry_policy = {
                  initial_delay: 0.01, max_delay: 60.0, multiplier: 2, retry_codes: [14, 4]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Bigtable Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Bigtable::V2::Bigtable::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @bigtable_stub.universe_domain
            end

            ##
            # Create a new Bigtable client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Bigtable client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/bigtable/v2/bigtable_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @bigtable_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Bigtable::V2::Bigtable::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @bigtable_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @bigtable_stub.logger
            end

            # Service calls

            ##
            # Streams back the contents of all requested rows in key order, optionally
            # applying the same Reader filter to each. Depending on their size,
            # rows and cells may be broken up across multiple responses, but
            # atomicity of each row will still be preserved. See the
            # ReadRowsResponse documentation for details.
            #
            # @overload read_rows(request, options = nil)
            #   Pass arguments to `read_rows` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::ReadRowsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::ReadRowsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload read_rows(table_name: nil, authorized_view_name: nil, materialized_view_name: nil, app_profile_id: nil, rows: nil, filter: nil, rows_limit: nil, request_stats_view: nil, reversed: nil)
            #   Pass arguments to `read_rows` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Optional. The unique name of the table from which to read.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #   @param authorized_view_name [::String]
            #     Optional. The unique name of the AuthorizedView from which to read.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
            #   @param materialized_view_name [::String]
            #     Optional. The unique name of the MaterializedView from which to read.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/materializedViews/<materialized_view>`.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #   @param rows [::Google::Cloud::Bigtable::V2::RowSet, ::Hash]
            #     The row keys and/or ranges to read sequentially. If not specified, reads
            #     from all rows.
            #   @param filter [::Google::Cloud::Bigtable::V2::RowFilter, ::Hash]
            #     The filter to apply to the contents of the specified row(s). If unset,
            #     reads the entirety of each row.
            #   @param rows_limit [::Integer]
            #     The read will stop after committing to N rows' worth of results. The
            #     default (zero) is to return all results.
            #   @param request_stats_view [::Google::Cloud::Bigtable::V2::ReadRowsRequest::RequestStatsView]
            #     The view into RequestStats, as described above.
            #   @param reversed [::Boolean]
            #     Experimental API - Please note that this API is currently experimental
            #     and can change in the future.
            #
            #     Return rows in lexiographical descending order of the row keys. The row
            #     contents will not be affected by this flag.
            #
            #     Example result set:
            #
            #         [
            #           {key: "k2", "f:col1": "v1", "f:col2": "v1"},
            #           {key: "k1", "f:col1": "v2", "f:col2": "v2"}
            #         ]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Bigtable::V2::ReadRowsResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Bigtable::V2::ReadRowsResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::ReadRowsRequest.new
            #
            #   # Call the read_rows method to start streaming.
            #   output = client.read_rows request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Bigtable::V2::ReadRowsResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def read_rows request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::ReadRowsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.read_rows.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name &&
                 %r{^projects/[^/]+/instances/[^/]+/tables/[^/]+/?$}.match?(request.table_name)
                header_params["table_name"] = request.table_name
              end
              if request.authorized_view_name
                regex_match = %r{^(?<table_name>projects/[^/]+/instances/[^/]+/tables/[^/]+)(?:/.*)?$}.match request.authorized_view_name
                if regex_match
                  header_params["table_name"] = regex_match["table_name".to_s]
                end
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end
              if request.materialized_view_name
                regex_match = %r{^(?<name>projects/[^/]+/instances/[^/]+)(?:/.*)?$}.match request.materialized_view_name
                if regex_match
                  header_params["name"] = regex_match["name".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.read_rows.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.read_rows.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :read_rows, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a sample of row keys in the table. The returned row keys will
            # delimit contiguous sections of the table of approximately equal size,
            # which can be used to break up the data for distributed tasks like
            # mapreduces.
            #
            # @overload sample_row_keys(request, options = nil)
            #   Pass arguments to `sample_row_keys` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::SampleRowKeysRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::SampleRowKeysRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload sample_row_keys(table_name: nil, authorized_view_name: nil, materialized_view_name: nil, app_profile_id: nil)
            #   Pass arguments to `sample_row_keys` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Optional. The unique name of the table from which to sample row keys.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #   @param authorized_view_name [::String]
            #     Optional. The unique name of the AuthorizedView from which to sample row
            #     keys.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
            #   @param materialized_view_name [::String]
            #     Optional. The unique name of the MaterializedView from which to read.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/materializedViews/<materialized_view>`.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Bigtable::V2::SampleRowKeysResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Bigtable::V2::SampleRowKeysResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::SampleRowKeysRequest.new
            #
            #   # Call the sample_row_keys method to start streaming.
            #   output = client.sample_row_keys request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Bigtable::V2::SampleRowKeysResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def sample_row_keys request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::SampleRowKeysRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.sample_row_keys.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name &&
                 %r{^projects/[^/]+/instances/[^/]+/tables/[^/]+/?$}.match?(request.table_name)
                header_params["table_name"] = request.table_name
              end
              if request.authorized_view_name
                regex_match = %r{^(?<table_name>projects/[^/]+/instances/[^/]+/tables/[^/]+)(?:/.*)?$}.match request.authorized_view_name
                if regex_match
                  header_params["table_name"] = regex_match["table_name".to_s]
                end
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end
              if request.materialized_view_name
                regex_match = %r{^(?<name>projects/[^/]+/instances/[^/]+)(?:/.*)?$}.match request.materialized_view_name
                if regex_match
                  header_params["name"] = regex_match["name".to_s]
                end
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.sample_row_keys.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.sample_row_keys.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :sample_row_keys, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Mutates a row atomically. Cells already present in the row are left
            # unchanged unless explicitly changed by `mutation`.
            #
            # @overload mutate_row(request, options = nil)
            #   Pass arguments to `mutate_row` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::MutateRowRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::MutateRowRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload mutate_row(table_name: nil, authorized_view_name: nil, app_profile_id: nil, row_key: nil, mutations: nil, idempotency: nil)
            #   Pass arguments to `mutate_row` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Optional. The unique name of the table to which the mutation should be
            #     applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #   @param authorized_view_name [::String]
            #     Optional. The unique name of the AuthorizedView to which the mutation
            #     should be applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #   @param row_key [::String]
            #     Required. The key of the row to which the mutation should be applied.
            #   @param mutations [::Array<::Google::Cloud::Bigtable::V2::Mutation, ::Hash>]
            #     Required. Changes to be atomically applied to the specified row. Entries
            #     are applied in order, meaning that earlier mutations can be masked by later
            #     ones. Must contain at least one entry and at most 100000.
            #   @param idempotency [::Google::Cloud::Bigtable::V2::Idempotency, ::Hash]
            #     If set consistently across retries, prevents this mutation from being
            #     double applied to aggregate column families within a 15m window.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Bigtable::V2::MutateRowResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Bigtable::V2::MutateRowResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::MutateRowRequest.new
            #
            #   # Call the mutate_row method.
            #   result = client.mutate_row request
            #
            #   # The returned object is of type Google::Cloud::Bigtable::V2::MutateRowResponse.
            #   p result
            #
            def mutate_row request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::MutateRowRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.mutate_row.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name &&
                 %r{^projects/[^/]+/instances/[^/]+/tables/[^/]+/?$}.match?(request.table_name)
                header_params["table_name"] = request.table_name
              end
              if request.authorized_view_name
                regex_match = %r{^(?<table_name>projects/[^/]+/instances/[^/]+/tables/[^/]+)(?:/.*)?$}.match request.authorized_view_name
                if regex_match
                  header_params["table_name"] = regex_match["table_name".to_s]
                end
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.mutate_row.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.mutate_row.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :mutate_row, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Mutates multiple rows in a batch. Each individual row is mutated
            # atomically as in MutateRow, but the entire batch is not executed
            # atomically.
            #
            # @overload mutate_rows(request, options = nil)
            #   Pass arguments to `mutate_rows` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::MutateRowsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::MutateRowsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload mutate_rows(table_name: nil, authorized_view_name: nil, app_profile_id: nil, entries: nil)
            #   Pass arguments to `mutate_rows` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Optional. The unique name of the table to which the mutations should be
            #     applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #   @param authorized_view_name [::String]
            #     Optional. The unique name of the AuthorizedView to which the mutations
            #     should be applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #   @param entries [::Array<::Google::Cloud::Bigtable::V2::MutateRowsRequest::Entry, ::Hash>]
            #     Required. The row keys and corresponding mutations to be applied in bulk.
            #     Each entry is applied as an atomic mutation, but the entries may be
            #     applied in arbitrary order (even between entries for the same row).
            #     At least one entry must be specified, and in total the entries can
            #     contain at most 100000 mutations.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Bigtable::V2::MutateRowsResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Bigtable::V2::MutateRowsResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::MutateRowsRequest.new
            #
            #   # Call the mutate_rows method to start streaming.
            #   output = client.mutate_rows request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Bigtable::V2::MutateRowsResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def mutate_rows request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::MutateRowsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.mutate_rows.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name &&
                 %r{^projects/[^/]+/instances/[^/]+/tables/[^/]+/?$}.match?(request.table_name)
                header_params["table_name"] = request.table_name
              end
              if request.authorized_view_name
                regex_match = %r{^(?<table_name>projects/[^/]+/instances/[^/]+/tables/[^/]+)(?:/.*)?$}.match request.authorized_view_name
                if regex_match
                  header_params["table_name"] = regex_match["table_name".to_s]
                end
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.mutate_rows.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.mutate_rows.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :mutate_rows, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Mutates a row atomically based on the output of a predicate Reader filter.
            #
            # @overload check_and_mutate_row(request, options = nil)
            #   Pass arguments to `check_and_mutate_row` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload check_and_mutate_row(table_name: nil, authorized_view_name: nil, app_profile_id: nil, row_key: nil, predicate_filter: nil, true_mutations: nil, false_mutations: nil)
            #   Pass arguments to `check_and_mutate_row` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Optional. The unique name of the table to which the conditional mutation
            #     should be applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #   @param authorized_view_name [::String]
            #     Optional. The unique name of the AuthorizedView to which the conditional
            #     mutation should be applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #   @param row_key [::String]
            #     Required. The key of the row to which the conditional mutation should be
            #     applied.
            #   @param predicate_filter [::Google::Cloud::Bigtable::V2::RowFilter, ::Hash]
            #     The filter to be applied to the contents of the specified row. Depending
            #     on whether or not any results are yielded, either `true_mutations` or
            #     `false_mutations` will be executed. If unset, checks that the row contains
            #     any values at all.
            #   @param true_mutations [::Array<::Google::Cloud::Bigtable::V2::Mutation, ::Hash>]
            #     Changes to be atomically applied to the specified row if `predicate_filter`
            #     yields at least one cell when applied to `row_key`. Entries are applied in
            #     order, meaning that earlier mutations can be masked by later ones.
            #     Must contain at least one entry if `false_mutations` is empty, and at most
            #     100000.
            #   @param false_mutations [::Array<::Google::Cloud::Bigtable::V2::Mutation, ::Hash>]
            #     Changes to be atomically applied to the specified row if `predicate_filter`
            #     does not yield any cells when applied to `row_key`. Entries are applied in
            #     order, meaning that earlier mutations can be masked by later ones.
            #     Must contain at least one entry if `true_mutations` is empty, and at most
            #     100000.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Bigtable::V2::CheckAndMutateRowResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Bigtable::V2::CheckAndMutateRowResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest.new
            #
            #   # Call the check_and_mutate_row method.
            #   result = client.check_and_mutate_row request
            #
            #   # The returned object is of type Google::Cloud::Bigtable::V2::CheckAndMutateRowResponse.
            #   p result
            #
            def check_and_mutate_row request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.check_and_mutate_row.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name &&
                 %r{^projects/[^/]+/instances/[^/]+/tables/[^/]+/?$}.match?(request.table_name)
                header_params["table_name"] = request.table_name
              end
              if request.authorized_view_name
                regex_match = %r{^(?<table_name>projects/[^/]+/instances/[^/]+/tables/[^/]+)(?:/.*)?$}.match request.authorized_view_name
                if regex_match
                  header_params["table_name"] = regex_match["table_name".to_s]
                end
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.check_and_mutate_row.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.check_and_mutate_row.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :check_and_mutate_row, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Warm up associated instance metadata for this connection.
            # This call is not required but may be useful for connection keep-alive.
            #
            # @overload ping_and_warm(request, options = nil)
            #   Pass arguments to `ping_and_warm` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::PingAndWarmRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::PingAndWarmRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload ping_and_warm(name: nil, app_profile_id: nil)
            #   Pass arguments to `ping_and_warm` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The unique name of the instance to check permissions for as well
            #     as respond. Values are of the form
            #     `projects/<project>/instances/<instance>`.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Bigtable::V2::PingAndWarmResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Bigtable::V2::PingAndWarmResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::PingAndWarmRequest.new
            #
            #   # Call the ping_and_warm method.
            #   result = client.ping_and_warm request
            #
            #   # The returned object is of type Google::Cloud::Bigtable::V2::PingAndWarmResponse.
            #   p result
            #
            def ping_and_warm request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::PingAndWarmRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.ping_and_warm.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name &&
                 %r{^projects/[^/]+/instances/[^/]+/?$}.match?(request.name)
                header_params["name"] = request.name
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.ping_and_warm.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.ping_and_warm.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :ping_and_warm, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies a row atomically on the server. The method reads the latest
            # existing timestamp and value from the specified columns and writes a new
            # entry based on pre-defined read/modify/write rules. The new value for the
            # timestamp is the greater of the existing timestamp or the current server
            # time. The method returns the new contents of all modified cells.
            #
            # @overload read_modify_write_row(request, options = nil)
            #   Pass arguments to `read_modify_write_row` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload read_modify_write_row(table_name: nil, authorized_view_name: nil, app_profile_id: nil, row_key: nil, rules: nil)
            #   Pass arguments to `read_modify_write_row` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Optional. The unique name of the table to which the read/modify/write rules
            #     should be applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #   @param authorized_view_name [::String]
            #     Optional. The unique name of the AuthorizedView to which the
            #     read/modify/write rules should be applied.
            #
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #   @param row_key [::String]
            #     Required. The key of the row to which the read/modify/write rules should be
            #     applied.
            #   @param rules [::Array<::Google::Cloud::Bigtable::V2::ReadModifyWriteRule, ::Hash>]
            #     Required. Rules specifying how the specified row's contents are to be
            #     transformed into writes. Entries are applied in order, meaning that earlier
            #     rules will affect the results of later ones. At least one entry must be
            #     specified, and there can be at most 100000 rules.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Bigtable::V2::ReadModifyWriteRowResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Bigtable::V2::ReadModifyWriteRowResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest.new
            #
            #   # Call the read_modify_write_row method.
            #   result = client.read_modify_write_row request
            #
            #   # The returned object is of type Google::Cloud::Bigtable::V2::ReadModifyWriteRowResponse.
            #   p result
            #
            def read_modify_write_row request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.read_modify_write_row.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name &&
                 %r{^projects/[^/]+/instances/[^/]+/tables/[^/]+/?$}.match?(request.table_name)
                header_params["table_name"] = request.table_name
              end
              if request.authorized_view_name
                regex_match = %r{^(?<table_name>projects/[^/]+/instances/[^/]+/tables/[^/]+)(?:/.*)?$}.match request.authorized_view_name
                if regex_match
                  header_params["table_name"] = regex_match["table_name".to_s]
                end
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.read_modify_write_row.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.read_modify_write_row.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :read_modify_write_row, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the current list of partitions that make up the table's
            # change stream. The union of partitions will cover the entire keyspace.
            # Partitions can be read with `ReadChangeStream`.
            # NOTE: This API is only intended to be used by Apache Beam BigtableIO.
            #
            # @overload generate_initial_change_stream_partitions(request, options = nil)
            #   Pass arguments to `generate_initial_change_stream_partitions` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_initial_change_stream_partitions(table_name: nil, app_profile_id: nil)
            #   Pass arguments to `generate_initial_change_stream_partitions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Required. The unique name of the table from which to get change stream
            #     partitions. Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #     Change streaming must be enabled on the table.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #     Single cluster routing must be configured on the profile.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest.new
            #
            #   # Call the generate_initial_change_stream_partitions method to start streaming.
            #   output = client.generate_initial_change_stream_partitions request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def generate_initial_change_stream_partitions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_initial_change_stream_partitions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name
                header_params["table_name"] = request.table_name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_initial_change_stream_partitions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_initial_change_stream_partitions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :generate_initial_change_stream_partitions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Reads changes from a table's change stream. Changes will
            # reflect both user-initiated mutations and mutations that are caused by
            # garbage collection.
            # NOTE: This API is only intended to be used by Apache Beam BigtableIO.
            #
            # @overload read_change_stream(request, options = nil)
            #   Pass arguments to `read_change_stream` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::ReadChangeStreamRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::ReadChangeStreamRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload read_change_stream(table_name: nil, app_profile_id: nil, partition: nil, start_time: nil, continuation_tokens: nil, end_time: nil, heartbeat_duration: nil)
            #   Pass arguments to `read_change_stream` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param table_name [::String]
            #     Required. The unique name of the table from which to read a change stream.
            #     Values are of the form
            #     `projects/<project>/instances/<instance>/tables/<table>`.
            #     Change streaming must be enabled on the table.
            #   @param app_profile_id [::String]
            #     This value specifies routing for replication. If not specified, the
            #     "default" application profile will be used.
            #     Single cluster routing must be configured on the profile.
            #   @param partition [::Google::Cloud::Bigtable::V2::StreamPartition, ::Hash]
            #     The partition to read changes from.
            #   @param start_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Start reading the stream at the specified timestamp. This timestamp must
            #     be within the change stream retention period, less than or equal to the
            #     current time, and after change stream creation, whichever is greater.
            #     This value is inclusive and will be truncated to microsecond granularity.
            #
            #     Note: The following parameters are mutually exclusive: `start_time`, `continuation_tokens`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param continuation_tokens [::Google::Cloud::Bigtable::V2::StreamContinuationTokens, ::Hash]
            #     Tokens that describe how to resume reading a stream where reading
            #     previously left off. If specified, changes will be read starting at the
            #     the position. Tokens are delivered on the stream as part of `Heartbeat`
            #     and `CloseStream` messages.
            #
            #     If a single token is provided, the token's partition must exactly match
            #     the request's partition. If multiple tokens are provided, as in the case
            #     of a partition merge, the union of the token partitions must exactly
            #     cover the request's partition. Otherwise, INVALID_ARGUMENT will be
            #     returned.
            #
            #     Note: The following parameters are mutually exclusive: `continuation_tokens`, `start_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param end_time [::Google::Protobuf::Timestamp, ::Hash]
            #     If specified, OK will be returned when the stream advances beyond
            #     this time. Otherwise, changes will be continuously delivered on the stream.
            #     This value is inclusive and will be truncated to microsecond granularity.
            #   @param heartbeat_duration [::Google::Protobuf::Duration, ::Hash]
            #     If specified, the duration between `Heartbeat` messages on the stream.
            #     Otherwise, defaults to 5 seconds.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::ReadChangeStreamRequest.new
            #
            #   # Call the read_change_stream method to start streaming.
            #   output = client.read_change_stream request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def read_change_stream request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::ReadChangeStreamRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.read_change_stream.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.table_name
                header_params["table_name"] = request.table_name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.read_change_stream.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.read_change_stream.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :read_change_stream, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Prepares a GoogleSQL query for execution on a particular Bigtable instance.
            #
            # @overload prepare_query(request, options = nil)
            #   Pass arguments to `prepare_query` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::PrepareQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::PrepareQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload prepare_query(instance_name: nil, app_profile_id: nil, query: nil, proto_format: nil, param_types: nil)
            #   Pass arguments to `prepare_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param instance_name [::String]
            #     Required. The unique name of the instance against which the query should be
            #     executed.
            #     Values are of the form `projects/<project>/instances/<instance>`
            #   @param app_profile_id [::String]
            #     Optional. This value specifies routing for preparing the query. Note that
            #     this `app_profile_id` is only used for preparing the query. The actual
            #     query execution will use the app profile specified in the
            #     `ExecuteQueryRequest`. If not specified, the `default` application profile
            #     will be used.
            #   @param query [::String]
            #     Required. The query string.
            #   @param proto_format [::Google::Cloud::Bigtable::V2::ProtoFormat, ::Hash]
            #     Protocol buffer format as described by ProtoSchema and ProtoRows
            #     messages.
            #   @param param_types [::Hash{::String => ::Google::Cloud::Bigtable::V2::Type, ::Hash}]
            #     Required. `param_types` is a map of parameter identifier strings to their
            #     `Type`s.
            #
            #     In query string, a parameter placeholder consists of the
            #     `@` character followed by the parameter name (for example, `@firstName`) in
            #     the query string.
            #
            #     For example, if param_types["firstName"] = Bytes then @firstName will be a
            #     query parameter of type Bytes. The specific `Value` to be used for the
            #     query execution must be sent in `ExecuteQueryRequest` in the `params` map.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Bigtable::V2::PrepareQueryResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Bigtable::V2::PrepareQueryResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::PrepareQueryRequest.new
            #
            #   # Call the prepare_query method.
            #   result = client.prepare_query request
            #
            #   # The returned object is of type Google::Cloud::Bigtable::V2::PrepareQueryResponse.
            #   p result
            #
            def prepare_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::PrepareQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.prepare_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.instance_name &&
                 %r{^projects/[^/]+/instances/[^/]+/?$}.match?(request.instance_name)
                header_params["name"] = request.instance_name
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.prepare_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.prepare_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :prepare_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Executes a SQL query against a particular Bigtable instance.
            #
            # @overload execute_query(request, options = nil)
            #   Pass arguments to `execute_query` via a request object, either of type
            #   {::Google::Cloud::Bigtable::V2::ExecuteQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Bigtable::V2::ExecuteQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload execute_query(instance_name: nil, app_profile_id: nil, query: nil, prepared_query: nil, proto_format: nil, resume_token: nil, params: nil)
            #   Pass arguments to `execute_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param instance_name [::String]
            #     Required. The unique name of the instance against which the query should be
            #     executed.
            #     Values are of the form `projects/<project>/instances/<instance>`
            #   @param app_profile_id [::String]
            #     Optional. This value specifies routing for replication. If not specified,
            #     the `default` application profile will be used.
            #   @param query [::String]
            #     Required. The query string.
            #
            #     Exactly one of `query` and `prepared_query` is required. Setting both
            #     or neither is an `INVALID_ARGUMENT`.
            #   @param prepared_query [::String]
            #     A prepared query that was returned from `PrepareQueryResponse`.
            #
            #     Exactly one of `query` and `prepared_query` is required. Setting both
            #     or neither is an `INVALID_ARGUMENT`.
            #
            #     Setting this field also places restrictions on several other fields:
            #     - `data_format` must be empty.
            #     - `validate_only` must be false.
            #     - `params` must match the `param_types` set in the `PrepareQueryRequest`.
            #   @param proto_format [::Google::Cloud::Bigtable::V2::ProtoFormat, ::Hash]
            #     Protocol buffer format as described by ProtoSchema and ProtoRows
            #     messages.
            #   @param resume_token [::String]
            #     Optional. If this request is resuming a previously interrupted query
            #     execution, `resume_token` should be copied from the last
            #     PartialResultSet yielded before the interruption. Doing this
            #     enables the query execution to resume where the last one left
            #     off.
            #     The rest of the request parameters must exactly match the
            #     request that yielded this token. Otherwise the request will fail.
            #   @param params [::Hash{::String => ::Google::Cloud::Bigtable::V2::Value, ::Hash}]
            #     Required. params contains string type keys and Bigtable type values that
            #     bind to placeholders in the query string. In query string, a parameter
            #     placeholder consists of the
            #     `@` character followed by the parameter name (for example, `@firstName`) in
            #     the query string.
            #
            #     For example, if
            #     `params["firstName"] = bytes_value: "foo" type {bytes_type {}}`
            #     then `@firstName` will be replaced with googlesql bytes value "foo" in the
            #     query string during query evaluation.
            #
            #     If `Value.kind` is not set, the value is treated as a NULL value of the
            #     given type. For example, if
            #     `params["firstName"] = type {string_type {}}`
            #     then `@firstName` will be replaced with googlesql null string.
            #
            #     If `query` is set, any empty `Value.type` in the map will be rejected with
            #     `INVALID_ARGUMENT`.
            #
            #     If `prepared_query` is set, any empty `Value.type` in the map will be
            #     inferred from the `param_types` in the `PrepareQueryRequest`. Any non-empty
            #     `Value.type` must match the corresponding `param_types` entry, or be
            #     rejected with `INVALID_ARGUMENT`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Enumerable<::Google::Cloud::Bigtable::V2::ExecuteQueryResponse>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Enumerable<::Google::Cloud::Bigtable::V2::ExecuteQueryResponse>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/bigtable/v2"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Bigtable::V2::Bigtable::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Bigtable::V2::ExecuteQueryRequest.new
            #
            #   # Call the execute_query method to start streaming.
            #   output = client.execute_query request
            #
            #   # The returned object is a streamed enumerable yielding elements of type
            #   # ::Google::Cloud::Bigtable::V2::ExecuteQueryResponse
            #   output.each do |current_response|
            #     p current_response
            #   end
            #
            def execute_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Bigtable::V2::ExecuteQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.execute_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Bigtable::V2::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.instance_name &&
                 %r{^projects/[^/]+/instances/[^/]+/?$}.match?(request.instance_name)
                header_params["name"] = request.instance_name
              end
              if request.app_profile_id && !request.app_profile_id.empty?
                header_params["app_profile_id"] = request.app_profile_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.execute_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.execute_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @bigtable_stub.call_rpc :execute_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Bigtable API.
            #
            # This class represents the configuration for Bigtable,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Bigtable::V2::Bigtable::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # read_rows to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Bigtable::V2::Bigtable::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.read_rows.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.read_rows.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Bigtable::V2::Bigtable::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "bigtable.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Bigtable API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `read_rows`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :read_rows
                ##
                # RPC-specific configuration for `sample_row_keys`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :sample_row_keys
                ##
                # RPC-specific configuration for `mutate_row`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :mutate_row
                ##
                # RPC-specific configuration for `mutate_rows`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :mutate_rows
                ##
                # RPC-specific configuration for `check_and_mutate_row`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :check_and_mutate_row
                ##
                # RPC-specific configuration for `ping_and_warm`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :ping_and_warm
                ##
                # RPC-specific configuration for `read_modify_write_row`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :read_modify_write_row
                ##
                # RPC-specific configuration for `generate_initial_change_stream_partitions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_initial_change_stream_partitions
                ##
                # RPC-specific configuration for `read_change_stream`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :read_change_stream
                ##
                # RPC-specific configuration for `prepare_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :prepare_query
                ##
                # RPC-specific configuration for `execute_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :execute_query

                # @private
                def initialize parent_rpcs = nil
                  read_rows_config = parent_rpcs.read_rows if parent_rpcs.respond_to? :read_rows
                  @read_rows = ::Gapic::Config::Method.new read_rows_config
                  sample_row_keys_config = parent_rpcs.sample_row_keys if parent_rpcs.respond_to? :sample_row_keys
                  @sample_row_keys = ::Gapic::Config::Method.new sample_row_keys_config
                  mutate_row_config = parent_rpcs.mutate_row if parent_rpcs.respond_to? :mutate_row
                  @mutate_row = ::Gapic::Config::Method.new mutate_row_config
                  mutate_rows_config = parent_rpcs.mutate_rows if parent_rpcs.respond_to? :mutate_rows
                  @mutate_rows = ::Gapic::Config::Method.new mutate_rows_config
                  check_and_mutate_row_config = parent_rpcs.check_and_mutate_row if parent_rpcs.respond_to? :check_and_mutate_row
                  @check_and_mutate_row = ::Gapic::Config::Method.new check_and_mutate_row_config
                  ping_and_warm_config = parent_rpcs.ping_and_warm if parent_rpcs.respond_to? :ping_and_warm
                  @ping_and_warm = ::Gapic::Config::Method.new ping_and_warm_config
                  read_modify_write_row_config = parent_rpcs.read_modify_write_row if parent_rpcs.respond_to? :read_modify_write_row
                  @read_modify_write_row = ::Gapic::Config::Method.new read_modify_write_row_config
                  generate_initial_change_stream_partitions_config = parent_rpcs.generate_initial_change_stream_partitions if parent_rpcs.respond_to? :generate_initial_change_stream_partitions
                  @generate_initial_change_stream_partitions = ::Gapic::Config::Method.new generate_initial_change_stream_partitions_config
                  read_change_stream_config = parent_rpcs.read_change_stream if parent_rpcs.respond_to? :read_change_stream
                  @read_change_stream = ::Gapic::Config::Method.new read_change_stream_config
                  prepare_query_config = parent_rpcs.prepare_query if parent_rpcs.respond_to? :prepare_query
                  @prepare_query = ::Gapic::Config::Method.new prepare_query_config
                  execute_query_config = parent_rpcs.execute_query if parent_rpcs.respond_to? :execute_query
                  @execute_query = ::Gapic::Config::Method.new execute_query_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
