# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/bigtable/v2/bigtable.proto for package 'Google.Cloud.Bigtable.V2'
# Original file comments:
# Copyright 2019 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/bigtable/v2/bigtable_pb'

module Google
  module Cloud
    module Bigtable
      module V2
        module Bigtable
          # Service for reading from and writing to existing Bigtable tables.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.bigtable.v2.Bigtable'

            # Streams back the contents of all requested rows in key order, optionally
            # applying the same Reader filter to each. Depending on their size,
            # rows and cells may be broken up across multiple responses, but
            # atomicity of each row will still be preserved. See the
            # ReadRowsResponse documentation for details.
            rpc :ReadRows, ::Google::Cloud::Bigtable::V2::ReadRowsRequest, stream(::Google::Cloud::Bigtable::V2::ReadRowsResponse)
            # Returns a sample of row keys in the table. The returned row keys will
            # delimit contiguous sections of the table of approximately equal size,
            # which can be used to break up the data for distributed tasks like
            # mapreduces.
            rpc :SampleRowKeys, ::Google::Cloud::Bigtable::V2::SampleRowKeysRequest, stream(::Google::Cloud::Bigtable::V2::SampleRowKeysResponse)
            # Mutates a row atomically. Cells already present in the row are left
            # unchanged unless explicitly changed by `mutation`.
            rpc :MutateRow, ::Google::Cloud::Bigtable::V2::MutateRowRequest, ::Google::Cloud::Bigtable::V2::MutateRowResponse
            # Mutates multiple rows in a batch. Each individual row is mutated
            # atomically as in MutateRow, but the entire batch is not executed
            # atomically.
            rpc :MutateRows, ::Google::Cloud::Bigtable::V2::MutateRowsRequest, stream(::Google::Cloud::Bigtable::V2::MutateRowsResponse)
            # Mutates a row atomically based on the output of a predicate Reader filter.
            rpc :CheckAndMutateRow, ::Google::Cloud::Bigtable::V2::CheckAndMutateRowRequest, ::Google::Cloud::Bigtable::V2::CheckAndMutateRowResponse
            # Warm up associated instance metadata for this connection.
            # This call is not required but may be useful for connection keep-alive.
            rpc :PingAndWarm, ::Google::Cloud::Bigtable::V2::PingAndWarmRequest, ::Google::Cloud::Bigtable::V2::PingAndWarmResponse
            # Modifies a row atomically on the server. The method reads the latest
            # existing timestamp and value from the specified columns and writes a new
            # entry based on pre-defined read/modify/write rules. The new value for the
            # timestamp is the greater of the existing timestamp or the current server
            # time. The method returns the new contents of all modified cells.
            rpc :ReadModifyWriteRow, ::Google::Cloud::Bigtable::V2::ReadModifyWriteRowRequest, ::Google::Cloud::Bigtable::V2::ReadModifyWriteRowResponse
            # Returns the current list of partitions that make up the table's
            # change stream. The union of partitions will cover the entire keyspace.
            # Partitions can be read with `ReadChangeStream`.
            # NOTE: This API is only intended to be used by Apache Beam BigtableIO.
            rpc :GenerateInitialChangeStreamPartitions, ::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsRequest, stream(::Google::Cloud::Bigtable::V2::GenerateInitialChangeStreamPartitionsResponse)
            # Reads changes from a table's change stream. Changes will
            # reflect both user-initiated mutations and mutations that are caused by
            # garbage collection.
            # NOTE: This API is only intended to be used by Apache Beam BigtableIO.
            rpc :ReadChangeStream, ::Google::Cloud::Bigtable::V2::ReadChangeStreamRequest, stream(::Google::Cloud::Bigtable::V2::ReadChangeStreamResponse)
            # Prepares a GoogleSQL query for execution on a particular Bigtable instance.
            rpc :PrepareQuery, ::Google::Cloud::Bigtable::V2::PrepareQueryRequest, ::Google::Cloud::Bigtable::V2::PrepareQueryResponse
            # Executes a SQL query against a particular Bigtable instance.
            rpc :ExecuteQuery, ::Google::Cloud::Bigtable::V2::ExecuteQueryRequest, stream(::Google::Cloud::Bigtable::V2::ExecuteQueryResponse)
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
