# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigtable
      module Admin
        module V2
          # Information about a table restore.
          # @!attribute [rw] source_type
          #   @return [::Google::Cloud::Bigtable::Admin::V2::RestoreSourceType]
          #     The type of the restore source.
          # @!attribute [rw] backup_info
          #   @return [::Google::Cloud::Bigtable::Admin::V2::BackupInfo]
          #     Information about the backup used to restore the table. The backup
          #     may no longer exist.
          class RestoreInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Change stream configuration.
          # @!attribute [rw] retention_period
          #   @return [::Google::Protobuf::Duration]
          #     How long the change stream should be retained. Change stream data older
          #     than the retention period will not be returned when reading the change
          #     stream from the table.
          #     Values must be at least 1 day and at most 7 days, and will be truncated to
          #     microsecond granularity.
          class ChangeStreamConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A collection of user data indexed by row, column, and timestamp.
          # Each table is served using the resources of its parent cluster.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name of the table. Values are of the form
          #     `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
          #     Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
          # @!attribute [r] cluster_states
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Bigtable::Admin::V2::Table::ClusterState}]
          #     Output only. Map from cluster ID to per-cluster table state.
          #     If it could not be determined whether or not the table has data in a
          #     particular cluster (for example, if its zone is unavailable), then
          #     there will be an entry for the cluster with UNKNOWN `replication_status`.
          #     Views: `REPLICATION_VIEW`, `ENCRYPTION_VIEW`, `FULL`
          # @!attribute [rw] column_families
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Bigtable::Admin::V2::ColumnFamily}]
          #     The column families configured for this table, mapped by column family ID.
          #     Views: `SCHEMA_VIEW`, `STATS_VIEW`, `FULL`
          # @!attribute [rw] granularity
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Table::TimestampGranularity]
          #     Immutable. The granularity (i.e. `MILLIS`) at which timestamps are stored
          #     in this table. Timestamps not matching the granularity will be rejected. If
          #     unspecified at creation time, the value will be set to `MILLIS`. Views:
          #     `SCHEMA_VIEW`, `FULL`.
          # @!attribute [r] restore_info
          #   @return [::Google::Cloud::Bigtable::Admin::V2::RestoreInfo]
          #     Output only. If this table was restored from another data source (e.g. a
          #     backup), this field will be populated with information about the restore.
          # @!attribute [rw] change_stream_config
          #   @return [::Google::Cloud::Bigtable::Admin::V2::ChangeStreamConfig]
          #     If specified, enable the change stream on this table.
          #     Otherwise, the change stream is disabled and the change stream is not
          #     retained.
          # @!attribute [rw] deletion_protection
          #   @return [::Boolean]
          #     Set to true to make the table protected against data loss. i.e. deleting
          #     the following resources through Admin APIs are prohibited:
          #
          #     * The table.
          #     * The column families in the table.
          #     * The instance containing the table.
          #
          #     Note one can still delete the data stored in the table through Data APIs.
          # @!attribute [rw] automated_backup_policy
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Table::AutomatedBackupPolicy]
          #     If specified, automated backups are enabled for this table.
          #     Otherwise, automated backups are disabled.
          # @!attribute [rw] row_key_schema
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Type::Struct]
          #     The row key schema for this table. The schema is used to decode the raw row
          #     key bytes into a structured format. The order of field declarations in this
          #     schema is important, as it reflects how the raw row key bytes are
          #     structured. Currently, this only affects how the key is read via a
          #     GoogleSQL query from the ExecuteQuery API.
          #
          #     For a SQL query, the _key column is still read as raw bytes. But queries
          #     can reference the key fields by name, which will be decoded from _key using
          #     provided type and encoding. Queries that reference key fields will fail if
          #     they encounter an invalid row key.
          #
          #     For example, if _key = "some_id#2024-04-30#\x00\x13\x00\xf3" with the
          #     following schema:
          #     {
          #       fields {
          #         field_name: "id"
          #         type { string { encoding: utf8_bytes \\{} } }
          #       }
          #       fields {
          #         field_name: "date"
          #         type { string { encoding: utf8_bytes \\{} } }
          #       }
          #       fields {
          #         field_name: "product_code"
          #         type { int64 { encoding: big_endian_bytes \\{} } }
          #       }
          #       encoding { delimited_bytes { delimiter: "#" } }
          #     }
          #
          #     The decoded key parts would be:
          #       id = "some_id", date = "2024-04-30", product_code = 1245427
          #     The query "SELECT _key, product_code FROM table" will return two columns:
          #     /------------------------------------------------------\
          #     |              _key                     | product_code |
          #     | --------------------------------------|--------------|
          #     | "some_id#2024-04-30#\x00\x13\x00\xf3" |   1245427    |
          #     \------------------------------------------------------/
          #
          #     The schema has the following invariants:
          #     (1) The decoded field values are order-preserved. For read, the field
          #     values will be decoded in sorted mode from the raw bytes.
          #     (2) Every field in the schema must specify a non-empty name.
          #     (3) Every field must specify a type with an associated encoding. The type
          #     is limited to scalar types only: Array, Map, Aggregate, and Struct are not
          #     allowed.
          #     (4) The field names must not collide with existing column family
          #     names and reserved keywords "_key" and "_timestamp".
          #
          #     The following update operations are allowed for row_key_schema:
          #     - Update from an empty schema to a new schema.
          #     - Remove the existing schema. This operation requires setting the
          #       `ignore_warnings` flag to `true`, since it might be a backward
          #       incompatible change. Without the flag, the update request will fail with
          #       an INVALID_ARGUMENT error.
          #     Any other row key schema update operation (e.g. update existing schema
          #     columns names or types) is currently unsupported.
          class Table
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of a table's data in a particular cluster.
            # @!attribute [r] replication_state
            #   @return [::Google::Cloud::Bigtable::Admin::V2::Table::ClusterState::ReplicationState]
            #     Output only. The state of replication for the table in this cluster.
            # @!attribute [r] encryption_info
            #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::EncryptionInfo>]
            #     Output only. The encryption information for the table in this cluster.
            #     If the encryption key protecting this resource is customer managed, then
            #     its version can be rotated in Cloud Key Management Service (Cloud KMS).
            #     The primary version of the key and its status will be reflected here when
            #     changes propagate from Cloud KMS.
            class ClusterState
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Table replication states.
              module ReplicationState
                # The replication state of the table is unknown in this cluster.
                STATE_NOT_KNOWN = 0

                # The cluster was recently created, and the table must finish copying
                # over pre-existing data from other clusters before it can begin
                # receiving live replication updates and serving Data API requests.
                INITIALIZING = 1

                # The table is temporarily unable to serve Data API requests from this
                # cluster due to planned internal maintenance.
                PLANNED_MAINTENANCE = 2

                # The table is temporarily unable to serve Data API requests from this
                # cluster due to unplanned or emergency maintenance.
                UNPLANNED_MAINTENANCE = 3

                # The table can serve Data API requests from this cluster. Depending on
                # replication delay, reads may not immediately reflect the state of the
                # table in other clusters.
                READY = 4

                # The table is fully created and ready for use after a restore, and is
                # being optimized for performance. When optimizations are complete, the
                # table will transition to `READY` state.
                READY_OPTIMIZING = 5
              end
            end

            # Defines an automated backup policy for a table
            # @!attribute [rw] retention_period
            #   @return [::Google::Protobuf::Duration]
            #     Required. How long the automated backups should be retained. The only
            #     supported value at this time is 3 days.
            # @!attribute [rw] frequency
            #   @return [::Google::Protobuf::Duration]
            #     Required. How frequently automated backups should occur. The only
            #     supported value at this time is 24 hours.
            class AutomatedBackupPolicy
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Bigtable::Admin::V2::Table::ClusterState]
            class ClusterStatesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Bigtable::Admin::V2::ColumnFamily]
            class ColumnFamiliesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Possible timestamp granularities to use when keeping multiple versions
            # of data in a table.
            module TimestampGranularity
              # The user did not specify a granularity. Should not be returned.
              # When specified during table creation, MILLIS will be used.
              TIMESTAMP_GRANULARITY_UNSPECIFIED = 0

              # The table keeps data versioned at a granularity of 1ms.
              MILLIS = 1
            end

            # Defines a view over a table's fields.
            module View
              # Uses the default view for each method as documented in its request.
              VIEW_UNSPECIFIED = 0

              # Only populates `name`.
              NAME_ONLY = 1

              # Only populates `name` and fields related to the table's schema.
              SCHEMA_VIEW = 2

              # Only populates `name` and fields related to the table's replication
              # state.
              REPLICATION_VIEW = 3

              # Only populates `name` and fields related to the table's encryption state.
              ENCRYPTION_VIEW = 5

              # Populates all fields.
              FULL = 4
            end
          end

          # AuthorizedViews represent subsets of a particular Cloud Bigtable table. Users
          # can configure access to each Authorized View independently from the table and
          # use the existing Data APIs to access the subset of data.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of this AuthorizedView.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
          # @!attribute [rw] subset_view
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView::SubsetView]
          #     An AuthorizedView permitting access to an explicit subset of a Table.
          # @!attribute [rw] etag
          #   @return [::String]
          #     The etag for this AuthorizedView.
          #     If this is provided on update, it must match the server's etag. The server
          #     returns ABORTED error on a mismatched etag.
          # @!attribute [rw] deletion_protection
          #   @return [::Boolean]
          #     Set to true to make the AuthorizedView protected against deletion.
          #     The parent Table and containing Instance cannot be deleted if an
          #     AuthorizedView has this bit set.
          class AuthorizedView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Subsets of a column family that are included in this AuthorizedView.
            # @!attribute [rw] qualifiers
            #   @return [::Array<::String>]
            #     Individual exact column qualifiers to be included in the AuthorizedView.
            # @!attribute [rw] qualifier_prefixes
            #   @return [::Array<::String>]
            #     Prefixes for qualifiers to be included in the AuthorizedView. Every
            #     qualifier starting with one of these prefixes is included in the
            #     AuthorizedView. To provide access to all qualifiers, include the empty
            #     string as a prefix
            #     ("").
            class FamilySubsets
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Defines a simple AuthorizedView that is a subset of the underlying Table.
            # @!attribute [rw] row_prefixes
            #   @return [::Array<::String>]
            #     Row prefixes to be included in the AuthorizedView.
            #     To provide access to all rows, include the empty string as a prefix ("").
            # @!attribute [rw] family_subsets
            #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Bigtable::Admin::V2::AuthorizedView::FamilySubsets}]
            #     Map from column family name to the columns in this family to be included
            #     in the AuthorizedView.
            class SubsetView
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # @!attribute [rw] key
              #   @return [::String]
              # @!attribute [rw] value
              #   @return [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView::FamilySubsets]
              class FamilySubsetsEntry
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Defines a subset of an AuthorizedView's fields.
            module ResponseView
              # Uses the default view for each method as documented in the request.
              RESPONSE_VIEW_UNSPECIFIED = 0

              # Only populates `name`.
              NAME_ONLY = 1

              # Only populates the AuthorizedView's basic metadata. This includes:
              # name, deletion_protection, etag.
              BASIC = 2

              # Populates every fields.
              FULL = 3
            end
          end

          # A set of columns within a table which share a common configuration.
          # @!attribute [rw] gc_rule
          #   @return [::Google::Cloud::Bigtable::Admin::V2::GcRule]
          #     Garbage collection rule specified as a protobuf.
          #     Must serialize to at most 500 bytes.
          #
          #     NOTE: Garbage collection executes opportunistically in the background, and
          #     so it's possible for reads to return a cell even if it matches the active
          #     GC expression for its family.
          # @!attribute [rw] value_type
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Type]
          #     The type of data stored in each of this family's cell values, including its
          #     full encoding. If omitted, the family only serves raw untyped bytes.
          #
          #     For now, only the `Aggregate` type is supported.
          #
          #     `Aggregate` can only be set at family creation and is immutable afterwards.
          #
          #
          #     If `value_type` is `Aggregate`, written data must be compatible with:
          #      * `value_type.input_type` for `AddInput` mutations
          class ColumnFamily
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Rule for determining which cells to delete during garbage collection.
          # @!attribute [rw] max_num_versions
          #   @return [::Integer]
          #     Delete all cells in a column except the most recent N.
          #
          #     Note: The following fields are mutually exclusive: `max_num_versions`, `max_age`, `intersection`, `union`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] max_age
          #   @return [::Google::Protobuf::Duration]
          #     Delete cells in a column older than the given age.
          #     Values must be at least one millisecond, and will be truncated to
          #     microsecond granularity.
          #
          #     Note: The following fields are mutually exclusive: `max_age`, `max_num_versions`, `intersection`, `union`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] intersection
          #   @return [::Google::Cloud::Bigtable::Admin::V2::GcRule::Intersection]
          #     Delete cells that would be deleted by every nested rule.
          #
          #     Note: The following fields are mutually exclusive: `intersection`, `max_num_versions`, `max_age`, `union`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] union
          #   @return [::Google::Cloud::Bigtable::Admin::V2::GcRule::Union]
          #     Delete cells that would be deleted by any nested rule.
          #
          #     Note: The following fields are mutually exclusive: `union`, `max_num_versions`, `max_age`, `intersection`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class GcRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A GcRule which deletes cells matching all of the given rules.
            # @!attribute [rw] rules
            #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::GcRule>]
            #     Only delete cells which would be deleted by every element of `rules`.
            class Intersection
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A GcRule which deletes cells matching any of the given rules.
            # @!attribute [rw] rules
            #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::GcRule>]
            #     Delete cells which would be deleted by any element of `rules`.
            class Union
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Encryption information for a given resource.
          # If this resource is protected with customer managed encryption, the in-use
          # Cloud Key Management Service (Cloud KMS) key version is specified along with
          # its status.
          # @!attribute [r] encryption_type
          #   @return [::Google::Cloud::Bigtable::Admin::V2::EncryptionInfo::EncryptionType]
          #     Output only. The type of encryption used to protect this resource.
          # @!attribute [r] encryption_status
          #   @return [::Google::Rpc::Status]
          #     Output only. The status of encrypt/decrypt calls on underlying data for
          #     this resource. Regardless of status, the existing data is always encrypted
          #     at rest.
          # @!attribute [r] kms_key_version
          #   @return [::String]
          #     Output only. The version of the Cloud KMS key specified in the parent
          #     cluster that is in use for the data underlying this table.
          class EncryptionInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible encryption types for a resource.
            module EncryptionType
              # Encryption type was not specified, though data at rest remains encrypted.
              ENCRYPTION_TYPE_UNSPECIFIED = 0

              # The data backing this resource is encrypted at rest with a key that is
              # fully managed by Google. No key version or status will be populated.
              # This is the default state.
              GOOGLE_DEFAULT_ENCRYPTION = 1

              # The data backing this resource is encrypted at rest with a key that is
              # managed by the customer.
              # The in-use version of the key and its status are populated for
              # CMEK-protected tables.
              # CMEK-protected backups are pinned to the key version that was in use at
              # the time the backup was taken. This key version is populated but its
              # status is not tracked and is reported as `UNKNOWN`.
              CUSTOMER_MANAGED_ENCRYPTION = 2
            end
          end

          # A snapshot of a table at a particular time. A snapshot can be used as a
          # checkpoint for data restoration or a data source for a new table.
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name of the snapshot.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
          # @!attribute [r] source_table
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Table]
          #     Output only. The source table at the time the snapshot was taken.
          # @!attribute [r] data_size_bytes
          #   @return [::Integer]
          #     Output only. The size of the data in the source table at the time the
          #     snapshot was taken. In some cases, this value may be computed
          #     asynchronously via a background process and a placeholder of 0 will be used
          #     in the meantime.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the snapshot is created.
          # @!attribute [rw] delete_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time when the snapshot will be deleted. The maximum amount of time a
          #     snapshot can stay active is 365 days. If 'ttl' is not specified,
          #     the default maximum of 365 days will be used.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Snapshot::State]
          #     Output only. The current state of the snapshot.
          # @!attribute [rw] description
          #   @return [::String]
          #     Description of the snapshot.
          class Snapshot
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Possible states of a snapshot.
            module State
              # The state of the snapshot could not be determined.
              STATE_NOT_KNOWN = 0

              # The snapshot has been successfully created and can serve all requests.
              READY = 1

              # The snapshot is currently being created, and may be destroyed if the
              # creation process encounters an error. A snapshot may not be restored to a
              # table while it is being created.
              CREATING = 2
            end
          end

          # A backup of a Cloud Bigtable table.
          # @!attribute [rw] name
          #   @return [::String]
          #     A globally unique identifier for the backup which cannot be
          #     changed. Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/
          #        backups/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
          #     The final segment of the name must be between 1 and 50 characters
          #     in length.
          #
          #     The backup is stored in the cluster identified by the prefix of the backup
          #     name of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
          # @!attribute [rw] source_table
          #   @return [::String]
          #     Required. Immutable. Name of the table from which this backup was created.
          #     This needs to be in the same instance as the backup. Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{source_table}`.
          # @!attribute [r] source_backup
          #   @return [::String]
          #     Output only. Name of the backup from which this backup was copied. If a
          #     backup is not created by copying a backup, this field will be empty. Values
          #     are of the form:
          #     projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>
          # @!attribute [rw] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. The expiration time of the backup.
          #     When creating a backup or updating its `expire_time`, the value must be
          #     greater than the backup creation time by:
          #     - At least 6 hours
          #     - At most 90 days
          #
          #     Once the `expire_time` has passed, Cloud Bigtable will delete the backup.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. `start_time` is the time that the backup was started
          #     (i.e. approximately the time the
          #     {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_backup CreateBackup}
          #     request is received).  The row data in this backup will be no older than
          #     this timestamp.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. `end_time` is the time that the backup was finished. The row
          #     data in the backup will be no newer than this timestamp.
          # @!attribute [r] size_bytes
          #   @return [::Integer]
          #     Output only. Size of the backup in bytes.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Backup::State]
          #     Output only. The current state of the backup.
          # @!attribute [r] encryption_info
          #   @return [::Google::Cloud::Bigtable::Admin::V2::EncryptionInfo]
          #     Output only. The encryption information for the backup.
          # @!attribute [rw] backup_type
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Backup::BackupType]
          #     Indicates the backup type of the backup.
          # @!attribute [rw] hot_to_standard_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the hot backup will be converted to a standard backup.
          #     Once the `hot_to_standard_time` has passed, Cloud Bigtable will convert the
          #     hot backup to a standard backup. This value must be greater than the backup
          #     creation time by:
          #     - At least 24 hours
          #
          #     This field only applies for hot backups. When creating or updating a
          #     standard backup, attempting to set this field will fail the request.
          class Backup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Indicates the current state of the backup.
            module State
              # Not specified.
              STATE_UNSPECIFIED = 0

              # The pending backup is still being created. Operations on the
              # backup may fail with `FAILED_PRECONDITION` in this state.
              CREATING = 1

              # The backup is complete and ready for use.
              READY = 2
            end

            # The type of the backup.
            module BackupType
              # Not specified.
              BACKUP_TYPE_UNSPECIFIED = 0

              # The default type for Cloud Bigtable managed backups. Supported for
              # backups created in both HDD and SSD instances. Requires optimization when
              # restored to a table in an SSD instance.
              STANDARD = 1

              # A backup type with faster restore to SSD performance. Only supported for
              # backups created in SSD instances. A new SSD table restored from a hot
              # backup reaches production performance more quickly than a standard
              # backup.
              HOT = 2
            end
          end

          # Information about a backup.
          # @!attribute [r] backup
          #   @return [::String]
          #     Output only. Name of the backup.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time that the backup was started. Row data in the backup
          #     will be no older than this timestamp.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. This time that the backup was finished. Row data in the
          #     backup will be no newer than this timestamp.
          # @!attribute [r] source_table
          #   @return [::String]
          #     Output only. Name of the table the backup was created from.
          # @!attribute [r] source_backup
          #   @return [::String]
          #     Output only. Name of the backup from which this backup was copied. If a
          #     backup is not created by copying a backup, this field will be empty. Values
          #     are of the form:
          #     projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>
          class BackupInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a protobuf schema.
          # @!attribute [rw] proto_descriptors
          #   @return [::String]
          #     Required. Contains a protobuf-serialized
          #     [google.protobuf.FileDescriptorSet](https://github.com/protocolbuffers/protobuf/blob/main/src/google/protobuf/descriptor.proto),
          #     which could include multiple proto files.
          #     To generate it, [install](https://grpc.io/docs/protoc-installation/) and
          #     run `protoc` with
          #     `--include_imports` and `--descriptor_set_out`. For example, to generate
          #     for moon/shot/app.proto, run
          #     ```
          #     $protoc  --proto_path=/app_path --proto_path=/lib_path \
          #              --include_imports \
          #              --descriptor_set_out=descriptors.pb \
          #              moon/shot/app.proto
          #     ```
          #     For more details, see protobuffer [self
          #     description](https://developers.google.com/protocol-buffers/docs/techniques#self-description).
          class ProtoSchema
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A named collection of related schemas.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The unique name identifying this schema bundle.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
          # @!attribute [rw] proto_schema
          #   @return [::Google::Cloud::Bigtable::Admin::V2::ProtoSchema]
          #     Schema for Protobufs.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Optional. The etag for this schema bundle.
          #     This may be sent on update and delete requests to ensure the
          #     client has an up-to-date value before proceeding. The server
          #     returns an ABORTED error on a mismatched etag.
          class SchemaBundle
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Indicates the type of the restore source.
          module RestoreSourceType
            # No restore associated.
            RESTORE_SOURCE_TYPE_UNSPECIFIED = 0

            # A backup was used as the source of the restore.
            BACKUP = 1
          end
        end
      end
    end
  end
end
