# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigtable
      module Admin
        module V2
          # A collection of Bigtable {::Google::Cloud::Bigtable::Admin::V2::Table Tables} and
          # the resources that serve them.
          # All tables in an instance are served from all
          # {::Google::Cloud::Bigtable::Admin::V2::Cluster Clusters} in the instance.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name of the instance. Values are of the form
          #     `projects/{project}/instances/[a-z][a-z0-9\\-]+[a-z0-9]`.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Required. The descriptive name for this instance as it appears in UIs.
          #     Can be changed at any time, but should be kept globally unique
          #     to avoid confusion.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Instance::State]
          #     Output only. The current state of the instance.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Instance::Type]
          #     The type of the instance. Defaults to `PRODUCTION`.
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Labels are a flexible and lightweight mechanism for organizing cloud
          #     resources into groups that reflect a customer's organizational needs and
          #     deployment strategies. They can be used to filter resources and aggregate
          #     metrics.
          #
          #     * Label keys must be between 1 and 63 characters long and must conform to
          #       the regular expression: `[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}`.
          #     * Label values must be between 0 and 63 characters long and must conform to
          #       the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`.
          #     * No more than 64 labels can be associated with a given resource.
          #     * Keys and values must both be under 128 bytes.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. A commit timestamp representing when this Instance was
          #     created. For instances created before this field was added (August 2021),
          #     this value is `seconds: 0, nanos: 1`.
          # @!attribute [r] satisfies_pzs
          #   @return [::Boolean]
          #     Output only. Reserved for future use.
          # @!attribute [r] satisfies_pzi
          #   @return [::Boolean]
          #     Output only. Reserved for future use.
          # @!attribute [rw] tags
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Input only. Immutable. Tag keys/values directly bound to this
          #     resource. For example:
          #     - "123/environment": "production",
          #     - "123/costCenter": "marketing"
          #
          #     Tags and Labels (above) are both used to bind metadata to resources, with
          #     different use-cases. See
          #     https://cloud.google.com/resource-manager/docs/tags/tags-overview for an
          #     in-depth overview on the difference between tags and labels.
          class Instance
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class TagsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Possible states of an instance.
            module State
              # The state of the instance could not be determined.
              STATE_NOT_KNOWN = 0

              # The instance has been successfully created and can serve requests
              # to its tables.
              READY = 1

              # The instance is currently being created, and may be destroyed
              # if the creation process encounters an error.
              CREATING = 2
            end

            # The type of the instance.
            module Type
              # The type of the instance is unspecified. If set when creating an
              # instance, a `PRODUCTION` instance will be created. If set when updating
              # an instance, the type will be left unchanged.
              TYPE_UNSPECIFIED = 0

              # An instance meant for production use. `serve_nodes` must be set
              # on the cluster.
              PRODUCTION = 1

              # DEPRECATED: Prefer PRODUCTION for all use cases, as it no longer enforces
              # a higher minimum node count than DEVELOPMENT.
              DEVELOPMENT = 2
            end
          end

          # The Autoscaling targets for a Cluster. These determine the recommended nodes.
          # @!attribute [rw] cpu_utilization_percent
          #   @return [::Integer]
          #     The cpu utilization that the Autoscaler should be trying to achieve.
          #     This number is on a scale from 0 (no utilization) to
          #     100 (total utilization), and is limited between 10 and 80, otherwise it
          #     will return INVALID_ARGUMENT error.
          # @!attribute [rw] storage_utilization_gib_per_node
          #   @return [::Integer]
          #     The storage utilization that the Autoscaler should be trying to achieve.
          #     This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD
          #     cluster and between 8192 (8TiB) and 16384 (16TiB) for an HDD cluster,
          #     otherwise it will return INVALID_ARGUMENT error. If this value is set to 0,
          #     it will be treated as if it were set to the default value: 2560 for SSD,
          #     8192 for HDD.
          class AutoscalingTargets
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Limits for the number of nodes a Cluster can autoscale up/down to.
          # @!attribute [rw] min_serve_nodes
          #   @return [::Integer]
          #     Required. Minimum number of nodes to scale down to.
          # @!attribute [rw] max_serve_nodes
          #   @return [::Integer]
          #     Required. Maximum number of nodes to scale up to.
          class AutoscalingLimits
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A resizable group of nodes in a particular cloud location, capable
          # of serving all {::Google::Cloud::Bigtable::Admin::V2::Table Tables} in the parent
          # {::Google::Cloud::Bigtable::Admin::V2::Instance Instance}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name of the cluster. Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/[a-z][-a-z0-9]*`.
          # @!attribute [rw] location
          #   @return [::String]
          #     Immutable. The location where this cluster's nodes and storage reside. For
          #     best performance, clients should be located as close as possible to this
          #     cluster. Currently only zones are supported, so values should be of the
          #     form `projects/{project}/locations/{zone}`.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Cluster::State]
          #     Output only. The current state of the cluster.
          # @!attribute [rw] serve_nodes
          #   @return [::Integer]
          #     The number of nodes in the cluster. If no value is set,
          #     Cloud Bigtable automatically allocates nodes based on your data footprint
          #     and optimized for 50% storage utilization.
          # @!attribute [rw] node_scaling_factor
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Cluster::NodeScalingFactor]
          #     Immutable. The node scaling factor of this cluster.
          # @!attribute [rw] cluster_config
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Cluster::ClusterConfig]
          #     Configuration for this cluster.
          # @!attribute [rw] default_storage_type
          #   @return [::Google::Cloud::Bigtable::Admin::V2::StorageType]
          #     Immutable. The type of storage used by this cluster to serve its
          #     parent instance's tables, unless explicitly overridden.
          # @!attribute [rw] encryption_config
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Cluster::EncryptionConfig]
          #     Immutable. The encryption configuration for CMEK-protected clusters.
          class Cluster
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Autoscaling config for a cluster.
            # @!attribute [rw] autoscaling_limits
            #   @return [::Google::Cloud::Bigtable::Admin::V2::AutoscalingLimits]
            #     Required. Autoscaling limits for this cluster.
            # @!attribute [rw] autoscaling_targets
            #   @return [::Google::Cloud::Bigtable::Admin::V2::AutoscalingTargets]
            #     Required. Autoscaling targets for this cluster.
            class ClusterAutoscalingConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration for a cluster.
            # @!attribute [rw] cluster_autoscaling_config
            #   @return [::Google::Cloud::Bigtable::Admin::V2::Cluster::ClusterAutoscalingConfig]
            #     Autoscaling configuration for this cluster.
            class ClusterConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Cloud Key Management Service (Cloud KMS) settings for a CMEK-protected
            # cluster.
            # @!attribute [rw] kms_key_name
            #   @return [::String]
            #     Describes the Cloud KMS encryption key that will be used to protect the
            #     destination Bigtable cluster. The requirements for this key are:
            #      1) The Cloud Bigtable service account associated with the project that
            #      contains this cluster must be granted the
            #      `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key.
            #      2) Only regional keys can be used and the region of the CMEK key must
            #      match the region of the cluster.
            #     Values are of the form
            #     `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
            class EncryptionConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Possible states of a cluster.
            module State
              # The state of the cluster could not be determined.
              STATE_NOT_KNOWN = 0

              # The cluster has been successfully created and is ready to serve requests.
              READY = 1

              # The cluster is currently being created, and may be destroyed
              # if the creation process encounters an error.
              # A cluster may not be able to serve requests while being created.
              CREATING = 2

              # The cluster is currently being resized, and may revert to its previous
              # node count if the process encounters an error.
              # A cluster is still capable of serving requests while being resized,
              # but may exhibit performance as if its number of allocated nodes is
              # between the starting and requested states.
              RESIZING = 3

              # The cluster has no backing nodes. The data (tables) still
              # exist, but no operations can be performed on the cluster.
              DISABLED = 4
            end

            # Possible node scaling factors of the clusters. Node scaling delivers better
            # latency and more throughput by removing node boundaries.
            module NodeScalingFactor
              # No node scaling specified. Defaults to NODE_SCALING_FACTOR_1X.
              NODE_SCALING_FACTOR_UNSPECIFIED = 0

              # The cluster is running with a scaling factor of 1.
              NODE_SCALING_FACTOR_1X = 1

              # The cluster is running with a scaling factor of 2.
              # All node count values must be in increments of 2 with this scaling factor
              # enabled, otherwise an INVALID_ARGUMENT error will be returned.
              NODE_SCALING_FACTOR_2X = 2
            end
          end

          # A configuration object describing how Cloud Bigtable should treat traffic
          # from a particular end user application.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name of the app profile. Values are of the form
          #     `projects/{project}/instances/{instance}/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Strongly validated etag for optimistic concurrency control. Preserve the
          #     value returned from `GetAppProfile` when calling `UpdateAppProfile` to
          #     fail the request if there has been a modification in the mean time. The
          #     `update_mask` of the request need not include `etag` for this protection
          #     to apply.
          #     See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
          #     [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
          #     details.
          # @!attribute [rw] description
          #   @return [::String]
          #     Long form description of the use case for this AppProfile.
          # @!attribute [rw] multi_cluster_routing_use_any
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::MultiClusterRoutingUseAny]
          #     Use a multi-cluster routing policy.
          #
          #     Note: The following fields are mutually exclusive: `multi_cluster_routing_use_any`, `single_cluster_routing`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] single_cluster_routing
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::SingleClusterRouting]
          #     Use a single-cluster routing policy.
          #
          #     Note: The following fields are mutually exclusive: `single_cluster_routing`, `multi_cluster_routing_use_any`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] priority
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::Priority]
          #     This field has been deprecated in favor of `standard_isolation.priority`.
          #     If you set this field, `standard_isolation.priority` will be set instead.
          #
          #     The priority of requests sent using this app profile.
          #
          #     Note: The following fields are mutually exclusive: `priority`, `standard_isolation`, `data_boost_isolation_read_only`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] standard_isolation
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::StandardIsolation]
          #     The standard options used for isolating this app profile's traffic from
          #     other use cases.
          #
          #     Note: The following fields are mutually exclusive: `standard_isolation`, `priority`, `data_boost_isolation_read_only`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] data_boost_isolation_read_only
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::DataBoostIsolationReadOnly]
          #     Specifies that this app profile is intended for read-only usage via the
          #     Data Boost feature.
          #
          #     Note: The following fields are mutually exclusive: `data_boost_isolation_read_only`, `priority`, `standard_isolation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class AppProfile
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Read/write requests are routed to the nearest cluster in the instance, and
            # will fail over to the nearest cluster that is available in the event of
            # transient errors or delays. Clusters in a region are considered
            # equidistant. Choosing this option sacrifices read-your-writes consistency
            # to improve availability.
            # @!attribute [rw] cluster_ids
            #   @return [::Array<::String>]
            #     The set of clusters to route to. The order is ignored; clusters will be
            #     tried in order of distance. If left empty, all clusters are eligible.
            # @!attribute [rw] row_affinity
            #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::MultiClusterRoutingUseAny::RowAffinity]
            #     Row affinity sticky routing based on the row key of the request.
            #     Requests that span multiple rows are routed non-deterministically.
            class MultiClusterRoutingUseAny
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # If enabled, Bigtable will route the request based on the row key of the
              # request, rather than randomly. Instead, each row key will be assigned
              # to a cluster, and will stick to that cluster. If clusters are added or
              # removed, then this may affect which row keys stick to which clusters.
              # To avoid this, users can use a cluster group to specify which clusters
              # are to be used. In this case, new clusters that are not a part of the
              # cluster group will not be routed to, and routing will be unaffected by
              # the new cluster. Moreover, clusters specified in the cluster group cannot
              # be deleted unless removed from the cluster group.
              class RowAffinity
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Unconditionally routes all read/write requests to a specific cluster.
            # This option preserves read-your-writes consistency but does not improve
            # availability.
            # @!attribute [rw] cluster_id
            #   @return [::String]
            #     The cluster to which read/write requests should be routed.
            # @!attribute [rw] allow_transactional_writes
            #   @return [::Boolean]
            #     Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
            #     allowed by this app profile. It is unsafe to send these requests to
            #     the same table/row/column in multiple clusters.
            class SingleClusterRouting
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Standard options for isolating this app profile's traffic from other use
            # cases.
            # @!attribute [rw] priority
            #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::Priority]
            #     The priority of requests sent using this app profile.
            class StandardIsolation
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Data Boost is a serverless compute capability that lets you run
            # high-throughput read jobs and queries on your Bigtable data, without
            # impacting the performance of the clusters that handle your application
            # traffic. Data Boost supports read-only use cases with single-cluster
            # routing.
            # @!attribute [rw] compute_billing_owner
            #   @return [::Google::Cloud::Bigtable::Admin::V2::AppProfile::DataBoostIsolationReadOnly::ComputeBillingOwner]
            #     The Compute Billing Owner for this Data Boost App Profile.
            class DataBoostIsolationReadOnly
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Compute Billing Owner specifies how usage should be accounted when using
              # Data Boost. Compute Billing Owner also configures which Cloud Project is
              # charged for relevant quota.
              module ComputeBillingOwner
                # Unspecified value.
                COMPUTE_BILLING_OWNER_UNSPECIFIED = 0

                # The host Cloud Project containing the targeted Bigtable Instance /
                # Table pays for compute.
                HOST_PAYS = 1
              end
            end

            # Possible priorities for an app profile. Note that higher priority writes
            # can sometimes queue behind lower priority writes to the same tablet, as
            # writes must be strictly sequenced in the durability log.
            module Priority
              # Default value. Mapped to PRIORITY_HIGH (the legacy behavior) on creation.
              PRIORITY_UNSPECIFIED = 0

              PRIORITY_LOW = 1

              PRIORITY_MEDIUM = 2

              PRIORITY_HIGH = 3
            end
          end

          # A tablet is a defined by a start and end key and is explained in
          # https://cloud.google.com/bigtable/docs/overview#architecture and
          # https://cloud.google.com/bigtable/docs/performance#optimization.
          # A Hot tablet is a tablet that exhibits high average cpu usage during the time
          # interval from start time to end time.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name of the hot tablet. Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/hotTablets/[a-zA-Z0-9_-]*`.
          # @!attribute [rw] table_name
          #   @return [::String]
          #     Name of the table that contains the tablet. Values are of the form
          #     `projects/{project}/instances/{instance}/tables/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The start time of the hot tablet.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The end time of the hot tablet.
          # @!attribute [rw] start_key
          #   @return [::String]
          #     Tablet Start Key (inclusive).
          # @!attribute [rw] end_key
          #   @return [::String]
          #     Tablet End Key (inclusive).
          # @!attribute [r] node_cpu_usage_percent
          #   @return [::Float]
          #     Output only. The average CPU usage spent by a node on this tablet over the
          #     start_time to end_time time range. The percentage is the amount of CPU used
          #     by the node to serve the tablet, from 0% (tablet was not interacted with)
          #     to 100% (the node spent all cycles serving the hot tablet).
          class HotTablet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A SQL logical view object that can be referenced in SQL queries.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The unique name of the logical view.
          #     Format:
          #     `projects/{project}/instances/{instance}/logicalViews/{logical_view}`
          # @!attribute [rw] query
          #   @return [::String]
          #     Required. The logical view's select query.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Optional. The etag for this logical view.
          #     This may be sent on update requests to ensure that the client has an
          #     up-to-date value before proceeding. The server returns an ABORTED error on
          #     a mismatched etag.
          # @!attribute [rw] deletion_protection
          #   @return [::Boolean]
          #     Optional. Set to true to make the LogicalView protected against deletion.
          class LogicalView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A materialized view object that can be referenced in SQL queries.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The unique name of the materialized view.
          #     Format:
          #     `projects/{project}/instances/{instance}/materializedViews/{materialized_view}`
          # @!attribute [rw] query
          #   @return [::String]
          #     Required. Immutable. The materialized view's select query.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Optional. The etag for this materialized view.
          #     This may be sent on update requests to ensure that the client has an
          #     up-to-date value before proceeding. The server returns an ABORTED error on
          #     a mismatched etag.
          # @!attribute [rw] deletion_protection
          #   @return [::Boolean]
          #     Set to true to make the MaterializedView protected against deletion.
          class MaterializedView
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
