# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Bigtable
      module Admin
        module V2
          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#restore_table RestoreTable}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the instance in which to create the restored
          #     table. Values are of the form `projects/<project>/instances/<instance>`.
          # @!attribute [rw] table_id
          #   @return [::String]
          #     Required. The id of the table to create and restore to. This
          #     table must not already exist. The `table_id` appended to
          #     `parent` forms the full table name of the form
          #     `projects/<project>/instances/<instance>/tables/<table_id>`.
          # @!attribute [rw] backup
          #   @return [::String]
          #     Name of the backup from which to restore.  Values are of the form
          #     `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
          class RestoreTableRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata type for the long-running operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#restore_table RestoreTable}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the table being created and restored to.
          # @!attribute [rw] source_type
          #   @return [::Google::Cloud::Bigtable::Admin::V2::RestoreSourceType]
          #     The type of the restore source.
          # @!attribute [rw] backup_info
          #   @return [::Google::Cloud::Bigtable::Admin::V2::BackupInfo]
          # @!attribute [rw] optimize_table_operation_name
          #   @return [::String]
          #     If exists, the name of the long-running operation that will be used to
          #     track the post-restore optimization process to optimize the performance of
          #     the restored table. The metadata type of the long-running operation is
          #     [OptimizeRestoreTableMetadata][]. The response type is
          #     {::Google::Protobuf::Empty Empty}. This long-running operation may be
          #     automatically created by the system if applicable after the
          #     RestoreTable long-running operation completes successfully. This operation
          #     may not be created if the table is already optimized or the restore was
          #     not successful.
          # @!attribute [rw] progress
          #   @return [::Google::Cloud::Bigtable::Admin::V2::OperationProgress]
          #     The progress of the
          #     {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#restore_table RestoreTable}
          #     operation.
          class RestoreTableMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata type for the long-running operation used to track the progress
          # of optimizations performed on a newly restored table. This long-running
          # operation is automatically created by the system after the successful
          # completion of a table restore, and cannot be cancelled.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the restored table being optimized.
          # @!attribute [rw] progress
          #   @return [::Google::Cloud::Bigtable::Admin::V2::OperationProgress]
          #     The progress of the post-restore optimizations.
          class OptimizeRestoredTableMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_table google.bigtable.admin.v2.BigtableTableAdmin.CreateTable}
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The unique name of the instance in which to create the table.
          #     Values are of the form `projects/{project}/instances/{instance}`.
          # @!attribute [rw] table_id
          #   @return [::String]
          #     Required. The name by which the new table should be referred to within the
          #     parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
          #     Maximum 50 characters.
          # @!attribute [rw] table
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Table]
          #     Required. The Table to create.
          # @!attribute [rw] initial_splits
          #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::CreateTableRequest::Split>]
          #     The optional list of row keys that will be used to initially split the
          #     table into several tablets (tablets are similar to HBase regions).
          #     Given two split keys, `s1` and `s2`, three tablets will be created,
          #     spanning the key ranges: `[, s1), [s1, s2), [s2, )`.
          #
          #     Example:
          #
          #     * Row keys := `["a", "apple", "custom", "customer_1", "customer_2",`
          #                    `"other", "zz"]`
          #     * initial_split_keys := `["apple", "customer_1", "customer_2", "other"]`
          #     * Key assignment:
          #         - Tablet 1 `[, apple)                => {"a"}.`
          #         - Tablet 2 `[apple, customer_1)      => {"apple", "custom"}.`
          #         - Tablet 3 `[customer_1, customer_2) => {"customer_1"}.`
          #         - Tablet 4 `[customer_2, other)      => {"customer_2"}.`
          #         - Tablet 5 `[other, )                => {"other", "zz"}.`
          class CreateTableRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # An initial split point for a newly created table.
            # @!attribute [rw] key
            #   @return [::String]
            #     Row key to use as an initial tablet boundary.
            class Split
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_table_from_snapshot google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot}
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The unique name of the instance in which to create the table.
          #     Values are of the form `projects/{project}/instances/{instance}`.
          # @!attribute [rw] table_id
          #   @return [::String]
          #     Required. The name by which the new table should be referred to within the
          #     parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
          # @!attribute [rw] source_snapshot
          #   @return [::String]
          #     Required. The unique name of the snapshot from which to restore the table.
          #     The snapshot and the table must be in the same instance. Values are of the
          #     form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
          class CreateTableFromSnapshotRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#drop_row_range google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the table on which to drop a range of rows.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] row_key_prefix
          #   @return [::String]
          #     Delete all rows that start with this row key prefix. Prefix cannot be
          #     zero length.
          #
          #     Note: The following fields are mutually exclusive: `row_key_prefix`, `delete_all_data_from_table`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] delete_all_data_from_table
          #   @return [::Boolean]
          #     Delete all rows in the table. Setting this to false is a no-op.
          #
          #     Note: The following fields are mutually exclusive: `delete_all_data_from_table`, `row_key_prefix`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class DropRowRangeRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_tables google.bigtable.admin.v2.BigtableTableAdmin.ListTables}
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The unique name of the instance for which tables should be
          #     listed. Values are of the form `projects/{project}/instances/{instance}`.
          # @!attribute [rw] view
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Table::View]
          #     The view to be applied to the returned tables' fields.
          #     NAME_ONLY view (default) and REPLICATION_VIEW are supported.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Maximum number of results per page.
          #
          #     A page_size of zero lets the server choose the number of items to return.
          #     A page_size which is strictly positive will return at most that many items.
          #     A negative page_size will cause an error.
          #
          #     Following the first request, subsequent paginated calls are not required
          #     to pass a page_size. If a page_size is set in subsequent calls, it must
          #     match the page_size given in the first request.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The value of `next_page_token` returned by a previous call.
          class ListTablesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_tables google.bigtable.admin.v2.BigtableTableAdmin.ListTables}
          # @!attribute [rw] tables
          #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::Table>]
          #     The tables present in the requested instance.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Set if not all tables could be returned in a single response.
          #     Pass this value to `page_token` in another request to get the next
          #     page of results.
          class ListTablesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#get_table google.bigtable.admin.v2.BigtableTableAdmin.GetTable}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the requested table.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] view
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Table::View]
          #     The view to be applied to the returned table's fields.
          #     Defaults to `SCHEMA_VIEW` if unspecified.
          class GetTableRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#update_table UpdateTable}.
          # @!attribute [rw] table
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Table]
          #     Required. The table to update.
          #     The table's `name` field is used to identify the table to update.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. The list of fields to update.
          #     A mask specifying which fields (e.g. `change_stream_config`) in the `table`
          #     field should be updated. This mask is relative to the `table` field, not to
          #     the request message. The wildcard (*) path is currently not supported.
          #     Currently UpdateTable is only supported for the following fields:
          #
          #     * `change_stream_config`
          #     * `change_stream_config.retention_period`
          #     * `deletion_protection`
          #     * `row_key_schema`
          #
          #     If `column_families` is set in `update_mask`, it will return an
          #     UNIMPLEMENTED error.
          # @!attribute [rw] ignore_warnings
          #   @return [::Boolean]
          #     Optional. If true, ignore safety checks when updating the table.
          class UpdateTableRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata type for the operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#update_table UpdateTable}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the table being updated.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this operation started.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     If set, the time at which this operation finished or was canceled.
          class UpdateTableMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#delete_table google.bigtable.admin.v2.BigtableTableAdmin.DeleteTable}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the table to be deleted.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          class DeleteTableRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#undelete_table google.bigtable.admin.v2.BigtableTableAdmin.UndeleteTable}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the table to be restored.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          class UndeleteTableRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata type for the operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#undelete_table google.bigtable.admin.v2.BigtableTableAdmin.UndeleteTable}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the table being restored.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this operation started.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     If set, the time at which this operation finished or was cancelled.
          class UndeleteTableMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#modify_column_families google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the table whose families should be modified.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] modifications
          #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::ModifyColumnFamiliesRequest::Modification>]
          #     Required. Modifications to be atomically applied to the specified table's
          #     families. Entries are applied in order, meaning that earlier modifications
          #     can be masked by later ones (in the case of repeated updates to the same
          #     family, for example).
          # @!attribute [rw] ignore_warnings
          #   @return [::Boolean]
          #     Optional. If true, ignore safety checks when modifying the column families.
          class ModifyColumnFamiliesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A create, update, or delete of a particular column family.
            # @!attribute [rw] id
            #   @return [::String]
            #     The ID of the column family to be modified.
            # @!attribute [rw] create
            #   @return [::Google::Cloud::Bigtable::Admin::V2::ColumnFamily]
            #     Create a new column family with the specified schema, or fail if
            #     one already exists with the given ID.
            #
            #     Note: The following fields are mutually exclusive: `create`, `update`, `drop`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] update
            #   @return [::Google::Cloud::Bigtable::Admin::V2::ColumnFamily]
            #     Update an existing column family to the specified schema, or fail
            #     if no column family exists with the given ID.
            #
            #     Note: The following fields are mutually exclusive: `update`, `create`, `drop`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] drop
            #   @return [::Boolean]
            #     Drop (delete) the column family with the given ID, or fail if no such
            #     family exists.
            #
            #     Note: The following fields are mutually exclusive: `drop`, `create`, `update`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] update_mask
            #   @return [::Google::Protobuf::FieldMask]
            #     Optional. A mask specifying which fields (e.g. `gc_rule`) in the `update`
            #     mod should be updated, ignored for other modification types. If unset or
            #     empty, we treat it as updating `gc_rule` to be backward compatible.
            class Modification
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#generate_consistency_token google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the Table for which to create a consistency
          #     token. Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          class GenerateConsistencyTokenRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#generate_consistency_token google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken}
          # @!attribute [rw] consistency_token
          #   @return [::String]
          #     The generated consistency token.
          class GenerateConsistencyTokenResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#check_consistency google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the Table for which to check replication
          #     consistency. Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] consistency_token
          #   @return [::String]
          #     Required. The token created using GenerateConsistencyToken for the Table.
          # @!attribute [rw] standard_read_remote_writes
          #   @return [::Google::Cloud::Bigtable::Admin::V2::StandardReadRemoteWrites]
          #     Checks that reads using an app profile with `StandardIsolation` can
          #     see all writes committed before the token was created, even if the
          #     read and write target different clusters.
          #
          #     Note: The following fields are mutually exclusive: `standard_read_remote_writes`, `data_boost_read_local_writes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] data_boost_read_local_writes
          #   @return [::Google::Cloud::Bigtable::Admin::V2::DataBoostReadLocalWrites]
          #     Checks that reads using an app profile with `DataBoostIsolationReadOnly`
          #     can see all writes committed before the token was created, but only if
          #     the read and write target the same cluster.
          #
          #     Note: The following fields are mutually exclusive: `data_boost_read_local_writes`, `standard_read_remote_writes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class CheckConsistencyRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Checks that all writes before the consistency token was generated are
          # replicated in every cluster and readable.
          class StandardReadRemoteWrites
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Checks that all writes before the consistency token was generated in the same
          # cluster are readable by Databoost.
          class DataBoostReadLocalWrites
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#check_consistency google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency}
          # @!attribute [rw] consistent
          #   @return [::Boolean]
          #     True only if the token is consistent. A token is consistent if replication
          #     has caught up with the restrictions specified in the request.
          class CheckConsistencyResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#snapshot_table google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable}
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the table to have the snapshot taken.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] cluster
          #   @return [::String]
          #     Required. The name of the cluster where the snapshot will be created in.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
          # @!attribute [rw] snapshot_id
          #   @return [::String]
          #     Required. The ID by which the new snapshot should be referred to within the
          #     parent cluster, e.g., `mysnapshot` of the form:
          #     `[_a-zA-Z0-9][-_.a-zA-Z0-9]*` rather than
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
          # @!attribute [rw] ttl
          #   @return [::Google::Protobuf::Duration]
          #     The amount of time that the new snapshot can stay active after it is
          #     created. Once 'ttl' expires, the snapshot will get deleted. The maximum
          #     amount of time a snapshot can stay active is 7 days. If 'ttl' is not
          #     specified, the default value of 24 hours will be used.
          # @!attribute [rw] description
          #   @return [::String]
          #     Description of the snapshot.
          class SnapshotTableRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#get_snapshot google.bigtable.admin.v2.BigtableTableAdmin.GetSnapshot}
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the requested snapshot.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
          class GetSnapshotRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_snapshots google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots}
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The unique name of the cluster for which snapshots should be
          #     listed. Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
          #     Use `{cluster} = '-'` to list snapshots for all clusters in an instance,
          #     e.g., `projects/{project}/instances/{instance}/clusters/-`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of snapshots to return per page.
          #     CURRENTLY UNIMPLEMENTED AND IGNORED.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The value of `next_page_token` returned by a previous call.
          class ListSnapshotsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_snapshots google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots}
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] snapshots
          #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::Snapshot>]
          #     The snapshots present in the requested cluster.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Set if not all snapshots could be returned in a single response.
          #     Pass this value to `page_token` in another request to get the next
          #     page of results.
          class ListSnapshotsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#delete_snapshot google.bigtable.admin.v2.BigtableTableAdmin.DeleteSnapshot}
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the snapshot to be deleted.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
          class DeleteSnapshotRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The metadata for the Operation returned by SnapshotTable.
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] original_request
          #   @return [::Google::Cloud::Bigtable::Admin::V2::SnapshotTableRequest]
          #     The request that prompted the initiation of this SnapshotTable operation.
          # @!attribute [rw] request_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the original request was received.
          # @!attribute [rw] finish_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the operation failed or was completed successfully.
          class SnapshotTableMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The metadata for the Operation returned by CreateTableFromSnapshot.
          #
          # Note: This is a private alpha release of Cloud Bigtable snapshots. This
          # feature is not currently available to most Cloud Bigtable customers. This
          # feature might be changed in backward-incompatible ways and is not recommended
          # for production use. It is not subject to any SLA or deprecation policy.
          # @!attribute [rw] original_request
          #   @return [::Google::Cloud::Bigtable::Admin::V2::CreateTableFromSnapshotRequest]
          #     The request that prompted the initiation of this CreateTableFromSnapshot
          #     operation.
          # @!attribute [rw] request_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the original request was received.
          # @!attribute [rw] finish_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the operation failed or was completed successfully.
          class CreateTableFromSnapshotMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_backup CreateBackup}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. This must be one of the clusters in the instance in which this
          #     table is located. The backup will be stored in this cluster. Values are
          #     of the form `projects/{project}/instances/{instance}/clusters/{cluster}`.
          # @!attribute [rw] backup_id
          #   @return [::String]
          #     Required. The id of the backup to be created. The `backup_id` along with
          #     the parent `parent` are combined as \\{parent}/backups/\\{backup_id} to create
          #     the full backup name, of the form:
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
          #     This string must be between 1 and 50 characters in length and match the
          #     regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
          # @!attribute [rw] backup
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Backup]
          #     Required. The backup to create.
          class CreateBackupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata type for the operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_backup CreateBackup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the backup being created.
          # @!attribute [rw] source_table
          #   @return [::String]
          #     The name of the table the backup is created from.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this operation started.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     If set, the time at which this operation finished or was cancelled.
          class CreateBackupMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#update_backup UpdateBackup}.
          # @!attribute [rw] backup
          #   @return [::Google::Cloud::Bigtable::Admin::V2::Backup]
          #     Required. The backup to update. `backup.name`, and the fields to be updated
          #     as specified by `update_mask` are required. Other fields are ignored.
          #     Update is only supported for the following fields:
          #
          #      * `backup.expire_time`.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. A mask specifying which fields (e.g. `expire_time`) in the
          #     Backup resource should be updated. This mask is relative to the Backup
          #     resource, not to the request message. The field mask must always be
          #     specified; this prevents any future fields from being erased accidentally
          #     by clients that do not know about them.
          class UpdateBackupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#get_backup GetBackup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the backup.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup}`.
          class GetBackupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#delete_backup DeleteBackup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the backup to delete.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup}`.
          class DeleteBackupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_backups ListBackups}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The cluster to list backups from.  Values are of the
          #     form `projects/{project}/instances/{instance}/clusters/{cluster}`.
          #     Use `{cluster} = '-'` to list backups for all clusters in an instance,
          #     e.g., `projects/{project}/instances/{instance}/clusters/-`.
          # @!attribute [rw] filter
          #   @return [::String]
          #     A filter expression that filters backups listed in the response.
          #     The expression must specify the field name, a comparison operator,
          #     and the value that you want to use for filtering. The value must be a
          #     string, a number, or a boolean. The comparison operator must be
          #     <, >, <=, >=, !=, =, or :. Colon ':' represents a HAS operator which is
          #     roughly synonymous with equality. Filter rules are case insensitive.
          #
          #     The fields eligible for filtering are:
          #
          #     * `name`
          #     * `source_table`
          #     * `state`
          #     * `start_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
          #     * `end_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
          #     * `expire_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
          #     * `size_bytes`
          #
          #     To filter on multiple expressions, provide each separate expression within
          #     parentheses. By default, each expression is an AND expression. However,
          #     you can include AND, OR, and NOT expressions explicitly.
          #
          #     Some examples of using filters are:
          #
          #     * `name:"exact"` --> The backup's name is the string "exact".
          #     * `name:howl` --> The backup's name contains the string "howl".
          #     * `source_table:prod`
          #            --> The source_table's name contains the string "prod".
          #     * `state:CREATING` --> The backup is pending creation.
          #     * `state:READY` --> The backup is fully created and ready for use.
          #     * `(name:howl) AND (start_time < \"2018-03-28T14:50:00Z\")`
          #            --> The backup name contains the string "howl" and start_time
          #                of the backup is before 2018-03-28T14:50:00Z.
          #     * `size_bytes > 10000000000` --> The backup's size is greater than 10GB
          # @!attribute [rw] order_by
          #   @return [::String]
          #     An expression for specifying the sort order of the results of the request.
          #     The string value should specify one or more fields in
          #     {::Google::Cloud::Bigtable::Admin::V2::Backup Backup}. The full syntax is described at
          #     https://aip.dev/132#ordering.
          #
          #     Fields supported are:
          #
          #     * name
          #     * source_table
          #     * expire_time
          #     * start_time
          #     * end_time
          #     * size_bytes
          #     * state
          #
          #     For example, "start_time". The default sorting order is ascending.
          #     To specify descending order for the field, a suffix " desc" should
          #     be appended to the field name. For example, "start_time desc".
          #     Redundant space characters in the syntax are insigificant.
          #
          #     If order_by is empty, results will be sorted by `start_time` in descending
          #     order starting from the most recently created backup.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Number of backups to be returned in the response. If 0 or
          #     less, defaults to the server's maximum allowed page size.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     If non-empty, `page_token` should contain a
          #     {::Google::Cloud::Bigtable::Admin::V2::ListBackupsResponse#next_page_token next_page_token}
          #     from a previous
          #     {::Google::Cloud::Bigtable::Admin::V2::ListBackupsResponse ListBackupsResponse} to the
          #     same `parent` and with the same `filter`.
          class ListBackupsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_backups ListBackups}.
          # @!attribute [rw] backups
          #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::Backup>]
          #     The list of matching backups.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     `next_page_token` can be sent in a subsequent
          #     {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_backups ListBackups} call
          #     to fetch more of the matching backups.
          class ListBackupsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#copy_backup CopyBackup}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the destination cluster that will contain the backup
          #     copy. The cluster must already exist. Values are of the form:
          #     `projects/{project}/instances/{instance}/clusters/{cluster}`.
          # @!attribute [rw] backup_id
          #   @return [::String]
          #     Required. The id of the new backup. The `backup_id` along with `parent`
          #     are combined as \\{parent}/backups/\\{backup_id} to create the full backup
          #     name, of the form:
          #     `projects/{project}/instances/{instance}/clusters/{cluster}/backups/{backup_id}`.
          #     This string must be between 1 and 50 characters in length and match the
          #     regex [_a-zA-Z0-9][-_.a-zA-Z0-9]*.
          # @!attribute [rw] source_backup
          #   @return [::String]
          #     Required. The source backup to be copied from.
          #     The source backup needs to be in READY state for it to be copied.
          #     Copying a copied backup is not allowed.
          #     Once CopyBackup is in progress, the source backup cannot be deleted or
          #     cleaned up on expiration until CopyBackup is finished.
          #     Values are of the form:
          #     `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
          # @!attribute [rw] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. Required. The expiration time of the copied backup with
          #     microsecond granularity that must be at least 6 hours and at most 30 days
          #     from the time the request is received. Once the `expire_time` has
          #     passed, Cloud Bigtable will delete the backup and free the resources used
          #     by the backup.
          class CopyBackupRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata type for the google.longrunning.Operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#copy_backup CopyBackup}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the backup being created through the copy operation.
          #     Values are of the form
          #     `projects/<project>/instances/<instance>/clusters/<cluster>/backups/<backup>`.
          # @!attribute [rw] source_backup_info
          #   @return [::Google::Cloud::Bigtable::Admin::V2::BackupInfo]
          #     Information about the source backup that is being copied from.
          # @!attribute [rw] progress
          #   @return [::Google::Cloud::Bigtable::Admin::V2::OperationProgress]
          #     The progress of the
          #     {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#copy_backup CopyBackup}
          #     operation.
          class CopyBackupMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_authorized_view CreateAuthorizedView}
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. This is the name of the table the AuthorizedView belongs to.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] authorized_view_id
          #   @return [::String]
          #     Required. The id of the AuthorizedView to create. This AuthorizedView must
          #     not already exist. The `authorized_view_id` appended to `parent` forms the
          #     full AuthorizedView name of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/authorizedView/{authorized_view}`.
          # @!attribute [rw] authorized_view
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView]
          #     Required. The AuthorizedView to create.
          class CreateAuthorizedViewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The metadata for the Operation returned by CreateAuthorizedView.
          # @!attribute [rw] original_request
          #   @return [::Google::Cloud::Bigtable::Admin::V2::CreateAuthorizedViewRequest]
          #     The request that prompted the initiation of this CreateAuthorizedView
          #     operation.
          # @!attribute [rw] request_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the original request was received.
          # @!attribute [rw] finish_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the operation failed or was completed successfully.
          class CreateAuthorizedViewMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_authorized_views google.bigtable.admin.v2.BigtableTableAdmin.ListAuthorizedViews}
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The unique name of the table for which AuthorizedViews should be
          #     listed. Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. Maximum number of results per page.
          #
          #     A page_size of zero lets the server choose the number of items to return.
          #     A page_size which is strictly positive will return at most that many items.
          #     A negative page_size will cause an error.
          #
          #     Following the first request, subsequent paginated calls are not required
          #     to pass a page_size. If a page_size is set in subsequent calls, it must
          #     match the page_size given in the first request.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. The value of `next_page_token` returned by a previous call.
          # @!attribute [rw] view
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView::ResponseView]
          #     Optional. The resource_view to be applied to the returned AuthorizedViews'
          #     fields. Default to NAME_ONLY.
          class ListAuthorizedViewsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_authorized_views google.bigtable.admin.v2.BigtableTableAdmin.ListAuthorizedViews}
          # @!attribute [rw] authorized_views
          #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::AuthorizedView>]
          #     The AuthorizedViews present in the requested table.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     Set if not all tables could be returned in a single response.
          #     Pass this value to `page_token` in another request to get the next
          #     page of results.
          class ListAuthorizedViewsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#get_authorized_view google.bigtable.admin.v2.BigtableTableAdmin.GetAuthorizedView}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the requested AuthorizedView.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`.
          # @!attribute [rw] view
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView::ResponseView]
          #     Optional. The resource_view to be applied to the returned AuthorizedView's
          #     fields. Default to BASIC.
          class GetAuthorizedViewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#update_authorized_view UpdateAuthorizedView}.
          # @!attribute [rw] authorized_view
          #   @return [::Google::Cloud::Bigtable::Admin::V2::AuthorizedView]
          #     Required. The AuthorizedView to update. The `name` in `authorized_view` is
          #     used to identify the AuthorizedView. AuthorizedView name must in this
          #     format:
          #     `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. The list of fields to update.
          #     A mask specifying which fields in the AuthorizedView resource should be
          #     updated. This mask is relative to the AuthorizedView resource, not to the
          #     request message. A field will be overwritten if it is in the mask. If
          #     empty, all fields set in the request will be overwritten. A special value
          #     `*` means to overwrite all fields (including fields not set in the
          #     request).
          # @!attribute [rw] ignore_warnings
          #   @return [::Boolean]
          #     Optional. If true, ignore the safety checks when updating the
          #     AuthorizedView.
          class UpdateAuthorizedViewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata for the google.longrunning.Operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#update_authorized_view UpdateAuthorizedView}.
          # @!attribute [rw] original_request
          #   @return [::Google::Cloud::Bigtable::Admin::V2::UpdateAuthorizedViewRequest]
          #     The request that prompted the initiation of this UpdateAuthorizedView
          #     operation.
          # @!attribute [rw] request_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the original request was received.
          # @!attribute [rw] finish_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which the operation failed or was completed successfully.
          class UpdateAuthorizedViewMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#delete_authorized_view google.bigtable.admin.v2.BigtableTableAdmin.DeleteAuthorizedView}
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the AuthorizedView to be deleted.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Optional. The current etag of the AuthorizedView.
          #     If an etag is provided and does not match the current etag of the
          #     AuthorizedView, deletion will be blocked and an ABORTED error will be
          #     returned.
          class DeleteAuthorizedViewRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_schema_bundle CreateSchemaBundle}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource where this schema bundle will be created.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] schema_bundle_id
          #   @return [::String]
          #     Required. The unique ID to use for the schema bundle, which will become the
          #     final component of the schema bundle's resource name.
          # @!attribute [rw] schema_bundle
          #   @return [::Google::Cloud::Bigtable::Admin::V2::SchemaBundle]
          #     Required. The schema bundle to create.
          class CreateSchemaBundleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The metadata for the Operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#create_schema_bundle CreateSchemaBundle}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name identifying this schema bundle.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this operation started.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     If set, the time at which this operation finished or was canceled.
          class CreateSchemaBundleMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#update_schema_bundle UpdateSchemaBundle}.
          # @!attribute [rw] schema_bundle
          #   @return [::Google::Cloud::Bigtable::Admin::V2::SchemaBundle]
          #     Required. The schema bundle to update.
          #
          #     The schema bundle's `name` field is used to identify the schema bundle to
          #     update. Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. The list of fields to update.
          # @!attribute [rw] ignore_warnings
          #   @return [::Boolean]
          #     Optional. If set, ignore the safety checks when updating the Schema Bundle.
          #     The safety checks are:
          #     - The new Schema Bundle is backwards compatible with the existing Schema
          #     Bundle.
          class UpdateSchemaBundleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The metadata for the Operation returned by
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#update_schema_bundle UpdateSchemaBundle}.
          # @!attribute [rw] name
          #   @return [::String]
          #     The unique name identifying this schema bundle.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this operation started.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     If set, the time at which this operation finished or was canceled.
          class UpdateSchemaBundleMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#get_schema_bundle GetSchemaBundle}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the schema bundle to retrieve.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
          class GetSchemaBundleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_schema_bundles ListSchemaBundles}.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent, which owns this collection of schema bundles.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of schema bundles to return. If the value is positive,
          #     the server may return at most this value. If unspecified, the server will
          #     return the maximum allowed page size.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     A page token, received from a previous `ListSchemaBundles` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListSchemaBundles` must
          #     match the call that provided the page token.
          class ListSchemaBundlesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The response for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#list_schema_bundles ListSchemaBundles}.
          # @!attribute [rw] schema_bundles
          #   @return [::Array<::Google::Cloud::Bigtable::Admin::V2::SchemaBundle>]
          #     The schema bundles from the specified table.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListSchemaBundlesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The request for
          # {::Google::Cloud::Bigtable::Admin::V2::BigtableTableAdmin::Client#delete_schema_bundle DeleteSchemaBundle}.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The unique name of the schema bundle to delete.
          #     Values are of the form
          #     `projects/{project}/instances/{instance}/tables/{table}/schemaBundles/{schema_bundle}`
          # @!attribute [rw] etag
          #   @return [::String]
          #     Optional. The etag of the schema bundle.
          #     If this is provided, it must match the server's etag. The server
          #     returns an ABORTED error on a mismatched etag.
          class DeleteSchemaBundleRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
